/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.minimizing;

import de.jtem.numericalMethods.calculus.function.RealFunctionOfSeveralVariables;
import de.jtem.numericalMethods.calculus.minimizing.BrentOnLine;
import de.jtem.numericalMethods.calculus.minimizing.Info;
import java.io.Serializable;

public final class Powell
implements Serializable {
    private static final long serialVersionUID = 1L;
    static int ITMAX = 200;

    public static int getITMAX() {
        return ITMAX;
    }

    public static void setITMAX(int n) {
        ITMAX = n;
    }

    static final double sqr(double d) {
        return d * d;
    }

    public static double[][] getStandardBasis(int n) {
        double[][] dArray = new double[n][n];
        for (int i = 0; i < n; ++i) {
            dArray[i][i] = 1.0;
        }
        return dArray;
    }

    public static final double search(double[] dArray, double d, RealFunctionOfSeveralVariables realFunctionOfSeveralVariables) {
        return Powell.search(dArray, Powell.getStandardBasis(dArray.length), d, realFunctionOfSeveralVariables, ITMAX, null);
    }

    public static final double search(double[] dArray, double d, int n, RealFunctionOfSeveralVariables realFunctionOfSeveralVariables) {
        return Powell.search(dArray, Powell.getStandardBasis(dArray.length), d, realFunctionOfSeveralVariables, n, null);
    }

    public static final double search(double[] dArray, double d, int n, RealFunctionOfSeveralVariables realFunctionOfSeveralVariables, Info info) {
        return Powell.search(dArray, Powell.getStandardBasis(dArray.length), d, realFunctionOfSeveralVariables, n, info);
    }

    public static double search(double[] dArray, double[][] dArray2, double d, RealFunctionOfSeveralVariables realFunctionOfSeveralVariables, int n, Info info) {
        int n2;
        double[] dArray3 = new double[2];
        int n3 = dArray.length;
        double[] dArray4 = new double[n3];
        double[] dArray5 = new double[n3];
        double[] dArray6 = new double[n3];
        BrentOnLine brentOnLine = new BrentOnLine(dArray, dArray6, realFunctionOfSeveralVariables);
        double d2 = realFunctionOfSeveralVariables.eval(dArray);
        if (info != null) {
            String string = new String(" f(p) = " + d2 + " , p = ");
            for (int i = 0; i < n3; ++i) {
                string = string + dArray[i] + " ";
            }
            info.setMessage(string);
            info.setMaxIter(n);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            dArray4[n2] = dArray[n2];
        }
        System.out.println("value=" + d2);
        n2 = 1;
        while (true) {
            double d3;
            double d4;
            int n4;
            int n5;
            double d5 = d2;
            int n6 = 0;
            double d6 = 0.0;
            for (n5 = 0; n5 < n3; ++n5) {
                for (n4 = 0; n4 < n3; ++n4) {
                    dArray6[n4] = dArray2[n4][n5];
                }
                d4 = d2;
                if (!(Math.abs(d4 - (d2 = brentOnLine.search(2.0E-8))) > d6)) continue;
                d6 = Math.abs(d4 - d2);
                n6 = n5;
            }
            if (2.0 * Math.abs(d5 - d2) <= d * (Math.abs(d5) + Math.abs(d2))) {
                if (info != null) {
                    String string = new String("iter = " + n2 + ", fret = " + d2 + ", fp = " + d5 + ", p = ");
                    for (n4 = 0; n4 < n3; ++n4) {
                        string = string + dArray[n4] + " ";
                    }
                    info.addMessage(string);
                    info.setCurrentIter(n2);
                    info.printDebug();
                }
                return d2;
            }
            if (info != null && n2 == n) {
                info.setCurrentIter(n2);
                info.setMessage("Too many iterations in routine POWELL");
                info.printDebug();
                return d2;
            }
            for (n5 = 0; n5 < n3; ++n5) {
                dArray5[n5] = 2.0 * dArray[n5] - dArray4[n5];
                dArray6[n5] = dArray[n5] - dArray4[n5];
                dArray4[n5] = dArray[n5];
            }
            d4 = realFunctionOfSeveralVariables.eval(dArray5);
            if (d4 < d5 && (d3 = 2.0 * (d5 - 2.0 * d2 + d4) * Powell.sqr(d5 - d2 - d6) - d6 * Powell.sqr(d5 - d4)) < 0.0) {
                d2 = brentOnLine.search(2.0E-8);
                for (int i = 0; i < n3; ++i) {
                    dArray2[i][n6] = dArray6[i];
                }
            }
            System.out.println("value=" + d2);
            ++n2;
        }
    }
}

