/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.glyph;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.biojava.bio.gui.glyph.Glyph;
import org.biojava.bio.gui.glyph.GlyphUtils;

public class HelixGlyph
implements Glyph {
    private Paint forePaint;
    private Paint backPaint;
    private Rectangle2D.Float bounds = new Rectangle2D.Float(0.0f, 0.0f, 0.0f, 0.0f);
    private Shape foreShape;
    private Shape backShape;

    public HelixGlyph() {
        this.forePaint = Color.RED;
        this.backPaint = Color.RED.darker().darker();
    }

    public HelixGlyph(Rectangle2D.Float bounds) {
        this();
        this.setBounds(bounds);
    }

    public Rectangle2D.Float getBounds() {
        return this.bounds;
    }

    public void setBounds(Rectangle2D.Float r) {
        int j;
        if (this.bounds.equals(r)) {
            return;
        }
        int[] vals = null;
        float hh = 0.0f;
        hh = r.height / 2.0f;
        vals = new int[2 * (int)hh];
        double dd = Math.PI * 2 / (double)vals.length;
        for (int i = 0; i < vals.length; ++i) {
            double v = (double)hh * Math.cos(dd * (double)i);
            vals[i] = (int)v;
        }
        ArrayList<Point2D.Float> p1 = new ArrayList<Point2D.Float>(2 * vals.length);
        ArrayList<Point2D.Float> p2 = new ArrayList<Point2D.Float>(2 * vals.length);
        int i = 0;
        while ((float)i < r.width) {
            j = i % vals.length;
            if (j < vals.length / 2) {
                p1.add(new Point2D.Float(r.x + (float)i, r.y + hh - (float)vals[j]));
            } else {
                p1.add(new Point2D.Float(r.x + (float)i, r.y));
            }
            if (vals[j] < 0) {
                p2.add(new Point2D.Float(r.x + (float)i, r.y + hh + (float)vals[j]));
            }
            ++i;
        }
        for (i = (int)r.width - 1; i >= 0; --i) {
            j = i % vals.length;
            if (j < vals.length / 2) {
                p1.add(new Point2D.Float(r.x + (float)i, r.y + r.height));
            } else {
                p1.add(new Point2D.Float(r.x + (float)i, r.y + hh + (float)vals[j]));
            }
            if (vals[j] >= 0) continue;
            p2.add(new Point2D.Float(r.x + (float)i, r.y + hh - (float)vals[j]));
        }
        this.foreShape = GlyphUtils.getShape(p1);
        this.backShape = GlyphUtils.getShape(p2);
        this.bounds = r;
    }

    public void render(Graphics2D g) {
        if (this.backShape != null) {
            g.setPaint(this.backPaint);
            g.fill(this.backShape);
        }
        if (this.foreShape != null) {
            g.setPaint(this.forePaint);
            g.fill(this.foreShape);
        }
    }
}

