/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.tagvalue;

import org.biojava.bio.program.tagvalue.BoundaryFinder;
import org.biojava.bio.program.tagvalue.SimpleTagValueWrapper;
import org.biojava.bio.program.tagvalue.TagValueContext;
import org.biojava.bio.program.tagvalue.TagValueListener;
import org.biojava.utils.ParserException;

public class Aggregator
extends SimpleTagValueWrapper {
    private BoundaryFinder observer;
    private String joiner;
    private StringBuffer value;
    private boolean inValue;

    public Aggregator(TagValueListener listener, BoundaryFinder observer, String joiner) {
        super(listener);
        this.observer = observer;
        this.joiner = joiner;
        this.value = new StringBuffer();
    }

    public BoundaryFinder getBoundaryFinder() {
        return this.observer;
    }

    public void setBoundaryFinder(BoundaryFinder finder) {
        this.observer = finder;
    }

    public String getJoiner() {
        return this.joiner;
    }

    public void setJoiner(String joiner) {
        this.joiner = joiner;
    }

    public void startTag(Object tag) throws ParserException {
        super.startTag(tag);
        this.inValue = false;
        this.value.setLength(0);
    }

    public void value(TagValueContext ctxt, Object value) throws ParserException {
        boolean isStart = this.observer.isBoundaryStart(value);
        boolean isEnd = this.observer.isBoundaryEnd(value);
        boolean dbv = this.observer.dropBoundaryValues();
        if (isStart && isEnd) {
            if (this.inValue) {
                super.value(ctxt, this.value.toString());
                this.value.setLength(0);
                this.inValue = false;
            }
            if (!dbv) {
                super.value(ctxt, value);
            }
        }
        if (isStart && !isEnd) {
            if (this.inValue) {
                super.value(ctxt, this.value.toString());
                this.value.setLength(0);
            }
            this.value.append(value);
            this.inValue = true;
        }
        if (!isStart && isEnd) {
            if (!dbv) {
                this.value.append(this.joiner);
                this.value.append(value);
            }
            super.value(ctxt, this.value.toString());
            this.inValue = false;
            this.value.setLength(0);
        }
        if (!isStart && !isEnd) {
            this.value.append(this.joiner);
            this.value.append(value);
            this.inValue = true;
        }
    }

    public void endTag() throws ParserException {
        if (this.inValue) {
            super.value(null, this.value.toString());
            this.inValue = false;
        }
        super.endTag();
    }
}

