/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.results.savers;

import de.jstacs.io.FileManager;
import de.jstacs.parameters.FileParameter;
import de.jstacs.results.TextResult;
import de.jstacs.results.savers.ResultSaver;
import de.jstacs.results.savers.ResultSaverLibrary;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;

public class TextResultSaver
implements ResultSaver<TextResult> {
    public static void register() {
        ResultSaverLibrary.register(TextResult.class, new TextResultSaver());
    }

    private TextResultSaver() {
    }

    @Override
    public String[] getFileExtensions(TextResult result) {
        String[] mimes = result.getMime().split("\\,");
        return mimes;
    }

    @Override
    public boolean writeOutput(TextResult result, File path) {
        try {
            FileParameter.FileRepresentation rep = result.getValue();
            if (rep.getFilename() != null && new File(rep.getFilename()).exists()) {
                FileManager.copy(rep.getFilename(), path.getAbsolutePath());
            } else {
                PrintWriter wr = new PrintWriter(path);
                wr.println(rep.getContent());
                wr.close();
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    @Override
    public boolean writeOutput(TextResult result, StringBuffer buf) {
        buf.append(result.getValue().getContent());
        return true;
    }
}

