/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.differentiable.continuous.gamma;

import de.jstacs.algorithms.optimization.DimensionException;
import de.jstacs.algorithms.optimization.EvaluationException;
import de.jstacs.sequenceScores.statisticalModels.differentiable.continuous.gamma.IntegrableFunction;
import java.util.LinkedList;

public class NumericalIntegration {
    public static double getIntegralByNestedIntervals(IntegrableFunction fun, double minValue, double initDelta, double acceptedEps) throws DimensionException, EvaluationException {
        int dim = fun.getDimensionOfScope();
        double[][] limits = fun.getLimits();
        double[] parValues = new double[dim];
        int i = 0;
        while (i < parValues.length) {
            parValues[i] = limits[i][0];
            ++i;
        }
        return NumericalIntegration.getOneDimIntegralByNestedIntervals(fun, minValue, initDelta, acceptedEps, parValues, limits, 0);
    }

    private static double getOneDimIntegralByNestedIntervals(IntegrableFunction fun, double minValue, double initDelta, double acceptedEps, double[] parValues, double[][] limits, int dimension) throws DimensionException, EvaluationException {
        double currVal = 0.0;
        double lastVal = 0.0;
        double lastBorder = 0.0;
        double currDelta = initDelta;
        LinkedList<Interval> list = new LinkedList<Interval>();
        if (Double.isInfinite(limits[dimension][0]) && Double.isInfinite(limits[dimension][0])) {
            throw new EvaluationException("You must specify at least one finite border for the domain of dimension " + dimension + ".");
        }
        if (!fun.isUnimodal() && (Double.isInfinite(limits[dimension][0]) || Double.isInfinite(limits[dimension][0]))) {
            throw new EvaluationException("You may specify infinite borders only for unimodal functions.");
        }
        if (fun.isUnimodal()) {
            boolean leftFin = !Double.isInfinite(limits[dimension][0]);
            parValues[dimension] = leftFin ? limits[dimension][0] : limits[dimension][1];
            currVal = dimension == fun.getDimensionOfScope() - 1 ? fun.evaluateFunction(parValues) : NumericalIntegration.getOneDimIntegralByNestedIntervals(fun, minValue, initDelta, acceptedEps, parValues, limits, dimension + 1);
            boolean desc = false;
            while (currVal > minValue || !desc) {
                lastBorder = parValues[dimension];
                lastVal = currVal;
                if (leftFin) {
                    int n = dimension;
                    parValues[n] = parValues[n] + currDelta;
                } else {
                    int n = dimension;
                    parValues[n] = parValues[n] - currDelta;
                }
                currDelta *= 1.1;
                currVal = dimension == fun.getDimensionOfScope() - 1 ? fun.evaluateFunction(parValues) : NumericalIntegration.getOneDimIntegralByNestedIntervals(fun, minValue, initDelta, acceptedEps, parValues, limits, dimension + 1);
                if (leftFin) {
                    list.add(new Interval(lastBorder, parValues[dimension], lastVal, currVal));
                } else {
                    list.add(new Interval(parValues[dimension], lastBorder, currVal, lastVal));
                }
                if (!(currVal < lastVal)) continue;
                desc = true;
            }
        } else {
            parValues[dimension] = limits[dimension][0];
            double left = fun.evaluateFunction(parValues);
            parValues[dimension] = limits[dimension][0];
            double right = fun.evaluateFunction(parValues);
            list.add(new Interval(limits[dimension][0], limits[dimension][1], left, right));
        }
        double integral = 0.0;
        while (list.size() > 0) {
            double midpoint;
            Interval curr = (Interval)list.removeFirst();
            double currInt = curr.getIntegral();
            parValues[dimension] = midpoint = curr.getMidpoint();
            double midVal = 0.0;
            midVal = dimension == fun.getDimensionOfScope() - 1 ? fun.evaluateFunction(parValues) : NumericalIntegration.getOneDimIntegralByNestedIntervals(fun, minValue, initDelta, acceptedEps, parValues, limits, dimension + 1);
            Interval i1 = new Interval(curr.leftBorder, midpoint, curr.leftValue, midVal);
            Interval i2 = new Interval(midpoint, curr.rightBorder, midVal, curr.rightValue);
            double newInt = i1.getIntegral() + i2.getIntegral();
            if (newInt < acceptedEps || Math.abs(newInt - currInt) / Math.abs(newInt + currInt) * 2.0 < acceptedEps) {
                integral += newInt;
                continue;
            }
            list.addFirst(i2);
            list.addFirst(i1);
        }
        return integral;
    }

    public static double getIntegralByTrapezoidRule(IntegrableFunction fun, double minValue, double delta) throws DimensionException, EvaluationException {
        int dim = fun.getDimensionOfScope();
        double[][] limits = fun.getLimits();
        double[] parValues = new double[dim];
        int i = 0;
        while (i < parValues.length) {
            parValues[i] = limits[i][0];
            ++i;
        }
        return NumericalIntegration.getOneDimIntegral(fun, minValue, delta, 0, limits, parValues);
    }

    private static double getOneDimIntegral(IntegrableFunction fun, double minValue, double delta, int dimension, double[][] limits, double[] parValues) throws DimensionException, EvaluationException {
        if (Double.isInfinite(limits[dimension][0]) && Double.isInfinite(limits[dimension][0])) {
            throw new EvaluationException("You must specify at least one finite border for the domain of dimension " + dimension + ".");
        }
        if (!fun.isUnimodal() && (Double.isInfinite(limits[dimension][0]) || Double.isInfinite(limits[dimension][0]))) {
            throw new EvaluationException("You may specify infinite borders only for unimodal functions.");
        }
        boolean leftFin = !Double.isInfinite(limits[dimension][0]);
        parValues[dimension] = leftFin ? limits[dimension][0] : limits[dimension][1];
        double funValue = 0.0;
        double lastValue = 0.0;
        double val = 0.0;
        boolean unimodal = fun.isUnimodal();
        boolean desc = false;
        funValue = dimension == fun.getDimensionOfScope() - 1 ? fun.evaluateFunction(parValues) : NumericalIntegration.getOneDimIntegral(fun, minValue, delta, dimension + 1, limits, parValues);
        do {
            if (leftFin) {
                int n = dimension;
                parValues[n] = parValues[n] + delta;
            } else {
                int n = dimension;
                parValues[n] = parValues[n] - delta;
            }
            lastValue = funValue;
            funValue = dimension == fun.getDimensionOfScope() - 1 ? fun.evaluateFunction(parValues) : NumericalIntegration.getOneDimIntegral(fun, minValue, delta, dimension + 1, limits, parValues);
            if (unimodal && !desc && funValue < lastValue) {
                desc = true;
            }
            val += (funValue + lastValue) / 2.0 * delta;
        } while ((funValue > minValue || !desc) && parValues[dimension] < limits[dimension][1]);
        return val;
    }

    private static class Interval {
        double leftBorder;
        double rightBorder;
        double leftValue;
        double rightValue;

        Interval(double leftBorder, double rightBorder, double leftValue, double rightValue) {
            this.leftBorder = leftBorder;
            this.rightBorder = rightBorder;
            this.leftValue = leftValue;
            this.rightValue = rightValue;
        }

        double getIntegral() {
            return (this.leftValue + this.rightValue) / 2.0 * (this.rightBorder - this.leftBorder);
        }

        double getMidpoint() {
            return (this.rightBorder + this.leftBorder) / 2.0;
        }
    }
}

