/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable;

import de.jstacs.clustering.hierachical.PWMSupplier;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.results.NumericalResultSet;
import de.jstacs.sequenceScores.statisticalModels.trainable.AbstractTrainableStatisticalModel;
import de.jstacs.utils.Normalisation;
import java.text.NumberFormat;

public class PFMWrapperTrainSM
extends AbstractTrainableStatisticalModel
implements PWMSupplier {
    private double[][] logPWM;
    private double[][] pfm;
    private String name;

    public PFMWrapperTrainSM(AlphabetContainer alphabets, String name, double[][] pfm, double ess) throws CloneNotSupportedException {
        super(alphabets, pfm.length);
        this.pfm = (double[][])ArrayHandler.clone((Cloneable[])pfm);
        this.logPWM = new double[pfm.length][];
        int i = 0;
        while (i < pfm.length) {
            this.logPWM[i] = new double[pfm[i].length];
            int j = 0;
            while (j < this.logPWM[i].length) {
                this.logPWM[i][j] = Math.log(pfm[i][j] + ess / (double)pfm[i].length);
                ++j;
            }
            double norm = Normalisation.getLogSum(this.logPWM[i]);
            int j2 = 0;
            while (j2 < this.logPWM[i].length) {
                double[] dArray = this.logPWM[i];
                int n = j2++;
                dArray[n] = dArray[n] - norm;
            }
            ++i;
        }
        this.name = name;
    }

    public PFMWrapperTrainSM(StringBuffer stringBuff) throws NonParsableException {
        super(stringBuff);
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer sb = new StringBuffer();
        XMLParser.appendObjectWithTags(sb, this.alphabets, "alphabet");
        XMLParser.appendObjectWithTags(sb, this.logPWM, "logPWM");
        XMLParser.appendObjectWithTags(sb, this.pfm, "pfm");
        XMLParser.appendObjectWithTags(sb, this.name, "name");
        XMLParser.addTags(sb, this.getClass().getSimpleName());
        return sb;
    }

    @Override
    public void train(DataSet data, double[] weights) throws Exception {
    }

    @Override
    public double getLogProbFor(Sequence sequence, int startpos, int endpos) throws Exception {
        double prob = 0.0;
        int i = startpos;
        while (i <= endpos) {
            prob += this.logPWM[i - startpos][sequence.discreteVal(i)];
            ++i;
        }
        return prob;
    }

    @Override
    public double getLogPriorTerm() throws Exception {
        return 0.0;
    }

    @Override
    public String getInstanceName() {
        return this.name == null ? "PFM Wrapper" : this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public NumericalResultSet getNumericalCharacteristics() throws Exception {
        return null;
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    @Override
    public String toString(NumberFormat nf) {
        if (this.name != null) {
            return this.name;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.logPWM.length) {
            sb.append(nf.format(Math.exp(this.logPWM[i][0])));
            int j = 1;
            while (j < this.logPWM[i].length) {
                sb.append("\t" + nf.format(Math.exp(this.logPWM[i][0])));
                ++j;
            }
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }

    @Override
    protected void fromXML(StringBuffer xml) throws NonParsableException {
        xml = XMLParser.extractForTag(xml, this.getClass().getSimpleName());
        this.alphabets = (AlphabetContainer)XMLParser.extractObjectForTags(xml, "alphabet");
        this.logPWM = (double[][])XMLParser.extractObjectForTags(xml, "logPWM");
        this.pfm = (double[][])XMLParser.extractObjectForTags(xml, "pfm");
        this.name = (String)XMLParser.extractObjectForTags(xml, "name");
        this.length = this.logPWM.length;
    }

    public double[][] getPFM() throws CloneNotSupportedException {
        return (double[][])ArrayHandler.clone((Cloneable[])this.pfm);
    }

    @Override
    public double[][] getPWM() {
        double[][] pwm = new double[this.logPWM.length][];
        int i = 0;
        while (i < pwm.length) {
            pwm[i] = new double[this.logPWM[i].length];
            int j = 0;
            while (j < pwm[i].length) {
                pwm[i][j] = Math.exp(this.logPWM[i][j]);
                ++j;
            }
            ++i;
        }
        return pwm;
    }
}

