/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifiers.assessment;

import de.jstacs.classifiers.AbstractClassifier;
import de.jstacs.classifiers.ClassDimensionException;
import de.jstacs.classifiers.assessment.ClassifierAssessmentAssessParameterSet;
import de.jstacs.classifiers.performanceMeasures.NumericalPerformanceMeasureParameterSet;
import de.jstacs.classifiers.trainSMBased.TrainSMBasedClassifier;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.NonParsableException;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.results.CategoricalResult;
import de.jstacs.results.ListResult;
import de.jstacs.results.MeanResultSet;
import de.jstacs.results.NumericalResultSet;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSet;
import de.jstacs.sequenceScores.statisticalModels.trainable.TrainableStatisticalModel;
import de.jstacs.utils.NullProgressUpdater;
import de.jstacs.utils.ProgressUpdater;
import java.util.LinkedList;

public abstract class ClassifierAssessment {
    AbstractClassifier[] NULL_AC_ARRAY = new AbstractClassifier[0];
    TrainableStatisticalModel[] NULL_AM_ARRAY = new TrainableStatisticalModel[0];
    TrainableStatisticalModel[][] NULL_AM_2DARRAY = new TrainableStatisticalModel[0][0];
    protected AbstractClassifier[] myAbstractClassifier;
    protected TrainableStatisticalModel[][] myModel;
    protected MeanResultSet[] myTempMeanResultSets;
    protected int skipLastClassifiersDuringClassifierTraining;

    private static AbstractClassifier[] turnIntoClassifierArray(boolean buildClassifiersByCrossProduct, TrainableStatisticalModel[][] aMs) throws IllegalArgumentException, WrongAlphabetException, CloneNotSupportedException, ClassDimensionException {
        if (aMs.length < 2) {
            throw new IllegalArgumentException("Given classes of models is less than 2 but a classifier consists of at least 2 models.");
        }
        boolean allFirstDimsEqual = true;
        int tempDim = aMs[0].length;
        int l = 0;
        for (int counter1 = 0; counter1 < aMs.length; ++counter1) {
            if (aMs[counter1].length == 0) {
                return new AbstractClassifier[0];
            }
            if (tempDim != aMs[counter1].length) {
                allFirstDimsEqual = false;
            }
            for (int counter2 = 0; counter2 < aMs[counter1].length; ++counter2) {
                if (aMs[counter1][counter2].getLength() == 0) continue;
                if (l == 0) {
                    l = aMs[counter1][counter2].getLength();
                    continue;
                }
                if (aMs[counter1][counter2].getLength() == l) continue;
                throw new IllegalArgumentException("All models have to be able to use sequences of the same length but at least 2 given models have different length (!=0).");
            }
        }
        TrainableStatisticalModel[] m = new TrainableStatisticalModel[aMs.length];
        AbstractClassifier[] erg = null;
        if (buildClassifiersByCrossProduct) {
            int counter1;
            int anz = 1;
            int[] current = new int[aMs.length];
            int[] max = new int[aMs.length];
            for (counter1 = 0; counter1 < aMs.length; ++counter1) {
                anz *= aMs[counter1].length;
                max[counter1] = aMs[counter1].length - 1;
            }
            erg = new ModelBasedAssessmentClassifier[anz];
            anz = m.length - 1;
            for (counter1 = 0; counter1 < erg.length; ++counter1) {
                int counter2;
                for (counter2 = 0; counter2 < m.length; ++counter2) {
                    m[counter2] = aMs[counter2][current[counter2]];
                }
                erg[counter1] = new ModelBasedAssessmentClassifier(m);
                counter2 = 0;
                while (counter2 < anz && current[counter2] == max[counter2]) {
                    current[counter2++] = 0;
                }
                int n = counter2;
                current[n] = current[n] + 1;
            }
        } else {
            if (!allFirstDimsEqual) {
                throw new IllegalArgumentException("Not all first dimensions of given aMs are equal but this is necessary if classfiers should not be constructed by cross-product of given models.");
            }
            AlphabetContainer abc = aMs[0][0].getAlphabetContainer();
            for (int counter1 = 1; counter1 < aMs[0].length; ++counter1) {
                if (abc.checkConsistency(aMs[0][counter1].getAlphabetContainer())) continue;
                throw new WrongAlphabetException("At least 2 models use different alphabets.");
            }
            erg = new ModelBasedAssessmentClassifier[tempDim];
            for (int i = 0; i < erg.length; ++i) {
                int j = 0;
                while (j < aMs.length) {
                    m[j] = aMs[j++][i];
                }
                erg[i] = new ModelBasedAssessmentClassifier(m);
            }
        }
        return erg;
    }

    protected ClassifierAssessment(AbstractClassifier[] aCs, TrainableStatisticalModel[][] aMs, boolean buildClassifiersByCrossProduct, boolean checkAlphabetConsistencyAndLength) throws IllegalArgumentException, WrongAlphabetException, CloneNotSupportedException, ClassDimensionException {
        int i;
        AbstractClassifier[] tempACs;
        if (aMs == null || aMs.length == 0) {
            this.myModel = this.NULL_AM_2DARRAY;
            tempACs = this.NULL_AC_ARRAY;
        } else {
            this.myModel = new TrainableStatisticalModel[aMs.length][];
            for (i = 0; i < this.myModel.length; ++i) {
                this.myModel[i] = (TrainableStatisticalModel[])ArrayHandler.clone((Cloneable[])aMs[i]);
            }
            tempACs = ClassifierAssessment.turnIntoClassifierArray(buildClassifiersByCrossProduct, this.myModel);
        }
        this.skipLastClassifiersDuringClassifierTraining = tempACs.length;
        if (aCs == null) {
            aCs = this.NULL_AC_ARRAY;
        }
        if (aCs.length > 0 && checkAlphabetConsistencyAndLength) {
            int tempL = aCs[0].getLength();
            AlphabetContainer abc = aCs[0].getAlphabetContainer();
            for (int counter1 = 1; counter1 < aCs.length; ++counter1) {
                if (!abc.checkConsistency(aCs[counter1].getAlphabetContainer())) {
                    throw new WrongAlphabetException("At least 2 classifiers use different alphabets.");
                }
                if (aCs[counter1].getLength() == 0) continue;
                if (tempL == 0) {
                    aCs[counter1].getLength();
                    continue;
                }
                if (aCs[counter1].getLength() == tempL) continue;
                throw new IllegalArgumentException("At least 2 classifiers have different length (!=0).");
            }
        }
        this.myAbstractClassifier = new AbstractClassifier[aCs.length + tempACs.length];
        i = 0;
        while (i < aCs.length) {
            this.myAbstractClassifier[i] = aCs[i++].clone();
        }
        i = 0;
        while (i < tempACs.length) {
            this.myAbstractClassifier[i + aCs.length] = tempACs[i++];
        }
    }

    public ClassifierAssessment(AbstractClassifier ... aCs) throws IllegalArgumentException, WrongAlphabetException, CloneNotSupportedException, ClassDimensionException {
        this(aCs, (TrainableStatisticalModel[][])null, false, true);
    }

    public ClassifierAssessment(boolean buildClassifiersByCrossProduct, TrainableStatisticalModel[] ... aMs) throws IllegalArgumentException, WrongAlphabetException, CloneNotSupportedException, ClassDimensionException {
        this(null, aMs, buildClassifiersByCrossProduct, false);
    }

    public ClassifierAssessment(AbstractClassifier[] aCs, boolean buildClassifiersByCrossProduct, TrainableStatisticalModel[] ... aMs) throws IllegalArgumentException, WrongAlphabetException, CloneNotSupportedException, ClassDimensionException {
        this(aCs, aMs, buildClassifiersByCrossProduct, true);
    }

    public ListResult assess(NumericalPerformanceMeasureParameterSet mp, ClassifierAssessmentAssessParameterSet assessPS, DataSet ... s) throws IllegalArgumentException, WrongAlphabetException, Exception {
        return this.assess(mp, assessPS, (ProgressUpdater)null, s);
    }

    public ListResult assess(NumericalPerformanceMeasureParameterSet mp, ClassifierAssessmentAssessParameterSet assessPS, ProgressUpdater pU, DataSet ... s) throws IllegalArgumentException, WrongAlphabetException, Exception {
        if (pU == null) {
            pU = NullProgressUpdater.getImmutableInstance();
        }
        this.prepareAssessment(s);
        LinkedList<Result> annotation = new LinkedList<Result>();
        annotation.add(new CategoricalResult("kind of assessment", "a description or name of the assessment", this.getNameOfAssessment()));
        annotation.addAll(assessPS.getAnnotation());
        annotation.add(new CategoricalResult("samples", "annotation of used samples", DataSet.getAnnotation(s)));
        this.evaluateClassifier(mp, assessPS, s, pU);
        return new ListResult(this.getNameOfAssessment(), "the results of a " + this.getNameOfAssessment(), new ResultSet(annotation), this.myTempMeanResultSets);
    }

    public ListResult assess(NumericalPerformanceMeasureParameterSet mp, ClassifierAssessmentAssessParameterSet assessPS, ProgressUpdater pU, DataSet[][] ... s) throws IllegalArgumentException, WrongAlphabetException, Exception {
        int i;
        if (pU == null) {
            pU = NullProgressUpdater.getImmutableInstance();
        }
        if (s == null) {
            throw new IllegalArgumentException("Please check the input: No samples are given!");
        }
        int numOfClasses = this.myAbstractClassifier[0].getNumberOfClasses();
        int eL = assessPS.getElementLength();
        boolean exceptionIfMPNotComputable = assessPS.getExceptionIfMPNotComputable();
        DataSet[][][] correctedS = new DataSet[s.length][2][s[0][0].length];
        AlphabetContainer abc = this.myAbstractClassifier[0].getAlphabetContainer();
        for (i = 0; i < s.length; ++i) {
            if (s[i].length != 2) {
                throw new IllegalArgumentException("For each iteration the given sample-3d-array has to contain exactly one array of training-samples and one array of test-samples but it doesn't.");
            }
            if (s[i][0].length != numOfClasses) {
                throw new IllegalArgumentException("For each iteration the given sample-3d-array has to contain a array of training-samples containing one training-sample for each class but it doesn't.");
            }
            if (s[i][1].length != numOfClasses) {
                throw new IllegalArgumentException("For each iteration the given sample-3d-array has to contain a array of test-samples containing one test-sample for each class but it doesn't.");
            }
            for (int j = 0; j < s[i][0].length; ++j) {
                for (int k = 0; k < 2; ++k) {
                    abc.checkConsistency(s[i][k][j].getAlphabetContainer());
                    correctedS[i][k][j] = s[i][k][j].getElementLength() != eL ? new DataSet(s[i][k][j], eL) : s[i][k][j];
                }
            }
        }
        this.myTempMeanResultSets = new MeanResultSet[this.myAbstractClassifier.length];
        for (i = 0; i < this.myAbstractClassifier.length; ++i) {
            this.myTempMeanResultSets[i] = new MeanResultSet(this.myAbstractClassifier[i].getClassifierAnnotation());
        }
        LinkedList<CategoricalResult> annotation = new LinkedList<CategoricalResult>();
        annotation.add(new CategoricalResult("kind of assessment", "a description or name of the assessment", "assessment using a series of user-given pairs of test- and train-datasets"));
        pU.setMax(s.length);
        for (i = 0; i < s.length; ++i) {
            this.train(correctedS[i][0]);
            this.test(mp, exceptionIfMPNotComputable, correctedS[i][1]);
            pU.setValue(i + 1);
            if (pU.isCancelled()) break;
        }
        return new ListResult(this.getNameOfAssessment(), "the results of an assessment using a series of user-given pairs of test- and train-datasets", new ResultSet(annotation), this.myTempMeanResultSets);
    }

    public AbstractClassifier[] getClassifier() throws CloneNotSupportedException {
        AbstractClassifier[] res = new AbstractClassifier[this.myAbstractClassifier.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.myAbstractClassifier[i].clone();
        }
        return res;
    }

    public String getNameOfAssessment() {
        return this.getClass().getSimpleName();
    }

    protected abstract void evaluateClassifier(NumericalPerformanceMeasureParameterSet var1, ClassifierAssessmentAssessParameterSet var2, DataSet[] var3, ProgressUpdater var4) throws IllegalArgumentException, Exception;

    protected void prepareAssessment(DataSet ... s) throws IllegalArgumentException, WrongAlphabetException {
        int i;
        if (s == null || s.length != this.myAbstractClassifier[0].getNumberOfClasses()) {
            throw new IllegalArgumentException("Either no samples are given or the number of samples is not equal to the number of different classes the local classifiers are able to distinguish");
        }
        AlphabetContainer abc = this.myAbstractClassifier[0].getAlphabetContainer();
        for (i = 0; i < s.length; ++i) {
            if (abc.checkConsistency(s[i].getAlphabetContainer())) continue;
            throw new WrongAlphabetException("The AlphabetContainer of DataSet " + i + " does not match with tha AlphabetContainer of the first classifier.");
        }
        this.myTempMeanResultSets = new MeanResultSet[this.myAbstractClassifier.length];
        i = 0;
        while (i < this.myAbstractClassifier.length) {
            this.myTempMeanResultSets[i] = new MeanResultSet(this.myAbstractClassifier[i++].getClassifierAnnotation());
        }
    }

    protected void test(NumericalPerformanceMeasureParameterSet mp, boolean exception, DataSet ... testS) throws SimpleParameter.IllegalValueException, MeanResultSet.InconsistentResultNumberException, MeanResultSet.AdditionImpossibleException, Exception {
        if (testS.length != this.myAbstractClassifier[0].getNumberOfClasses()) {
            throw new IllegalArgumentException("Dimension of given testDataSet-array is not equal to problem-dimension (classifier.getNumberOfClasses).");
        }
        for (int i = 0; i < this.myAbstractClassifier.length; ++i) {
            this.myTempMeanResultSets[i].addResults((NumericalResultSet)this.myAbstractClassifier[i].evaluate(mp, exception, testS), this.myAbstractClassifier[i].getNumericalCharacteristics());
        }
    }

    protected void train(DataSet ... trainS) throws IllegalArgumentException, Exception {
        if (trainS.length != this.myAbstractClassifier[0].getNumberOfClasses()) {
            throw new IllegalArgumentException("Dimension of given trainDataSet-array is not equal to problem-dimension (classifier.getNumberOfClasses).");
        }
        for (int i = 0; i < this.myAbstractClassifier.length - this.skipLastClassifiersDuringClassifierTraining; ++i) {
            this.myAbstractClassifier[i].train(trainS);
        }
        for (int classes = 0; classes < this.myModel.length; ++classes) {
            int models = 0;
            while (models < this.myModel[classes].length) {
                this.myModel[classes][models++].train(trainS[classes]);
            }
        }
    }

    private static class ModelBasedAssessmentClassifier
    extends TrainSMBasedClassifier {
        private ModelBasedAssessmentClassifier(TrainableStatisticalModel ... models) throws IllegalArgumentException, CloneNotSupportedException, ClassDimensionException {
            super(false, models);
        }

        private ModelBasedAssessmentClassifier(StringBuffer xml) throws NonParsableException {
            super(xml);
        }

        @Override
        public TrainSMBasedClassifier clone() throws CloneNotSupportedException {
            try {
                TrainSMBasedClassifier mbc = new TrainSMBasedClassifier(this.models);
                mbc.setClassWeights(false, this.getClassWeights());
                return mbc;
            }
            catch (ClassDimensionException cde) {
                throw new CloneNotSupportedException(cde.getMessage());
            }
        }
    }
}

