/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifiers.assessment;

import de.jstacs.classifiers.AbstractClassifier;
import de.jstacs.classifiers.ClassDimensionException;
import de.jstacs.classifiers.assessment.ClassifierAssessment;
import de.jstacs.classifiers.assessment.ClassifierAssessmentAssessParameterSet;
import de.jstacs.classifiers.assessment.RepeatedHoldOutAssessParameterSet;
import de.jstacs.classifiers.performanceMeasures.NumericalPerformanceMeasureParameterSet;
import de.jstacs.data.DataSet;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.sequenceScores.statisticalModels.trainable.TrainableStatisticalModel;
import de.jstacs.utils.ProgressUpdater;

public class RepeatedHoldOutExperiment
extends ClassifierAssessment {
    protected RepeatedHoldOutExperiment(AbstractClassifier[] aCs, TrainableStatisticalModel[][] aMs, boolean buildClassifiersByCrossProduct, boolean checkAlphabetConsistencyAndLength) throws IllegalArgumentException, WrongAlphabetException, CloneNotSupportedException, ClassDimensionException {
        super(aCs, aMs, buildClassifiersByCrossProduct, checkAlphabetConsistencyAndLength);
    }

    public RepeatedHoldOutExperiment(AbstractClassifier ... aCs) throws IllegalArgumentException, WrongAlphabetException, CloneNotSupportedException, ClassDimensionException {
        super(aCs);
    }

    public RepeatedHoldOutExperiment(boolean buildClassifiersByCrossProduct, TrainableStatisticalModel[] ... aMs) throws IllegalArgumentException, WrongAlphabetException, CloneNotSupportedException, ClassDimensionException {
        super(buildClassifiersByCrossProduct, aMs);
    }

    public RepeatedHoldOutExperiment(AbstractClassifier[] aCs, boolean buildClassifiersByCrossProduct, TrainableStatisticalModel[] ... aMs) throws IllegalArgumentException, WrongAlphabetException, CloneNotSupportedException, ClassDimensionException {
        super(aCs, buildClassifiersByCrossProduct, aMs);
    }

    @Override
    protected void evaluateClassifier(NumericalPerformanceMeasureParameterSet mp, ClassifierAssessmentAssessParameterSet assessPS, DataSet[] s, ProgressUpdater pU) throws IllegalArgumentException, Exception {
        RepeatedHoldOutAssessParameterSet tempAssessPS = null;
        try {
            tempAssessPS = (RepeatedHoldOutAssessParameterSet)assessPS;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Given AssessParameterSet assessPS is not of type RepeatedHoldOutAssessParameterSet.");
        }
        DataSet.PartitionMethod splitMethod = tempAssessPS.getDataSplitMethod();
        int subSeqL = tempAssessPS.getElementLength();
        boolean exceptionIfMPNotComputable = tempAssessPS.getExceptionIfMPNotComputable();
        int repeats = tempAssessPS.getRepeats();
        double[] percents = tempAssessPS.getPercents();
        if (percents.length != this.myAbstractClassifier[0].getNumberOfClasses()) {
            throw new IllegalArgumentException("Given RepeatedHoldOutAssessParameterSet contains a invalid parameter percents. Percents (double[], percentage of test-data of all given class specific data) must contain as much entries as classes the local classifers are able to distinguish.");
        }
        DataSet[][] sTrainTestClassWise = new DataSet[2][s.length];
        pU.setMax(repeats);
        for (int iteration = 0; iteration < repeats; ++iteration) {
            for (int classes = 0; classes < s.length; ++classes) {
                DataSet[] temp = s[classes].partition(percents[classes], splitMethod, subSeqL);
                sTrainTestClassWise[0][classes] = temp[0];
                sTrainTestClassWise[1][classes] = temp[1];
            }
            this.train(sTrainTestClassWise[0]);
            this.test(mp, exceptionIfMPNotComputable, sTrainTestClassWise[1]);
            pU.setValue(iteration + 1);
            if (pU.isCancelled()) break;
        }
    }
}

