/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifiers.assessment;

import de.jstacs.classifiers.AbstractClassifier;
import de.jstacs.classifiers.ClassDimensionException;
import de.jstacs.classifiers.assessment.ClassifierAssessment;
import de.jstacs.classifiers.assessment.ClassifierAssessmentAssessParameterSet;
import de.jstacs.classifiers.assessment.RepeatedSubSamplingAssessParameterSet;
import de.jstacs.classifiers.performanceMeasures.NumericalPerformanceMeasureParameterSet;
import de.jstacs.data.DataSet;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.sequenceScores.statisticalModels.trainable.TrainableStatisticalModel;
import de.jstacs.utils.ProgressUpdater;

public class RepeatedSubSamplingExperiment
extends ClassifierAssessment {
    protected RepeatedSubSamplingExperiment(AbstractClassifier[] aCs, TrainableStatisticalModel[][] aMs, boolean buildClassifiersByCrossProduct, boolean checkAlphabetConsistencyAndLength) throws IllegalArgumentException, WrongAlphabetException, CloneNotSupportedException, ClassDimensionException {
        super(aCs, aMs, buildClassifiersByCrossProduct, checkAlphabetConsistencyAndLength);
    }

    public RepeatedSubSamplingExperiment(AbstractClassifier ... aCs) throws IllegalArgumentException, WrongAlphabetException, CloneNotSupportedException, ClassDimensionException {
        super(aCs);
    }

    public RepeatedSubSamplingExperiment(boolean buildClassifiersByCrossProduct, TrainableStatisticalModel[] ... aMs) throws IllegalArgumentException, WrongAlphabetException, CloneNotSupportedException, ClassDimensionException {
        super(buildClassifiersByCrossProduct, aMs);
    }

    public RepeatedSubSamplingExperiment(AbstractClassifier[] aCs, boolean buildClassifiersByCrossProduct, TrainableStatisticalModel[] ... aMs) throws IllegalArgumentException, WrongAlphabetException, CloneNotSupportedException, ClassDimensionException {
        super(aCs, buildClassifiersByCrossProduct, aMs);
    }

    @Override
    protected void evaluateClassifier(NumericalPerformanceMeasureParameterSet mp, ClassifierAssessmentAssessParameterSet assessPS, DataSet[] s, ProgressUpdater pU) throws IllegalArgumentException, Exception {
        RepeatedSubSamplingAssessParameterSet tempAssessPS = null;
        try {
            tempAssessPS = (RepeatedSubSamplingAssessParameterSet)assessPS;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Given AssessParameterSet assessPS is not of type RepeatedSubSamlplingAssessParameterSet.");
        }
        int eL = tempAssessPS.getElementLength();
        boolean exceptionIfMPNotComputable = tempAssessPS.getExceptionIfMPNotComputable();
        int repeats = tempAssessPS.getRepeats();
        int[] trainN = tempAssessPS.getTrain_TestNumbers(true);
        int[] testN = tempAssessPS.getTrain_TestNumbers(false);
        int subSeqL = tempAssessPS.getElementLength();
        if (trainN.length != this.myAbstractClassifier[0].getNumberOfClasses()) {
            throw new IllegalArgumentException("Given RepeatedSubSamlpingAssessParameterSet contains a invalid parameter trainDataNumbers. trainDataNumbers (int[], number of train-data items that should be subsampled for each class) must contain as much entries as classes the local classifers are able to distinguish.");
        }
        if (testN.length != this.myAbstractClassifier[0].getNumberOfClasses()) {
            throw new IllegalArgumentException("Given RepeatedSubSamlpingAssessParameterSet contains a invalid parameter testDataNumbers. testDataNumbers (int[], number of test-data items that should be subsampled for each class) must contain as much entries as classes the local classifers are able to distinguish.");
        }
        DataSet[] tempS = new DataSet[s.length];
        for (int i = 0; i < tempS.length; ++i) {
            tempS[i] = s[i].getElementLength() != eL ? new DataSet(s[i], eL) : s[i];
        }
        DataSet[][] sTrainTestClassWise = new DataSet[2][s.length];
        pU.setMax(repeats);
        for (int iteration = 0; iteration < repeats; ++iteration) {
            for (int classes = 0; classes < s.length; ++classes) {
                sTrainTestClassWise[0][classes] = tempS[classes].subSampling(trainN[classes]);
                sTrainTestClassWise[1][classes] = new DataSet(tempS[classes].subSampling(testN[classes]), subSeqL);
            }
            this.train(sTrainTestClassWise[0]);
            this.test(mp, exceptionIfMPNotComputable, sTrainTestClassWise[1]);
            pU.setValue(iteration + 1);
            if (pU.isCancelled()) break;
        }
    }
}

