/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.io;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.LinkedList;

public final class ArrayHandler {
    public static <T> Class getSuperClassOf(T ... o) {
        LinkedList classHierarchy = new LinkedList();
        HashSet hash = new HashSet();
        for (int i = 0; i < o.length; ++i) {
            Class<?> current;
            if (o[i] == null) continue;
            if (classHierarchy.size() == 0) {
                for (current = o[i].getClass(); current != Object.class; current = current.getSuperclass()) {
                    classHierarchy.add(current);
                    hash.add(current);
                }
                classHierarchy.add(current);
                hash.add(current);
                continue;
            }
            while (!hash.contains(current)) {
                current = current.getSuperclass();
            }
            while (classHierarchy.get(0) != current) {
                hash.remove(classHierarchy.remove(0));
            }
            if (classHierarchy.size() == 1) break;
        }
        if (classHierarchy.size() > 0) {
            return (Class)classHierarchy.get(0);
        }
        return o.getClass().getComponentType();
    }

    public static Object[] cast(Object[] o) {
        return ArrayHandler.cast(ArrayHandler.getSuperClassOf(o), o);
    }

    public static <S> S[] cast(Class<? extends S> c, Object[] o) {
        if (o.getClass().getComponentType().equals(c)) {
            return o;
        }
        Object[] res = (Object[])Array.newInstance(c, o.length);
        for (int i = 0; i < o.length; ++i) {
            res[i] = o[i];
        }
        return res;
    }

    public static <T extends Cloneable> T[] clone(T ... t) throws CloneNotSupportedException {
        return (Cloneable[])ArrayHandler.deepClone(t);
    }

    private static Object deepClone(Object s) throws CloneNotSupportedException {
        Object res;
        block7: {
            res = null;
            if (s == null) break block7;
            Class<?> k = s.getClass();
            if (k.isArray()) {
                Class<?> c = k.getComponentType();
                int l = Array.getLength(s);
                res = Array.newInstance(c, l);
                if (c.isPrimitive()) {
                    System.arraycopy(s, 0, res, 0, l);
                } else {
                    for (int i = 0; i < l; ++i) {
                        Array.set(res, i, ArrayHandler.deepClone(Array.get(s, i)));
                    }
                }
            } else {
                try {
                    Method cloneMethod = k.getMethod("clone", new Class[0]);
                    res = cloneMethod.invoke(s, new Object[0]);
                }
                catch (Exception e) {
                    CloneNotSupportedException cnse = new CloneNotSupportedException(e.getMessage());
                    cnse.setStackTrace(e.getStackTrace());
                    throw cnse;
                }
            }
        }
        return res;
    }

    public static <T extends Cloneable> T[] createArrayOf(T t, int l) throws CloneNotSupportedException {
        Class<?> c = t.getClass();
        Cloneable[] res = (Cloneable[])Array.newInstance(c, l);
        try {
            Method cloneMethod = c.getMethod("clone", new Class[0]);
            for (int i = 0; i < l; ++i) {
                res[i] = (Cloneable)cloneMethod.invoke(t, new Object[0]);
            }
        }
        catch (Exception e) {
            CloneNotSupportedException cnse = new CloneNotSupportedException(e.getMessage());
            cnse.setStackTrace(e.getStackTrace());
            throw cnse;
        }
        return res;
    }
}

