/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.differentiable.logistic;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.sequenceScores.differentiable.AbstractDifferentiableSequenceScore;
import de.jstacs.sequenceScores.differentiable.logistic.LogisticConstraint;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import java.util.Arrays;
import java.util.Random;

public class LogisticDiffSS
extends AbstractDifferentiableSequenceScore {
    private LogisticConstraint[] constraint;
    private double[] parameter;
    private static final String XML_TAG = LogisticDiffSS.class.getSimpleName();

    public LogisticDiffSS(AlphabetContainer con, int length, LogisticConstraint ... constraint) throws CloneNotSupportedException {
        super(con, length);
        this.constraint = (LogisticConstraint[])ArrayHandler.clone((Cloneable[])constraint);
        this.parameter = new double[constraint.length];
    }

    public LogisticDiffSS(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public LogisticDiffSS clone() throws CloneNotSupportedException {
        LogisticDiffSS clone = (LogisticDiffSS)super.clone();
        clone.parameter = (double[])this.parameter.clone();
        clone.constraint = (LogisticConstraint[])ArrayHandler.clone((Cloneable[])this.constraint);
        return clone;
    }

    @Override
    public double[] getCurrentParameterValues() throws Exception {
        return (double[])this.parameter.clone();
    }

    @Override
    public String getInstanceName() {
        return "logistic function";
    }

    @Override
    public double getLogScoreFor(Sequence seq, int start) {
        double res = 0.0;
        for (int i = 0; i < this.constraint.length; ++i) {
            res += this.parameter[i] * this.constraint[i].getValue(seq, start);
        }
        return res;
    }

    @Override
    public double getLogScoreAndPartialDerivation(Sequence seq, int start, IntList indices, DoubleList partialDer) {
        double res = 0.0;
        for (int i = 0; i < this.constraint.length; ++i) {
            double f = this.constraint[i].getValue(seq, start);
            res += this.parameter[i] * f;
            indices.add(i);
            partialDer.add(f);
        }
        return res;
    }

    @Override
    public int getNumberOfParameters() {
        return this.parameter.length;
    }

    @Override
    public void initializeFunction(int index, boolean freeParams, DataSet[] data, double[][] weights) throws Exception {
        this.initializeFunctionRandomly(freeParams);
    }

    @Override
    public void initializeFunctionRandomly(boolean freeParams) throws Exception {
        Random r = new Random();
        for (int i = 0; i < this.parameter.length; ++i) {
            this.parameter[i] = r.nextGaussian();
        }
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    @Override
    public void setParameters(double[] params, int start) {
        System.arraycopy(params, start, this.parameter, 0, this.parameter.length);
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer();
        XMLParser.appendObjectWithTags(xml, this.alphabets, "alphabetContainer");
        XMLParser.appendObjectWithTags(xml, this.length, "length");
        XMLParser.appendObjectWithTags(xml, this.constraint, "constraint");
        XMLParser.appendObjectWithTags(xml, this.parameter, "parameter");
        XMLParser.addTags(xml, XML_TAG);
        return xml;
    }

    @Override
    protected void fromXML(StringBuffer xml) throws NonParsableException {
        xml = XMLParser.extractForTag(xml, XML_TAG);
        this.alphabets = (AlphabetContainer)XMLParser.extractObjectForTags(xml, "alphabetContainer");
        this.length = XMLParser.extractObjectForTags(xml, "length", Integer.class);
        this.constraint = XMLParser.extractObjectForTags(xml, "constraint", LogisticConstraint[].class);
        this.parameter = XMLParser.extractObjectForTags(xml, "parameter", double[].class);
    }

    public String toString() {
        return Arrays.toString(this.parameter);
    }
}

