/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import org.biojava.bio.program.sax.BlastLikeSAXParser;
import org.biojava.bio.program.xml.SimpleXMLEmitter;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class BlastLikeToXMLConverter {
    private String oInput;
    private XMLReader oParser;
    private boolean tStrict = true;

    public BlastLikeToXMLConverter(String poInput) {
        this.oInput = poInput;
    }

    public void convert() throws IOException, SAXException {
        this.oParser = new BlastLikeSAXParser();
        if (this.tStrict) {
            ((BlastLikeSAXParser)this.oParser).setModeStrict();
        } else {
            ((BlastLikeSAXParser)this.oParser).setModeLazy();
        }
        try {
            this.oParser.setFeature("http://xml.org/sax/features/namespaces", true);
            this.oParser.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        }
        catch (Exception e) {
            System.out.println("WARNING: ignoring attempt to set illegal combination of parser features");
            System.out.println(e);
        }
        SimpleXMLEmitter oHandler = new SimpleXMLEmitter(true);
        this.oParser.setContentHandler(oHandler);
        try {
            FileInputStream oInputFileStream = new FileInputStream(this.oInput);
            BufferedReader oContents = new BufferedReader(new InputStreamReader(oInputFileStream));
            this.oParser.parse(new InputSource(oContents));
        }
        catch (FileNotFoundException x) {
            System.out.println(x.getMessage());
            System.out.println("Couldn't open file");
            System.exit(0);
        }
        System.out.println();
    }

    public void setModeStrict() {
        this.tStrict = true;
    }

    public void setModeLazy() {
        this.tStrict = false;
    }
}

