/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.phylo.io.nexus;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.seq.io.ParseException;
import org.biojavax.bio.phylo.io.nexus.NexusBlock;
import org.biojavax.bio.phylo.io.nexus.NexusComment;
import org.biojavax.bio.phylo.io.nexus.NexusFileFormat;

public class TaxaBlock
extends NexusBlock.Abstract {
    public static final String TAXA_BLOCK = "TAXA";
    private int dimensionsNTax = 0;
    private List taxLabels = new ArrayList();
    private List comments = new ArrayList();

    public TaxaBlock() {
        super(TAXA_BLOCK);
    }

    public void setDimensionsNTax(int dimensionsNTax) {
        this.dimensionsNTax = dimensionsNTax;
    }

    public int getDimensionsNTax() {
        return this.dimensionsNTax;
    }

    public void addTaxLabel(String taxLabel) throws ParseException {
        if (this.taxLabels.contains(taxLabel)) {
            throw new ParseException("Duplicate taxa label: " + taxLabel);
        }
        try {
            int i = Integer.parseInt(taxLabel);
            if (i <= this.taxLabels.size()) {
                throw new ParseException("Taxa label " + i + " refers to already extant taxa position");
            }
        }
        catch (NumberFormatException e) {
        }
        catch (ParseException e) {
            throw e;
        }
        this.taxLabels.add(taxLabel);
    }

    public void removeTaxLabel(String taxLabel) {
        this.taxLabels.remove(taxLabel);
    }

    public boolean containsTaxLabel(String taxLabel) {
        if (this.taxLabels.contains(taxLabel)) {
            return true;
        }
        try {
            int i = Integer.parseInt(taxLabel);
            if (i <= this.taxLabels.size() + 1) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    public List getTaxLabels() {
        return this.taxLabels;
    }

    public void addComment(NexusComment comment) {
        this.comments.add(comment);
    }

    public void removeComment(NexusComment comment) {
        this.comments.remove(comment);
    }

    public List getComments() {
        return this.comments;
    }

    protected void writeBlockContents(Writer writer) throws IOException {
        Iterator i = this.comments.iterator();
        while (i.hasNext()) {
            ((NexusComment)i.next()).writeObject(writer);
            writer.write(NexusFileFormat.NEW_LINE);
        }
        writer.write(" DIMENSIONS NTAX=" + this.dimensionsNTax + ";" + NexusFileFormat.NEW_LINE);
        writer.write(" TAXLABELS");
        i = this.taxLabels.iterator();
        while (i.hasNext()) {
            writer.write(32);
            this.writeToken(writer, (String)i.next());
        }
        writer.write(";" + NexusFileFormat.NEW_LINE);
    }
}

