/*
 * Decompiled with CFR 0.152.
 */
package projects;

import de.jstacs.algorithms.optimization.termination.SmallDifferenceOfFunctionEvaluationsCondition;
import de.jstacs.algorithms.optimization.termination.TerminationCondition;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.StringExtractor;
import de.jstacs.motifDiscovery.MotifDiscoverer;
import de.jstacs.sequenceScores.statisticalModels.trainable.AbstractTrainableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.trainable.TrainableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.homogeneous.HomogeneousMM;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.homogeneous.parameters.HomMMParameterSet;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.BayesianNetworkTrainSM;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.StructureLearner;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.parameters.BayesianNetworkTrainSMParameterSet;
import de.jstacs.sequenceScores.statisticalModels.trainable.mixture.AbstractMixtureTrainSM;
import de.jstacs.sequenceScores.statisticalModels.trainable.mixture.StrandTrainSM;
import de.jstacs.sequenceScores.statisticalModels.trainable.mixture.motif.ZOOPSTrainSM;
import de.jstacs.sequenceScores.statisticalModels.trainable.mixture.motif.positionprior.GaussianLikePositionPrior;
import de.jstacs.sequenceScores.statisticalModels.trainable.mixture.motif.positionprior.PositionPrior;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;

public class MotifAdjuster {
    public static void main(String[] args) {
        System.out.println("java ... MotifAdjuster <file> <ignoreChar> <length> <fgOrder> <ess> <bothStrands> <output> <sigma> <p(no motif)>");
        try {
            DNAAlphabetContainer con = DNAAlphabetContainer.SINGLETON;
            char ignore = args[1].charAt(0);
            DataSet s = new DataSet(con, new StringExtractor(new File(args[0]), 200, ignore));
            if (s.getElementLength() == 0) {
                System.out.println("All sequences have to have the same length.");
            } else {
                String line;
                AbstractTrainableStatisticalModel motifModel;
                System.out.println(s.getAnnotation() + ": " + s.getNumberOfElements() + " sequences of length " + s.getElementLength());
                int sl = Integer.parseInt(args[2]);
                int l = s.getElementLength();
                int max = (l - sl) / 2;
                byte fgOrder = Byte.parseByte(args[3]);
                double ess = Double.parseDouble(args[4]);
                boolean bothStrands = Boolean.parseBoolean(args[5]);
                double sigma = Double.parseDouble(args[7]);
                double pBg = Double.parseDouble(args[8]);
                double pwmESS = (1.0 - pBg) * ess;
                double strandHyper = pwmESS / 2.0;
                BayesianNetworkTrainSMParameterSet p = new BayesianNetworkTrainSMParameterSet(con, sl, pwmESS, "foreground model", StructureLearner.ModelType.IMM, fgOrder, StructureLearner.LearningType.ML_OR_MAP);
                SmallDifferenceOfFunctionEvaluationsCondition stop = new SmallDifferenceOfFunctionEvaluationsCondition(1.0E-6);
                if (bothStrands) {
                    motifModel = new StrandTrainSM((TrainableStatisticalModel)new BayesianNetworkTrainSM(p), 1, new double[]{strandHyper, strandHyper}, 1.0, (TerminationCondition)stop, AbstractMixtureTrainSM.Parameterization.LAMBDA);
                    ((StrandTrainSM)motifModel).setOutputStream(null);
                } else {
                    motifModel = new BayesianNetworkTrainSM(p);
                }
                HomogeneousMM backgroundModel = new HomogeneousMM(new HomMMParameterSet(con, ((double)s.getElementLength() - (1.0 - pBg) * (double)sl) * ess, null, 0));
                GaussianLikePositionPrior pr = new GaussianLikePositionPrior(l, max, sigma);
                System.out.println("prior prop. to: exp( -(" + max + " - l)^2/(2 * " + sigma + "^2) )");
                ZOOPSTrainSM em = new ZOOPSTrainSM((TrainableStatisticalModel)motifModel, (TrainableStatisticalModel)backgroundModel, false, 10, 1.0 - pBg, (PositionPrior)pr, 1.0, (TerminationCondition)stop, AbstractMixtureTrainSM.Parameterization.LAMBDA);
                if (Boolean.parseBoolean(args[6])) {
                    em.setOutputStream(System.out);
                } else {
                    em.setOutputStream(null);
                }
                em.train(s);
                System.out.println();
                System.out.println("models: ");
                System.out.println(em);
                motifModel = (AbstractTrainableStatisticalModel)em.getModel(0);
                StrandTrainSM strand = null;
                if (bothStrands) {
                    strand = (StrandTrainSM)motifModel;
                }
                System.out.println("results for " + s.getNumberOfElements() + " sites");
                System.out.println();
                System.out.println("\"annotation\"\tsequence\tcontains BS\tpredicted shift\tpredicted strand\tadjusted BS");
                BufferedReader reader = new BufferedReader(new FileReader(args[0]));
                while ((line = reader.readLine()) != null) {
                    String annot = " ";
                    while (line.charAt(0) == ignore) {
                        annot = line;
                        line = reader.readLine();
                    }
                    Sequence seq = Sequence.create(con, line);
                    System.out.print("\"" + annot.substring(1).trim() + "\"\t" + seq + "\t");
                    if (em.getIndexOfMaximalComponentFor(seq) == 1) {
                        System.out.print("0");
                    } else {
                        double[] prof = em.getProfileOfScoresFor(0, 0, seq, 0, MotifDiscoverer.KindOfProfile.UNNORMALIZED_CONDITIONAL);
                        int start = MotifAdjuster.getIndexOfMax(prof);
                        System.out.print("1\t" + (start - max) + "\t");
                        seq = seq.getSubSequence(start, sl);
                        if (bothStrands) {
                            if (strand.getIndexOfMaximalComponentFor(seq) == 0) {
                                System.out.print("forward ");
                            } else {
                                System.out.print("rev. compl.");
                                seq = seq.reverseComplement();
                            }
                        } else {
                            System.out.print("forward ");
                        }
                        System.out.print("\t" + seq);
                    }
                    System.out.println();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static int getIndexOfMax(double[] array) {
        int idx = 0;
        for (int i = 1; i < array.length; ++i) {
            if (!(array[idx] < array[i])) continue;
            idx = i;
        }
        return idx;
    }
}

