/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifiers.differentiableSequenceScoreBased;

import de.jstacs.algorithms.optimization.DimensionException;
import de.jstacs.classifiers.differentiableSequenceScoreBased.AbstractMultiThreadedOptimizableFunction;
import de.jstacs.classifiers.differentiableSequenceScoreBased.OptimizableFunction;
import de.jstacs.classifiers.differentiableSequenceScoreBased.logPrior.DoesNothingLogPrior;
import de.jstacs.classifiers.differentiableSequenceScoreBased.logPrior.LogPrior;
import de.jstacs.data.DataSet;
import de.jstacs.sequenceScores.differentiable.DifferentiableSequenceScore;
import de.jstacs.sequenceScores.statisticalModels.differentiable.DifferentiableStatisticalModel;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import java.util.Arrays;

public abstract class DiffSSBasedOptimizableFunction
extends AbstractMultiThreadedOptimizableFunction {
    protected int[] shortcut;
    protected DifferentiableSequenceScore[][] score;
    protected DoubleList[][] dList;
    protected IntList[][] iList;
    protected LogPrior prior;

    public DiffSSBasedOptimizableFunction(int threads, DifferentiableSequenceScore[] score, DataSet[] data, double[][] weights, LogPrior prior, boolean norm, boolean freeParams) throws IllegalArgumentException {
        super(threads, data, weights, norm, freeParams);
        this.shortcut = new int[this.cl + 1];
        this.shortcut[0] = freeParams ? this.cl - 1 : this.cl;
        this.prior = prior == null ? DoesNothingLogPrior.defaultInstance : prior;
        this.dList = new DoubleList[threads][this.cl];
        this.iList = new IntList[threads][this.cl];
        this.score = new DifferentiableSequenceScore[threads][this.cl];
        int i = 0;
        while (i < this.cl) {
            this.score[0][i] = score[i];
            int j = 0;
            while (j < threads) {
                this.dList[j][i] = new DoubleList();
                this.iList[j][i] = new IntList();
                ++j;
            }
            ++i;
        }
    }

    public final double[] getClassParams(double[] params) {
        double[] res = new double[this.cl];
        System.arraycopy(params, 0, res, 0, this.shortcut[0]);
        if (this.freeParams) {
            res[this.shortcut[0]] = 0.0;
        }
        return res;
    }

    @Override
    public final int getDimensionOfScope() {
        return this.shortcut[this.cl];
    }

    @Override
    protected void setThreadIndependentParameters() throws DimensionException {
        if (this.params == null || this.params.length != this.shortcut[this.cl]) {
            if (this.params != null) {
                throw new DimensionException(this.params.length, this.shortcut[this.cl]);
            }
            throw new DimensionException(0, this.shortcut[this.cl]);
        }
        int counter1 = 0;
        while (counter1 < this.shortcut[0]) {
            this.logClazz[counter1] = this.params[counter1];
            this.clazz[counter1] = Math.exp(this.logClazz[counter1]);
            ++counter1;
        }
        if (this.freeParams) {
            this.clazz[this.cl - 1] = Math.exp(this.logClazz[this.cl - 1]);
        }
    }

    @Override
    public void getParameters(OptimizableFunction.KindOfParameter kind, double[] erg) throws Exception {
        switch (kind) {
            case PLUGIN: {
                double[] ess = new double[this.score[0].length];
                double discount = 0.0;
                double e = 0.0;
                int i = 0;
                while (i < this.cl) {
                    if (this.score[0][i] instanceof DifferentiableStatisticalModel) {
                        ess[i] = ((DifferentiableStatisticalModel)this.score[0][i]).getESS();
                    }
                    e += ess[i];
                    ++i;
                }
                if (this.freeParams) {
                    discount = this.score[0][this.cl - 1].getInitialClassParam((this.sum[this.cl - 1] + ess[this.cl - 1]) / (this.sum[this.cl] + e));
                }
                i = 0;
                while (i < this.shortcut[0]) {
                    erg[i] = this.score[0][i].getInitialClassParam((this.sum[i] + ess[i]) / (this.sum[this.cl] + e)) - discount;
                    ++i;
                }
                break;
            }
            case LAST: {
                int i = 0;
                while (i < this.shortcut[0]) {
                    erg[i] = this.logClazz[i];
                    ++i;
                }
                break;
            }
            case ZEROS: {
                Arrays.fill(erg, 0.0);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown kind of parameter");
            }
        }
        int i = 0;
        while (i < this.cl) {
            System.arraycopy(this.score[0][i].getCurrentParameterValues(), 0, erg, this.shortcut[i], this.score[0][i].getNumberOfParameters());
            ++i;
        }
    }

    @Override
    protected void setParams(int index) throws DimensionException {
        int counter1 = 0;
        while (counter1 < this.cl) {
            this.score[index][counter1].setParameters(this.params, this.shortcut[counter1]);
            ++counter1;
        }
    }

    public final void addTermToClassParameter(int classIndex, double term) {
        if (classIndex < 0 || classIndex >= this.cl) {
            throw new IndexOutOfBoundsException("check the class index");
        }
        if (this.freeParams && classIndex == this.cl - 1) {
            int i = 0;
            while (i < this.shortcut[0]) {
                int n = i;
                this.logClazz[n] = this.logClazz[n] - term;
                this.clazz[i] = Math.exp(this.logClazz[i]);
                ++i;
            }
        } else {
            int n = classIndex;
            this.logClazz[n] = this.logClazz[n] + term;
            this.clazz[classIndex] = Math.exp(this.logClazz[classIndex]);
        }
    }

    public abstract void reset(DifferentiableSequenceScore[] var1) throws Exception;

    @Override
    public final void reset() throws Exception {
        this.reset(this.score[0]);
        System.gc();
    }
}

