/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifiers.differentiableSequenceScoreBased.sampling;

import de.jstacs.classifiers.differentiableSequenceScoreBased.DiffSSBasedOptimizableFunction;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.GenDisMixClassifier;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.GenDisMixClassifierParameterSet;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.LearningPrinciple;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.LogGenDisMixFunction;
import de.jstacs.classifiers.differentiableSequenceScoreBased.logPrior.LogPrior;
import de.jstacs.classifiers.differentiableSequenceScoreBased.sampling.SamplingGenDisMixClassifierParameterSet;
import de.jstacs.classifiers.differentiableSequenceScoreBased.sampling.SamplingScoreBasedClassifier;
import de.jstacs.data.DataSet;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.sampling.BurnInTest;
import de.jstacs.sequenceScores.statisticalModels.differentiable.DifferentiableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.differentiable.SamplingDifferentiableStatisticalModel;

public class SamplingGenDisMixClassifier
extends SamplingScoreBasedClassifier {
    private LogPrior prior;
    private double[] beta;
    private double factor;

    public SamplingGenDisMixClassifier(SamplingGenDisMixClassifierParameterSet params, BurnInTest burnInTest, double[] classVariances, LogPrior prior, double[] beta, SamplingDifferentiableStatisticalModel ... scoringFunctions) throws CloneNotSupportedException {
        super(params, burnInTest, classVariances, scoringFunctions);
        this.prior = prior;
        this.beta = (double[])beta.clone();
        this.factor = 0.0;
        int i = 0;
        while (i < beta.length) {
            if (beta[i] > 0.0 && this.factor == 0.0) {
                this.factor = 1.0 / beta[i];
            } else if (beta[i] > 0.0 && this.factor > 0.0 && 1.0 / this.factor != beta[i]) {
                this.factor = 1.0;
            }
            ++i;
        }
    }

    public SamplingGenDisMixClassifier(SamplingGenDisMixClassifierParameterSet params, BurnInTest burnInTest, double[] classVariances, LogPrior prior, LearningPrinciple principle, SamplingDifferentiableStatisticalModel ... scoringFunctions) throws CloneNotSupportedException {
        this(params, burnInTest, classVariances, prior, LearningPrinciple.getBeta(principle), scoringFunctions);
    }

    public SamplingGenDisMixClassifier(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    protected DiffSSBasedOptimizableFunction getFunction(DataSet[] data, double[][] weights) throws Exception {
        LogGenDisMixFunction fun = new LogGenDisMixFunction(((SamplingGenDisMixClassifierParameterSet)this.params).getNumberOfThreads(), this.scoringFunctions, data, weights, this.prior, this.beta, false, this.params.getFreeParameters());
        fun.reset();
        return fun;
    }

    @Override
    protected double modifyFunctionValue(double value) {
        return this.factor * value;
    }

    @Override
    protected String getXMLTag() {
        return "SamplingGenDisMixClassifier";
    }

    @Override
    protected StringBuffer getFurtherClassifierInfos() {
        StringBuffer xml = super.getFurtherClassifierInfos();
        XMLParser.appendObjectWithTags(xml, this.prior, "prior");
        XMLParser.appendObjectWithTags(xml, this.beta, "beta");
        return xml;
    }

    @Override
    protected void extractFurtherClassifierInfosFromXML(StringBuffer xml) throws NonParsableException {
        this.prior = XMLParser.extractObjectForTags(xml, "prior", LogPrior.class);
        this.beta = XMLParser.extractObjectForTags(xml, "beta", double[].class);
    }

    public GenDisMixClassifier getClassifierForBestParameters(GenDisMixClassifierParameterSet params) throws Exception {
        GenDisMixClassifier cls = new GenDisMixClassifier(params, this.prior, this.beta, (DifferentiableStatisticalModel[])this.scoringFunctions);
        cls.initUsingParameters(this.getBestParameters());
        return cls;
    }

    public GenDisMixClassifier getClassifierForMeanParameters(GenDisMixClassifierParameterSet params, boolean testBurnIn, int minBurnInSteps) throws Exception {
        GenDisMixClassifier cls = new GenDisMixClassifier(params, this.prior, this.beta, (DifferentiableStatisticalModel[])this.scoringFunctions);
        cls.initUsingParameters(this.getMeanParameters(testBurnIn, minBurnInSteps));
        return cls;
    }
}

