/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data.sequences.annotation;

import de.jstacs.data.sequences.annotation.LocatedSequenceAnnotation;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.results.Result;
import java.util.Collection;

public class LocatedSequenceAnnotationWithLength
extends LocatedSequenceAnnotation {
    private int length;

    public LocatedSequenceAnnotationWithLength(int position, int length, String type, String identifier, Result ... results) {
        super(position, type, identifier, results);
        this.length = length;
    }

    public LocatedSequenceAnnotationWithLength(int position, int length, String type, String identifier, Collection<Result> results) {
        super(position, type, identifier, results);
        this.length = length;
    }

    public LocatedSequenceAnnotationWithLength(int position, int length, String type, String identifier, SequenceAnnotation[] annotations, Result ... additionalAnnotations) {
        super(position, type, identifier, annotations, additionalAnnotations);
        this.length = length;
    }

    public LocatedSequenceAnnotationWithLength(String type, String identifier, LocatedSequenceAnnotation[] annotations, Result ... additionalAnnotations) {
        super(type, identifier, annotations, additionalAnnotations);
        int end = -2147483647;
        int i = 0;
        while (i < annotations.length) {
            if (annotations[i] instanceof LocatedSequenceAnnotationWithLength) {
                if (((LocatedSequenceAnnotationWithLength)annotations[i]).getEnd() > end) {
                    end = ((LocatedSequenceAnnotationWithLength)annotations[i]).getEnd();
                }
            } else if (annotations[i].getPosition() + 1 > end) {
                end = annotations[i].getPosition() + 1;
            }
            ++i;
        }
        this.length = end - this.getPosition();
    }

    public LocatedSequenceAnnotationWithLength(StringBuffer representation) throws NonParsableException {
        super(representation);
    }

    @Override
    protected void fromXML(StringBuffer representation) throws NonParsableException {
        representation = XMLParser.extractForTag(representation, "locatedSequenceAnnotationWithLength");
        super.fromXML(XMLParser.extractForTag(representation, "locatedSequenceAnnotation"));
        this.length = XMLParser.extractObjectForTags(representation, "length", Integer.TYPE);
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer buf = super.toXML();
        XMLParser.addTags(buf, "locatedSequenceAnnotation");
        XMLParser.appendObjectWithTags(buf, this.length, "length");
        XMLParser.addTags(buf, "locatedSequenceAnnotationWithLength");
        return buf;
    }

    public int getLength() {
        return this.length;
    }

    public int getEnd() {
        return this.getPosition() + this.length;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString());
        buf.append("length: ");
        buf.append(this.length);
        buf.append("\n");
        return buf.toString();
    }

    public boolean overlaps(LocatedSequenceAnnotationWithLength second) {
        return this.getPosition() <= second.getPosition() && this.getEnd() > second.getPosition() || this.getPosition() >= second.getPosition() && second.getEnd() > this.getPosition();
    }
}

