/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.parameters;

import de.jstacs.DataType;
import de.jstacs.InstantiableFromParameterSet;
import de.jstacs.Singleton;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.ParameterSetParser;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.InstanceParameterSet;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.SelectionParameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.utils.SubclassFinder;
import java.util.Iterator;
import java.util.LinkedList;

public abstract class SequenceScoringParameterSet<T extends InstantiableFromParameterSet>
extends InstanceParameterSet<T> {
    protected Parameter alphabet;
    protected Parameter length;
    private boolean variableLength;

    public SequenceScoringParameterSet(Class<T> instanceClass, AlphabetContainer.AlphabetContainerType type, boolean simple) {
        this(instanceClass, type, simple, false);
    }

    public SequenceScoringParameterSet(Class<T> instanceClass, AlphabetContainer.AlphabetContainerType type, boolean simple, boolean variableLength) {
        super(instanceClass);
        this.variableLength = variableLength;
        try {
            LinkedList<InstanceParameterSet<AlphabetContainer>> list = SubclassFinder.getInstanceParameterSets(AlphabetContainer.class, AlphabetContainer.class.getPackage().getName());
            ParameterSet[] ps = new InstanceParameterSet[list.size()];
            Iterator it = list.iterator();
            int i = 0;
            while (it.hasNext()) {
                InstanceParameterSet p = (InstanceParameterSet)it.next();
                if (Singleton.class.isAssignableFrom(p.getClass())) {
                    ps[i] = p;
                } else {
                    Class<?> c = p.getClass();
                    ps[i] = (InstanceParameterSet)c.getConstructor(AlphabetContainer.AlphabetContainerType.class, Boolean.TYPE).newInstance(new Object[]{type, simple});
                }
                ++i;
            }
            this.alphabet = new SelectionParameter("Alphabet", "The alphabet the model works on", true, ps);
            this.length = variableLength ? new SimpleParameter(DataType.INT, "Length", "The length of sequences the model can work on", true, new NumberValidator<Integer>(0, 0), 0) : new SimpleParameter(DataType.INT, "Length", "The length of sequences the model can work on", true, new NumberValidator<Integer>(1, Integer.MAX_VALUE));
        }
        catch (Exception hopefullyDoesNotHappen) {
            RuntimeException ex = new RuntimeException(hopefullyDoesNotHappen);
            ex.setStackTrace(hopefullyDoesNotHappen.getStackTrace());
            throw ex;
        }
    }

    public SequenceScoringParameterSet(StringBuffer representation) throws NonParsableException {
        super(representation);
    }

    public SequenceScoringParameterSet(Class<T> instanceClass, AlphabetContainer alphabet, int length, boolean variableLength) throws Exception {
        this(instanceClass, alphabet.getType(), alphabet.isSimple(), variableLength);
        this.length.setValue(length);
        this.alphabet.setValue(alphabet.getCurrentParameterSet());
    }

    public SequenceScoringParameterSet(Class<T> instanceClass, AlphabetContainer alphabet) throws Exception {
        this(instanceClass, alphabet, 0, true);
    }

    @Override
    public boolean hasDefaultOrIsSet() {
        boolean erg;
        boolean bl = erg = super.hasDefaultOrIsSet() && this.alphabet.hasDefaultOrIsSet() && this.length.hasDefaultOrIsSet();
        if (erg) {
            int l = 0;
            if (this.alphabet != null) {
                l = ((AlphabetContainer.AbstractAlphabetContainerParameterSet)this.alphabet.getValue()).getPossibleLength();
            }
            if (!(erg &= l == 0 || (Integer)this.length.getValue() == l)) {
                this.errorMessage = "The length of the alphabet and the length of the model must match!";
            }
        }
        return erg;
    }

    @Override
    public void reset() {
        super.reset();
        this.length.reset();
        this.alphabet.reset();
    }

    public AlphabetContainer getAlphabetContainer() {
        try {
            return (AlphabetContainer)((AlphabetContainer.AbstractAlphabetContainerParameterSet)this.alphabet.getValue()).getInstance();
        }
        catch (ParameterSetParser.NotInstantiableException e) {
            throw new RuntimeException(e);
        }
    }

    public int getLength() throws IllegalArgumentException {
        int l = (Integer)this.length.getValue();
        if (this.variableLength && l != 0) {
            throw new IllegalArgumentException("The model can handle sequences of variable length, but length is defined as " + l);
        }
        return l;
    }

    @Override
    protected void fromXML(StringBuffer representation) throws NonParsableException {
        representation = XMLParser.extractForTag(representation, "sequenceScoringParameterSet");
        super.fromXML(XMLParser.extractForTag(representation, "superParameters"));
        this.variableLength = XMLParser.extractObjectForTags(representation, "variableLength", Boolean.TYPE);
        this.alphabet = (Parameter)XMLParser.extractObjectForTags(representation, "alphabet");
        this.length = new SimpleParameter(XMLParser.extractForTag(representation, "length"));
    }

    @Override
    public int getNumberOfParameters() {
        if (this.variableLength) {
            return super.getNumberOfParameters() + 1;
        }
        return super.getNumberOfParameters() + 2;
    }

    @Override
    public Parameter getParameterAt(int i) {
        if (i < super.getNumberOfParameters()) {
            return super.getParameterAt(i);
        }
        if (i == super.getNumberOfParameters()) {
            return this.alphabet;
        }
        if (!this.variableLength) {
            return this.length;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer buf = super.toXML();
        XMLParser.addTags(buf, "superParameters");
        XMLParser.appendObjectWithTags(buf, this.variableLength, "variableLength");
        XMLParser.appendObjectWithTags(buf, this.alphabet, "alphabet");
        XMLParser.appendObjectWithTags(buf, this.length, "length");
        XMLParser.addTags(buf, "sequenceScoringParameterSet");
        return buf;
    }

    public boolean equals(Object o) {
        if (o instanceof SequenceScoringParameterSet) {
            SequenceScoringParameterSet comp = (SequenceScoringParameterSet)o;
            boolean erg = this.getInstanceClass().equals(comp.getInstanceClass()) && this.getLength() == comp.getLength() && this.parameters.size() == comp.parameters.size() && this.getAlphabetContainer().checkConsistency(comp.getAlphabetContainer());
            int i = 0;
            while (i < this.parameters.size() && erg) {
                erg &= ((Parameter)this.parameters.get(i)).equals(comp.parameters.get(i++));
            }
            return erg;
        }
        return false;
    }

    @Override
    public SequenceScoringParameterSet<T> clone() throws CloneNotSupportedException {
        SequenceScoringParameterSet res = (SequenceScoringParameterSet)super.clone();
        res.alphabet = this.alphabet.clone();
        res.length = this.length.clone();
        return res;
    }
}

