/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.sequences.ArbitrarySequence;
import de.jstacs.data.sequences.IntSequence;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.WrongSequenceTypeException;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.results.NumericalResultSet;
import de.jstacs.sequenceScores.statisticalModels.trainable.AbstractTrainableStatisticalModel;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Random;

public class UniformTrainSM
extends AbstractTrainableStatisticalModel {
    private static final long serialVersionUID = 1L;
    private static final String XML_TAG = "DiscreteUniformModel";
    private double p;
    private static final Random r = new Random();

    public UniformTrainSM(AlphabetContainer alphabet) {
        super(alphabet, alphabet.getPossibleLength());
        this.init();
    }

    public UniformTrainSM(StringBuffer stringBuff) throws NonParsableException {
        super(stringBuff);
        this.init();
    }

    private void init() {
        if (this.length > 0) {
            this.p = 0.0;
            int i = 0;
            while (i < this.length) {
                this.p -= Math.log(this.alphabets.getAlphabetLengthAt(i));
                ++i;
            }
        } else {
            this.p = -Math.log(this.alphabets.getAlphabetLengthAt(0));
        }
    }

    @Override
    public UniformTrainSM clone() throws CloneNotSupportedException {
        return (UniformTrainSM)super.clone();
    }

    @Override
    public double getLogProbFor(Sequence sequence, int startpos, int endpos) throws IllegalArgumentException, WrongAlphabetException {
        if (!this.alphabets.checkConsistency(sequence.getAlphabetContainer())) {
            throw new WrongAlphabetException("This sequence and model doesnot match.");
        }
        if (startpos < 0 || endpos > sequence.getLength()) {
            throw new IllegalArgumentException("Attention: 0 <= startpos, endpos < sequence.length()");
        }
        if (endpos - startpos + 1 < 0) {
            throw new IllegalArgumentException("The sequence does not have a correct length. The length has to be non-negative.");
        }
        if (this.length > 0) {
            if (endpos - startpos + 1 == this.length) {
                return this.p;
            }
            throw new IllegalArgumentException("The sequence does not have a correct length (" + this.length + ").");
        }
        return this.p * (double)(endpos - startpos + 1);
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    @Override
    public void fromXML(StringBuffer representation) throws NonParsableException {
        this.alphabets = new AlphabetContainer(XMLParser.extractForTag(representation, XML_TAG));
        this.length = this.alphabets.getPossibleLength();
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = this.alphabets.toXML();
        XMLParser.addTags(xml, XML_TAG);
        return xml;
    }

    @Override
    public String toString(NumberFormat nf) {
        return "";
    }

    @Override
    @Deprecated
    public void train(DataSet data, double[] weights) throws IOException {
    }

    @Override
    public DataSet emitDataSet(int n, int ... lengths) throws Exception {
        Sequence[] seq;
        if (this.length == 0) {
            if (lengths.length == 1) {
                seq = this.getSequences(n, lengths[0]);
            } else {
                seq = new Sequence[n];
                int i = 0;
                while (i < n) {
                    seq[i] = this.getSequences(1, lengths[i])[0];
                    ++i;
                }
            }
        } else {
            if (lengths != null && lengths.length != 0) {
                throw new Exception("This is an inhomogeneous model. Please check parameter lengths.");
            }
            double[] content = new double[this.length];
            seq = new Sequence[n];
            int i = 0;
            while (i < n) {
                int j = 0;
                while (j < this.length) {
                    content[j] = this.alphabets.getMin(j) + r.nextDouble() * this.alphabets.getAlphabetLengthAt(j);
                    if (this.alphabets.isDiscreteAt(j)) {
                        content[j] = (int)content[j];
                    }
                    ++j;
                }
                seq[i] = new ArbitrarySequence(this.alphabets, content);
                ++i;
            }
        }
        return new DataSet("sampled from " + this.getInstanceName(), seq);
    }

    private Sequence[] getSequences(int n, int length) throws WrongAlphabetException, WrongSequenceTypeException {
        Sequence[] seqs = new Sequence[n];
        if (this.alphabets.isDiscrete()) {
            int[] seq = new int[length];
            int j = 0;
            int l = (int)this.alphabets.getAlphabetLengthAt(0);
            while (j < n) {
                int i = 0;
                while (i < length) {
                    seq[i] = r.nextInt(l);
                    ++i;
                }
                seqs[j++] = new IntSequence(this.alphabets, seq);
            }
        } else {
            double[] seq = new double[length];
            double m = this.alphabets.getMin(0);
            double l = this.alphabets.getAlphabetLengthAt(0);
            int j = 0;
            while (j < n) {
                int i = 0;
                while (i < length) {
                    seq[i] = m + r.nextDouble() * l;
                    ++i;
                }
                seqs[j++] = new ArbitrarySequence(this.alphabets, seq);
            }
        }
        return seqs;
    }

    @Override
    public double getLogPriorTerm() throws Exception {
        return 0.0;
    }

    @Override
    public byte getMaximalMarkovOrder() throws UnsupportedOperationException {
        return 0;
    }

    @Override
    public NumericalResultSet getNumericalCharacteristics() throws Exception {
        return null;
    }

    @Override
    public String getInstanceName() {
        return "uniform";
    }
}

