/*
 * Decompiled with CFR 0.152.
 */
package projects.dispom;

import de.jstacs.data.DataSet;
import de.jstacs.data.EmptyDataSetException;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.MotifAnnotation;
import de.jstacs.data.sequences.annotation.StrandedLocatedSequenceAnnotationWithLength;
import de.jstacs.io.AbstractStringExtractor;
import de.jstacs.io.SparseStringExtractor;
import de.jstacs.io.StringExtractor;
import de.jstacs.io.SymbolExtractor;
import de.jstacs.results.NumericalResult;
import de.jstacs.results.Result;
import de.jstacs.utils.ComparableElement;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.StringTokenizer;
import projects.dispom.MyList;

public class ParserToolBox {
    private static final String AGLAM_RESULTS = "! Best possible alignment:";
    private static final String AGLAM_ANCHOR = "Anchors are given as:";
    private static final String DME_MOTIF = "AC";
    private static final String DME_BINDINGSITE = "BS";

    public static DataSet annotateWithMoAnResults(DataSet data, boolean addAnnot, File ... files) throws Exception {
        SparseStringExtractor best = null;
        double bestScore = Double.NEGATIVE_INFINITY;
        String str = null;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            double score;
            File f = fileArray[n2];
            SparseStringExtractor curr = new SparseStringExtractor(f.getAbsolutePath(), '#');
            while (curr.hasMoreElements() && !(str = (String)curr.nextElement()).startsWith("Score:")) {
            }
            if (str != null && str.startsWith("Score:") && (score = Double.parseDouble(str.split(":\\s+")[1])) > bestScore) {
                bestScore = score;
                best = curr;
            }
            ++n2;
        }
        if (best != null) {
            return ParserToolBox.annotateWithMoAnResults(data, addAnnot, best);
        }
        return null;
    }

    public static DataSet annotateWithMoAnResults(DataSet data, boolean addAnnot, AbstractStringExtractor moAn) throws Exception {
        Sequence[] moAnSeqs = new Sequence[data.getNumberOfElements()];
        int i = 0;
        while (i < moAnSeqs.length) {
            moAnSeqs[i] = data.getElementAt(i);
            ++i;
        }
        String str = null;
        int num = 1;
        while (moAn.hasMoreElements()) {
            while (moAn.hasMoreElements() && !(str = (String)moAn.nextElement()).startsWith("Hits")) {
            }
            moAn.nextElement();
            while (moAn.hasMoreElements() && !(str = (String)moAn.nextElement()).startsWith("---")) {
                str = str.trim();
                String[] split = str.split(":?\\s+");
                int idx = Integer.parseInt(split[0]);
                int pos = Integer.parseInt(split[1]);
                String subseq = split[2];
                double score = Double.parseDouble(split[3]);
                StrandedLocatedSequenceAnnotationWithLength.Strand strand = StrandedLocatedSequenceAnnotationWithLength.Strand.UNKNOWN;
                moAnSeqs[idx] = moAnSeqs[idx].annotate(addAnnot, new MotifAnnotation("motif" + num, pos, subseq.length(), strand, new NumericalResult("score", "score of element", score)));
            }
            ++num;
        }
        return new DataSet("Sample annotated by MoAn", moAnSeqs);
    }

    public static DataSet annotateBestCoBindResults(DataSet data, String cobindFileName) throws Exception {
        StringExtractor cobind = new StringExtractor(new File(cobindFileName), 100, '&');
        double best = Double.NEGATIVE_INFINITY;
        DataSet bestS = null;
        while (cobind.hasMoreElements()) {
            ComparableElement<DataSet, Double> el = ParserToolBox.annotateSingleCoBindResults(data, cobind);
            if (!(el.getWeight() > best)) continue;
            best = el.getWeight();
            bestS = el.getElement();
        }
        return bestS;
    }

    public static ComparableElement<DataSet, Double> annotateSingleCoBindResults(DataSet data, StringExtractor cobind) throws EmptyDataSetException, WrongAlphabetException {
        Sequence[] cobindSeqs = new Sequence[data.getNumberOfElements()];
        int i = 0;
        while (i < cobindSeqs.length) {
            cobindSeqs[i] = data.getElementAt(i);
            ++i;
        }
        String str = null;
        int num = 1;
        double annScore = Double.NEGATIVE_INFINITY;
        block1: while (true) {
            if (cobind.hasMoreElements() && !(str = cobind.nextElement()).startsWith("# BEST_SITES")) {
                if (!str.startsWith("# >> Maximum conbined energy for both units (MaxUU):")) continue;
                annScore = Double.parseDouble(str.substring("# >> Maximum conbined energy for both units (MaxUU):".length()).trim());
                cobind.nextElement();
                cobind.nextElement();
                break;
            }
            if (!cobind.hasMoreElements()) break;
            cobind.nextElement();
            while (true) {
                if (!cobind.hasMoreElements()) continue block1;
                str = cobind.nextElement();
                if (str.startsWith("# ave_log_S")) {
                    ++num;
                    continue block1;
                }
                String[] sp = str.split("[\\s:]+");
                int idx = Integer.parseInt(sp[2]) - 1;
                double score = Double.parseDouble(sp[3]);
                int pos = 0;
                StrandedLocatedSequenceAnnotationWithLength.Strand strand = StrandedLocatedSequenceAnnotationWithLength.Strand.FORWARD;
                sp[4] = sp[4].trim();
                if (sp[4].endsWith("'")) {
                    pos = Integer.parseInt(sp[4].substring(0, sp[4].length() - 1)) - 1;
                    strand = StrandedLocatedSequenceAnnotationWithLength.Strand.REVERSE;
                } else {
                    pos = Integer.parseInt(sp[4]);
                }
                cobindSeqs[idx] = cobindSeqs[idx].annotate(true, new MotifAnnotation("motif" + num, pos, sp[5].length(), strand, new NumericalResult("score", "score of element", score)));
            }
            break;
        }
        return new ComparableElement<DataSet, Double>(new DataSet("Sample annotated by Co-Bind", cobindSeqs), annScore);
    }

    public static DataSet annotateWithCisModuleResults(DataSet data, boolean addAnnot, String cismodFileName) throws Exception {
        StringExtractor cismod = new StringExtractor(new File(cismodFileName), 100);
        Sequence[] cismodSeqs = new Sequence[data.getNumberOfElements()];
        int i = 0;
        while (i < cismodSeqs.length) {
            cismodSeqs[i] = data.getElementAt(i);
            ++i;
        }
        String str = null;
        while (cismod.hasMoreElements() && !(str = cismod.nextElement()).startsWith("Motif")) {
        }
        int num = 1;
        do {
            int w = 0;
            while (cismod.hasMoreElements() && !(str = cismod.nextElement()).startsWith(">")) {
                if (!str.startsWith(String.valueOf(w + 1))) continue;
                ++w;
            }
            if (!cismod.hasMoreElements()) break;
            do {
                String[] sp = str.split("\\s+");
                int idx = Integer.parseInt(sp[0].substring(4));
                StrandedLocatedSequenceAnnotationWithLength.Strand strand = StrandedLocatedSequenceAnnotationWithLength.Strand.FORWARD;
                if (sp[1].trim().equals("r")) {
                    strand = StrandedLocatedSequenceAnnotationWithLength.Strand.REVERSE;
                }
                int pos = Integer.parseInt(sp[2]) - 1;
                double score = Double.parseDouble(sp[3]);
                cismodSeqs[idx] = cismodSeqs[idx].annotate(true, new MotifAnnotation("motif" + num, pos, w, strand, new NumericalResult("score", "score of element", score)));
                cismod.nextElement();
            } while (cismod.hasMoreElements() && (str = cismod.nextElement()).startsWith(">"));
            ++num;
        } while (cismod.hasMoreElements());
        return new DataSet("Sample annotated by CisModule", cismodSeqs);
    }

    public static DataSet annotateWithGibbsSamplerResults(DataSet data, boolean addAnnot, String gibbsFileName) throws FileNotFoundException, IOException, IllegalArgumentException, EmptyDataSetException, WrongAlphabetException {
        StringExtractor gibbs = new StringExtractor(new File(gibbsFileName), 100);
        Sequence[] gibbsSeqs = new Sequence[data.getNumberOfElements()];
        int idx = 0;
        String line = gibbs.getElement(idx);
        while (!line.matches("\\s+[0-9]+,\\s+[0-9]+\\s+[0-9]+\\s+[acgt]*\\s*[ACGT]+\\s*[acgt]*\\s+[0-9]+.*")) {
            if (++idx < gibbs.getNumberOfElements()) {
                line = gibbs.getElement(idx);
                continue;
            }
            return data;
        }
        while (line.matches("\\s+[0-9]+,\\s+[0-9]+\\s+[0-9]+\\s+[acgt]*\\s*[ACGT]+\\s*[acgt]*\\s+[0-9]+.*")) {
            String[] temp = line.split("[\\s,]+");
            int seq = Integer.parseInt(temp[1]);
            int left = Integer.parseInt(temp[3]);
            int i = 4;
            while (temp[i].matches("[acgtACGT]+")) {
                ++i;
            }
            int right = Integer.parseInt(temp[i]);
            Boolean fwd = null;
            if (temp.length >= i + 3) {
                fwd = temp[i + 2].equals("F");
            }
            double val = Double.parseDouble(temp[i + 1]);
            MotifAnnotation ann = new MotifAnnotation("motif", Math.min(left, right) - 1, Math.max(left, right) - Math.min(left, right) + 1, fwd == null ? StrandedLocatedSequenceAnnotationWithLength.Strand.UNKNOWN : (fwd != false ? StrandedLocatedSequenceAnnotationWithLength.Strand.FORWARD : StrandedLocatedSequenceAnnotationWithLength.Strand.REVERSE), new NumericalResult("score", "probability of element", val));
            gibbsSeqs[seq - 1] = gibbsSeqs[seq - 1] == null ? data.getElementAt(seq - 1).annotate(addAnnot, ann) : gibbsSeqs[seq - 1].annotate(true, ann);
            line = gibbs.getElement(++idx);
        }
        int i = 0;
        while (i < gibbsSeqs.length) {
            if (gibbsSeqs[i] == null) {
                gibbsSeqs[i] = data.getElementAt(i);
            }
            ++i;
        }
        return new DataSet("gibbsSampler", gibbsSeqs);
    }

    public static DataSet annotateWithMemeResults(DataSet data, boolean addAnnot, String memeFileName) throws IllegalArgumentException, EmptyDataSetException, FileNotFoundException, IOException, WrongAlphabetException {
        StringExtractor meme = new StringExtractor(new File(memeFileName), 100);
        Sequence[] memeSeqs = new Sequence[data.getNumberOfElements()];
        int start = -1;
        int idx = -1;
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        LinkedList<MotifAnnotation> annots = new LinkedList<MotifAnnotation>();
        int i = 0;
        while (i < meme.getNumberOfElements()) {
            String line = meme.getElement(i);
            if (line.matches("MOTIF\\s+\\d\\s+width.*")) {
                int w = line.indexOf("width");
                Integer num = Integer.parseInt(line.substring(line.indexOf("MOTIF") + "MOTIF".length(), w).trim());
                int length2 = Integer.parseInt(line.substring(line.indexOf("=") + 1, line.indexOf("sites")).trim());
                map.put(num, length2);
            }
            if (meme.getElement(i).indexOf("Combined block diagrams") > -1) {
                start = 3;
                idx = 0;
            } else if (start > 0) {
                --start;
            } else if (start == 0) {
                if (meme.getElement(i).indexOf("---") > -1) {
                    start = -1;
                } else {
                    String s = meme.getElement(i);
                    String[] temp = s.split("\\s+");
                    s = temp[2];
                    if ((temp = s.split("_")).length > 1) {
                        annots.clear();
                        int off = 0;
                        int j = 0;
                        while (j < temp.length) {
                            if (temp[j].matches("\\[[+-]?\\d\\(.+\\)\\]")) {
                                Integer num = null;
                                StrandedLocatedSequenceAnnotationWithLength.Strand strand = StrandedLocatedSequenceAnnotationWithLength.Strand.FORWARD;
                                if (temp[j].indexOf("[+") > -1) {
                                    num = Integer.parseInt(temp[j].substring(temp[j].indexOf("[") + 2, temp[j].indexOf("(")));
                                } else if (temp[j].indexOf("[-") > -1) {
                                    num = Integer.parseInt(temp[j].substring(temp[j].indexOf("[") + 2, temp[j].indexOf("(")));
                                    strand = StrandedLocatedSequenceAnnotationWithLength.Strand.REVERSE;
                                } else {
                                    num = Integer.parseInt(temp[j].substring(temp[j].indexOf("[") + 1, temp[j].indexOf("(")));
                                }
                                double val = Double.parseDouble(temp[j].substring(temp[j].indexOf("(") + 1, temp[j].indexOf(")") - 1));
                                annots.add(new MotifAnnotation("Motif " + num, off, (Integer)map.get(num), strand, new NumericalResult("score", "1-(p-value)", 1.0 - val)));
                            } else {
                                off += Integer.parseInt(temp[j]);
                            }
                            ++j;
                        }
                        memeSeqs[idx] = data.getElementAt(idx).annotate(false, annots.toArray(new MotifAnnotation[0]));
                    } else {
                        memeSeqs[idx] = data.getElementAt(idx);
                    }
                    ++idx;
                }
            }
            ++i;
        }
        DataSet memeSample = new DataSet("meme", memeSeqs);
        return memeSample;
    }

    public static DataSet annotateWithDemeResults(DataSet data, boolean addAnnot, String demeFileName) throws IllegalArgumentException, EmptyDataSetException, FileNotFoundException, IOException, WrongAlphabetException {
        StringExtractor deme = new StringExtractor(new File(demeFileName), 100, '$');
        Sequence[] demeSeqs = new Sequence[data.getNumberOfElements()];
        int start = -1;
        int idx = -1;
        int i = 0;
        while (i < deme.getNumberOfElements()) {
            String line = deme.getElement(i);
            if (line.indexOf("# Training sequences") > -1) {
                start = 1;
                idx = 0;
            } else if (start > 0) {
                --start;
            } else if (start == 0) {
                if (line.length() == 0) {
                    start = -1;
                } else {
                    String[] temp = line.split("\\s+");
                    if (temp[3].trim().equals("1")) {
                        int pos = Integer.parseInt(temp[4]) - 1;
                        StrandedLocatedSequenceAnnotationWithLength.Strand strand = StrandedLocatedSequenceAnnotationWithLength.Strand.FORWARD;
                        if (temp[5].trim().equals("-")) {
                            strand = StrandedLocatedSequenceAnnotationWithLength.Strand.REVERSE;
                        }
                        int length2 = temp[6].trim().length();
                        double val = Double.parseDouble(temp[8].trim());
                        demeSeqs[idx] = data.getElementAt(idx).annotate(addAnnot, new MotifAnnotation("motif1", pos, length2, strand, new NumericalResult("score", "P(C|X,theta)", val)));
                        ++idx;
                    }
                }
            }
            ++i;
        }
        DataSet demeSample = new DataSet("deme", demeSeqs);
        return demeSample;
    }

    public static DataSet annotateWithImprobizerResults(DataSet data, boolean addAnnot, String improbFileName, int improbLength) throws IllegalArgumentException, EmptyDataSetException, FileNotFoundException, IOException, WrongAlphabetException {
        StringExtractor imp = new StringExtractor(new File(improbFileName), 100);
        Sequence[] impSeqs = new Sequence[data.getNumberOfElements()];
        LinkedList<MotifAnnotation> annots = new LinkedList<MotifAnnotation>();
        int lastseq = -1;
        int i = 0;
        while (i < imp.getNumberOfElements()) {
            MotifAnnotation b;
            int k;
            MotifAnnotation a;
            int j;
            LinkedList<MotifAnnotation> toRemove;
            String line = imp.getElement(i);
            String[] parts = line.split("\\s+");
            int seq = Integer.parseInt(parts[2].substring(3));
            double val = Double.parseDouble(parts[1]);
            boolean fwd = parts[0].equals("1");
            int pos = Integer.parseInt(parts[3]);
            MotifAnnotation ann = new MotifAnnotation("Motif", pos, improbLength, fwd ? StrandedLocatedSequenceAnnotationWithLength.Strand.FORWARD : StrandedLocatedSequenceAnnotationWithLength.Strand.REVERSE, new NumericalResult("score", "score", val));
            if (seq != lastseq) {
                toRemove = new LinkedList<MotifAnnotation>();
                j = 0;
                while (j < annots.size()) {
                    a = (MotifAnnotation)annots.get(j);
                    k = j + 1;
                    while (k < annots.size()) {
                        b = (MotifAnnotation)annots.get(k);
                        if (a.getPosition() == b.getPosition() && a.getLength() == b.getLength()) {
                            toRemove.add(b);
                        }
                        ++k;
                    }
                    ++j;
                }
                annots.removeAll(toRemove);
                if (lastseq >= 0) {
                    impSeqs[lastseq] = data.getElementAt(lastseq).annotate(false, annots.toArray(new MotifAnnotation[0]));
                }
                annots.clear();
                if (seq != lastseq) {
                    annots.add(ann);
                }
            } else {
                annots.add(ann);
            }
            if (i == imp.getNumberOfElements() - 1) {
                toRemove = new LinkedList();
                j = 0;
                while (j < annots.size()) {
                    a = (MotifAnnotation)annots.get(j);
                    k = j + 1;
                    while (k < annots.size()) {
                        b = (MotifAnnotation)annots.get(k);
                        if (a.getPosition() == b.getPosition() && a.getLength() == b.getLength()) {
                            toRemove.add(b);
                        }
                        ++k;
                    }
                    ++j;
                }
                annots.removeAll(toRemove);
                impSeqs[seq] = data.getElementAt(seq).annotate(false, annots.toArray(new MotifAnnotation[0]));
            }
            lastseq = seq;
            ++i;
        }
        i = 0;
        while (i < impSeqs.length) {
            if (impSeqs[i] == null) {
                impSeqs[i] = data.getElementAt(i);
            }
            ++i;
        }
        DataSet impSample = new DataSet("improbizer", impSeqs);
        return impSample;
    }

    public static int getImprobizerMotifLength(String fName) throws IOException {
        BufferedReader r = new BufferedReader(new FileReader(new File(fName)));
        String line = r.readLine().trim();
        r.close();
        int idx = line.lastIndexOf(32);
        return line.substring(idx + 1).length();
    }

    public static DataSet annotateWithWeederResults(DataSet data, boolean addAnnot, String weederFileName) throws FileNotFoundException, IOException, IllegalArgumentException, EmptyDataSetException, WrongAlphabetException {
        StringExtractor weed = new StringExtractor(new File(weederFileName), 100);
        int i = 0;
        while (!weed.getElement(i).startsWith("Best occurrences:")) {
            ++i;
        }
        i += 2;
        Sequence[] weedSeqs = new Sequence[data.getNumberOfElements()];
        int start = -1;
        int idx = -1;
        HashMap map = new HashMap();
        LinkedList<MotifAnnotation> annots = new LinkedList<MotifAnnotation>();
        int lastseq = -1;
        while (i < weed.getNumberOfElements()) {
            MotifAnnotation b;
            int k;
            MotifAnnotation a;
            int j;
            LinkedList<MotifAnnotation> toRemove;
            String line = weed.getElement(i);
            String[] parts = line.split("\\s+");
            int off = parts[0].length() == 0 ? 1 : 0;
            int seq = Integer.parseInt(parts[off]);
            boolean fwd = parts[off + 1].equals("+");
            String str = parts[off + 2];
            int length = str.length();
            if (str.startsWith("[")) {
                --length;
            }
            if (str.endsWith("]")) {
                --length;
            }
            int pos = Integer.parseInt(parts[off + 3]);
            double val = Double.parseDouble(parts[off + 4].substring(1, parts[off + 4].length() - 1));
            MotifAnnotation ann = new MotifAnnotation("Motif", pos - 1, length, fwd ? StrandedLocatedSequenceAnnotationWithLength.Strand.FORWARD : StrandedLocatedSequenceAnnotationWithLength.Strand.REVERSE, new NumericalResult("score", "score", val));
            if (seq != lastseq) {
                toRemove = new LinkedList<MotifAnnotation>();
                j = 0;
                while (j < annots.size()) {
                    a = (MotifAnnotation)annots.get(j);
                    k = j + 1;
                    while (k < annots.size()) {
                        b = (MotifAnnotation)annots.get(k);
                        if (a.getPosition() == b.getPosition() && a.getLength() == b.getLength()) {
                            toRemove.add(b);
                        }
                        ++k;
                    }
                    ++j;
                }
                annots.removeAll(toRemove);
                if (lastseq > 0) {
                    weedSeqs[lastseq - 1] = data.getElementAt(lastseq - 1).annotate(addAnnot, annots.toArray(new MotifAnnotation[0]));
                }
                annots.clear();
                if (seq != lastseq) {
                    annots.add(ann);
                }
            } else {
                annots.add(ann);
            }
            if (i == weed.getNumberOfElements() - 1 || weed.getElement(i + 1).length() == 0) {
                toRemove = new LinkedList();
                j = 0;
                while (j < annots.size()) {
                    a = (MotifAnnotation)annots.get(j);
                    k = j + 1;
                    while (k < annots.size()) {
                        b = (MotifAnnotation)annots.get(k);
                        if (a.getPosition() == b.getPosition() && a.getLength() == b.getLength()) {
                            toRemove.add(b);
                        }
                        ++k;
                    }
                    ++j;
                }
                annots.removeAll(toRemove);
                weedSeqs[seq - 1] = data.getElementAt(seq - 1).annotate(addAnnot, annots.toArray(new MotifAnnotation[0]));
                break;
            }
            lastseq = seq;
            ++i;
        }
        i = 0;
        while (i < weedSeqs.length) {
            if (weedSeqs[i] == null) {
                weedSeqs[i] = data.getElementAt(i);
            }
            ++i;
        }
        DataSet weederSample = new DataSet("weeder", weedSeqs);
        return weederSample;
    }

    public static DataSet annotateWithAGlamResults(DataSet data, boolean addAnnot, String ouputFileName, String motifName, boolean evalues) throws Exception {
        StringTokenizer st;
        String line;
        Sequence[] seqs = data.getAllElements();
        boolean[] add = new boolean[seqs.length];
        Arrays.fill(add, addAnnot);
        BufferedReader r = new BufferedReader(new FileReader(ouputFileName));
        String anchor = null;
        while ((line = r.readLine()) != null && !line.startsWith(AGLAM_RESULTS)) {
            if (!line.startsWith(AGLAM_ANCHOR)) continue;
            anchor = line.substring(AGLAM_ANCHOR.length());
        }
        int[] anchors = new int[data.getNumberOfElements()];
        if (anchor == null) {
            Arrays.fill(anchors, 0);
        } else {
            st = new StringTokenizer(anchor);
            int i = 0;
            while (i < anchors.length) {
                anchors[i] = Integer.parseInt(st.nextToken());
                ++i;
            }
        }
        char seqComment = '>';
        int idx = 0;
        while ((line = r.readLine()) != null) {
            if (line.length() <= 0 || line.charAt(0) != seqComment) continue;
            String annot = r.readLine().trim();
            st = new StringTokenizer(annot, " ");
            if (st.countTokens() > 1) {
                StrandedLocatedSequenceAnnotationWithLength.Strand s;
                int v1 = anchors[idx] + Integer.parseInt(st.nextToken());
                st.nextToken();
                int v2 = anchors[idx] + Integer.parseInt(st.nextToken());
                StrandedLocatedSequenceAnnotationWithLength.Strand strand = s = v1 < v2 ? StrandedLocatedSequenceAnnotationWithLength.Strand.FORWARD : StrandedLocatedSequenceAnnotationWithLength.Strand.REVERSE;
                if (s == StrandedLocatedSequenceAnnotationWithLength.Strand.REVERSE) {
                    int h = v1;
                    v1 = v2 - 1;
                    v2 = h;
                } else {
                    --v1;
                }
                NumericalResult res = null;
                st.nextToken();
                if (evalues) {
                    st.nextToken();
                }
                String temp = st.nextToken();
                temp = temp.substring(1, temp.length() - 1);
                double val = Double.parseDouble(temp);
                res = evalues ? new NumericalResult("score", "negative E-value", -val) : new NumericalResult("score", "alignment score", val);
                MotifAnnotation ma = new MotifAnnotation(motifName, v1, v2 - v1, s, res);
                seqs[idx] = seqs[idx].annotate(add[idx], ma);
                add[idx] = true;
            }
            ++idx;
        }
        r.close();
        return new DataSet("data with annotation from A-GLAM", seqs);
    }

    public static DataSet annotateWithDMEResults(DataSet data, boolean addAnnot, String ouputFileName, int index) throws Exception {
        String line;
        Sequence[] seqs = data.getAllElements();
        boolean[] add = new boolean[seqs.length];
        Arrays.fill(add, addAnnot);
        BufferedReader r = new BufferedReader(new FileReader(ouputFileName));
        int i = 0;
        while ((line = r.readLine()) != null && !line.startsWith(DME_MOTIF) || ++i < index && line != null) {
        }
        if (line == null) {
            r.close();
            return null;
        }
        String motifName = "motif " + index + " (" + line.substring(2).trim() + ")";
        while ((line = r.readLine()) != null && !line.startsWith(DME_BINDINGSITE)) {
        }
        int sep = 59;
        int idx = 0;
        do {
            idx = line.indexOf(sep) + 1;
            int h = line.indexOf(sep, idx);
            String seq = line.substring(idx, h).trim();
            idx = Integer.parseInt(seq.replace("seq", ""));
            int v1 = h + 1;
            h = line.indexOf(sep, v1);
            v1 = Integer.parseInt(line.substring(v1, h).trim());
            int v2 = h + 1;
            h = line.indexOf(sep, v2);
            v2 = Integer.parseInt(line.substring(v2, h).trim());
            StrandedLocatedSequenceAnnotationWithLength.Strand s = line.substring(h = line.indexOf(sep, h + 1) + 1).trim().startsWith("p") ? StrandedLocatedSequenceAnnotationWithLength.Strand.FORWARD : StrandedLocatedSequenceAnnotationWithLength.Strand.REVERSE;
            h = line.indexOf(sep, h + 1);
            double val = Double.parseDouble(line.substring(h + 1));
            MotifAnnotation ma = new MotifAnnotation(motifName, v1, v2, s, new NumericalResult("score", "score", val));
            seqs[idx] = seqs[idx].annotate(add[idx], ma);
            add[idx] = true;
        } while ((line = r.readLine()) != null && line.startsWith(DME_BINDINGSITE));
        r.close();
        return new DataSet("data with annotation from DME", seqs);
    }

    public static DataSet annotateWithAmadeusResults(DataSet data, boolean addAnnot, String targetFile, int motifIndex, int length) throws Exception {
        String line;
        Sequence[] seqs = data.getAllElements();
        boolean[] add = new boolean[seqs.length];
        Arrays.fill(add, addAnnot);
        BufferedReader r = new BufferedReader(new FileReader(targetFile));
        String m = "" + motifIndex;
        String motifName = "motif " + motifIndex;
        SymbolExtractor se = new SymbolExtractor("\t");
        MyList<String> list = new MyList<String>();
        while ((line = r.readLine()) != null) {
            se.setStringToBeParsed(line);
            int seqIdx = Integer.parseInt(se.nextElement());
            String motif = se.nextElement();
            if (!motif.equals(m)) continue;
            se.nextElement();
            se.nextElement();
            se.nextElement();
            String set = se.nextElement();
            if (!set.equalsIgnoreCase("Target")) continue;
            list.clear();
            while (se.hasMoreElements()) {
                list.add(se.nextElement());
            }
            list.sort();
            int l = list.size() - 1;
            int i = 0;
            while (i <= l) {
                String pos = (String)list.get(i);
                int j = pos.indexOf(40);
                char s = pos.charAt(j + 1);
                pos = pos.substring(0, j);
                StrandedLocatedSequenceAnnotationWithLength.Strand strand = null;
                while (i < l && ((String)list.get(1 + i)).startsWith(pos)) {
                    String p;
                    if (s == (p = (String)list.get(1 + i++)).charAt(p.indexOf(40) + 1)) continue;
                    strand = StrandedLocatedSequenceAnnotationWithLength.Strand.UNKNOWN;
                }
                if (strand == null) {
                    strand = s == '+' ? StrandedLocatedSequenceAnnotationWithLength.Strand.FORWARD : StrandedLocatedSequenceAnnotationWithLength.Strand.REVERSE;
                }
                seqs[seqIdx] = seqs[seqIdx].annotate(add[seqIdx], new MotifAnnotation(motifName, seqs[seqIdx].getLength() - 1 + Integer.parseInt(pos), length, strand, new Result[0]));
                add[seqIdx] = true;
                ++i;
            }
        }
        r.close();
        return new DataSet("data with annotation from Amadeus", seqs);
    }
}

