/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.hups;

import umontreal.iro.lecuyer.hups.PointSet;
import umontreal.iro.lecuyer.hups.PointSetIterator;
import umontreal.iro.lecuyer.hups.PointSetRandomization;
import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.util.PrintfFormat;

public abstract class ContainerPointSet
extends PointSet {
    protected PointSet P;

    protected void init(PointSet P0) {
        this.P = P0;
    }

    public int getDimension() {
        return this.P.getDimension();
    }

    public int getNumPoints() {
        return this.P.getNumPoints();
    }

    public double getCoordinate(int i, int j) {
        return this.P.getCoordinate(i, j);
    }

    public PointSetIterator iterator() {
        return new ContainerPointSetIterator();
    }

    public void randomize(PointSetRandomization rand) {
        rand.randomize(this.P);
    }

    public void addRandomShift(int d1, int d2, RandomStream stream) {
        this.P.addRandomShift(d1, d2, stream);
    }

    public void addRandomShift(RandomStream stream) {
        this.P.addRandomShift(stream);
    }

    public void clearRandomShift() {
        this.P.clearRandomShift();
    }

    public String toString() {
        return "Container point set of: {" + PrintfFormat.LINE_SEPARATOR + this.P.toString() + PrintfFormat.LINE_SEPARATOR + "}";
    }

    public String formatPoints() {
        return this.P.formatPoints();
    }

    protected class ContainerPointSetIterator
    extends PointSet.DefaultPointSetIterator {
        protected PointSetIterator innerIterator;

        protected ContainerPointSetIterator() {
            super(ContainerPointSet.this);
            this.innerIterator = ContainerPointSet.this.P.iterator();
        }

        public void setCurCoordIndex(int j) {
            this.innerIterator.setCurCoordIndex(j);
        }

        public void resetCurCoordIndex() {
            this.innerIterator.resetCurCoordIndex();
        }

        public boolean hasNextCoordinate() {
            return this.innerIterator.hasNextCoordinate();
        }

        public double nextCoordinate() {
            return this.innerIterator.nextCoordinate();
        }

        public void setCurPointIndex(int i) {
            this.innerIterator.setCurPointIndex(i);
        }

        public void resetCurPointIndex() {
            this.innerIterator.resetCurPointIndex();
        }

        public int resetToNextPoint() {
            return this.innerIterator.resetToNextPoint();
        }

        public boolean hasNextPoint() {
            return this.innerIterator.hasNextPoint();
        }
    }
}

