/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifiers.performanceMeasures;

import de.jstacs.classifiers.performanceMeasures.NumericalPerformanceMeasure;
import de.jstacs.io.NonParsableException;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.SelectionParameter;
import de.jstacs.results.ResultSet;
import de.jstacs.utils.SubclassFinder;
import java.util.Iterator;
import java.util.LinkedList;

public abstract class AbstractPerformanceMeasure
extends ParameterSet {
    protected AbstractPerformanceMeasure() {
    }

    protected AbstractPerformanceMeasure(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    public abstract String getName();

    public abstract ResultSet compute(double[] var1, double[] var2);

    public abstract ResultSet compute(double[][][] var1);

    public abstract int getAllowedNumberOfClasses();

    public static SelectionParameter getCollectionOfAllMeasures(int numClasses, boolean numerical) throws Exception {
        LinkedList<Class<AbstractPerformanceMeasure>> list = SubclassFinder.findInstantiableSubclasses(AbstractPerformanceMeasure.class, AbstractPerformanceMeasure.class.getPackage().getName());
        Iterator it = list.iterator();
        LinkedList<AbstractPerformanceMeasure> found = new LinkedList<AbstractPerformanceMeasure>();
        while (it.hasNext()) {
            Class cl = (Class)it.next();
            if (numerical && !NumericalPerformanceMeasure.class.isAssignableFrom(cl)) continue;
            try {
                AbstractPerformanceMeasure mea = (AbstractPerformanceMeasure)cl.getConstructor(new Class[0]).newInstance(new Object[0]);
                if (mea.getAllowedNumberOfClasses() != 0 && mea.getAllowedNumberOfClasses() != numClasses) continue;
                found.add(mea);
            }
            catch (NoSuchMethodException e) {}
        }
        return new SelectionParameter("Performance Measures", "Performance measures that can be computed for " + (numClasses == 0 ? "any number of" : Integer.valueOf(numClasses)) + " classes.", true, found.toArray(new AbstractPerformanceMeasure[0]));
    }
}

