/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data.sequences.annotation;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.ReferenceSequenceAnnotation;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.data.sequences.annotation.SplitSequenceAnnotationParser;
import de.jstacs.results.Result;

public class ReferenceSequenceAnnotationParser
extends SplitSequenceAnnotationParser {
    private String key;
    private AlphabetContainer alphabet;
    private String delim;

    public ReferenceSequenceAnnotationParser(String key, AlphabetContainer alphabet, String keyValueDelimiter, String annotationDelimiter, String delim) throws IllegalArgumentException {
        super(keyValueDelimiter, annotationDelimiter);
        this.key = key;
        this.alphabet = alphabet;
        this.delim = delim;
    }

    public ReferenceSequenceAnnotationParser(String key, AlphabetContainer alphabet, String keyValueDelimiter, String annotationDelimiter) throws IllegalArgumentException {
        this(key, alphabet, keyValueDelimiter, annotationDelimiter, alphabet.getDelim());
    }

    @Override
    protected void add(String type, String identifier) {
        if (type.equalsIgnoreCase(this.key)) {
            try {
                this.annot.add(new ReferenceSequenceAnnotation(this.key, Sequence.create(this.alphabet, identifier, this.delim), new Result[0]));
            }
            catch (Exception e) {
                RuntimeException re = new RuntimeException(e.getMessage());
                re.setStackTrace(e.getStackTrace());
                throw re;
            }
        } else {
            super.add(type, identifier);
        }
    }

    @Override
    public String parseAnnotationToComment(char commentChar, SequenceAnnotation ... annotations) {
        StringBuffer res = new StringBuffer();
        res.append(commentChar);
        if (annotations != null && annotations.length > 0) {
            if (annotations[0] instanceof ReferenceSequenceAnnotation) {
                res.append(annotations[0].getIdentifier() + this.keyValueDelimiter + ((ReferenceSequenceAnnotation)annotations[0]).getReferenceSequence());
            } else {
                res.append(annotations[0].getType() + this.keyValueDelimiter + annotations[0].getIdentifier());
            }
            for (int i = 1; i < annotations.length; ++i) {
                if (annotations[i] instanceof ReferenceSequenceAnnotation) {
                    res.append(this.annotationDelimiter + " " + annotations[i].getIdentifier() + this.keyValueDelimiter + ((ReferenceSequenceAnnotation)annotations[i]).getReferenceSequence());
                    continue;
                }
                res.append(this.annotationDelimiter + " " + annotations[i].getType() + this.keyValueDelimiter + annotations[i].getIdentifier());
            }
        }
        return res.toString();
    }
}

