/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable.hmm.training;

import de.jstacs.DataType;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.ParameterSetParser;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.sampling.AbstractBurnInTest;
import de.jstacs.sampling.AbstractBurnInTestParameterSet;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.training.HMMTrainingParameterSet;
import de.jstacs.utils.SubclassFinder;

public class SamplingHMMTrainingParameterSet
extends HMMTrainingParameterSet {
    public SamplingHMMTrainingParameterSet() {
        this.addParameters();
    }

    public SamplingHMMTrainingParameterSet(int starts, int stepsPerIteration, int stationarySteps, AbstractBurnInTestParameterSet burnInTestParameters) throws SimpleParameter.IllegalValueException {
        super(starts);
        this.addParameters();
        this.getParameterAt(1).setValue(stepsPerIteration);
        this.getParameterAt(2).setValue(stationarySteps);
        ((Parameter)this.parameters.get(3)).setValue(burnInTestParameters);
    }

    public SamplingHMMTrainingParameterSet(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    private void addParameters() {
        try {
            this.parameters.add(new Parameter[]{new SimpleParameter(DataType.INT, "stepsPerIteration", "the number of steps during one iteration", true, new NumberValidator<Integer>(1, Integer.MAX_VALUE))});
            this.parameters.add(new Parameter[]{new SimpleParameter(DataType.INT, "steps", "the total number of steps after burn-in", true, new NumberValidator<Integer>(1, Integer.MAX_VALUE))});
            this.parameters.add(new Parameter[]{SubclassFinder.getSelectionParameter(AbstractBurnInTestParameterSet.class, AbstractBurnInTest.class.getPackage().getName(), "Burn in test parameters", "the parameters used to create a burn in test", true)});
        }
        catch (Exception hopefullydoesnothappen) {
            RuntimeException ex = new RuntimeException(hopefullydoesnothappen);
            ex.setStackTrace(hopefullydoesnothappen.getStackTrace());
            throw ex;
        }
    }

    public int getNumberOfStepsPerIteration() {
        return (Integer)this.getParameterForName("stepsPerIteration").getValue();
    }

    public int getNumberOfStepsInStationaryPhase() {
        return (Integer)this.getParameterForName("steps").getValue();
    }

    public AbstractBurnInTest getBurnInTest() throws ParameterSetParser.NotInstantiableException {
        return (AbstractBurnInTest)((AbstractBurnInTestParameterSet)this.getParameterForName(AbstractBurnInTest.class.getSimpleName()).getValue()).getInstance();
    }
}

