/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifiers;

import de.jstacs.Storable;
import de.jstacs.classifiers.ClassDimensionException;
import de.jstacs.classifiers.performanceMeasures.AbstractPerformanceMeasure;
import de.jstacs.classifiers.performanceMeasures.PerformanceMeasureParameterSet;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.results.CategoricalResult;
import de.jstacs.results.NumericalResultSet;
import de.jstacs.results.ResultSet;
import de.jstacs.results.StorableResult;
import java.util.LinkedList;

public abstract class AbstractClassifier
implements Storable,
Cloneable {
    private AlphabetContainer alphabets;
    private int length;

    public AbstractClassifier(AlphabetContainer abc) {
        this(abc, 0);
    }

    public AbstractClassifier(AlphabetContainer abc, int length) throws IllegalArgumentException {
        int l = abc.getPossibleLength();
        if (l != 0 && l != length) {
            throw new IllegalArgumentException("The length and the possible length of the AlphabetContainer does not match.");
        }
        this.alphabets = abc;
        this.length = length;
    }

    public AbstractClassifier(StringBuffer xml) throws NonParsableException {
        this.alphabets = null;
        this.length = -1;
        this.fromXML(xml);
        if (this.length < 0 || this.alphabets == null) {
            throw new NonParsableException("The alphabets or the length were not set.");
        }
    }

    public abstract byte classify(Sequence var1) throws Exception;

    public byte[] classify(DataSet s) throws Exception {
        byte[] clazz = new byte[s.getNumberOfElements()];
        DataSet.ElementEnumerator ei = new DataSet.ElementEnumerator(s);
        for (int i = 0; i < clazz.length; ++i) {
            clazz[i] = this.classify(ei.nextElement());
        }
        return clazz;
    }

    public AbstractClassifier clone() throws CloneNotSupportedException {
        return (AbstractClassifier)super.clone();
    }

    public final ResultSet evaluate(PerformanceMeasureParameterSet params, boolean exceptionIfNotComputeable, DataSet ... s) throws Exception {
        LinkedList list = new LinkedList();
        boolean isNumeric = this.getResults(list, s, params, exceptionIfNotComputeable);
        if (isNumeric) {
            return new NumericalResultSet(list);
        }
        return new ResultSet(list);
    }

    protected boolean getResults(LinkedList list, DataSet[] s, PerformanceMeasureParameterSet params, boolean exceptionIfNotComputeable) throws Exception {
        AbstractPerformanceMeasure[] m;
        if (s.length != this.getNumberOfClasses()) {
            throw new ClassDimensionException();
        }
        double[][][] scores = this.getMultiClassScores(s);
        boolean isNumeric = true;
        for (AbstractPerformanceMeasure current : m = params.getAllMeasures()) {
            ResultSet r;
            block5: {
                r = null;
                try {
                    r = current.compute(scores);
                }
                catch (Exception e) {
                    if (!exceptionIfNotComputeable) break block5;
                    throw e;
                }
            }
            isNumeric &= r instanceof NumericalResultSet;
            for (int j = 0; j < r.getNumberOfResults(); ++j) {
                list.add(r.getResultAt(j));
            }
        }
        return isNumeric;
    }

    protected double[][][] getMultiClassScores(DataSet[] s) throws Exception {
        double[][][] scores = new double[this.getNumberOfClasses()][][];
        for (int d = 0; d < s.length; ++d) {
            scores[d] = new double[s[d].getNumberOfElements()][scores.length];
            for (int n = 0; n < scores[d].length; ++n) {
                scores[d][n][this.classify((Sequence)s[d].getElementAt((int)n))] = 1.0;
            }
        }
        return scores;
    }

    public final AlphabetContainer getAlphabetContainer() {
        return this.alphabets;
    }

    public ResultSet getCharacteristics() throws Exception {
        return new ResultSet(this.getNumericalCharacteristics().getResults(), {new StorableResult("classifer", "the xml representation of the classifier", this)});
    }

    public abstract String getInstanceName();

    public abstract CategoricalResult[] getClassifierAnnotation();

    public final int getLength() {
        return this.length;
    }

    public abstract NumericalResultSet getNumericalCharacteristics() throws Exception;

    public abstract int getNumberOfClasses();

    public abstract boolean isInitialized();

    public void train(DataSet ... s) throws Exception {
        this.train(s, new double[s.length][]);
    }

    public abstract void train(DataSet[] var1, double[][] var2) throws Exception;

    protected abstract String getXMLTag();

    private void fromXML(StringBuffer representation) throws NonParsableException {
        StringBuffer xml = XMLParser.extractForTag(representation, this.getXMLTag());
        this.alphabets = (AlphabetContainer)XMLParser.extractObjectForTags(xml, "alphabetcontainer");
        this.length = XMLParser.extractObjectForTags(xml, "length", Integer.TYPE);
        this.extractFurtherClassifierInfosFromXML(xml);
    }

    protected abstract void extractFurtherClassifierInfosFromXML(StringBuffer var1) throws NonParsableException;

    @Override
    public final StringBuffer toXML() {
        StringBuffer xml = new StringBuffer(100000);
        XMLParser.appendObjectWithTags(xml, this.alphabets, "alphabetcontainer");
        XMLParser.appendObjectWithTags(xml, this.length, "length");
        xml.append(this.getFurtherClassifierInfos());
        XMLParser.addTags(xml, this.getXMLTag());
        return xml;
    }

    protected abstract StringBuffer getFurtherClassifierInfos();
}

