/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifiers.performanceMeasures;

import de.jstacs.DataType;
import de.jstacs.classifiers.performanceMeasures.NumericalPerformanceMeasure;
import de.jstacs.classifiers.performanceMeasures.TwoClassAbstractPerformanceMeasure;
import de.jstacs.io.NonParsableException;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterException;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.results.NumericalResult;
import de.jstacs.results.NumericalResultSet;

public class FalsePositiveRateForFixedSensitivity
extends TwoClassAbstractPerformanceMeasure
implements NumericalPerformanceMeasure {
    public FalsePositiveRateForFixedSensitivity() {
        try {
            this.parameters.add(new Parameter[]{new SimpleParameter(DataType.DOUBLE, "Sensitivity", "The fixed sensitivity for the false positive rate.", true, new NumberValidator<Double>(0.0, 1.0), 0.95)});
        }
        catch (ParameterException parameterException) {
            // empty catch block
        }
    }

    public FalsePositiveRateForFixedSensitivity(double sensitivity) throws Exception {
        this();
        this.getParameterAt(0).setValue(sensitivity);
    }

    public FalsePositiveRateForFixedSensitivity(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public String getName() {
        return "False positive rate for fixed sensitivity";
    }

    @Override
    public NumericalResultSet compute(double[] sortedScoresClass0, double[] sortedScoresClass1) {
        int i;
        double sensitivity = (Double)this.getParameterAt(0).getValue();
        int d = sortedScoresClass1.length;
        double threshold = sortedScoresClass0[(int)Math.ceil((1.0 - sensitivity) * (double)(sortedScoresClass0.length - 1))];
        for (i = d - 1; i >= 0 && sortedScoresClass1[i] >= threshold; --i) {
        }
        return new NumericalResultSet(new NumericalResult[][]{{new NumericalResult(this.getName() + " of " + sensitivity, "", (double)(d - 1 - i) / (double)d), new NumericalResult("Threshold for the " + this.getName().toLowerCase() + " of " + sensitivity, "", threshold)}});
    }

    @Override
    public NumericalResultSet compute(double[][][] classSpecificScores) {
        return (NumericalResultSet)super.compute(classSpecificScores);
    }
}

