/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.motifDiscovery;

import de.jstacs.classifiers.utils.PValueComputation;
import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.PermutedSequence;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.MotifAnnotation;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.data.sequences.annotation.StrandedLocatedSequenceAnnotationWithLength;
import de.jstacs.motifDiscovery.MotifDiscoverer;
import de.jstacs.results.NumericalResult;
import de.jstacs.sequenceScores.statisticalModels.differentiable.homogeneous.HomogeneousMMDiffSM;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.ToolBox;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;

public class SignificantMotifOccurrencesFinder {
    private RandomSeqType type;
    private boolean oneHistogram;
    private DataSet bg;
    private double[] weights;
    private MotifDiscoverer disc;
    private int numSequences;
    private double sign;
    private double[][] sortedScores;
    private int[][][] globalToLocalIndexes;
    private JoinMethod joinMethod;

    public SignificantMotifOccurrencesFinder(MotifDiscoverer disc, RandomSeqType type, boolean oneHistogram, int numSequences, double sign) {
        this(disc, type, new SumOfProbabilities(), oneHistogram, numSequences, sign);
    }

    public SignificantMotifOccurrencesFinder(MotifDiscoverer disc, RandomSeqType type, JoinMethod joiner, boolean oneHistogram, int numSequences, double sign) {
        this.disc = disc;
        if (type == RandomSeqType.BACKGROUND) {
            throw new IllegalArgumentException("This type can not be used in this constructor.");
        }
        this.type = type;
        this.joinMethod = joiner;
        this.oneHistogram = oneHistogram;
        this.numSequences = numSequences;
        this.sign = sign;
        this.prepareIndices();
    }

    public SignificantMotifOccurrencesFinder(MotifDiscoverer disc, DataSet bg, double[] weights, double sign) {
        this(disc, new SumOfProbabilities(), bg, weights, sign);
    }

    public SignificantMotifOccurrencesFinder(MotifDiscoverer disc, JoinMethod joiner, DataSet bg, double[] weights, double sign) {
        this.disc = disc;
        this.type = RandomSeqType.BACKGROUND;
        this.joinMethod = joiner;
        this.oneHistogram = true;
        this.numSequences = bg.getNumberOfElements();
        this.bg = bg;
        this.weights = weights == null ? null : (double[])weights.clone();
        this.sign = sign;
        this.prepareIndices();
    }

    private void createBgDataSet(DataSet s) throws Exception {
        switch (this.type) {
            case BACKGROUND: {
                break;
            }
            case PERMUTED: {
                Sequence[] seqs = new Sequence[s.getNumberOfElements() * this.numSequences];
                int n = 0;
                for (int i = 0; i < s.getNumberOfElements(); ++i) {
                    Sequence current = s.getElementAt(i);
                    int j = 0;
                    while (j < this.numSequences) {
                        seqs[n] = new PermutedSequence(current);
                        ++j;
                        ++n;
                    }
                }
                this.bg = new DataSet("permuted " + s.getAnnotation(), seqs);
                break;
            }
            case hMM0: 
            case hMM1: 
            case hMM2: 
            case hMM3: 
            case hMM4: 
            case hMM5: {
                int order = this.type.getOrder();
                HomogeneousMMDiffSM hmm = new HomogeneousMMDiffSM(s.getAlphabetContainer(), order, 0.0, new double[order + 1], true, true, 1);
                hmm.initializeFunction(0, false, new DataSet[]{s}, null);
                if (order > 0) {
                    double[][][] condProbs = hmm.getAllConditionalStationaryDistributions();
                    DoubleList list = new DoubleList((int)(1.5 * Math.pow(s.getAlphabetContainer().getAlphabetLengthAt(0), condProbs.length)));
                    for (int i = 0; i < condProbs.length; ++i) {
                        for (int j = 0; j < condProbs[i].length; ++j) {
                            for (int k = 0; k < condProbs[i][j].length; ++k) {
                                list.add(Math.log(condProbs[i][j][k]));
                            }
                        }
                    }
                    hmm.setParameters(list.toArray(), 0);
                }
                this.bg = hmm.emit(this.numSequences * s.getNumberOfElements(), s.getElementLength());
                break;
            }
        }
    }

    private void createBgDataSet(Sequence seq) throws Exception {
        this.createBgDataSet(new DataSet("", seq));
    }

    private double[][] getAllProfilesOfScoresFor(int motif, Sequence seq, int start) throws Exception {
        double[][] profiles = new double[this.globalToLocalIndexes[motif][0].length][];
        for (int i = 0; i < this.globalToLocalIndexes[motif][0].length; ++i) {
            profiles[i] = this.disc.getProfileOfScoresFor(this.globalToLocalIndexes[motif][0][i], this.globalToLocalIndexes[motif][1][i], seq, start, MotifDiscoverer.KindOfProfile.UNNORMALIZED_JOINT);
        }
        return profiles;
    }

    private double[] getJointProfileOfScoresFor(int motif, Sequence seq, int start) throws Exception {
        double[][] profiles = this.getAllProfilesOfScoresFor(motif, seq, start);
        return this.joinMethod.joinProfiles(profiles);
    }

    private void fillSortedScoresArray(int motif, int start) throws Exception {
        int i;
        int num = 0;
        Sequence bgSeq = null;
        LinkedList<double[]> scoreList = new LinkedList<double[]>();
        double[] temp = null;
        for (i = 0; i < this.numSequences; ++i) {
            bgSeq = this.bg.getElementAt(i);
            temp = this.getJointProfileOfScoresFor(motif, bgSeq, start);
            scoreList.add(temp);
            num += temp.length;
        }
        this.sortedScores = new double[2][num];
        Iterator it = scoreList.iterator();
        num = 0;
        i = 0;
        while (it.hasNext()) {
            temp = (double[])it.next();
            System.arraycopy(temp, 0, this.sortedScores[0], num, temp.length);
            Arrays.fill(this.sortedScores[1], num, num + temp.length, this.weights == null ? 1.0 : this.weights[i]);
            num += temp.length;
            ++i;
        }
        int[] rank = ToolBox.rank(this.sortedScores[0], false);
        double[] help = new double[num];
        int n = rank.length - 1;
        for (int j = 0; j < 2; ++j) {
            for (i = 0; i < num; ++i) {
                help[n - rank[i]] = this.sortedScores[j][i];
            }
            double[] h2 = this.sortedScores[j];
            this.sortedScores[j] = help;
            help = h2;
        }
        double sum = 0.0;
        for (i = 0; i < num; ++i) {
            this.sortedScores[1][i] = sum += this.sortedScores[1][i];
        }
        for (i = 0; i < num; ++i) {
            this.sortedScores[1][i] = this.sortedScores[1][i] / sum;
        }
    }

    private void findSignificantMotifOccurrences(int motif, Sequence seq, int start, AbstractList<MotifAnnotation> annotation, int addMax, AbstractList<Sequence> sites, int addLeftSymbols, int addRightSymbols) throws Exception {
        if (!this.oneHistogram) {
            this.createBgDataSet(seq);
            this.fillSortedScoresArray(motif, start);
        }
        double[][] allProfs = this.getAllProfilesOfScoresFor(motif, seq, start);
        double[] joined = this.joinMethod.joinProfiles(allProfs);
        int signIndex = PValueComputation.getIndex(this.sortedScores[1], 1.0 - this.sign, 0);
        double thresh = this.sortedScores[0][signIndex];
        int length = this.disc.getMotifLength(motif);
        int annotIndex = annotation != null ? annotation.size() : 0;
        int siteIndex = sites != null ? sites.size() : 0;
        DoubleList pValues = new DoubleList();
        double[] probs = new double[2];
        double[] tempStrandProbs = null;
        double[] tempCompProbs = new double[allProfs.length];
        for (int j = 0; j < joined.length; ++j) {
            if (!(joined[j] > thresh)) continue;
            try {
                for (int c = 0; c < tempCompProbs.length; ++c) {
                    tempCompProbs[c] = Math.exp(allProfs[c][j] - joined[j]);
                }
                probs[1] = 0.0;
                probs[0] = 0.0;
                for (int i = 0; i < tempCompProbs.length; ++i) {
                    tempStrandProbs = this.disc.getStrandProbabilitiesFor(this.globalToLocalIndexes[motif][0][i], this.globalToLocalIndexes[motif][1][i], seq, start + j);
                    for (int s = 0; s < probs.length; ++s) {
                        int n = s;
                        probs[n] = probs[n] + tempStrandProbs[s] * tempCompProbs[i];
                    }
                }
                if (sites != null) {
                    Sequence site = probs[1] > probs[0] ? seq.getSubSequence(j + start - addRightSymbols, length + addLeftSymbols + addRightSymbols).reverseComplement() : seq.getSubSequence(j + start - addLeftSymbols, length + addLeftSymbols + addRightSymbols);
                    sites.add(site);
                }
                double pVal = SignificantMotifOccurrencesFinder.getPValue(this.sortedScores[0], signIndex, joined[j], this.sortedScores[1]);
                pValues.add(pVal);
                if (annotation == null) continue;
                annotation.add(new MotifAnnotation("motif* " + motif, j + start, length, probs[1] > probs[0] ? StrandedLocatedSequenceAnnotationWithLength.Strand.REVERSE : StrandedLocatedSequenceAnnotationWithLength.Strand.FORWARD, new NumericalResult("component", "the component of the model where this motif was found with the highest probability", this.globalToLocalIndexes[motif][0][SignificantMotifOccurrencesFinder.getIndexOfMax(tempCompProbs)]), new NumericalResult("p-value", "", pVal), new NumericalResult("score", "", joined[j]), new NumericalResult("forward probability", "probability of the forward strand", probs[0])));
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (pValues.length() > addMax) {
            double[] array = pValues.toArray();
            Arrays.sort(array);
            for (int i = 0; i < pValues.length(); ++i) {
                if (pValues.get(i) >= array[addMax]) {
                    if (annotation != null) {
                        annotation.remove(annotIndex);
                    }
                    if (sites == null) continue;
                    sites.remove(siteIndex);
                    continue;
                }
                ++annotIndex;
                ++siteIndex;
            }
        }
    }

    private static double getPValue(double[] sortedScores, int signIndex, double myScore, double[] cumulative) {
        int idx = PValueComputation.getIndex(sortedScores, myScore, signIndex);
        return idx >= cumulative.length ? 0.0 : 1.0 - cumulative[idx];
    }

    private int getLocalIndexOfMotifInComponent(int component, int motif) {
        for (int i = 0; i < this.disc.getNumberOfMotifsInComponent(component); ++i) {
            if (this.disc.getGlobalIndexOfMotifInComponent(component, i) != motif) continue;
            return i;
        }
        return -1;
    }

    private void prepareIndices() {
        int n = this.disc.getNumberOfMotifs();
        this.globalToLocalIndexes = new int[n][][];
        for (int i = 0; i < n; ++i) {
            this.globalToLocalIndexes[i] = this.computeIndices(i);
        }
    }

    private int[][] computeIndices(int motif) {
        int num = 0;
        for (int i = 0; i < this.disc.getNumberOfComponents(); ++i) {
            int loc = this.getLocalIndexOfMotifInComponent(i, motif);
            if (loc <= -1) continue;
            ++num;
        }
        int[][] idxs = new int[2][num];
        num = 0;
        for (int i = 0; i < this.disc.getNumberOfComponents(); ++i) {
            int loc = this.getLocalIndexOfMotifInComponent(i, motif);
            if (loc <= -1) continue;
            idxs[0][num] = i;
            idxs[1][num] = loc;
            ++num;
        }
        return idxs;
    }

    public MotifAnnotation[] findSignificantMotifOccurrences(int motif, Sequence seq, int start) throws Exception {
        return this.findSignificantMotifOccurrences(motif, seq, Integer.MAX_VALUE, start);
    }

    public MotifAnnotation[] findSignificantMotifOccurrences(int motif, Sequence seq, int addMax, int start) throws Exception {
        LinkedList<MotifAnnotation> list = new LinkedList<MotifAnnotation>();
        if (this.oneHistogram) {
            this.fillSortedScoresArray(motif, start);
        }
        this.findSignificantMotifOccurrences(motif, seq, start, list, addMax, null, 0, 0);
        return list.toArray(new MotifAnnotation[0]);
    }

    public DataSet annotateMotif(DataSet data, int motifIndex) throws Exception {
        return this.annotateMotif(0, data, motifIndex);
    }

    public DataSet annotateMotif(int startPos, DataSet data, int motifIndex) throws Exception {
        return this.annotateMotif(startPos, data, motifIndex, Integer.MAX_VALUE, false);
    }

    public DataSet annotateMotif(DataSet data, int motifIndex, int addMax) throws Exception {
        return this.annotateMotif(0, data, motifIndex, addMax, false);
    }

    public DataSet annotateMotif(int startPos, DataSet data, int motifIndex, int addMax, boolean addAnnotation) throws Exception {
        return (DataSet)this.predictBS(startPos, data, null, motifIndex, addMax, 0, 0, addAnnotation).get(0);
    }

    public DataSet getBindingSites(DataSet data, int motifIndex) throws Exception {
        return this.getBindingSites(0, data, motifIndex, Integer.MAX_VALUE, 0, 0);
    }

    public DataSet getBindingSites(int startPos, DataSet data, int motifIndex, int addMax, int addLeft, int addRight) throws Exception {
        return (DataSet)this.predictBS(startPos, data, null, motifIndex, addMax, addLeft, addRight, false).get(1);
    }

    public IntList getStartPositions(int startPos, DataSet data, int motifIndex, int addMax) throws Exception {
        return (IntList)this.predictBS(startPos, data, null, motifIndex, addMax, 0, 0, false).get(3);
    }

    public double getNumberOfBoundSequences(DataSet data, double[] weights, int motifIndex) throws Exception {
        return (Double)this.predictBS(0, data, weights, motifIndex, Integer.MAX_VALUE, 0, 0, false).get(2);
    }

    public double getOffsetForAucPR() {
        return this.oneHistogram ? 0.0 : 1.0;
    }

    public double getFactorForAucPR() {
        return this.oneHistogram ? 1.0 : -1.0;
    }

    public double[][] getValuesForEachNucleotide(DataSet data, int motif, boolean addOnlyBest) throws Exception {
        double[][] res = new double[data.getNumberOfElements()][];
        if (this.oneHistogram) {
            this.fillSortedScoresArray(motif, 0);
        }
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.getValueForNucleotides(data.getElementAt(i), 0, motif, addOnlyBest);
        }
        return res;
    }

    private static int getIndexOfMax(double ... values) {
        int idx = 0;
        for (int i = 1; i < values.length; ++i) {
            if (!(values[i] > values[idx])) continue;
            idx = i;
        }
        return idx;
    }

    private double[] getValueForNucleotides(Sequence seq, int start, int motif, boolean addOnlyBest) throws Exception {
        double[] res;
        block4: {
            int length;
            double[] temp;
            block3: {
                if (!this.oneHistogram) {
                    this.createBgDataSet(seq);
                    this.fillSortedScoresArray(motif, start);
                }
                temp = this.getJointProfileOfScoresFor(motif, seq, start);
                length = this.disc.getMotifLength(motif);
                if (!addOnlyBest) break block3;
                res = new double[seq.getLength() - start];
                Arrays.fill(res, this.oneHistogram ? Double.NEGATIVE_INFINITY : 1.0);
                int idx = SignificantMotifOccurrencesFinder.getIndexOfMax(temp);
                double best = this.oneHistogram ? temp[idx] : SignificantMotifOccurrencesFinder.getPValue(this.sortedScores[0], 0, temp[idx], this.sortedScores[1]);
                for (int i = 0; i < length; ++i) {
                    res[idx + i] = best;
                }
                break block4;
            }
            res = SignificantMotifOccurrencesFinder.smooth(temp, seq.getLength() - start, length);
            if (this.oneHistogram) break block4;
            for (int i = 0; i < temp.length; ++i) {
                res[i] = SignificantMotifOccurrencesFinder.getPValue(this.sortedScores[0], 0, temp[i], this.sortedScores[1]);
            }
        }
        return res;
    }

    private static double[] smooth(double[] temp, int seqLength, int motifLength) {
        double[] res = new double[seqLength];
        Arrays.fill(res, temp[temp.length - 1]);
        System.arraycopy(temp, 0, res, 0, temp.length);
        for (int i = res.length - 1; i >= 0; --i) {
            int k = i - 1;
            for (int j = 1; j < motifLength && k >= 0; ++j, --k) {
                if (!(res[i] < res[k])) continue;
                res[i] = res[k];
            }
        }
        return res;
    }

    private ArrayList predictBS(int startPos, DataSet data, double[] weights, int motif, int addMax, int addLeft, int addRight, boolean addAnnotation) throws Exception {
        DataSet bs;
        int n = data.getNumberOfElements();
        Sequence[] seqs = new Sequence[n];
        IntList posList = new IntList();
        LinkedList<MotifAnnotation> seqAn = new LinkedList<MotifAnnotation>();
        LinkedList<Sequence> bsList = new LinkedList<Sequence>();
        LinkedList<Sequence> currentList = new LinkedList<Sequence>();
        SequenceAnnotation[] empty = new SequenceAnnotation[]{};
        if (this.oneHistogram) {
            this.createBgDataSet(data);
            this.fillSortedScoresArray(motif, startPos);
        }
        double weight = 1.0;
        double bound = 0.0;
        for (int i = 0; i < n; ++i) {
            seqs[i] = data.getElementAt(i);
            if (weights != null) {
                weight = weights[i];
            }
            seqAn.clear();
            this.findSignificantMotifOccurrences(motif, seqs[i], startPos, seqAn, addMax, currentList, addLeft, addRight);
            if (currentList.size() > 0) {
                bound += weight;
                bsList.addAll(currentList);
                currentList.clear();
            }
            seqs[i] = seqs[i].annotate(addAnnotation, seqAn.toArray(empty));
            for (int k = 0; k < seqAn.size(); ++k) {
                MotifAnnotation current = seqAn.get(k);
                posList.add(current.getPosition());
            }
        }
        ArrayList<Object> res = new ArrayList<Object>(4);
        res.add(new DataSet("annotated sample", seqs));
        try {
            bs = new DataSet("annotated binding sites", bsList.toArray(new Sequence[0]));
        }
        catch (Exception e) {
            bs = null;
        }
        res.add(bs);
        res.add(bound);
        res.add(posList);
        return res;
    }

    public MotifDiscoverer getMotifDiscoverer() throws CloneNotSupportedException {
        return this.disc.clone();
    }

    public static class SumOfProbabilities
    implements JoinMethod {
        @Override
        public double[] joinProfiles(double[][] profiles) {
            double[] res = new double[profiles[0].length];
            for (int i = 0; i < profiles.length; ++i) {
                if (profiles[i].length == res.length) continue;
                throw new IllegalArgumentException("Profiles must be of same length, but profile " + i + " has length " + profiles[i].length + " instead of " + res.length);
            }
            double[] temp = new double[profiles.length];
            for (int i = 0; i < res.length; ++i) {
                for (int j = 0; j < temp.length; ++j) {
                    temp[j] = profiles[j][i];
                }
                res[i] = Normalisation.getLogSum(temp);
            }
            return res;
        }
    }

    public static interface JoinMethod {
        public double[] joinProfiles(double[][] var1) throws Exception;
    }

    public static enum RandomSeqType {
        BACKGROUND(-2),
        PERMUTED(-1),
        hMM0(0),
        hMM1(1),
        hMM2(2),
        hMM3(3),
        hMM4(4),
        hMM5(5);

        private final int order;

        private RandomSeqType(int order) {
            this.order = order;
        }

        public int getOrder() {
            return this.order;
        }
    }
}

