/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db.biosql;

import java.lang.reflect.Method;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.biojava.bio.BioRuntimeException;
import org.biojava.bio.seq.db.biosql.DBHelper;

public class OracleDBHelper
extends DBHelper {
    private final DBHelper.JoinStyle mJoinStyle;
    private final DBHelper.BioSequenceStyle mBseqStyle;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleDBHelper(Connection connection) {
        DBHelper.JoinStyle joinStyle = JOIN_GENERIC;
        DBHelper.BioSequenceStyle bseqStyle = BIOSEQUENCE_GENERIC;
        try {
            DatabaseMetaData metadata = connection.getMetaData();
            String version = metadata.getDatabaseProductVersion();
            if (version != null && version.startsWith("Oracle8")) {
                joinStyle = JOIN_ORACLE8;
            }
            Statement st = null;
            ResultSet rs = null;
            try {
                st = connection.createStatement();
                rs = st.executeQuery("select data_type from user_tab_columns where table_name='BIOSEQUENCE' and column_name='SEQ'");
                String seqType = null;
                if (rs.next()) {
                    seqType = rs.getString(1);
                }
                if (seqType == null || "CLOB".equals(seqType)) {
                    bseqStyle = BIOSEQUENCE_ORACLECLOB;
                }
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException se) {}
                }
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException se) {}
                }
            }
        }
        catch (SQLException e) {
            System.err.println("Exception getting DatabaseMetaData:" + e.getMessage());
        }
        this.mJoinStyle = joinStyle;
        this.mBseqStyle = bseqStyle;
    }

    public DBHelper.JoinStyle getJoinStyle() {
        return this.mJoinStyle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInsertID(Connection conn, String table, String columnName) throws SQLException {
        Statement st = null;
        ResultSet rs = null;
        try {
            st = conn.createStatement();
            rs = st.executeQuery("select " + table + "_pk_seq.CURRVAL from dual");
            int id = -1;
            if (rs.next()) {
                id = rs.getInt(1);
            }
            if (id < 1) {
                throw new SQLException("Couldn't get last insert id");
            }
            int n = id;
            return n;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException se) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException se) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsTable(DataSource ds, String tablename) {
        if (ds == null) {
            throw new NullPointerException("Require a datasource.");
        }
        if (tablename == null || tablename.length() == 0) {
            throw new IllegalArgumentException("Invalid table name given");
        }
        Connection conn = null;
        try {
            boolean present;
            conn = ds.getConnection();
            PreparedStatement ps = conn.prepareStatement("select rownum from " + tablename + " where rownum < 1");
            try {
                ps.executeQuery();
                present = true;
            }
            catch (SQLException ex) {
                present = false;
            }
            finally {
                ps.close();
                if (conn != null) {
                    conn.close();
                }
            }
            return present;
        }
        catch (SQLException ex) {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ex3) {
                    // empty catch block
                }
            }
            throw new BioRuntimeException(ex);
        }
    }

    public DBHelper.BioSequenceStyle getBioSequenceStyle() {
        return this.mBseqStyle;
    }

    public String clobToString(Connection conn, ResultSet rs, int column) {
        try {
            Clob seqclob = rs.getClob(column);
            StringBuffer buf = new StringBuffer();
            int bufSize = 1024;
            long start = 1L;
            for (long remain = seqclob.length(); remain > 0L; remain -= (long)bufSize) {
                if ((long)bufSize > remain) {
                    bufSize = (int)remain;
                }
                buf.append(seqclob.getSubString(start, bufSize));
                start += (long)bufSize;
            }
            return buf.toString().trim();
        }
        catch (Exception ex) {
            throw new BioRuntimeException(ex);
        }
    }

    public void stringToClob(Connection conn, ResultSet rs, int column, String value) {
        try {
            Class<?> clob = Class.forName("oracle.sql.CLOB");
            Method putString = clob.getDeclaredMethod("putString", Long.TYPE, String.class);
            if (value == null) {
                value = "";
            }
            putString.invoke((Object)rs.getClob(column), new Long(1L), value);
        }
        catch (Exception ex) {
            throw new BioRuntimeException(ex);
        }
    }
}

