/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.db.biosql;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.biojava.bio.BioRuntimeException;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FilterUtils;
import org.biojava.utils.walker.WalkerFactory;
import org.biojavax.Note;
import org.biojavax.RichAnnotation;
import org.biojavax.RichObjectFactory;
import org.biojavax.SimpleNote;
import org.biojavax.bio.db.biosql.BioSQLAcceptAllFilter;
import org.biojavax.bio.db.biosql.BioSQLAcceptNoneFilter;
import org.biojavax.bio.seq.RichFeature;
import org.biojavax.bio.seq.RichLocation;
import org.biojavax.ontology.ComparableTerm;

public interface BioSQLFeatureFilter
extends FeatureFilter {
    public static final BioSQLFeatureFilter all = new BioSQLAcceptAllFilter();
    public static final BioSQLFeatureFilter none = new BioSQLAcceptNoneFilter();

    public Object asCriterion();

    public Map criterionAliasMap();

    public static final class ByNoteTermOnly
    extends HibernateFeatureFilter {
        private ComparableTerm term;

        public ByNoteTermOnly(ComparableTerm term) {
            this.term = term;
        }

        public ComparableTerm getTerm() {
            return this.term;
        }

        public boolean accept(Feature f) {
            if (f instanceof RichFeature) {
                RichAnnotation ra = (RichAnnotation)((RichFeature)f).getAnnotation();
                try {
                    Iterator i = ra.getNoteSet().iterator();
                    while (i.hasNext()) {
                        if (!((Note)i.next()).getTerm().equals(this.term)) continue;
                        return true;
                    }
                }
                catch (NoSuchElementException e) {
                    return false;
                }
            }
            return false;
        }

        public Object asCriterion() {
            try {
                return this.eq.invoke(null, "n.term", this.term);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        public Map criterionAliasMap() {
            HashMap<String, String> results = new HashMap<String, String>();
            results.put("noteSet", "n");
            return results;
        }

        public boolean equals(Object o) {
            if (o instanceof ByNoteTermOnly) {
                ByNoteTermOnly that = (ByNoteTermOnly)o;
                return this.getTerm() == that.getTerm();
            }
            return false;
        }

        public int hashCode() {
            return this.getTerm().hashCode();
        }

        public String toString() {
            return "ByNoteTermOnly {" + this.term + "}";
        }
    }

    public static final class ByNote
    extends HibernateFeatureFilter {
        private Note note;

        public ByNote(Note note) {
            this.note = note;
        }

        public Note getNote() {
            return this.note;
        }

        public boolean accept(Feature f) {
            if (f instanceof RichFeature) {
                RichAnnotation ra = (RichAnnotation)((RichFeature)f).getAnnotation();
                try {
                    Note n = ra.getNote(this.note);
                    return n.getValue() == this.note.getValue() || n.getValue() != null && this.note.getValue() != null && n.getValue().equals(this.note.getValue());
                }
                catch (NoSuchElementException e) {
                    return false;
                }
            }
            return false;
        }

        public Object asCriterion() {
            try {
                Object conjunct = this.conjunction.invoke(null, null);
                this.conjunctAdd.invoke(conjunct, this.eq.invoke(null, "n.term", this.note.getTerm()));
                this.conjunctAdd.invoke(conjunct, this.eq.invoke(null, "n.value", this.note.getValue()));
                this.conjunctAdd.invoke(conjunct, this.eq.invoke(null, "n.rank", new Integer(this.note.getRank())));
                return conjunct;
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        public Map criterionAliasMap() {
            HashMap<String, String> results = new HashMap<String, String>();
            results.put("noteSet", "n");
            return results;
        }

        public boolean equals(Object o) {
            if (o instanceof ByNote) {
                ByNote that = (ByNote)o;
                return this.getNote() == that.getNote();
            }
            return false;
        }

        public int hashCode() {
            return this.getNote().hashCode();
        }

        public String toString() {
            return "ByNote {" + this.note + "}";
        }
    }

    public static final class OverlapsRichLocation
    extends HibernateFeatureFilter {
        private RichLocation loc;

        public RichLocation getRichLocation() {
            return this.loc;
        }

        public OverlapsRichLocation(RichLocation loc) {
            if (loc == null) {
                throw new NullPointerException("Loc may not be null");
            }
            this.loc = loc;
        }

        public boolean accept(Feature f) {
            return this.loc.overlaps(f.getLocation());
        }

        public Object asCriterion() {
            try {
                Collection members = RichLocation.Tools.flatten(this.loc);
                Object parentConjunct = this.conjunction.invoke(null, null);
                for (RichLocation loc : members) {
                    Object childDisjunct = this.disjunction.invoke(null, null);
                    this.disjunctAdd.invoke(childDisjunct, this.eq.invoke(null, "l.strandNum", new Integer(loc.getStrand().intValue())));
                    this.disjunctAdd.invoke(childDisjunct, this.eq.invoke(null, "l.crossRef", loc.getCrossRef()));
                    this.disjunctAdd.invoke(childDisjunct, this.ge.invoke(null, "l.max", new Integer(loc.getMin())));
                    this.disjunctAdd.invoke(childDisjunct, this.le.invoke(null, "l.min", new Integer(loc.getMax())));
                    this.conjunctAdd.invoke(parentConjunct, childDisjunct);
                }
                return parentConjunct;
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        public Map criterionAliasMap() {
            HashMap<String, String> results = new HashMap<String, String>();
            results.put("locationSet", "l");
            return results;
        }

        public boolean equals(Object o) {
            return o instanceof OverlapsRichLocation && ((OverlapsRichLocation)o).getRichLocation().equals(this.getRichLocation());
        }

        public int hashCode() {
            return this.getRichLocation().hashCode();
        }

        public String toString() {
            return "Overlaps(" + this.loc + ")";
        }
    }

    public static final class ByStrand
    extends HibernateFeatureFilter {
        private RichLocation.Strand str;

        public RichLocation.Strand getStrand() {
            return this.str;
        }

        public ByStrand(RichLocation.Strand str) {
            if (str == null) {
                throw new NullPointerException("Strand may not be null");
            }
            this.str = str;
        }

        public boolean accept(Feature f) {
            if (f instanceof RichFeature) {
                RichFeature rf = (RichFeature)f;
                Iterator i = rf.getLocation().blockIterator();
                while (i.hasNext()) {
                    RichLocation l = (RichLocation)i.next();
                    if (!l.getStrand().equals(this.str)) continue;
                    return true;
                }
            }
            return false;
        }

        public Object asCriterion() {
            try {
                return this.eq.invoke(null, "l.strandNum", new Integer(this.str.intValue()));
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        public Map criterionAliasMap() {
            HashMap<String, String> results = new HashMap<String, String>();
            results.put("locationSet", "l");
            return results;
        }

        public boolean equals(Object o) {
            return o instanceof ByStrand && ((ByStrand)o).getStrand().equals(this.getStrand());
        }

        public int hashCode() {
            return this.getStrand().hashCode();
        }

        public String toString() {
            return "ByStrand(" + this.str + ")";
        }
    }

    public static final class ContainedByRichLocation
    extends HibernateFeatureFilter {
        private RichLocation loc;

        public RichLocation getRichLocation() {
            return this.loc;
        }

        public ContainedByRichLocation(RichLocation loc) {
            if (loc == null) {
                throw new NullPointerException("Loc may not be null");
            }
            this.loc = loc;
        }

        public boolean accept(Feature f) {
            return this.loc.contains(f.getLocation());
        }

        public Object asCriterion() {
            try {
                Collection members = RichLocation.Tools.flatten(this.loc);
                Object parentConjunct = this.conjunction.invoke(null, null);
                for (RichLocation loc : members) {
                    Object childDisjunct = this.disjunction.invoke(null, null);
                    this.disjunctAdd.invoke(childDisjunct, this.eq.invoke(null, "l.strandNum", new Integer(loc.getStrand().intValue())));
                    this.disjunctAdd.invoke(childDisjunct, this.eq.invoke(null, "l.crossRef", loc.getCrossRef()));
                    this.disjunctAdd.invoke(childDisjunct, this.ge.invoke(null, "l.min", new Integer(loc.getMin())));
                    this.disjunctAdd.invoke(childDisjunct, this.le.invoke(null, "l.max", new Integer(loc.getMax())));
                    this.conjunctAdd.invoke(parentConjunct, childDisjunct);
                }
                return parentConjunct;
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        public Map criterionAliasMap() {
            HashMap<String, String> results = new HashMap<String, String>();
            results.put("locationSet", "l");
            return results;
        }

        public boolean equals(Object o) {
            return o instanceof ContainedByRichLocation && ((ContainedByRichLocation)o).getRichLocation().equals(this.getRichLocation());
        }

        public int hashCode() {
            return this.getRichLocation().hashCode();
        }

        public String toString() {
            return "ContainedBy(" + this.loc + ")";
        }
    }

    public static final class BySequenceName
    extends HibernateFeatureFilter {
        private String seqName;

        public BySequenceName(String seqName) {
            this.seqName = seqName;
        }

        public String getSequenceName() {
            return this.seqName;
        }

        public boolean accept(Feature f) {
            return f.getSequence().getName().equals(this.seqName);
        }

        public Object asCriterion() {
            try {
                return this.eq.invoke(null, "p.name", this.seqName);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        public Map criterionAliasMap() {
            HashMap<String, String> results = new HashMap<String, String>();
            results.put("parent", "p");
            return results;
        }

        public boolean equals(Object o) {
            return o instanceof BySequenceName && ((BySequenceName)o).getSequenceName().equals(this.seqName);
        }

        public int hashCode() {
            return this.seqName.hashCode();
        }
    }

    public static final class BySourceTermName
    extends HibernateFeatureFilter {
        private String sourceTermName;

        public String getSourceTermName() {
            return this.sourceTermName;
        }

        public BySourceTermName(String sourceTermName) {
            if (sourceTermName == null) {
                throw new NullPointerException("Source name may not be null");
            }
            this.sourceTermName = sourceTermName;
        }

        public boolean accept(Feature f) {
            return this.sourceTermName.equals(f.getSourceTerm().getName());
        }

        public Object asCriterion() {
            try {
                return this.eq.invoke(null, "st.name", this.sourceTermName);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        public Map criterionAliasMap() {
            HashMap<String, String> results = new HashMap<String, String>();
            results.put("sourceTerm", "st");
            return results;
        }

        public boolean equals(Object o) {
            return o instanceof BySourceTermName && ((BySourceTermName)o).getSourceTermName().equals(this.getSourceTermName());
        }

        public int hashCode() {
            return this.getSourceTermName().hashCode();
        }

        public String toString() {
            return "BySourceTermName(" + this.sourceTermName + ")";
        }
    }

    public static final class ByTypeTermName
    extends HibernateFeatureFilter {
        private String typeTermName;

        public String getTypeTermName() {
            return this.typeTermName;
        }

        public ByTypeTermName(String typeTermName) {
            if (typeTermName == null) {
                throw new NullPointerException("Type name may not be null");
            }
            this.typeTermName = typeTermName;
        }

        public boolean accept(Feature f) {
            return this.typeTermName.equals(f.getTypeTerm().getName());
        }

        public Object asCriterion() {
            try {
                return this.eq.invoke(null, "tt.name", this.typeTermName);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        public Map criterionAliasMap() {
            HashMap<String, String> results = new HashMap<String, String>();
            results.put("typeTerm", "tt");
            return results;
        }

        public boolean equals(Object o) {
            return o instanceof ByTypeTermName && ((ByTypeTermName)o).getTypeTermName().equals(this.getTypeTermName());
        }

        public int hashCode() {
            return this.getTypeTermName().hashCode();
        }

        public String toString() {
            return "ByTypeTermName(" + this.typeTermName + ")";
        }
    }

    public static final class BySourceTerm
    extends HibernateFeatureFilter {
        private ComparableTerm sourceTerm;

        public ComparableTerm getSourceTerm() {
            return this.sourceTerm;
        }

        public BySourceTerm(ComparableTerm sourceTerm) {
            if (sourceTerm == null) {
                throw new NullPointerException("Source may not be null");
            }
            this.sourceTerm = sourceTerm;
        }

        public boolean accept(Feature f) {
            return this.sourceTerm.equals(f.getSourceTerm());
        }

        public Object asCriterion() {
            try {
                return this.eq.invoke(null, "sourceTerm", this.sourceTerm);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean equals(Object o) {
            return o instanceof BySourceTerm && ((BySourceTerm)o).getSourceTerm().equals(this.getSourceTerm());
        }

        public int hashCode() {
            return this.getSourceTerm().hashCode();
        }

        public String toString() {
            return "BySourceTerm(" + this.sourceTerm + ")";
        }
    }

    public static final class ByTypeTerm
    extends HibernateFeatureFilter {
        private ComparableTerm typeTerm;

        public ComparableTerm getTypeTerm() {
            return this.typeTerm;
        }

        public ByTypeTerm(ComparableTerm typeTerm) {
            if (typeTerm == null) {
                throw new NullPointerException("Type may not be null");
            }
            this.typeTerm = typeTerm;
        }

        public boolean accept(Feature f) {
            return this.typeTerm.equals(f.getTypeTerm());
        }

        public Object asCriterion() {
            try {
                return this.eq.invoke(null, "typeTerm", this.typeTerm);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean equals(Object o) {
            return o instanceof ByTypeTerm && ((ByTypeTerm)o).getTypeTerm().equals(this.getTypeTerm());
        }

        public int hashCode() {
            return this.getTypeTerm().hashCode();
        }

        public String toString() {
            return "ByTypeTerm(" + this.typeTerm + ")";
        }
    }

    public static final class ByRank
    extends HibernateFeatureFilter {
        private int rank;

        public int getRank() {
            return this.rank;
        }

        public ByRank(int rank) {
            this.rank = rank;
        }

        public boolean accept(Feature f) {
            if (f instanceof RichFeature) {
                return this.rank == ((RichFeature)f).getRank();
            }
            return false;
        }

        public Object asCriterion() {
            try {
                return this.eq.invoke(null, "rank", new Integer(this.rank));
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean equals(Object o) {
            return o instanceof ByRank && ((ByRank)o).getRank() == this.getRank();
        }

        public int hashCode() {
            return this.rank;
        }

        public String toString() {
            return "ByRank(" + this.rank + ")";
        }
    }

    public static final class ByName
    extends HibernateFeatureFilter {
        private String name;

        public String getName() {
            return this.name;
        }

        public ByName(String name) {
            if (name == null) {
                throw new NullPointerException("Name may not be null");
            }
            this.name = name;
        }

        public boolean accept(Feature f) {
            if (f instanceof RichFeature) {
                return this.name.equals(((RichFeature)f).getName());
            }
            return false;
        }

        public Object asCriterion() {
            try {
                return this.eq.invoke(null, "name", this.name);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean equals(Object o) {
            return o instanceof ByName && ((ByName)o).getName().equals(this.getName());
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public String toString() {
            return "ByName(" + this.name + ")";
        }
    }

    public static final class Or
    extends HibernateFeatureFilter {
        BioSQLFeatureFilter c1;
        BioSQLFeatureFilter c2;

        public BioSQLFeatureFilter getChild1() {
            return this.c1;
        }

        public BioSQLFeatureFilter getChild2() {
            return this.c2;
        }

        public Or(BioSQLFeatureFilter c1, BioSQLFeatureFilter c2) {
            if (!(c1 instanceof BioSQLFeatureFilter) || !(c2 instanceof BioSQLFeatureFilter)) {
                throw new BioRuntimeException("Cannot use non-BioSQLFeatureFilter instances with this class");
            }
            this.c1 = c1;
            this.c2 = c2;
        }

        public boolean accept(Feature f) {
            return this.c1.accept(f) || this.c2.accept(f);
        }

        public Object asCriterion() {
            try {
                return this.or.invoke(null, this.c1.asCriterion(), this.c2.asCriterion());
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        public Map criterionAliasMap() {
            HashMap results = new HashMap();
            results.putAll(this.c1.criterionAliasMap());
            results.putAll(this.c2.criterionAliasMap());
            return results;
        }

        public boolean equals(Object o) {
            if (o instanceof BioSQLFeatureFilter) {
                return FilterUtils.areEqual(this, (FeatureFilter)o);
            }
            return false;
        }

        public int hashCode() {
            return this.getChild1().hashCode() ^ this.getChild2().hashCode();
        }

        public String toString() {
            return "Or(" + this.c1 + " , " + this.c2 + ")";
        }

        static {
            WalkerFactory.getInstance().addTypeWithParent(Or.class);
        }
    }

    public static final class And
    extends HibernateFeatureFilter {
        BioSQLFeatureFilter c1;
        BioSQLFeatureFilter c2;

        public BioSQLFeatureFilter getChild1() {
            return this.c1;
        }

        public BioSQLFeatureFilter getChild2() {
            return this.c2;
        }

        public And(BioSQLFeatureFilter c1, BioSQLFeatureFilter c2) {
            if (!(c1 instanceof BioSQLFeatureFilter) || !(c2 instanceof BioSQLFeatureFilter)) {
                throw new BioRuntimeException("Cannot use non-BioSQLFeatureFilter instances with this class");
            }
            this.c1 = c1;
            this.c2 = c2;
        }

        public boolean accept(Feature f) {
            return this.c1.accept(f) && this.c2.accept(f);
        }

        public Object asCriterion() {
            try {
                return this.and.invoke(null, this.c1.asCriterion(), this.c2.asCriterion());
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        public Map criterionAliasMap() {
            HashMap results = new HashMap();
            results.putAll(this.c1.criterionAliasMap());
            results.putAll(this.c2.criterionAliasMap());
            return results;
        }

        public boolean equals(Object o) {
            if (o instanceof BioSQLFeatureFilter) {
                return FilterUtils.areEqual(this, (FeatureFilter)o);
            }
            return false;
        }

        public int hashCode() {
            return this.getChild1().hashCode() ^ this.getChild2().hashCode();
        }

        public String toString() {
            return "And(" + this.c1 + " , " + this.c2 + ")";
        }

        static {
            WalkerFactory.getInstance().addTypeWithParent(And.class);
        }
    }

    public static final class Not
    extends HibernateFeatureFilter {
        BioSQLFeatureFilter child;

        public BioSQLFeatureFilter getChild() {
            return this.child;
        }

        public Not(BioSQLFeatureFilter child) {
            if (!(child instanceof BioSQLFeatureFilter)) {
                throw new BioRuntimeException("Cannot use non-BioSQLFeatureFilter instances with this class");
            }
            this.child = child;
        }

        public boolean accept(Feature f) {
            return !this.child.accept(f);
        }

        public Object asCriterion() {
            try {
                return this.not.invoke(null, this.child.asCriterion());
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        public Map criterionAliasMap() {
            return this.child.criterionAliasMap();
        }

        public boolean equals(Object o) {
            return o instanceof Not && ((Not)o).getChild().equals(this.getChild());
        }

        public int hashCode() {
            return this.getChild().hashCode();
        }

        public String toString() {
            return "Not(" + this.child + ")";
        }

        static {
            WalkerFactory.getInstance().addTypeWithParent(Not.class);
        }
    }

    public static abstract class HibernateFeatureFilter
    implements BioSQLFeatureFilter {
        protected Method not;
        protected Method and;
        protected Method or;
        protected Method eq;
        protected Method le;
        protected Method ge;
        protected Method conjunction;
        protected Method disjunction;
        protected Method conjunctAdd;
        protected Method disjunctAdd;

        public HibernateFeatureFilter() {
            try {
                Class<?> restrictions = Class.forName("org.hibernate.criterion.Restrictions");
                Class<?> criterion = Class.forName("org.hibernate.criterion.Criterion");
                this.not = restrictions.getMethod("not", criterion);
                this.and = restrictions.getMethod("and", criterion, criterion);
                this.or = restrictions.getMethod("or", criterion, criterion);
                this.eq = restrictions.getMethod("eq", String.class, Object.class);
                this.le = restrictions.getMethod("le", String.class, Object.class);
                this.ge = restrictions.getMethod("ge", String.class, Object.class);
                this.conjunction = restrictions.getMethod("conjunction", new Class[0]);
                this.disjunction = restrictions.getMethod("disjunction", new Class[0]);
                Class<?> conjunctClass = Class.forName("org.hibernate.criterion.Conjunction");
                Class<?> disjunctClass = Class.forName("org.hibernate.criterion.Disjunction");
                this.conjunctAdd = conjunctClass.getMethod("add", criterion);
                this.disjunctAdd = disjunctClass.getMethod("add", criterion);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }

        public Map criterionAliasMap() {
            return Collections.EMPTY_MAP;
        }
    }

    public static class Tools {
        public static BioSQLFeatureFilter convert(FeatureFilter ff) {
            if (ff instanceof BioSQLFeatureFilter) {
                return (BioSQLFeatureFilter)ff;
            }
            BioSQLFeatureFilter bff = Tools.attemptConversion(ff);
            if (bff != null) {
                return bff;
            }
            return all;
        }

        private static BioSQLFeatureFilter attemptConversion(FeatureFilter ff) {
            if (ff instanceof FeatureFilter.And) {
                FeatureFilter.And ffand = (FeatureFilter.And)ff;
                BioSQLFeatureFilter child1 = Tools.attemptConversion(ffand.getChild1());
                BioSQLFeatureFilter child2 = Tools.attemptConversion(ffand.getChild2());
                if (child1 == null && child2 == null) {
                    return null;
                }
                if (child1 == null && child2 != null) {
                    return child2;
                }
                if (child1 != null && child2 == null) {
                    return child1;
                }
                return new And(child1, child2);
            }
            if (ff instanceof FeatureFilter.Or) {
                FeatureFilter.Or ffor = (FeatureFilter.Or)ff;
                BioSQLFeatureFilter child1 = Tools.attemptConversion(ffor.getChild1());
                BioSQLFeatureFilter child2 = Tools.attemptConversion(ffor.getChild2());
                if (child1 == null || child2 == null) {
                    return null;
                }
                return new Or(child1, child2);
            }
            if (ff instanceof FeatureFilter.Not) {
                FeatureFilter.Not ffnot = (FeatureFilter.Not)ff;
                BioSQLFeatureFilter child = Tools.attemptConversion(ffnot.getChild());
                if (child == null) {
                    return null;
                }
                return new Not(child);
            }
            if (ff instanceof FeatureFilter.BySource) {
                FeatureFilter.BySource ffsrc = (FeatureFilter.BySource)ff;
                String name = ffsrc.getSource();
                return new BySourceTermName(name);
            }
            if (ff instanceof FeatureFilter.ByType) {
                FeatureFilter.ByType ffsrc = (FeatureFilter.ByType)ff;
                String name = ffsrc.getType();
                return new ByTypeTermName(name);
            }
            if (ff instanceof FeatureFilter.ContainedByLocation) {
                FeatureFilter.ContainedByLocation ffloc = (FeatureFilter.ContainedByLocation)ff;
                return new ContainedByRichLocation(RichLocation.Tools.enrich(ffloc.getLocation()));
            }
            if (ff instanceof FeatureFilter.BySequenceName) {
                FeatureFilter.BySequenceName ffsn = (FeatureFilter.BySequenceName)ff;
                return new BySequenceName(ffsn.getSequenceName());
            }
            if (ff instanceof FeatureFilter.ShadowOverlapsLocation) {
                FeatureFilter.ShadowOverlapsLocation ffloc = (FeatureFilter.ShadowOverlapsLocation)ff;
                return new OverlapsRichLocation(RichLocation.Tools.enrich(ffloc.getLocation()));
            }
            if (ff instanceof FeatureFilter.AnnotationContains) {
                ComparableTerm noteTerm;
                FeatureFilter.AnnotationContains ffann = (FeatureFilter.AnnotationContains)ff;
                if (!(ffann.getValue() instanceof String)) {
                    return null;
                }
                String noteValue = (String)ffann.getValue();
                Object key = ffann.getKey();
                if (key instanceof Collection) {
                    Collection coll = (Collection)key;
                    if (coll.size() < 1) {
                        return null;
                    }
                    key = coll.toArray()[0];
                }
                if (key instanceof ComparableTerm) {
                    noteTerm = (ComparableTerm)key;
                } else if (key instanceof String) {
                    noteTerm = RichObjectFactory.getDefaultOntology().getOrCreateTerm((String)key);
                } else {
                    return null;
                }
                return new ByNote(new SimpleNote(noteTerm, noteValue, 0));
            }
            if (ff instanceof FeatureFilter.StrandFilter) {
                FeatureFilter.StrandFilter ffstr = (FeatureFilter.StrandFilter)ff;
                RichLocation.Strand strand = RichLocation.Strand.forName("" + ffstr.getStrand().getToken());
                return new ByStrand(strand);
            }
            if (ff instanceof FeatureFilter.HasAnnotation) {
                ComparableTerm noteTerm;
                FeatureFilter.HasAnnotation ffann = (FeatureFilter.HasAnnotation)ff;
                if (ffann.getKey() instanceof ComparableTerm) {
                    noteTerm = (ComparableTerm)ffann.getKey();
                } else if (ffann.getKey() instanceof String) {
                    noteTerm = RichObjectFactory.getDefaultOntology().getOrCreateTerm((String)ffann.getKey());
                } else {
                    return null;
                }
                return new ByNoteTermOnly(noteTerm);
            }
            if (ff instanceof FeatureFilter.ByAnnotation) {
                ComparableTerm noteTerm;
                FeatureFilter.ByAnnotation ffann = (FeatureFilter.ByAnnotation)ff;
                if (!(ffann.getValue() instanceof String)) {
                    return null;
                }
                String noteValue = (String)ffann.getValue();
                Object key = ffann.getKey();
                if (key instanceof ComparableTerm) {
                    noteTerm = (ComparableTerm)key;
                } else if (key instanceof String) {
                    noteTerm = RichObjectFactory.getDefaultOntology().getOrCreateTerm((String)key);
                } else {
                    return null;
                }
                return new ByNote(new SimpleNote(noteTerm, noteValue, 0));
            }
            if (ff instanceof FeatureFilter.OverlapsLocation) {
                FeatureFilter.OverlapsLocation ffloc = (FeatureFilter.OverlapsLocation)ff;
                return new OverlapsRichLocation(RichLocation.Tools.enrich(ffloc.getLocation()));
            }
            if (ff instanceof FeatureFilter.ShadowContainedByLocation) {
                FeatureFilter.ShadowContainedByLocation ffloc = (FeatureFilter.ShadowContainedByLocation)ff;
                return new ContainedByRichLocation(RichLocation.Tools.enrich(ffloc.getLocation()));
            }
            return null;
        }
    }
}

