/*
 * Decompiled with CFR 0.152.
 */
package projects.dispom;

import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.GenDisMixClassifier;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.EmptyDataSetException;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.WrongLengthException;
import de.jstacs.data.alphabets.DNAAlphabet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.sequences.PermutedSequence;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.MotifAnnotation;
import de.jstacs.data.sequences.annotation.StrandedLocatedSequenceAnnotationWithLength;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.FileManager;
import de.jstacs.io.SparseStringExtractor;
import de.jstacs.io.XMLParser;
import de.jstacs.motifDiscovery.MotifDiscoverer;
import de.jstacs.motifDiscovery.SignificantMotifOccurrencesFinder;
import de.jstacs.parameters.ParameterSetTagger;
import de.jstacs.sequenceScores.statisticalModels.differentiable.DifferentiableStatisticalModel;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Random;
import projects.dispom.DispomPredictorParameterSet;

public class DispomPredictor {
    private static final String[] PREFIX = new String[]{"home", "ignore", "fg", "bg", "xml", "p-val", "one-histogram"};

    private static DataSet getSample(AlphabetContainer con, String fileName, char ignore) throws FileNotFoundException, WrongAlphabetException, EmptyDataSetException, WrongLengthException, IOException {
        return new DataSet(con, new SparseStringExtractor(fileName, ignore));
    }

    public static void main(String[] args) throws Exception {
        int i;
        SignificantMotifOccurrencesFinder smof;
        ParameterSetTagger params = new ParameterSetTagger(PREFIX, new DispomPredictorParameterSet());
        params.fillParameters("=", args);
        System.out.println("parameters:");
        System.out.println(params);
        System.out.println("_________________________________");
        if (!params.hasDefaultOrIsSet()) {
            System.out.println("Some of the required parameters are not specified.");
            System.exit(1);
        }
        DNAAlphabetContainer con = DNAAlphabetContainer.SINGLETON;
        String home = params.getValueFromTag("home", String.class);
        char ignore = params.getValueFromTag("ignore", Character.class).charValue();
        int anz = 1;
        if (params.isSet("bg")) {
            anz = 2;
        }
        DataSet[] data = new DataSet[anz];
        data[0] = DispomPredictor.getSample(con, home + File.separatorChar + params.getValueFromTag("fg", String.class), ignore);
        if (anz > 1) {
            data[1] = DispomPredictor.getSample(con, home + File.separatorChar + params.getValueFromTag("bg", String.class), ignore);
        }
        double[][] weights = new double[anz][];
        for (int i2 = 0; i2 < data.length; ++i2) {
            weights[i2] = new double[data[i2].getNumberOfElements()];
            Arrays.fill(weights[i2], 1.0);
            System.out.println(i2 + "\t# = " + data[i2].getNumberOfElements() + "\tlength = " + data[i2].getElementLength() + "\t" + data[i2].getAnnotation());
        }
        int sl = data[0].getElementLength();
        String fName = params.getValueFromTag("xml", String.class);
        if (!fName.endsWith(".xml")) {
            fName = fName + ".xml";
        }
        GenDisMixClassifier cl = new GenDisMixClassifier(XMLParser.extractForTag(FileManager.readFile(new File(fName)), "classifier"));
        DifferentiableStatisticalModel[] bestNSF = ArrayHandler.cast(DifferentiableStatisticalModel.class, cl.getDifferentiableSequenceScores());
        System.out.println("_________________________________");
        System.out.println(bestNSF[0]);
        System.out.println("result: " + cl.getLastScore());
        System.out.println("_________________________________");
        if (anz > 1) {
            smof = new SignificantMotifOccurrencesFinder((MotifDiscoverer)((Object)bestNSF[0]), data[1], null, params.getValueFromTag("p-val", Double.class));
        } else if (params.getValueFromTag("one-histogram", Boolean.class).booleanValue()) {
            Random r = new Random();
            Sequence[] seqs = new Sequence[1000];
            int numFg = data[0].getNumberOfElements();
            for (int n = 0; n < seqs.length; ++n) {
                seqs[n] = new PermutedSequence(data[0].getElementAt(r.nextInt(numFg)));
            }
            DataSet bg = new DataSet("permuted", seqs);
            smof = new SignificantMotifOccurrencesFinder((MotifDiscoverer)((Object)bestNSF[0]), bg, null, params.getValueFromTag("p-val", Double.class));
        } else {
            smof = new SignificantMotifOccurrencesFinder((MotifDiscoverer)((Object)bestNSF[0]), SignificantMotifOccurrencesFinder.RandomSeqType.PERMUTED, false, 1000, (double)params.getValueFromTag("p-val", Double.class));
        }
        System.out.println("prediction");
        System.out.println();
        System.out.println("sequence\tposition\tstrand\tbinding site\tp-value");
        System.out.println("------------------------------------------------------------------------");
        LinkedList<Sequence> list = new LinkedList<Sequence>();
        for (i = 0; i < data[0].getNumberOfElements(); ++i) {
            Sequence seq = data[0].getElementAt(i);
            MotifAnnotation[] ma = smof.findSignificantMotifOccurrences(0, seq, 0);
            if (ma == null || ma.length == 0) continue;
            for (int j = 0; j < ma.length; ++j) {
                Sequence site = seq.getSubSequence(ma[j].getPosition(), ma[j].getLength());
                if (ma[j].getStrandedness() == StrandedLocatedSequenceAnnotationWithLength.Strand.REVERSE) {
                    list.add(site.reverseComplement());
                } else {
                    list.add(site);
                }
                System.out.println(i + "\t" + ma[j].getPosition() + "\t" + (Object)((Object)ma[j].getStrandedness()) + "\t" + site + "\t" + ma[j].getAnnotations()[1].getValue());
            }
        }
        double[][] pfm = DispomPredictor.getPFM(new DataSet("", list.toArray(new Sequence[0])));
        System.out.println("------------------------------------------------------------------------");
        System.out.println("Position frequency matrix of sites: ");
        for (i = 0; i < pfm.length; ++i) {
            System.out.print("\t" + i);
        }
        System.out.println();
        for (int j = 0; j < pfm[0].length; ++j) {
            System.out.print(DNAAlphabet.SINGLETON.getSymbolAt(j));
            for (int i3 = 0; i3 < pfm.length; ++i3) {
                System.out.print("\t" + pfm[i3][j]);
            }
            System.out.println();
        }
        System.out.println();
        System.out.println("------------------------------------------------------------------------");
        System.out.println("Position weight matrix of sites: ");
        for (i = 0; i < pfm.length; ++i) {
            System.out.print("\t" + i);
        }
        System.out.println();
        double s = list.size();
        for (int j = 0; j < pfm[0].length; ++j) {
            System.out.print(DNAAlphabet.SINGLETON.getSymbolAt(j));
            for (int i4 = 0; i4 < pfm.length; ++i4) {
                System.out.print("\t" + pfm[i4][j] / s);
            }
            System.out.println();
        }
    }

    public static double[][] getPFM(DataSet data) {
        if (data == null) {
            return null;
        }
        double[][] pfm = new double[data.getElementLength()][];
        AlphabetContainer con = data.getAlphabetContainer();
        for (int l = 0; l < pfm.length; ++l) {
            pfm[l] = new double[(int)con.getAlphabetLengthAt(l)];
        }
        for (int n = 0; n < data.getNumberOfElements(); ++n) {
            Sequence seq = data.getElementAt(n);
            for (int l = 0; l < pfm.length; ++l) {
                double[] dArray = pfm[l];
                int n2 = seq.discreteVal(l);
                dArray[n2] = dArray[n2] + 1.0;
            }
        }
        return pfm;
    }
}

