/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.algorithms.optimization;

import de.jstacs.algorithms.optimization.StartDistanceForecaster;
import java.util.Arrays;

public class LimitedMedianStartDistance
implements StartDistanceForecaster {
    private double initial;
    private double[] memory;
    private double[] sorted;
    private int index;

    public LimitedMedianStartDistance(int slots, double value) {
        if (value <= 0.0) {
            throw new IllegalArgumentException("The initial start distance has to be positive.");
        }
        this.initial = value;
        if (slots < 1) {
            throw new IllegalArgumentException("The number of slots has to be positive.");
        }
        this.memory = new double[slots];
        this.sorted = new double[slots];
        this.reset();
    }

    @Override
    public double getNewStartDistance() {
        System.arraycopy(this.memory, 0, this.sorted, 0, this.memory.length);
        Arrays.sort(this.sorted);
        double median = this.memory.length % 2 == 1 ? this.sorted[this.memory.length / 2] : 0.5 * (this.sorted[this.memory.length / 2 - 1] + this.sorted[this.memory.length / 2]);
        return 0.667 * median;
    }

    @Override
    public void setLastDistance(double last) {
        this.memory[this.index] = last;
        ++this.index;
        this.index %= this.memory.length;
    }

    @Override
    public void reset() {
        this.index = 0;
        Arrays.fill(this.memory, this.initial);
    }
}

