/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.algorithms.optimization;

import de.jstacs.algorithms.optimization.DifferentiableFunction;
import de.jstacs.algorithms.optimization.DimensionException;
import de.jstacs.algorithms.optimization.EvaluationException;
import de.jstacs.algorithms.optimization.OneDimensionalFunction;
import de.jstacs.algorithms.optimization.QuadraticFunction;
import de.jstacs.algorithms.optimization.StartDistanceForecaster;
import de.jstacs.algorithms.optimization.TerminationException;
import de.jstacs.algorithms.optimization.termination.TerminationCondition;
import de.jstacs.utils.SafeOutputStream;
import de.jstacs.utils.Time;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.LinkedList;

public class Optimizer {
    private static final double limFib = (Math.sqrt(5.0) - 1.0) / 2.0;
    private static final double limFibPlus1 = limFib + 1.0;
    private static final double limFibPlus2 = limFib + 2.0;
    public static final byte STEEPEST_DESCENT = 16;
    public static final byte CONJUGATE_GRADIENTS_FR = 17;
    public static final byte CONJUGATE_GRADIENTS_PRP = 18;
    public static final byte QUASI_NEWTON_DFP = 19;
    public static final byte QUASI_NEWTON_BFGS = 20;

    public static double[] findBracket(OneDimensionalFunction f, double lower, double fLower, double startDistance) throws EvaluationException {
        double[] erg = new double[]{lower, fLower, lower + startDistance, 0.0, 0.0, 0.0};
        erg[3] = f.evaluateFunction(erg[2]);
        if (Double.isNaN(erg[3]) || erg[1] <= erg[3]) {
            do {
                erg[4] = erg[2];
                erg[5] = erg[3];
                erg[2] = erg[0] + (1.0 - limFib) * (erg[2] - erg[0]);
                erg[3] = f.evaluateFunction(erg[2]);
            } while (Double.isNaN(erg[3]) || erg[0] != erg[2] && erg[1] < erg[3]);
        } else {
            boolean b;
            do {
                erg[4] = limFibPlus2 * erg[2] - limFibPlus1 * erg[0];
                erg[5] = f.evaluateFunction(erg[4]);
                boolean bl = b = erg[3] > erg[5];
                if (!b) continue;
                erg[0] = erg[2];
                erg[1] = erg[3];
                erg[2] = erg[4];
                erg[3] = erg[5];
            } while (!Double.isNaN(erg[5]) && b);
        }
        if (Double.isNaN(erg[5])) {
            double x;
            while (Double.compare(erg[2], x = erg[2] + (1.0 - limFib) * (erg[4] - erg[2])) != 0) {
                double fx = f.evaluateFunction(x);
                if (Double.isNaN(fx) || fx > erg[3]) {
                    erg[4] = x;
                    erg[5] = fx;
                } else {
                    if (fx != erg[3]) {
                        erg[0] = erg[2];
                        erg[1] = erg[3];
                    }
                    erg[2] = x;
                    erg[3] = fx;
                }
                if (Double.isNaN(erg[5])) continue;
            }
            if (Double.isNaN(erg[3])) {
                erg[5] = erg[3];
                erg[4] = erg[2];
            }
        }
        return erg;
    }

    public static double[] findBracket(OneDimensionalFunction f, double lower, double startDistance) throws EvaluationException {
        return Optimizer.findBracket(f, lower, f.evaluateFunction(lower), startDistance);
    }

    public static double[] brentsMethod(OneDimensionalFunction f, double a, double x, double fx, double b, double tol) throws EvaluationException {
        double fw;
        double w;
        int i = 0;
        double c = 1.0 - limFib;
        double d = 0.0;
        double eps = 1.2E-16;
        double tol1 = eps + 1.0;
        eps = Math.sqrt(eps);
        double e = 0.0;
        double v = w = x;
        double fv = fw = fx;
        double tol3 = tol / 3.0;
        double xm = 0.5 * (a + b);
        tol1 = eps * Math.abs(x) + tol3;
        double t2 = 2.0 * tol1;
        while (Math.abs(x - xm) > t2 - 0.5 * (b - a)) {
            double fu;
            double u;
            double r = 0.0;
            double q = 0.0;
            double p = 0.0;
            if (Math.abs(e) > tol1) {
                r = (x - w) * (fx - fv);
                q = (x - v) * (fx - fw);
                p = (x - v) * q - (x - w) * r;
                if ((q = 2.0 * (q - r)) > 0.0) {
                    p = -p;
                } else {
                    q = -q;
                }
                r = e;
                e = d;
            }
            if (Math.abs(p) < Math.abs(0.5 * q * r) && p > q * (a - x) && p < q * (b - x)) {
                d = p / q;
                u = x + d;
                if (u - a < t2 || b - u < t2) {
                    d = tol1;
                    if (x >= xm) {
                        d = -d;
                    }
                }
            } else {
                e = x < xm ? b - x : a - x;
                d = c * e;
            }
            if (fx <= (fu = f.evaluateFunction(u = Math.abs(d) >= tol1 ? x + d : (d > 0.0 ? x + tol1 : x - tol1)))) {
                if (u < x) {
                    a = u;
                } else {
                    b = u;
                }
            }
            if (fu <= fx) {
                if (u < x) {
                    b = x;
                } else {
                    a = x;
                }
                v = w;
                fv = fw;
                w = x;
                fw = fx;
                x = u;
                fx = fu;
            } else if (fu <= fw || w == x) {
                v = w;
                fv = fw;
                w = u;
                fw = fu;
            } else if (!(fu > fv) || v == x || v == w) {
                v = u;
                fv = fu;
            }
            xm = 0.5 * (a + b);
            tol1 = eps * Math.abs(x) + tol3;
            t2 = 2.0 * tol1;
            ++i;
        }
        double[] erg = new double[]{x, fx};
        return erg;
    }

    public static double[] brentsMethod(OneDimensionalFunction f, double a, double x, double b, double tol) throws EvaluationException {
        return Optimizer.brentsMethod(f, a, x, f.evaluateFunction(x), b, tol);
    }

    public static double[] goldenRatio(OneDimensionalFunction f, double lower, double p1, double fP1, double upper, double eps) throws EvaluationException {
        double[] erg = new double[]{lower + limFib * (upper - lower), 0.0};
        boolean fP1Computed = true;
        int i = 0;
        while (upper - lower > eps) {
            ++i;
            if (!fP1Computed) {
                fP1 = f.evaluateFunction(p1);
            } else {
                erg[1] = f.evaluateFunction(erg[0]);
            }
            if (fP1 < erg[1]) {
                upper = erg[0];
                erg[0] = p1;
                erg[1] = fP1;
                p1 = lower + (1.0 - limFib) * (upper - lower);
                fP1Computed = false;
                continue;
            }
            lower = p1;
            p1 = erg[0];
            fP1 = erg[1];
            erg[0] = lower + limFib * (upper - lower);
            fP1Computed = true;
        }
        if (fP1Computed) {
            erg[0] = p1;
            erg[1] = fP1;
        }
        return erg;
    }

    public static double[] goldenRatio(OneDimensionalFunction f, double lower, double upper, double eps) throws EvaluationException {
        return Optimizer.goldenRatio(f, lower, lower + (1.0 - limFib) * (upper - lower), f.evaluateFunction(lower + (1.0 - limFib) * (upper - lower)), upper, eps);
    }

    public static double[] parabolicInterpolation(OneDimensionalFunction f, double lower, double fLower, double p1, double fP1, double upper, double fUpper, double eps) throws Exception {
        double[] erg = new double[]{p1, fP1};
        double eps2 = 2.0 * eps;
        int i = 0;
        while (upper - lower > eps) {
            if (fLower == fP1 && fP1 == fUpper) {
                return erg;
            }
            ++i;
            erg[0] = new QuadraticFunction(lower, fLower, p1, fP1, upper, fUpper).findMin();
            if (Math.abs(erg[0] - p1) <= eps) {
                erg[0] = erg[0] < p1 ? (p1 - lower <= eps2 ? lower + (p1 - lower) / 2.0 : p1 - eps) : (upper - p1 <= eps2 ? p1 + (p1 - lower) / 2.0 : p1 + eps);
            }
            erg[1] = f.evaluateFunction(erg[0]);
            if (erg[0] < p1) {
                if (erg[1] < fP1) {
                    upper = p1;
                    fUpper = fP1;
                    p1 = erg[0];
                    fP1 = erg[1];
                    continue;
                }
                lower = erg[0];
                fLower = erg[1];
                continue;
            }
            if (erg[1] < fP1) {
                lower = p1;
                fLower = fP1;
                p1 = erg[0];
                fP1 = erg[1];
                continue;
            }
            upper = erg[0];
            fUpper = erg[1];
        }
        return erg;
    }

    public static double[] parabolicInterpolation(OneDimensionalFunction f, double lower, double p1, double upper, double eps) throws Exception {
        return Optimizer.parabolicInterpolation(f, lower, f.evaluateFunction(lower), p1, f.evaluateFunction(p1), upper, f.evaluateFunction(upper), eps);
    }

    private static void checkStartDistance(double startDistance) throws IllegalArgumentException {
        if (startDistance <= 0.0) {
            throw new IllegalArgumentException("The startDistance has to be greater than 0.");
        }
    }

    public static int steepestDescent(DifferentiableFunction f, double[] currentValues, TerminationCondition terminationMode, double linEps, StartDistanceForecaster startDistance, OutputStream out, Time t) throws DimensionException, TerminationException, EvaluationException, IOException {
        SafeOutputStream myOut = SafeOutputStream.getSafeOutputStream(out);
        int i = 0;
        int n = f.getDimensionOfScope();
        double[] d = new double[n];
        Arrays.fill(d, Double.MAX_VALUE);
        double current = Double.POSITIVE_INFINITY;
        double[] help = new double[]{Double.POSITIVE_INFINITY, f.evaluateFunction(currentValues)};
        double[] gradient = f.evaluateGradientOfFunction(currentValues);
        myOut.writeln("iteration\ttime\tf(x)\tdelta\tstart distance\tlinesearch");
        myOut.writeln("0\t0\t" + help[1] + "\t0");
        while (terminationMode.doNextIteration(i, current, help[1], gradient, d, help[0], t)) {
            current = help[1];
            d = gradient;
            int counter = 0;
            while (counter < n) {
                int n2 = counter++;
                d[n2] = d[n2] * -1.0;
            }
            double sd = startDistance.getNewStartDistance();
            Optimizer.checkStartDistance(sd);
            help = f.findOneDimensionalMin(currentValues, d, 0.0, current, linEps, sd);
            myOut.writeln(String.valueOf(++i) + " \t" + t.getElapsedTime() + " \t" + help[1] + " \t" + (current - help[1]) + "\t" + sd + "\t" + help[0]);
            startDistance.setLastDistance(help[0]);
            counter = 0;
            while (counter < n) {
                int n3 = counter;
                currentValues[n3] = currentValues[n3] + d[counter] * help[0];
                ++counter;
            }
            gradient = f.evaluateGradientOfFunction(currentValues);
        }
        return i;
    }

    public static int conjugateGradientsFR(DifferentiableFunction f, double[] currentValues, TerminationCondition terminationMode, double linEps, StartDistanceForecaster startDistance, OutputStream out, Time t) throws DimensionException, TerminationException, IOException, EvaluationException {
        SafeOutputStream myOut = SafeOutputStream.getSafeOutputStream(out);
        int i = 0;
        int n = f.getDimensionOfScope();
        double[] d = new double[n];
        Arrays.fill(d, Double.MAX_VALUE);
        double current = Double.POSITIVE_INFINITY;
        double[] help = new double[]{Double.POSITIVE_INFINITY, f.evaluateFunction(currentValues)};
        double[] gradient = f.evaluateGradientOfFunction(currentValues);
        double mu1 = 0.0;
        double mu2 = 1.0;
        int counter = 0;
        while (counter < n) {
            mu1 += gradient[counter] * gradient[counter];
            ++counter;
        }
        boolean next = terminationMode.doNextIteration(i, current, help[1], gradient, d, help[0], t);
        Arrays.fill(d, 0.0);
        myOut.writeln("iteration\ttime\tf(x)\tdelta\tstart distance\tlinesearch");
        myOut.writeln("0\t0\t" + help[1] + "\t0");
        while (next) {
            current = help[1];
            counter = 0;
            while (counter < n) {
                d[counter] = -gradient[counter] + mu1 / mu2 * d[counter];
                ++counter;
            }
            double sd = startDistance.getNewStartDistance();
            Optimizer.checkStartDistance(sd);
            help = f.findOneDimensionalMin(currentValues, d, 0.0, current, linEps, sd);
            myOut.writeln(String.valueOf(++i) + "\t" + t.getElapsedTime() + "\t" + help[1] + "\t" + (current - help[1]) + "\t" + sd + "\t" + help[0]);
            startDistance.setLastDistance(help[0]);
            counter = 0;
            while (counter < n) {
                int n2 = counter;
                currentValues[n2] = currentValues[n2] + d[counter] * help[0];
                ++counter;
            }
            mu2 = mu1;
            mu1 = 0.0;
            gradient = f.evaluateGradientOfFunction(currentValues);
            counter = 0;
            while (counter < n) {
                mu1 += gradient[counter] * gradient[counter];
                ++counter;
            }
            next = terminationMode.doNextIteration(i, current, help[1], gradient, d, help[0], t);
        }
        return i;
    }

    public static int conjugateGradientsPR(DifferentiableFunction f, double[] currentValues, TerminationCondition terminationMode, double linEps, StartDistanceForecaster startDistance, OutputStream out, Time t) throws DimensionException, TerminationException, IOException, EvaluationException {
        return Optimizer.conjugateGradientsPRP(f, currentValues, terminationMode, linEps, startDistance, out, false, t);
    }

    public static int conjugateGradientsPRP(DifferentiableFunction f, double[] currentValues, TerminationCondition terminationMode, double linEps, StartDistanceForecaster startDistance, OutputStream out, Time t) throws DimensionException, TerminationException, IOException, EvaluationException {
        return Optimizer.conjugateGradientsPRP(f, currentValues, terminationMode, linEps, startDistance, out, true, t);
    }

    private static int conjugateGradientsPRP(DifferentiableFunction f, double[] currentValues, TerminationCondition terminationMode, double linEps, StartDistanceForecaster startDistance, OutputStream out, boolean positive, Time t) throws DimensionException, TerminationException, IOException, EvaluationException, IllegalArgumentException {
        double[] gradient_new;
        SafeOutputStream myOut = SafeOutputStream.getSafeOutputStream(out);
        int i = 0;
        int n = f.getDimensionOfScope();
        double[] d = new double[n];
        Arrays.fill(d, Double.MAX_VALUE);
        double current = Double.POSITIVE_INFINITY;
        double[] help = new double[]{Double.POSITIVE_INFINITY, f.evaluateFunction(currentValues)};
        double[] gradient_old = gradient_new = f.evaluateGradientOfFunction(currentValues);
        myOut.writeln("iteration\ttime\tf(x)\tdelta\tstart distance\tlinesearch");
        myOut.writeln("0\t0\t" + help[1] + "\t0");
        while (terminationMode.doNextIteration(i, current, help[1], gradient_new, d, help[0], t)) {
            current = help[1];
            double mu2 = 0.0;
            double mu1 = 0.0;
            int counter = 0;
            while (counter < n) {
                mu1 += (gradient_new[counter] - gradient_old[counter]) * gradient_new[counter];
                mu2 += gradient_old[counter] * gradient_old[counter];
                ++counter;
            }
            mu1 = positive ? Math.max(0.0, mu1 / mu2) : (mu1 /= mu2);
            counter = 0;
            while (counter < n) {
                d[counter] = -gradient_new[counter] + mu1 * d[counter];
                ++counter;
            }
            double sd = startDistance.getNewStartDistance();
            Optimizer.checkStartDistance(sd);
            help = f.findOneDimensionalMin(currentValues, d, 0.0, current, linEps, sd);
            myOut.writeln(String.valueOf(++i) + "\t" + t.getElapsedTime() + "\t" + help[1] + "\t" + (current - help[1]) + "\t" + sd + "\t" + help[0]);
            startDistance.setLastDistance(help[0]);
            counter = 0;
            while (counter < n) {
                int n2 = counter;
                currentValues[n2] = currentValues[n2] + d[counter] * help[0];
                ++counter;
            }
            gradient_old = gradient_new;
            gradient_new = f.evaluateGradientOfFunction(currentValues);
        }
        return i;
    }

    public static int quasiNewtonDFP(DifferentiableFunction f, double[] currentValues, TerminationCondition terminationMode, double linEps, StartDistanceForecaster startDistance, OutputStream out, Time t) throws DimensionException, TerminationException, IOException, EvaluationException {
        SafeOutputStream myOut = SafeOutputStream.getSafeOutputStream(out);
        int i = 0;
        int n = f.getDimensionOfScope();
        double[] d = new double[n];
        double current = Double.POSITIVE_INFINITY;
        double[] help = new double[]{Double.POSITIVE_INFINITY, f.evaluateFunction(currentValues)};
        double[] s = new double[n];
        double[] v = new double[n];
        double[] matrixv = new double[n];
        double[] gradient_new = f.evaluateGradientOfFunction(currentValues);
        double[][] matrix = new double[n][n];
        int counter1 = 0;
        while (counter1 < n) {
            d[counter1] = -gradient_new[counter1];
            matrix[counter1][counter1] = 1.0;
            ++counter1;
        }
        boolean next = terminationMode.doNextIteration(i, current, help[1], gradient_new, d, help[0], t);
        myOut.writeln("iteration\ttime\tf(x)\tdelta\tstart distance\tlinesearch");
        myOut.writeln("0\t0\t" + help[1] + "\t0");
        while (next) {
            int counter2;
            current = help[1];
            double sd = startDistance.getNewStartDistance();
            Optimizer.checkStartDistance(sd);
            help = f.findOneDimensionalMin(currentValues, d, 0.0, current, linEps, sd);
            myOut.writeln(String.valueOf(++i) + "\t" + t.getElapsedTime() + "\t" + help[1] + "\t" + (current - help[1]) + "\t" + sd + "\t" + help[0]);
            startDistance.setLastDistance(help[0]);
            counter1 = 0;
            while (counter1 < n) {
                int n2 = counter1;
                currentValues[n2] = currentValues[n2] + d[counter1] * help[0];
                ++counter1;
            }
            double[] gradient_old = gradient_new;
            gradient_new = f.evaluateGradientOfFunction(currentValues);
            next = terminationMode.doNextIteration(i, current, help[1], gradient_new, d, help[0], t);
            if (!next) continue;
            counter1 = 0;
            while (counter1 < n) {
                s[counter1] = d[counter1] * help[0];
                v[counter1] = gradient_new[counter1] - gradient_old[counter1];
                ++counter1;
            }
            double vv = 0.0;
            double sv = 0.0;
            double vmatrixv = 0.0;
            counter1 = 0;
            while (counter1 < n) {
                sv += s[counter1] * v[counter1];
                vv += v[counter1] * v[counter1];
                matrixv[counter1] = 0.0;
                counter2 = 0;
                while (counter2 < n) {
                    int n3 = counter1;
                    matrixv[n3] = matrixv[n3] + matrix[counter1][counter2] * v[counter2];
                    ++counter2;
                }
                vmatrixv += v[counter1] * matrixv[counter1];
                ++counter1;
            }
            counter1 = 0;
            while (counter1 < n) {
                counter2 = 0;
                while (counter2 < n) {
                    double[] dArray = matrix[counter1];
                    int n4 = counter2;
                    dArray[n4] = dArray[n4] + (s[counter1] * s[counter2] / sv - matrixv[counter1] * matrixv[counter2] / vmatrixv);
                    ++counter2;
                }
                d[counter1] = 0.0;
                counter2 = 0;
                while (counter2 < n) {
                    int n5 = counter1;
                    d[n5] = d[n5] + -matrix[counter1][counter2] * gradient_new[counter2];
                    ++counter2;
                }
                ++counter1;
            }
        }
        return i;
    }

    public static int quasiNewtonBFGS(DifferentiableFunction f, double[] currentValues, TerminationCondition terminationMode, double linEps, StartDistanceForecaster startDistance, OutputStream out, Time t) throws DimensionException, TerminationException, IOException, EvaluationException {
        SafeOutputStream myOut = SafeOutputStream.getSafeOutputStream(out);
        int i = 0;
        int n = f.getDimensionOfScope();
        double[] d = new double[n];
        double current = Double.POSITIVE_INFINITY;
        double[] help = new double[]{Double.POSITIVE_INFINITY, f.evaluateFunction(currentValues)};
        double[] s = new double[n];
        double[] v = new double[n];
        double[] u = new double[n];
        double[] matrixv = new double[n];
        double[] gradient_new = f.evaluateGradientOfFunction(currentValues);
        double[][] matrix = new double[n][n];
        int counter1 = 0;
        while (counter1 < n) {
            d[counter1] = -gradient_new[counter1];
            matrix[counter1][counter1] = 1.0;
            ++counter1;
        }
        boolean next = terminationMode.doNextIteration(i, current, help[1], gradient_new, d, help[0], t);
        myOut.writeln("iteration\ttime\tf(x)\tdelta\tstart distance\tlinesearch");
        myOut.writeln("0\t0\t" + help[1] + "\t0");
        while (next) {
            int counter2;
            current = help[1];
            double sd = startDistance.getNewStartDistance();
            Optimizer.checkStartDistance(sd);
            help = f.findOneDimensionalMin(currentValues, d, 0.0, current, linEps, sd);
            myOut.writeln(String.valueOf(++i) + "\t" + t.getElapsedTime() + "\t" + help[1] + "\t" + (current - help[1]) + "\t" + sd + "\t" + help[0]);
            startDistance.setLastDistance(help[0]);
            counter1 = 0;
            while (counter1 < n) {
                int n2 = counter1;
                currentValues[n2] = currentValues[n2] + d[counter1] * help[0];
                ++counter1;
            }
            double[] gradient_old = gradient_new;
            gradient_new = f.evaluateGradientOfFunction(currentValues);
            next = terminationMode.doNextIteration(i, current, help[1], gradient_new, d, help[0], t);
            if (!next) continue;
            counter1 = 0;
            while (counter1 < n) {
                s[counter1] = d[counter1] * help[0];
                v[counter1] = gradient_new[counter1] - gradient_old[counter1];
                ++counter1;
            }
            double vv = 0.0;
            double sv = 0.0;
            double vmatrixv = 0.0;
            counter1 = 0;
            while (counter1 < n) {
                sv += s[counter1] * v[counter1];
                vv += v[counter1] * v[counter1];
                matrixv[counter1] = 0.0;
                counter2 = 0;
                while (counter2 < n) {
                    int n3 = counter1;
                    matrixv[n3] = matrixv[n3] + matrix[counter1][counter2] * v[counter2];
                    ++counter2;
                }
                vmatrixv += v[counter1] * matrixv[counter1];
                ++counter1;
            }
            counter1 = 0;
            while (counter1 < n) {
                u[counter1] = s[counter1] / sv - matrixv[counter1] / vmatrixv;
                ++counter1;
            }
            counter1 = 0;
            while (counter1 < n) {
                counter2 = 0;
                while (counter2 < n) {
                    double[] dArray = matrix[counter1];
                    int n4 = counter2;
                    dArray[n4] = dArray[n4] + (s[counter1] * s[counter2] / sv - matrixv[counter1] * matrixv[counter2] / vmatrixv + vmatrixv * u[counter1] * u[counter2]);
                    ++counter2;
                }
                d[counter1] = 0.0;
                counter2 = 0;
                while (counter2 < n) {
                    int n5 = counter1;
                    d[n5] = d[n5] + -matrix[counter1][counter2] * gradient_new[counter2];
                    ++counter2;
                }
                ++counter1;
            }
        }
        return i;
    }

    public static int limitedMemoryBFGS(DifferentiableFunction f, double[] currentValues, byte m, TerminationCondition terminationMode, double linEps, StartDistanceForecaster startDistance, OutputStream out, Time t) throws DimensionException, TerminationException, IOException, EvaluationException {
        if (m <= 2) {
            throw new IllegalArgumentException("This choice of m is not allowed.");
        }
        SafeOutputStream myOut = SafeOutputStream.getSafeOutputStream(out);
        int i = 0;
        int n = f.getDimensionOfScope();
        double[] d = new double[n];
        double current = Double.POSITIVE_INFINITY;
        double[] help = new double[]{Double.POSITIVE_INFINITY, f.evaluateFunction(currentValues)};
        LinkedList<VectorPair> vp = new LinkedList<VectorPair>();
        double[] gradient_new = f.evaluateGradientOfFunction(currentValues);
        int counter1 = 0;
        while (counter1 < n) {
            d[counter1] = -gradient_new[counter1];
            ++counter1;
        }
        boolean next = terminationMode.doNextIteration(i, current, help[1], gradient_new, d, help[0], t);
        myOut.writeln("iteration\ttime\tf(x)\tdelta\tstart distance\tlinesearch");
        myOut.writeln("0\t0\t" + help[1] + "\t0");
        while (next) {
            int counter2;
            VectorPair now;
            current = help[1];
            double sd = startDistance.getNewStartDistance();
            Optimizer.checkStartDistance(sd);
            help = f.findOneDimensionalMin(currentValues, d, 0.0, current, linEps, sd);
            myOut.writeln(String.valueOf(++i) + "\t" + t.getElapsedTime() + "\t" + help[1] + "\t" + (current - help[1]) + "\t" + sd + "\t" + help[0]);
            startDistance.setLastDistance(help[0]);
            VectorPair newVp = new VectorPair(n);
            newVp.rho = 0.0;
            counter1 = 0;
            while (counter1 < n) {
                ((VectorPair)newVp).s[counter1] = d[counter1] * help[0];
                int n2 = counter1;
                currentValues[n2] = currentValues[n2] + newVp.s[counter1];
                ++counter1;
            }
            double[] gradient_old = gradient_new;
            gradient_new = f.evaluateGradientOfFunction(currentValues);
            next = terminationMode.doNextIteration(i, current, help[1], gradient_new, d, help[0], t);
            if (!next) continue;
            counter1 = 0;
            while (counter1 < n) {
                ((VectorPair)newVp).v[counter1] = gradient_new[counter1] - gradient_old[counter1];
                d[counter1] = -gradient_new[counter1];
                VectorPair vectorPair = newVp;
                vectorPair.rho = vectorPair.rho + newVp.s[counter1] * newVp.v[counter1];
                ++counter1;
            }
            newVp.rho = 1.0 / newVp.rho;
            vp.addFirst(newVp);
            int s = vp.size();
            if (s > m) {
                vp.removeLast();
                --s;
            }
            counter1 = 0;
            while (counter1 < s) {
                now = (VectorPair)vp.get(counter1);
                now.alpha = 0.0;
                counter2 = 0;
                while (counter2 < n) {
                    VectorPair vectorPair = now;
                    vectorPair.alpha = vectorPair.alpha + now.s[counter2] * d[counter2];
                    ++counter2;
                }
                VectorPair vectorPair = now;
                vectorPair.alpha = vectorPair.alpha * now.rho;
                counter2 = 0;
                while (counter2 < n) {
                    int n3 = counter2;
                    d[n3] = d[n3] - now.alpha * now.v[counter2];
                    ++counter2;
                }
                ++counter1;
            }
            double beta = 0.0;
            double yy = 0.0;
            counter2 = 0;
            while (counter2 < n) {
                beta += newVp.v[counter2] * newVp.s[counter2];
                yy += newVp.v[counter2] * newVp.v[counter2];
                ++counter2;
            }
            beta /= yy;
            counter2 = 0;
            while (counter2 < n) {
                int n4 = counter2++;
                d[n4] = d[n4] * beta;
            }
            counter1 = s - 1;
            while (counter1 >= 0) {
                now = (VectorPair)vp.get(counter1);
                beta = 0.0;
                counter2 = 0;
                while (counter2 < n) {
                    beta += now.v[counter2] * d[counter2];
                    ++counter2;
                }
                beta *= now.rho;
                counter2 = 0;
                while (counter2 < n) {
                    int n5 = counter2;
                    d[n5] = d[n5] + (now.alpha - beta) * now.s[counter2];
                    ++counter2;
                }
                --counter1;
            }
        }
        return i;
    }

    public static int optimize(byte algorithm, DifferentiableFunction f, double[] currentValues, TerminationCondition terminationMode, double linEps, StartDistanceForecaster startDistance, OutputStream out) throws DimensionException, TerminationException, IOException, EvaluationException {
        return Optimizer.optimize(algorithm, f, currentValues, terminationMode, linEps, startDistance, SafeOutputStream.getSafeOutputStream(out), Time.getTimeInstance(out));
    }

    public static int optimize(byte algorithm, DifferentiableFunction f, double[] currentValues, TerminationCondition terminationMode, double linEps, StartDistanceForecaster startDistance, OutputStream out, Time t) throws DimensionException, TerminationException, IOException, EvaluationException {
        int counter1;
        SafeOutputStream myOut = SafeOutputStream.getSafeOutputStream(out);
        switch (algorithm) {
            case 16: {
                myOut.writeln("STEEPEST_DESCENT");
                counter1 = Optimizer.steepestDescent(f, currentValues, terminationMode, linEps, startDistance, out, t);
                break;
            }
            case 17: {
                myOut.writeln("CONJUGATE_GRADIENTS_FR");
                counter1 = Optimizer.conjugateGradientsFR(f, currentValues, terminationMode, linEps, startDistance, out, t);
                break;
            }
            case 18: {
                myOut.writeln("CONJUGATE_GRADIENTS_PRP");
                counter1 = Optimizer.conjugateGradientsPRP(f, currentValues, terminationMode, linEps, startDistance, out, t);
                break;
            }
            case 19: {
                myOut.writeln("QUASI_NEWTON_DFP");
                counter1 = Optimizer.quasiNewtonDFP(f, currentValues, terminationMode, linEps, startDistance, out, t);
                break;
            }
            case 20: {
                myOut.writeln("QUASI_NEWTON_BFGS");
                counter1 = Optimizer.quasiNewtonBFGS(f, currentValues, terminationMode, linEps, startDistance, out, t);
                break;
            }
            default: {
                if (algorithm >= 3 && algorithm <= 10) {
                    myOut.writeln("lm-BFGS (n=" + algorithm + ")");
                    counter1 = Optimizer.limitedMemoryBFGS(f, currentValues, algorithm, terminationMode, linEps, startDistance, out, t);
                    break;
                }
                throw new IllegalArgumentException("The algorithm choice is impossible.");
            }
        }
        return counter1;
    }

    private static class VectorPair {
        private double[] v;
        private double[] s;
        private double alpha;
        private double rho;

        private VectorPair(int n) {
            this.v = new double[n];
            this.s = new double[n];
        }
    }
}

