/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifiers.differentiableSequenceScoreBased.logPrior;

import de.jstacs.algorithms.optimization.DimensionException;
import de.jstacs.algorithms.optimization.EvaluationException;
import de.jstacs.classifiers.differentiableSequenceScoreBased.logPrior.SeparateLogPrior;
import de.jstacs.io.NonParsableException;

public class SeparateGaussianLogPrior
extends SeparateLogPrior {
    protected double[] vars2;
    protected double[] mus;

    public SeparateGaussianLogPrior(double[] vars, double[] classVars, double[] classMus) {
        super(vars, classVars, classMus);
    }

    public SeparateGaussianLogPrior(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public void unset() {
        this.vars2 = null;
        this.mus = null;
    }

    private void computeVars() {
        int num = this.funs.length - (this.freeParameters ? 1 : 0);
        int i = 0;
        while (i < this.funs.length) {
            num += this.funs[i].getNumberOfParameters();
            ++i;
        }
        this.vars2 = new double[num];
        this.mus = new double[num];
        num = 0;
        while (num < this.funs.length - (this.freeParameters ? 1 : 0)) {
            this.vars2[num] = this.classVars[num];
            this.mus[num] = this.classMus[num];
            ++num;
        }
        i = 0;
        while (i < this.funs.length) {
            int j = 0;
            while (j < this.funs[i].getNumberOfParameters()) {
                this.vars2[num] = this.vars[i] * (double)this.funs[i].getSizeOfEventSpaceForRandomVariablesOfParameter(j);
                this.mus[num] = 0.0;
                ++num;
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void addGradientFor(double[] params, double[] grad) {
        if (this.vars2 == null) {
            this.computeVars();
        }
        int j = 0;
        while (j < params.length) {
            int n = j;
            grad[n] = grad[n] - (params[j] - this.mus[j]) / this.vars2[j];
            ++j;
        }
    }

    @Override
    public double evaluateFunction(double[] x) throws DimensionException, EvaluationException {
        if (this.vars2 == null) {
            this.computeVars();
        }
        double prior = 0.0;
        int i = 0;
        while (i < x.length) {
            prior -= (x[i] - this.mus[i]) * (x[i] - this.mus[i]) / this.vars2[i];
            ++i;
        }
        return prior /= 2.0;
    }

    @Override
    public int getDimensionOfScope() {
        if (this.vars2 == null) {
            return -1;
        }
        return this.vars2.length;
    }

    @Override
    public String getInstanceName() {
        return "Separate Gaussian prior";
    }
}

