/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data.sequences;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.sequences.IntSequence;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.WrongSequenceTypeException;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import java.util.Arrays;
import java.util.Random;

public abstract class SimpleDiscreteSequence
extends Sequence<int[]> {
    static Random r = new Random();

    public static SimpleDiscreteSequence shuffle(SimpleDiscreteSequence original, int k) throws Exception {
        int n = original.getLength();
        if (n < 4 * (k + 1)) {
            return original;
        }
        int[] shuffle = new int[n];
        int[] help = (int[])shuffle.clone();
        int i = 0;
        while (i < n) {
            shuffle[i] = original.discreteVal(i);
            ++i;
        }
        int anz = 0;
        int i2 = 0;
        while (i2 < shuffle.length) {
            int a = r.nextInt(n - 4 * (k + 1));
            int b = a + 1 + r.nextInt(n - 3 * (k + 1) - a);
            int c = b + 1 + r.nextInt(n - 2 * (k + 1) - b);
            int d = c + 1 + r.nextInt(n - k + 1 - c);
            int j = 0;
            while (j < k - 1 && shuffle[a + j] == shuffle[c + j]) {
                ++j;
            }
            boolean matches = j == k - 1;
            j = 0;
            while (matches && j < k - 1 && shuffle[b + j] == shuffle[d + j]) {
                ++j;
            }
            if (matches &= j == k - 1) {
                ++anz;
                Arrays.fill(help, 0);
                System.arraycopy(shuffle, 0, help, 0, a);
                System.arraycopy(shuffle, c, help, a, d - c);
                System.arraycopy(shuffle, b, help, a + d - c, c - b);
                System.arraycopy(shuffle, a, help, a + d - b, b - a);
                System.arraycopy(shuffle, d, help, d, n - d);
                System.arraycopy(help, 0, shuffle, 0, n);
            }
            ++i2;
        }
        Exception ex = null;
        try {
            return new IntSequence(original.getAlphabetContainer(), shuffle);
        }
        catch (WrongAlphabetException wae) {
            ex = wae;
        }
        catch (WrongSequenceTypeException wste) {
            ex = wste;
        }
        throw new RuntimeException(ex.getMessage());
    }

    public SimpleDiscreteSequence(AlphabetContainer container, SequenceAnnotation[] annotation) throws WrongAlphabetException {
        super(container, annotation);
        if (!container.isDiscrete()) {
            throw new WrongAlphabetException("The alphabet is not discrete.");
        }
    }

    @Override
    public final double continuousVal(int pos) {
        return this.discreteVal(pos);
    }

    @Override
    public boolean isMultiDimensional() {
        return false;
    }

    @Override
    public int[] getEmptyContainer() {
        return new int[1];
    }

    @Override
    public void fillContainer(int[] container, int pos) {
        container[0] = this.discreteVal(pos);
    }

    @Override
    protected Object getEmptyRepresentation() {
        return new StringBuffer();
    }

    @Override
    protected void addToRepresentation(Object representation, int pos, String delim) {
        ((StringBuffer)representation).append(String.valueOf(this.alphabetCon.getSymbol(pos, this.discreteVal(pos))) + delim);
    }

    @Override
    protected String getStringRepresentation(Object representation) {
        return representation.toString();
    }

    @Override
    protected int hashCodeForPos(int pos) {
        return this.discreteVal(pos);
    }

    @Override
    public int compareTo(int[] t1, int[] t2) {
        if (t1.length == t2.length) {
            int i = 0;
            while (i < t1.length) {
                if (t1[i] != t2[i]) {
                    return t1[i] - t2[i];
                }
                ++i;
            }
            return 0;
        }
        return t1.length - t2.length;
    }
}

