/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.parameters;

import de.jstacs.DataType;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.GalaxyConvertible;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.SimpleParameter;

public class ParameterSetContainer
extends Parameter
implements GalaxyConvertible {
    private ParameterSet parameters;
    private Class<? extends ParameterSet> parameterClass;

    public ParameterSetContainer(ParameterSet p) {
        this(ParameterSet.getName(p), ParameterSet.getComment(p), p);
    }

    public ParameterSetContainer(String name, String comment, ParameterSet content) {
        this(name, comment, content.getClass());
        this.parameters = content;
        this.parameters.setParent(this);
    }

    public ParameterSetContainer(Class<? extends ParameterSet> contentClazz) {
        this(ParameterSet.getName(contentClazz), ParameterSet.getComment(contentClazz), contentClazz);
    }

    public ParameterSetContainer(String name, String comment, Class<? extends ParameterSet> contentClazz) {
        super(name, comment, DataType.PARAMETERSET);
        this.parameterClass = contentClazz;
    }

    public ParameterSetContainer(StringBuffer representation) throws NonParsableException {
        super(representation);
    }

    @Override
    public ParameterSetContainer clone() throws CloneNotSupportedException {
        ParameterSetContainer clone = (ParameterSetContainer)super.clone();
        ParameterSet parameterSet = clone.parameters = this.parameters == null ? null : this.parameters.clone();
        if (clone.parameters != null) {
            clone.parameters.setParent(clone);
        }
        return clone;
    }

    @Override
    public boolean isRequired() {
        return true;
    }

    @Override
    public boolean checkValue(Object value) {
        if (value == null || !(value instanceof ParameterSet)) {
            return false;
        }
        return this.parameterClass.isInstance(value) || this.parameters == null || this.parameters.isComparable((ParameterSet)value);
    }

    @Override
    public void setValue(Object value) throws SimpleParameter.IllegalValueException {
        if (!this.checkValue(value)) {
            throw new SimpleParameter.IllegalValueException(this.name, "Only parameter sets allowed for ParameterSetContainer!");
        }
        this.parameters = (ParameterSet)value;
        this.parameters.setParent(this);
    }

    @Override
    public ParameterSet getValue() {
        if (this.parameters == null) {
            this.loadParameters();
        }
        return this.parameters;
    }

    @Override
    public boolean hasDefaultOrIsSet() {
        return this.parameters != null && this.parameters.hasDefaultOrIsSet();
    }

    @Override
    public boolean isSet() {
        return this.parameters != null;
    }

    @Override
    public boolean isAtomic() {
        return false;
    }

    @Override
    public String getErrorMessage() {
        if (this.parameters == null) {
            return null;
        }
        return this.parameters.getErrorMessage();
    }

    @Override
    public void reset() {
        if (this.parameters != null) {
            this.parameters.reset();
        }
    }

    @Override
    public void setDefault(Object defaultValue) throws Exception {
        throw new Exception("Not applicable to ParameterSetContainer");
    }

    @Override
    public String getXMLTag() {
        return "parameterSetContainer";
    }

    private void loadParameters() {
        if (this.parameters == null) {
            try {
                this.parameters = this.parameterClass.newInstance();
                this.parameters.setParent(this);
            }
            catch (Exception e) {
                RuntimeException ex = new RuntimeException(e);
                ex.setStackTrace(e.getStackTrace());
                throw ex;
            }
            this.parameters.setParent(this);
        }
    }

    @Override
    protected void appendFurtherInfos(StringBuffer buf) {
        super.appendFurtherInfos(buf);
        if (this.parameters == null) {
            XMLParser.appendObjectWithTags(buf, this.parameterClass, "parameterClass");
        } else {
            XMLParser.appendObjectWithTags(buf, this.parameters, "parameters");
        }
    }

    @Override
    protected void extractFurtherInfos(StringBuffer representation) throws NonParsableException {
        super.appendFurtherInfos(representation);
        if (!XMLParser.hasTag(representation, "parameters", null, null)) {
            this.parameterClass = XMLParser.extractObjectForTags(representation, "parameterClass", Class.class);
        } else {
            this.parameters = XMLParser.extractObjectForTags(representation, "parameters", ParameterSet.class);
            this.parameterClass = this.parameters.getClass();
            this.parameters.setParent(this);
        }
    }

    @Override
    public void toGalaxy(String namePrefix, String configPrefix, int depth, StringBuffer descBuffer, StringBuffer configBuffer, boolean addLine, int indentation) throws Exception {
        if (this.parameters == null) {
            this.loadParameters();
        }
        StringBuffer pars = new StringBuffer();
        this.parameters.toGalaxy(namePrefix, configPrefix, depth, pars, configBuffer, false, indentation);
        descBuffer.append(pars);
    }

    @Override
    public void fromGalaxy(String namePrefix, StringBuffer command) throws Exception {
        if (this.parameters == null) {
            this.loadParameters();
        }
        this.parameters.fromGalaxy(namePrefix, command);
    }

    @Override
    public void toGalaxyTest(String namePrefix, int depth, StringBuffer testBuffer, int indentation) throws Exception {
        if (this.parameters == null) {
            this.loadParameters();
        }
        StringBuffer pars = new StringBuffer();
        this.parameters.toGalaxyTest(namePrefix, depth, pars, indentation);
        testBuffer.append(pars);
    }
}

