/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.results;

import de.jstacs.DataType;
import de.jstacs.Storable;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.results.Result;
import de.jstacs.results.savers.PlotGeneratorResultSaver;
import de.jstacs.utils.graphics.GraphicsAdaptor;

public class PlotGeneratorResult
extends Result {
    private PlotGenerator gen;
    private boolean isStatic;
    private PlotGeneratorResultSaver.Format outputFormat;

    public PlotGeneratorResult(String name, String comment, PlotGenerator gen, boolean isStatic) {
        this(name, comment, gen, isStatic, PlotGeneratorResultSaver.Format.PDF);
    }

    public PlotGeneratorResult(String name, String comment, PlotGenerator gen, boolean isStatic, PlotGeneratorResultSaver.Format outputFormat) {
        super(name, comment, DataType.IMAGE);
        this.gen = gen;
        this.isStatic = isStatic;
        this.outputFormat = outputFormat;
    }

    public PlotGeneratorResult(StringBuffer rep) throws NonParsableException {
        super(rep);
    }

    @Override
    public String getXMLTag() {
        return "PlotGeneratorResult";
    }

    @Override
    protected void appendFurtherInfos(StringBuffer buf) {
        XMLParser.appendObjectWithTags(buf, this.gen, "generator");
        XMLParser.appendObjectWithTags(buf, this.isStatic, "isStatic");
        XMLParser.appendObjectWithTags(buf, this.outputFormat.toString(), "outputFormat");
    }

    @Override
    protected void extractFurtherInfos(StringBuffer buf) throws NonParsableException {
        this.gen = (PlotGenerator)XMLParser.extractObjectForTags(buf, "generator");
        this.isStatic = (Boolean)XMLParser.extractObjectForTags(buf, "isStatic");
        try {
            String outform = (String)XMLParser.extractObjectForTags(buf, "outputFormat");
            this.outputFormat = PlotGeneratorResultSaver.Format.valueOf(outform);
        }
        catch (NonParsableException ex) {
            this.outputFormat = PlotGeneratorResultSaver.Format.PDF;
        }
    }

    @Override
    public PlotGenerator getValue() {
        return this.gen;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public PlotGeneratorResultSaver.Format getFormat() {
        return this.outputFormat;
    }

    public static interface PlotGenerator
    extends Storable {
        public void generatePlot(GraphicsAdaptor var1) throws Exception;
    }
}

