/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.structureLearning.measures.btMeasures;

import de.jstacs.DataType;
import de.jstacs.algorithms.graphs.MST;
import de.jstacs.data.DataSet;
import de.jstacs.io.NonParsableException;
import de.jstacs.parameters.EnumParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterException;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.structureLearning.measures.Measure;

public class BTMutualInformation
extends Measure {
    public BTMutualInformation(StringBuffer buf) throws NonParsableException {
        super(buf);
    }

    public BTMutualInformation(DataSource clazz, double[] ess) throws CloneNotSupportedException, Exception {
        this(new BTMutualInformationParameterSet(clazz, ess));
    }

    public BTMutualInformation(BTMutualInformationParameterSet parameters) throws CloneNotSupportedException {
        super(parameters);
    }

    @Override
    public String getInstanceName() {
        DataSource clazz = ((BTMutualInformationParameterSet)this.parameters).getClazz();
        String str = "Bayesian tree with mutual information of";
        if (clazz == DataSource.FG) {
            return String.valueOf(str) + " foreground";
        }
        if (clazz == DataSource.BG) {
            return String.valueOf(str) + " background";
        }
        return String.valueOf(str) + " foreground and background";
    }

    @Override
    public int[][] getParents(DataSet fg, DataSet bg, double[] weightsFg, double[] weightsBg, int length) throws Exception {
        DataSet data = null;
        double[] weights = null;
        double ess2 = 0.0;
        BTMutualInformationParameterSet ps = (BTMutualInformationParameterSet)this.parameters;
        DataSource clazz = ps.getClazz();
        double[] ess = ps.getEss();
        if (clazz == DataSource.FG) {
            data = fg;
            weights = weightsFg;
            ess2 = ess[0];
        } else if (clazz == DataSource.BG) {
            data = bg;
            weights = weightsBg;
            ess2 = ess[1];
        } else {
            data = DataSet.union(fg, bg);
            weights = BTMutualInformation.union(new double[][]{weightsFg, weightsBg});
            ess2 = ess[0] + ess[1];
        }
        double[][][][] stat = BTMutualInformation.getStatistics(data, weights, length, ess2);
        double[][] mi = BTMutualInformation.getMI(stat, BTMutualInformation.sum(weights) + ess2);
        mi = this.getMatrixForKruskal(mi);
        int[][] p = MST.kruskal(mi);
        p = this.reStructure(p, mi.length);
        int[][] parents = new int[length][1];
        int i = 0;
        while (i < parents.length) {
            parents[i][0] = i;
            ++i;
        }
        i = 0;
        while (i < p.length) {
            if (p[i].length > 1) {
                int idx = p[i][1];
                parents[idx] = new int[2];
                parents[idx][0] = p[i][0];
                parents[idx][1] = idx;
            }
            ++i;
        }
        return parents;
    }

    @Override
    public String getXMLTag() {
        return "btMutualInformation";
    }

    public static class BTMutualInformationParameterSet
    extends Measure.MeasureParameterSet {
        public BTMutualInformationParameterSet() throws ParameterException {
            super((Class<? extends Measure>)BTMutualInformation.class);
            this.parameters.add(new Parameter[]{new SimpleParameter(DataType.DOUBLE, "Foreground ESS", "The equivalent sample size for the foreground.", true)});
            this.parameters.add(new Parameter[]{new SimpleParameter(DataType.DOUBLE, "Background ESS", "The equivalent sample size for the background, i.e. the background class or (in case of more than two classes) all non-foreground classes.", true)});
            this.parameters.add(new Parameter[]{new EnumParameter(DataSource.class, "The data used to compute mutual information.", true)});
        }

        public BTMutualInformationParameterSet(DataSource clazz, double[] ess) throws Exception {
            this();
            ((Parameter)this.parameters.get(0)).setValue(ess[0]);
            ((Parameter)this.parameters.get(1)).setValue(ess[1]);
            ((Parameter)this.parameters.get(2)).setValue((Object)clazz);
        }

        public BTMutualInformationParameterSet(StringBuffer representation) throws NonParsableException {
            super(representation);
        }

        public double[] getEss() {
            return new double[]{(Double)((Parameter)this.parameters.get(0)).getValue(), (Double)((Parameter)this.parameters.get(1)).getValue()};
        }

        public DataSource getClazz() {
            return (DataSource)((EnumParameter)this.parameters.get(2)).getValue();
        }

        @Override
        public String getInstanceComment() {
            return "Bayesian tree - mutual information";
        }

        @Override
        public String getInstanceName() {
            return "Build a Bayesian tree using mutual information as structure measure.";
        }
    }

    public static enum DataSource {
        FG,
        BG,
        BOTH;

    }
}

