/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.tools;

import de.jstacs.DataType;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.AbstractSelectionParameter;
import de.jstacs.parameters.FileParameter;
import de.jstacs.parameters.GalaxyConvertible;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterException;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.ParameterSetContainer;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.validation.ParameterValidator;
import de.jstacs.tools.ui.galaxy.GalaxyAdaptor;
import java.util.LinkedList;

public class DataColumnParameter
extends SimpleParameter {
    private String dataRef;

    public DataColumnParameter(String dataRef, String name, String comment, boolean required, Integer defaultVal) throws SimpleParameter.DatatypeNotValidException, SimpleParameter.IllegalValueException {
        super(DataType.INT, name, comment, required, defaultVal);
        this.dataRef = dataRef;
    }

    public DataColumnParameter(String dataRef, String name, String comment, boolean required, ParameterValidator validator, Integer defaultVal) throws ParameterException {
        super(DataType.INT, name, comment, required, validator, defaultVal);
        this.dataRef = dataRef;
    }

    public DataColumnParameter(String dataRef, String name, String comment, boolean required, ParameterValidator validator) throws SimpleParameter.DatatypeNotValidException {
        super(DataType.INT, name, comment, required, validator);
        this.dataRef = dataRef;
    }

    public DataColumnParameter(String dataRef, String name, String comment, boolean required) throws SimpleParameter.DatatypeNotValidException {
        super(DataType.INT, name, comment, required);
        this.dataRef = dataRef;
    }

    public DataColumnParameter(StringBuffer representation) throws NonParsableException {
        super(representation);
    }

    @Override
    protected String dataTypeToGalaxy() {
        return "data_column";
    }

    public String getDataRef() {
        return this.dataRef;
    }

    @Override
    public void toGalaxy(String namePrefix, String configPrefix, int depth, StringBuffer descBuffer, StringBuffer configBuffer, boolean addLine, int indentation) throws Exception {
        FileParameter fp = DataColumnParameter.find(this.getParent(), this.dataRef);
        String tool = namePrefix.substring(0, namePrefix.indexOf("_ps"));
        String refPrefix = String.valueOf(tool) + this.getNamePostfix(fp);
        namePrefix = String.valueOf(namePrefix) + "_" + GalaxyAdaptor.getLegalName(this.getName());
        StringBuffer buf = new StringBuffer();
        if (this.validator != null && this.validator instanceof GalaxyConvertible) {
            ((GalaxyConvertible)((Object)this.validator)).toGalaxy(String.valueOf(namePrefix) + "_valid", null, depth, buf, null, false, XMLParser.nextIndentation(indentation));
        }
        String line = "";
        if (addLine) {
            line = "&lt;hr /&gt;";
        }
        XMLParser.addTagsAndAttributes(buf, "param", "type=\"" + this.dataTypeToGalaxy() + "\" name=\"" + namePrefix + "\" data_ref=\"" + refPrefix + "\" force_select=\"" + this.isRequired() + "\"  label=\"" + line + this.getName() + "\" help=\"" + this.getComment() + "\" value=\"" + (this.defaultValue == null ? "" : this.defaultValue) + "\" optional=\"" + !this.isRequired() + "\"", indentation);
        descBuffer.append(buf);
        buf = new StringBuffer();
        buf.append("${" + configPrefix + namePrefix + "}");
        XMLParser.addTags(buf, namePrefix);
        configBuffer.append(buf);
    }

    private String getNamePostfix(FileParameter par) {
        String postfix = "_" + GalaxyAdaptor.getLegalName(par.getName());
        return this.getNamePostfix(par, postfix);
    }

    private String getNamePostfix(Parameter par, String postfix) {
        ParameterSet set = par.getParent();
        Parameter parent = set.getParent();
        if (parent != null && parent instanceof AbstractSelectionParameter) {
            ParameterSet in = ((AbstractSelectionParameter)parent).getParametersInCollection();
            int i = 0;
            while (i < in.getNumberOfParameters()) {
                ParameterSetContainer cont = (ParameterSetContainer)in.getParameterAt(i);
                if (cont.getValue() == set) {
                    return this.getNamePostfix(parent, "_" + GalaxyAdaptor.getLegalName(parent.getName()) + "_opt" + i + postfix);
                }
                ++i;
            }
        } else {
            postfix = "_ps" + postfix;
            if (parent != null) {
                postfix = this.getNamePostfix(parent, postfix);
            }
            return postfix;
        }
        return null;
    }

    @Override
    public void fromGalaxy(String namePrefix, StringBuffer command) throws Exception {
        namePrefix = String.valueOf(namePrefix) + "_" + GalaxyAdaptor.getLegalName(this.getName());
        try {
            String val = XMLParser.extractForTag(command, namePrefix).toString();
            if (!"None".equals(val)) {
                this.setValue(val);
            }
        }
        catch (NullPointerException e) {
            throw new NullPointerException(String.valueOf(this.getName()) + " " + command + " " + namePrefix);
        }
    }

    @Override
    protected void appendFurtherInfos(StringBuffer buf) {
        super.appendFurtherInfos(buf);
        XMLParser.appendObjectWithTags(buf, this.dataRef, "dataRef");
    }

    @Override
    protected void extractFurtherInfos(StringBuffer representation) throws NonParsableException {
        super.extractFurtherInfos(representation);
        this.dataRef = (String)XMLParser.extractObjectForTags(representation, "dataRef");
    }

    public static FileParameter find(ParameterSet top, String dataRef) {
        Parameter par;
        while (top.getParent() != null) {
            top = top.getParent().getParent();
        }
        LinkedList<ParameterSet> next = new LinkedList<ParameterSet>();
        int i = 0;
        while (i < top.getNumberOfParameters()) {
            par = top.getParameterAt(i);
            if (par instanceof FileParameter && par.getName().equals(dataRef)) {
                return (FileParameter)par;
            }
            if (par instanceof ParameterSetContainer) {
                next.add(((ParameterSetContainer)par).getValue());
            }
            ++i;
        }
        i = 0;
        while (i < next.size()) {
            par = DataColumnParameter.find((ParameterSet)next.get(i), dataRef);
            if (par != null) {
                return par;
            }
            ++i;
        }
        return null;
    }
}

