/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.utils;

import java.util.Arrays;

public final class IntList
implements Cloneable {
    private int size;
    private int[] array;

    public IntList() {
        this(10);
    }

    public IntList(int size) throws IllegalArgumentException {
        if (size <= 0) {
            throw new IllegalArgumentException("The size has to be positive.");
        }
        this.size = 0;
        this.array = new int[size];
    }

    public IntList clone() throws CloneNotSupportedException {
        IntList clone = (IntList)super.clone();
        clone.array = (int[])this.array.clone();
        return clone;
    }

    public void add(int val) {
        if (this.array.length == this.size) {
            int[] help = new int[2 * this.array.length];
            System.arraycopy(this.array, 0, help, 0, this.size);
            this.array = help;
        }
        this.array[this.size++] = val;
    }

    public void addToValues(int start, int end, int offset) {
        int i = start;
        while (i < end) {
            int n = i++;
            this.array[n] = this.array[n] + offset;
        }
    }

    public int addConditional(int val) {
        int b = this.contains(val);
        if (b < 0) {
            this.add(val);
        }
        return b;
    }

    public void clear() {
        this.size = 0;
    }

    public int get(int index) {
        if (index < this.size) {
            return this.array[index];
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    public int pop() {
        int temp = this.array[this.size - 1];
        if (this.size > 0) {
            --this.size;
        }
        return temp;
    }

    public int contains(int val) {
        int i = 0;
        while (i < this.size) {
            if (this.array[i] == val) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int length() {
        return this.size;
    }

    public int[] toArray() {
        int[] res = new int[this.size];
        System.arraycopy(this.array, 0, res, 0, this.size);
        return res;
    }

    public void reverse() {
        int i = 0;
        int n = this.size / 2;
        while (i < n) {
            int help = this.array[i];
            this.array[i] = this.array[this.size - 1 - i];
            this.array[this.size - 1 - i++] = help;
        }
    }

    public void sort() {
        Arrays.sort(this.array, 0, this.size);
    }

    /*
     * Unable to fully structure code
     */
    public void sortAndMakeUnique() {
        this.sort();
        i = 0;
        j = 0;
        ** GOTO lbl11
        {
            ++i;
            do {
                if (i < this.size - 1 && this.array[i] == this.array[i + 1]) continue block0;
                this.array[j] = this.array[i];
                ++j;
                ++i;
lbl11:
                // 2 sources

            } while (i < this.size);
        }
        this.size = j;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof IntList) {
            IntList list = (IntList)o;
            if (this.size == list.size) {
                int n = 0;
                while (n < this.size && this.array[n] != list.array[n]) {
                    ++n;
                }
                return n == this.size;
            }
            return false;
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        int i = 0;
        while (i < this.size) {
            sb.append(i == 0 ? "" : ", ");
            sb.append(this.array[i]);
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    public int binarySearch(int key, int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return Arrays.binarySearch(this.array, fromIndex, toIndex, key);
    }

    public int interpolationSearch(int key, int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.interpolationSearch(key, fromIndex, toIndex, this.array[fromIndex], this.array[toIndex - 1]);
    }

    private int interpolationSearch(int idx2, int fromIndex, int toIndex, int first, int last) {
        int idx = (int)((double)(idx2 - first) / (double)(last - first) * (double)(toIndex - fromIndex - 1)) + fromIndex;
        int mid = this.array[idx];
        while (mid != idx2) {
            if (mid > idx2) {
                toIndex = idx;
                last = mid;
            } else {
                fromIndex = idx + 1;
                first = this.array[idx + 1];
            }
            idx = (int)((double)(idx2 - first) / (double)(last - first) * (double)(toIndex - fromIndex - 1)) + fromIndex;
            mid = this.array[idx];
        }
        return idx;
    }
}

