/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.CRAMContainerStreamWriter;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriterImpl;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.cram.lossy.PreservationPolicy;
import htsjdk.samtools.cram.ref.CRAMReferenceSource;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.StringLineReader;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;

public class CRAMFileWriter
extends SAMFileWriterImpl {
    private CRAMContainerStreamWriter cramContainerStream;
    private final SAMFileHeader samFileHeader;
    private final String fileName;
    private static final Log log = Log.getInstance(CRAMFileWriter.class);

    public CRAMFileWriter(OutputStream outputStream, CRAMReferenceSource referenceSource, SAMFileHeader samFileHeader, String fileName) {
        this(outputStream, null, referenceSource, samFileHeader, fileName);
    }

    public CRAMFileWriter(OutputStream outputStream, OutputStream indexOS, CRAMReferenceSource referenceSource, SAMFileHeader samFileHeader, String fileName) {
        this(outputStream, indexOS, true, referenceSource, samFileHeader, fileName);
    }

    public CRAMFileWriter(OutputStream outputStream, OutputStream indexOS, boolean presorted, CRAMReferenceSource referenceSource, SAMFileHeader samFileHeader, String fileName) {
        if (outputStream == null) {
            throw new IllegalArgumentException("CRAMWriter output stream can not be null.");
        }
        if (referenceSource == null) {
            throw new IllegalArgumentException("A reference is required for CRAM writers");
        }
        if (samFileHeader == null) {
            throw new IllegalArgumentException("A valid SAMFileHeader is required for CRAM writers");
        }
        this.samFileHeader = samFileHeader;
        this.fileName = fileName;
        this.setSortOrder(samFileHeader.getSortOrder(), presorted);
        this.cramContainerStream = new CRAMContainerStreamWriter(outputStream, indexOS, referenceSource, samFileHeader, fileName);
        this.setHeader(samFileHeader);
    }

    @Override
    protected void writeAlignment(SAMRecord alignment) {
        this.cramContainerStream.writeAlignment(alignment);
    }

    @Override
    protected void writeHeader(String textHeader) {
        this.cramContainerStream.writeHeader(new SAMTextHeaderCodec().decode(new StringLineReader(textHeader), this.fileName != null ? this.fileName : null));
    }

    @Override
    protected void finish() {
        this.cramContainerStream.finish(true);
    }

    @Override
    protected String getFilename() {
        return this.fileName;
    }

    public boolean isPreserveReadNames() {
        return this.cramContainerStream.isPreserveReadNames();
    }

    public void setPreserveReadNames(boolean preserveReadNames) {
        this.cramContainerStream.setPreserveReadNames(preserveReadNames);
    }

    public List<PreservationPolicy> getPreservationPolicies() {
        return this.cramContainerStream.getPreservationPolicies();
    }

    public boolean isCaptureAllTags() {
        return this.cramContainerStream.isCaptureAllTags();
    }

    public void setCaptureAllTags(boolean captureAllTags) {
        this.cramContainerStream.setCaptureAllTags(captureAllTags);
    }

    public Set<String> getCaptureTags() {
        return this.cramContainerStream.getCaptureTags();
    }

    public void setCaptureTags(Set<String> captureTags) {
        this.cramContainerStream.setCaptureTags(captureTags);
    }

    public Set<String> getIgnoreTags() {
        return this.cramContainerStream.getIgnoreTags();
    }

    public void setIgnoreTags(Set<String> ignoreTags) {
        this.cramContainerStream.setIgnoreTags(ignoreTags);
    }
}

