/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.reference;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.reference.FastaSequenceIndexEntry;
import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.MatchResult;

public class FastaSequenceIndex
implements Iterable<FastaSequenceIndexEntry> {
    private final Map<String, FastaSequenceIndexEntry> sequenceEntries = new LinkedHashMap<String, FastaSequenceIndexEntry>();

    public FastaSequenceIndex(File indexFile) {
        this(indexFile == null ? null : indexFile.toPath());
    }

    public FastaSequenceIndex(Path indexFile) {
        IOUtil.assertFileIsReadable(indexFile);
        this.parseIndexFile(indexFile);
    }

    protected FastaSequenceIndex() {
    }

    protected void add(FastaSequenceIndexEntry indexEntry) {
        FastaSequenceIndexEntry ret = this.sequenceEntries.put(indexEntry.getContig(), indexEntry);
        if (ret != null) {
            throw new SAMException("Contig '" + indexEntry.getContig() + "' already exists in fasta index.");
        }
    }

    protected void rename(FastaSequenceIndexEntry entry, String newName) {
        this.sequenceEntries.remove(entry.getContig());
        entry.setContig(newName);
        this.add(entry);
    }

    public boolean equals(Object other) {
        if (!(other instanceof FastaSequenceIndex)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        FastaSequenceIndex otherIndex = (FastaSequenceIndex)other;
        if (this.size() != otherIndex.size()) {
            return false;
        }
        Iterator<FastaSequenceIndexEntry> iter = this.iterator();
        Iterator<FastaSequenceIndexEntry> otherIter = otherIndex.iterator();
        while (iter.hasNext()) {
            if (!otherIter.hasNext()) {
                return false;
            }
            if (iter.next().equals(otherIter.next())) continue;
            return false;
        }
        return true;
    }

    private void parseIndexFile(Path indexFile) {
        try {
            Scanner scanner = new Scanner(indexFile);
            int sequenceIndex = 0;
            while (scanner.hasNext()) {
                String result = scanner.findInLine("(.+)\\t+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)");
                if (result == null) {
                    throw new SAMException("Found invalid line in index file:" + scanner.nextLine());
                }
                MatchResult tokens = scanner.match();
                if (tokens.groupCount() != 5) {
                    throw new SAMException("Found invalid line in index file:" + scanner.nextLine());
                }
                scanner.nextLine();
                String contig = tokens.group(1);
                long size = Long.valueOf(tokens.group(2));
                long location = Long.valueOf(tokens.group(3));
                int basesPerLine = Integer.valueOf(tokens.group(4));
                int bytesPerLine = Integer.valueOf(tokens.group(5));
                contig = SAMSequenceRecord.truncateSequenceName(contig);
                this.add(new FastaSequenceIndexEntry(contig, location, size, basesPerLine, bytesPerLine, sequenceIndex++));
            }
            scanner.close();
        }
        catch (IOException e) {
            throw new SAMException("Fasta index file could not be opened: " + indexFile, e);
        }
    }

    public boolean hasIndexEntry(String contigName) {
        return this.sequenceEntries.containsKey(contigName);
    }

    public FastaSequenceIndexEntry getIndexEntry(String contigName) {
        if (!this.hasIndexEntry(contigName)) {
            throw new SAMException("Unable to find entry for contig: " + contigName);
        }
        return this.sequenceEntries.get(contigName);
    }

    @Override
    public Iterator<FastaSequenceIndexEntry> iterator() {
        return this.sequenceEntries.values().iterator();
    }

    public int size() {
        return this.sequenceEntries.size();
    }
}

