/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.util.RuntimeIOException;
import java.io.Closeable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AbstractAsyncWriter<T>
implements Closeable {
    private static volatile int threadsCreated = 0;
    public static final int DEFAULT_QUEUE_SIZE = 2000;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final BlockingQueue<T> queue;
    private final Thread writer;
    private final WriterRunnable writerRunnable;
    private final AtomicReference<Throwable> ex = new AtomicReference<Object>(null);

    protected abstract String getThreadNamePrefix();

    protected abstract void synchronouslyWrite(T var1);

    protected abstract void synchronouslyClose();

    protected AbstractAsyncWriter(int queueSize) {
        this.queue = new ArrayBlockingQueue<T>(queueSize);
        this.writerRunnable = new WriterRunnable();
        this.writer = new Thread((Runnable)this.writerRunnable, this.getThreadNamePrefix() + threadsCreated++);
        this.writer.setDaemon(true);
        this.writer.start();
    }

    public void write(T item) {
        if (this.isClosed.get()) {
            throw new RuntimeIOException("Attempt to add record to closed writer.");
        }
        this.checkAndRethrow();
        try {
            this.queue.put(item);
        }
        catch (InterruptedException ie) {
            throw new RuntimeException("Interrupted queueing item for writing.", ie);
        }
        this.checkAndRethrow();
    }

    @Override
    public void close() {
        this.checkAndRethrow();
        if (!this.isClosed.getAndSet(true)) {
            try {
                if (this.queue.isEmpty()) {
                    this.writer.interrupt();
                }
                this.writer.join();
            }
            catch (InterruptedException ie) {
                throw new RuntimeException("Interrupted waiting on writer thread.", ie);
            }
            while (!this.queue.isEmpty()) {
                Object item = this.queue.poll();
                this.synchronouslyWrite(item);
            }
            this.synchronouslyClose();
            this.checkAndRethrow();
        }
    }

    private final void checkAndRethrow() {
        Throwable t = this.ex.get();
        if (t != null) {
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    private class WriterRunnable
    implements Runnable {
        private WriterRunnable() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!AbstractAsyncWriter.this.isClosed.get() || !AbstractAsyncWriter.this.queue.isEmpty()) {
                    try {
                        Object item = AbstractAsyncWriter.this.queue.poll(2L, TimeUnit.SECONDS);
                        if (item == null) continue;
                        AbstractAsyncWriter.this.synchronouslyWrite(item);
                    }
                    catch (InterruptedException item) {}
                }
                return;
            }
            catch (Throwable t) {
                AbstractAsyncWriter.this.ex.compareAndSet(null, t);
                AbstractAsyncWriter.this.queue.clear();
            }
        }
    }
}

