/*
 * Decompiled with CFR 0.152.
 */
package projects.gemoma;

import de.jstacs.DataType;
import de.jstacs.io.FileManager;
import de.jstacs.parameters.ExpandableParameterSet;
import de.jstacs.parameters.FileParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterSetContainer;
import de.jstacs.parameters.SelectionParameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.SimpleParameterSet;
import de.jstacs.parameters.validation.FileExistsValidator;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.parameters.validation.RegExpValidator;
import de.jstacs.results.ResultSet;
import de.jstacs.results.TextResult;
import de.jstacs.tools.JstacsTool;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.Protocol;
import de.jstacs.tools.ToolParameterSet;
import de.jstacs.tools.ToolResult;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import projects.gemoma.GeMoMa;
import projects.gemoma.GeMoMaModule;
import projects.gemoma.Tools;

public class AnnotationFinalizer
extends GeMoMaModule {
    static boolean rename;
    static final String PARENT = "Parent=";
    static String toolName;
    static final String defResult = "final_annotation";

    static {
        toolName = "AnnotationFinalizer";
    }

    static int set(Feature[] array, ArrayList<? extends Feature> list, int start) {
        if (list == null) {
            return start;
        }
        int i = 0;
        while (i < list.size()) {
            array[start] = list.get(i);
            ++i;
            ++start;
        }
        return start;
    }

    static HashMap<String, HashMap<String, Gene>> read(String fName, Protocol protocol, String tag, StringBuffer begin, boolean add) throws IOException {
        Object[] split;
        String line;
        String[] tags = new String[]{"gene", tag, "CDS"};
        BufferedReader r = new BufferedReader(new FileReader(fName));
        ArrayList[] list = new ArrayList[tags.length + (add ? 1 : 0)];
        HashMap<String, Integer> tagIndex = new HashMap<String, Integer>();
        int i = 0;
        while (i < tags.length) {
            list[i] = new ArrayList();
            tagIndex.put(tags[i], i);
            ++i;
        }
        if (add) {
            list[tags.length] = new ArrayList();
        }
        boolean gff = true;
        boolean start = true;
        while ((line = r.readLine()) != null) {
            Integer i2;
            int index;
            if (gff && line.equalsIgnoreCase("##FASTA")) break;
            if (line.length() == 0) continue;
            if (line.startsWith("#")) {
                if (!start || line.startsWith("##sequence-region")) continue;
                begin.append(String.valueOf(line) + "\n");
                continue;
            }
            start = false;
            if (!gff && (index = line.indexOf(35)) > 0) {
                line = line.substring(0, index);
            }
            if ((i2 = (Integer)tagIndex.get((split = line.split("\t"))[2])) == null && add) {
                i2 = list.length - 1;
            }
            if (i2 == null) continue;
            list[i2].add(split);
        }
        r.close();
        HashMap<String, HashMap<String, Gene>> res = new HashMap<String, HashMap<String, Gene>>();
        HashMap<String, Feature> all = new HashMap<String, Feature>();
        int[] w = new int[2];
        int i3 = 0;
        while (i3 < tags.length) {
            int anz = 0;
            int j = 0;
            while (j < list[i3].size()) {
                split = (String[])list[i3].get(j);
                if (i3 == 0) {
                    String chr = split[0];
                    HashMap<String, Gene> h = res.get(chr);
                    if (h == null) {
                        h = new HashMap();
                        res.put(chr, h);
                    }
                    String[] attr = ((String)split[8]).split(";");
                    int k = 0;
                    while (k < attr.length && !attr[k].startsWith("ID=")) {
                        ++k;
                    }
                    if (k < attr.length) {
                        String id = attr[k].substring(3);
                        Gene g = new Gene((String[])split);
                        ++anz;
                        h.put(id, g);
                        all.put(id, g);
                    } else {
                        System.out.println("WARNING1: " + Arrays.toString(split));
                        w[0] = w[0] + 1;
                    }
                } else {
                    String[] attr = split[8].split(";");
                    int k = 0;
                    while (k < attr.length && !attr[k].startsWith(PARENT)) {
                        ++k;
                    }
                    int l = 0;
                    while (l < attr.length && !attr[l].startsWith("ID=")) {
                        ++l;
                    }
                    if (k < attr.length) {
                        String parent = attr[k].substring(7);
                        Feature f = (Feature)all.get(parent);
                        Feature n = f.addFeature((String[])split);
                        ++anz;
                        if (l < attr.length) {
                            String id = attr[l].substring(3);
                            all.put(id, n);
                        }
                    }
                    if (k == attr.length || i3 + 1 != tags.length && l == attr.length) {
                        System.out.println("WARNING2: " + Arrays.toString(split));
                        w[1] = w[1] + 1;
                    }
                }
                ++j;
            }
            protocol.append("#" + tags[i3] + "s: " + anz + "\n");
            protocol.append("#warnings: " + Arrays.toString(w) + "\n");
            ++i3;
        }
        if (add) {
            int j = 0;
            while (j < list[tags.length].size()) {
                Feature f;
                split = (String[])list[tags.length].get(j);
                String parent = AnnotationFinalizer.get(PARENT, (String[])split);
                if (parent != null) {
                    f = (Feature)all.get(parent);
                    if (f == null) {
                        throw new NullPointerException("Could not find Parent: " + Arrays.toString(split));
                    }
                } else {
                    throw new NullPointerException("Could not find Parent attribute: " + Arrays.toString(split));
                }
                f.add((String[])split);
                ++j;
            }
        }
        return res;
    }

    static String get(String tag, String[] split) {
        String[] attr = split[8].split(";");
        int k = 0;
        while (k < attr.length && !attr[k].startsWith(tag)) {
            ++k;
        }
        if (k < attr.length) {
            return attr[k].substring(tag.length());
        }
        return null;
    }

    @Override
    public ToolResult run(ToolParameterSet parameters, Protocol protocol, ProgressUpdater progress, int threads, String temp) throws Exception {
        return this.run(parameters, protocol, progress, threads, null, null, temp);
    }

    ToolResult run(ToolParameterSet parameters, Protocol protocol, ProgressUpdater progress, int threads, ToolParameterSet description, String version, String temp) throws Exception {
        String info;
        String prefix;
        progress.setIndeterminate();
        SimpleParameterSet utrPs = (SimpleParameterSet)parameters.getParameterForName("UTR").getValue();
        if (GeMoMa.seqs == null) {
            String genome = (String)parameters.getParameterForName("genome").getValue();
            int reads = 1;
            ExpandableParameterSet introns = null;
            ExpandableParameterSet coverage = null;
            if (utrPs.getNumberOfParameters() > 0) {
                reads = (Integer)utrPs.getParameterForName("reads").getValue();
                introns = (ExpandableParameterSet)((ParameterSetContainer)utrPs.getParameterAt(0)).getValue();
                coverage = (ExpandableParameterSet)((ParameterSetContainer)utrPs.getParameterAt(2)).getValue();
            }
            GeMoMa.fill(protocol, false, 0, genome, null, reads, introns, coverage);
            protocol.append("\n");
        }
        String source = null;
        if (utrPs.getNumberOfParameters() > 0) {
            Parameter p = utrPs.getParameterForName("additional source suffix");
            String string = source = p == null ? null : (String)p.getValue();
            if (source != null && source.length() == 1) {
                source = null;
            }
        }
        source = String.valueOf(toolName) + (source == null ? "" : "_" + source);
        SimpleParameterSet renamePS = (SimpleParameterSet)parameters.getParameterForName("rename").getValue();
        int n = renamePS.getNumberOfParameters();
        int digits = -100;
        String infix = null;
        String suffix = "";
        String search = null;
        String replace = null;
        boolean bl = rename = n > 0;
        if (rename) {
            prefix = renamePS.getParameterForName("prefix").getValue().toString();
            digits = (Integer)renamePS.getParameterForName("digits").getValue();
            if (n > 2) {
                infix = renamePS.getParameterForName("infix").getValue().toString();
                suffix = renamePS.getParameterForName("suffix").getValue().toString();
                search = renamePS.getParameterForName("contig search pattern").getValue().toString();
                replace = renamePS.getParameterForName("contig replace pattern").getValue().toString();
            }
        } else {
            prefix = null;
        }
        boolean asName = (Boolean)parameters.getParameterForName("name attribute").getValue();
        Parameter p = parameters.getParameterForName("transfer features");
        boolean addAdditional = p == null ? false : (Boolean)p.getValue();
        String tag = parameters.getParameterForName("tag").getValue().toString();
        StringBuffer begin = new StringBuffer();
        HashMap<String, HashMap<String, Gene>> annotation = AnnotationFinalizer.read(parameters.getParameterForName("annotation").getValue().toString(), protocol, tag, begin, addAdditional);
        File gffFile = Tools.createTempFile(this.getShortName(), temp);
        BufferedWriter w = new BufferedWriter(new FileWriter(gffFile));
        if (description == null) {
            w.append(begin);
            w.append("#SOFTWARE INFO: " + this.getShortName() + " " + this.getToolVersion() + "; ");
            info = JstacsTool.getSimpleParameterInfo(parameters);
        } else {
            w.append("##gff-version 3");
            w.newLine();
            w.append("#SOFTWARE INFO: " + description.getToolName() + " " + version + "; ");
            info = JstacsTool.getSimpleParameterInfo(description);
        }
        if (info != null) {
            w.append("SIMPLE PARAMETERS: " + info);
        }
        w.newLine();
        int num = 1;
        int utrBoth = 0;
        int utr = 0;
        int utr5 = 0;
        int utr3 = 0;
        String[] keys = new String[annotation.size()];
        annotation.keySet().toArray(keys);
        Arrays.sort(keys, new SequenceIDComparator());
        String[] stringArray = keys;
        int n2 = keys.length;
        int n3 = 0;
        while (n3 < n2) {
            int[][][] don;
            int[][][] acc;
            int[][] revCov;
            int[][] fwdCov;
            String c = stringArray[n3];
            w.append("##sequence-region " + c + " 1 " + GeMoMa.seqs.get(c).length());
            w.newLine();
            String newC = c;
            String pref = null;
            if (rename) {
                if (n == 2) {
                    pref = prefix;
                } else {
                    newC = newC.replaceAll(search, replace);
                    pref = String.valueOf(prefix) + newC + infix;
                    num = 1;
                }
            }
            Collection<Gene> gg = annotation.get(c).values();
            ArrayList<Gene> genes = new ArrayList<Gene>(gg);
            Collections.sort(genes);
            if (GeMoMa.coverage != null) {
                fwdCov = GeMoMa.coverage[0].get(c);
                revCov = GeMoMa.coverage[1].get(c);
            } else {
                revCov = null;
                fwdCov = null;
            }
            if (GeMoMa.acceptorSites != null) {
                acc = GeMoMa.acceptorSites.get(c);
                don = GeMoMa.donorSites.get(c);
            } else {
                don = null;
                acc = null;
            }
            if (fwdCov != null || revCov != null) {
                for (Gene g : genes) {
                    int[][] cov;
                    int[][] a;
                    int strand = g.strand();
                    int[][] nArray = acc == null ? null : (a = acc[strand == 1 ? 0 : 1]);
                    int[][] d = don == null ? null : don[strand == 1 ? 0 : 1];
                    int[][] nArray2 = cov = strand == 1 ? fwdCov : revCov;
                    if (cov != null) {
                        for (Transcript t : g.list) {
                            boolean u5 = AnnotationFinalizer.extendUTR(t, -1, cov, a, 1, source);
                            boolean u3 = AnnotationFinalizer.extendUTR(t, 1, cov, d, 0, source);
                            if (u5) {
                                ++utr5;
                            }
                            if (u3) {
                                ++utr3;
                            }
                            if (u5 || u3) {
                                ++utr;
                            }
                            if (!u5 || !u3) continue;
                            ++utrBoth;
                        }
                    }
                    g.set();
                }
            }
            Collections.sort(genes);
            for (Gene g : genes) {
                if (rename) {
                    g.genericName(String.valueOf(pref) + String.format("%0" + digits + "d", num++) + suffix, asName);
                }
                w.append(g.toString());
            }
            ++n3;
        }
        w.close();
        if (GeMoMa.seqs != null) {
            protocol.append("\n#transcripts with 5'-UTR annotation: " + utr5 + "\n");
            protocol.append("#transcripts with 3'-UTR annotation: " + utr3 + "\n");
            protocol.append("#transcripts with some UTR annotation: " + utr + "\n");
            protocol.append("#transcripts with 5'- and 3'-UTR annotation: " + utrBoth + "\n");
        }
        ArrayList<TextResult> res = new ArrayList<TextResult>();
        res.add(new TextResult(defResult, "Result", new FileParameter.FileRepresentation(gffFile.getAbsolutePath()), "gff", this.getToolName(), null, true));
        return new ToolResult("", "", null, new ResultSet(res), parameters, this.getToolName(), new Date());
    }

    private static boolean extendUTR(Transcript t, int d, int[][] cov, int[][] splice, int sIdx, String source) {
        int start;
        int strand = t.strand();
        int min = t.getMin();
        int max = t.getMax();
        int dir = d * strand;
        String utr = d == 1 ? "three_prime_UTR" : "five_prime_UTR";
        LinkedList<String[]> utrs = new LinkedList<String[]>();
        int n = start = dir == -1 ? min : max;
        boolean extend = d == 1 ? t.downUTR.size() == 0 : t.upUTR.size() == 0;
        while (extend) {
            int firstBase = start + dir;
            extend = false;
            int h = firstBase;
            int idx = Arrays.binarySearch(cov, new int[]{firstBase}, GeMoMa.IntArrayComparator.comparator[2]);
            if (idx < 0) {
                idx = -(idx + 1);
                idx = Math.max(0, idx - 1);
            }
            if (cov[idx][0] > firstBase || firstBase > cov[idx][1]) break;
            do {
                h = cov[idx][dir == -1 ? 0 : 1];
            } while ((idx += dir) >= 0 && idx < cov.length && cov[idx][dir == -1 ? 1 : 0] == h + dir);
            int lastBase = h;
            if (dir == -1) {
                int xxx = lastBase;
                lastBase = firstBase;
                firstBase = xxx;
            }
            if (splice != null && splice[sIdx] != null) {
                int st = firstBase + dir;
                idx = Arrays.binarySearch(splice[sIdx], st);
                if (idx > 0) {
                    while (idx > 0 && splice[sIdx][idx - 1] == st) {
                        --idx;
                    }
                }
                if (idx < 0) {
                    idx = -(idx + 1);
                }
                int maxSplitReads = -1;
                int maxIdx = -1;
                int end = lastBase + dir;
                while (idx < splice[sIdx].length && splice[sIdx][idx] <= end) {
                    int c;
                    int i = Arrays.binarySearch(cov, new int[]{splice[sIdx][idx] + dir}, GeMoMa.IntArrayComparator.comparator[2]);
                    if (i < 0) {
                        i = -(i + 1);
                        i = Math.max(0, idx - 1);
                        c = cov[i][1] > splice[sIdx][idx] + dir ? cov[i][2] : 0;
                    } else {
                        c = cov[i][2];
                    }
                    if (splice[2][idx] >= c && splice[2][idx] > maxSplitReads) {
                        maxSplitReads = splice[2][idx];
                        maxIdx = idx;
                    }
                    ++idx;
                }
                if (maxIdx >= 0) {
                    int add;
                    extend = true;
                    int n2 = add = dir == 1 ? -1 : 0;
                    if (dir == -1) {
                        firstBase = splice[sIdx][maxIdx] + add;
                    } else {
                        lastBase = splice[sIdx][maxIdx] + add;
                    }
                    start = splice[1 - sIdx][maxIdx] + add;
                }
            }
            if (firstBase > lastBase) continue;
            String[] stringArray = new String[9];
            stringArray[0] = t.split[0];
            stringArray[1] = source;
            stringArray[2] = utr;
            stringArray[3] = "" + firstBase;
            stringArray[4] = "" + lastBase;
            stringArray[5] = ".";
            stringArray[6] = t.split[6];
            stringArray[7] = ".";
            String[] split = stringArray;
            if (d == -1) {
                utrs.addFirst(split);
                continue;
            }
            utrs.addLast(split);
        }
        boolean hasUTR = utrs.size() > 0;
        while (utrs.size() > 0) {
            String[] split = (String[])utrs.removeFirst();
            split[8] = PARENT + t.id;
            t.addUTR(d == -1, split);
        }
        return hasUTR;
    }

    @Override
    public ToolParameterSet getToolParameters() {
        try {
            return new ToolParameterSet(this.getShortName(), new FileParameter("genome", "The genome file (FASTA), i.e., the target sequences in the blast run. Should be in IUPAC code", "fasta,fa,fas,fna,fasta.gz,fa.gz,fas.gz,fna.gz", true, new FileExistsValidator(), true), new FileParameter("annotation", "The predicted genome annotation file (GFF)", "gff,gff3", true, new FileExistsValidator(), true), new SimpleParameter(DataType.STRING, "tag", "A user-specified tag for transcript predictions in the third column of the returned gff. It might be beneficial to set this to a specific value for some genome browsers.", true, "mRNA"), new SimpleParameter(DataType.BOOLEAN, "transfer features", "if true other features than gene, &lt;tag&gt; (default: mRNA), and CDS of the input will be written in the output", true, false), new SelectionParameter(DataType.PARAMETERSET, new String[]{"NO", "YES"}, new Object[]{new SimpleParameterSet(new Parameter[0]), new SimpleParameterSet(new ParameterSetContainer("introns", "", new ExpandableParameterSet(new SimpleParameterSet(new FileParameter("introns file", "Introns (GFF), which might be obtained from RNA-seq", "gff,gff3", true, new FileExistsValidator(), true)), "introns", "", 1)), new SimpleParameter(DataType.INT, "reads", "if introns are given by a GFF, only use those which have at least this number of supporting split reads", true, new NumberValidator<Integer>(1, Integer.MAX_VALUE), 1), new ParameterSetContainer("coverage", "", new ExpandableParameterSet(new SimpleParameterSet(new SelectionParameter(DataType.PARAMETERSET, new String[]{"NO", "UNSTRANDED", "STRANDED"}, new Object[]{new SimpleParameterSet(new Parameter[0]), new SimpleParameterSet(new FileParameter("coverage_unstranded", "The coverage file contains the unstranded coverage of the genome per interval. Intervals with coverage 0 (zero) can be left out.", "bedgraph", true, new FileExistsValidator())), new SimpleParameterSet(new FileParameter("coverage_forward", "The coverage file contains the forward coverage of the genome per interval. Intervals with coverage 0 (zero) can be left out.", "bedgraph", true, new FileExistsValidator()), new FileParameter("coverage_reverse", "The coverage file contains the reverse coverage of the genome per interval. Intervals with coverage 0 (zero) can be left out.", "bedgraph", true, new FileExistsValidator()))}, "coverage file", "experimental coverage (RNA-seq)", true)), "coverage", "", 1)), new SimpleParameter(DataType.STRING, "additional source suffix", "a suffix for source values of UTR features", true, new RegExpValidator("\\w*"), ""))}, new String[]{"no UTR prediction", "UTR prediction"}, "UTR", "allows to predict UTRs using RNA-seq data", true), new SelectionParameter(DataType.PARAMETERSET, new String[]{"COMPOSED", "SIMPLE", "NO"}, new Object[]{new SimpleParameterSet(new SimpleParameter(DataType.STRING, "prefix", "the prefix of the generic name", true, new RegExpValidator("\\w+")), new SimpleParameter(DataType.STRING, "infix", "the infix of the generic name", true, "G"), new SimpleParameter(DataType.STRING, "suffix", "the suffix of the generic name", true, "0"), new SimpleParameter(DataType.INT, "digits", "the number of informative digits", true, new NumberValidator<Integer>(4, 10), 5), new SimpleParameter(DataType.STRING, "contig search pattern", "search string, i.e., a regular expression for search-and-replace parts of the contig/scaffold/chromosome names, the modified string is used as infix for the gene name", true, ""), new SimpleParameter(DataType.STRING, "contig replace pattern", "replace string, i.e., a regular expression for search-and-replace parts of the contig/scaffold/chromosome names, the modified string is used as infix for the gene name", true, new RegExpValidator("[^;^=^\"^\\s]*"), "")), new SimpleParameterSet(new SimpleParameter(DataType.STRING, "prefix", "the prefix of the generic name", true, new RegExpValidator("\\w+")), new SimpleParameter(DataType.INT, "digits", "the number of informative digits", true, new NumberValidator<Integer>(4, 10), 5)), new SimpleParameterSet(new Parameter[0])}, new String[]{"composed renaming: <prefix><contig/chr*><infix><number><suffix>; recommended for whole genome (re-)annotations", "simple renaming: <prefix><number>; recommended for gene family annotations", "no renaming"}, "rename", "allows to generate generic gene and transcripts names (cf. parameter &quot;name attribute&quot;)", true), new SimpleParameter(DataType.BOOLEAN, "name attribute", "if true the new name is added as new attribute &quot;Name&quot;, otherwise &quot;Parent&quot; and &quot;ID&quot; values are modified accordingly", true, true));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }

    @Override
    public String getToolName() {
        return toolName;
    }

    @Override
    public String getShortName() {
        return toolName;
    }

    @Override
    public String getDescription() {
        return "predicts UTRs for a given set of CDS annotations";
    }

    @Override
    public String getHelpText() {
        return "This tool finalizes an annotation. It allows to predict for UTRs for annotated coding sequences and to generate generic gene and transcript names. UTR prediction might be negatively influenced (i.e. too long predictions) by genomic contamination of RNA-seq libraries, overlapping genes or genes in close proximity as well as unstranded RNA-seq libraries. Please use **ERE** to preprocess the mapped reads." + MORE;
    }

    @Override
    public JstacsTool.ResultEntry[] getDefaultResultInfos() {
        return new JstacsTool.ResultEntry[]{new JstacsTool.ResultEntry(TextResult.class, "gff", defResult)};
    }

    @Override
    public ToolResult[] getTestCases(String path) {
        try {
            return new ToolResult[]{new ToolResult(FileManager.readFile(String.valueOf(path) + File.separator + "tests/gemoma/xml/af-test-nothing.xml")), new ToolResult(FileManager.readFile(String.valueOf(path) + File.separator + "tests/gemoma/xml/af-test-utr.xml"))};
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static class AddFeature
    extends Feature {
        AddFeature(String[] split) {
            super(split);
        }

        @Override
        public Feature addFeature(String[] split) {
            throw new RuntimeException("IllegalOperation");
        }
    }

    static class CDS
    extends Feature {
        CDS(String[] split) {
            super(split);
        }

        @Override
        public Feature addFeature(String[] split) {
            throw new RuntimeException("not supported");
        }

        public int getMin() {
            return Integer.parseInt(this.split[3]);
        }

        public int getMax() {
            return Integer.parseInt(this.split[4]);
        }
    }

    static abstract class Feature {
        int start;
        int end;
        String[] split;
        ArrayList<Feature> add;

        Feature(String[] split) {
            this.split = split;
            this.start = Integer.parseInt(split[3]);
            this.end = Integer.parseInt(split[4]);
        }

        public abstract Feature addFeature(String[] var1);

        public void add(String[] split) {
            if (this.add == null) {
                this.add = new ArrayList();
            }
            this.add.add(new AddFeature(split));
        }

        public void rename(String tag, String oldN, String newN) {
            String sep = this.split[8].indexOf(59) >= 0 ? ";" : "";
            this.split[8] = this.split[8].replace(String.valueOf(tag) + "=" + oldN + sep, String.valueOf(tag) + "=" + newN + sep);
        }

        static <T extends Feature> void rename(String tag, String oldN, String newN, ArrayList<T> l) {
            if (l == null) {
                return;
            }
            int i = 0;
            while (i < l.size()) {
                ((Feature)l.get(i)).rename(tag, oldN, newN);
                ++i;
            }
        }

        public String toString() {
            return this.toString(this.add != null);
        }

        public String toString(boolean addAdd) {
            StringBuffer all = new StringBuffer();
            int i = 0;
            while (i < this.split.length) {
                all.append(String.valueOf(this.split[i]) + (i + 1 == this.split.length ? "\n" : "\t"));
                ++i;
            }
            if (addAdd) {
                i = 0;
                while (i < this.add.size()) {
                    all.append(this.add.get(i).toString());
                    ++i;
                }
            }
            return all.toString();
        }
    }

    static class FeatureComparator
    implements Comparator<Feature> {
        static final FeatureComparator DUMMY = new FeatureComparator();

        FeatureComparator() {
        }

        @Override
        public int compare(Feature first, Feature other) {
            int diff = first.start - other.start;
            if (diff == 0) {
                diff = first.end - first.start - (other.end - other.start);
            }
            if (first.split[6].charAt(0) == '-') {
                diff *= -1;
            }
            return diff;
        }
    }

    static class Gene
    extends Feature
    implements Comparable<Gene> {
        ArrayList<Transcript> list = new ArrayList();
        int min = -100;
        int max = -100;

        Gene(String[] split) {
            super(split);
        }

        public int strand() {
            return this.split[6].charAt(0) == '+' ? 1 : -1;
        }

        @Override
        public Transcript addFeature(String[] split) {
            Transcript t = new Transcript(split);
            this.list.add(t);
            return t;
        }

        void determine() {
            this.min = Integer.MAX_VALUE;
            int i = 0;
            while (i < this.list.size()) {
                this.min = Math.min(this.list.get(i).determine(), this.min);
                ++i;
            }
            this.max = Integer.MIN_VALUE;
            i = 0;
            while (i < this.list.size()) {
                this.max = Math.max(Integer.parseInt(this.list.get((int)i).split[4]), this.max);
                ++i;
            }
        }

        void set() {
            this.determine();
            this.split[3] = "" + this.min;
            this.split[4] = "" + this.max;
        }

        @Override
        public int compareTo(Gene g) {
            if (this.min == -100) {
                this.determine();
            }
            if (g.min == -100) {
                g.determine();
            }
            return Integer.compare(this.min, g.min);
        }

        @Override
        public String toString() {
            StringBuffer all = new StringBuffer();
            all.append(super.toString());
            int i = 0;
            while (i < this.list.size()) {
                all.append(this.list.get(i).toString());
                ++i;
            }
            return all.toString();
        }

        public void genericName(String name, boolean asName) {
            if (asName) {
                this.split[8] = "Name=" + name + ";" + this.split[8];
                int i = 0;
                while (i < this.list.size()) {
                    Transcript t = this.list.get(i);
                    t.split[8] = "Name=" + name + "." + (i + 1) + ";" + t.split[8];
                    ++i;
                }
            } else {
                int i1 = this.split[8].indexOf("ID=");
                int i2 = this.split[8].indexOf(";", i1);
                String old = this.split[8].substring(i1 + 3, i2);
                this.split[8] = this.split[8].replace("ID=" + old + ";", "ID=" + name + ";");
                Feature.rename("Parent", old, name, this.add);
                int i = 0;
                while (i < this.list.size()) {
                    Transcript t = this.list.get(i);
                    i1 = t.split[8].indexOf("ID=");
                    i2 = t.split[8].indexOf(";", i1);
                    String oldT = t.split[8].substring(i1 + 3, i2);
                    String newT = String.valueOf(name) + "." + (i + 1);
                    t.rename("Parent", old, name);
                    t.rename("ID", oldT, newT);
                    if (t.split[8].indexOf("oldID=") >= 0) {
                        throw new IllegalArgumentException("oldID already exists as attribute");
                    }
                    t.split[8] = String.valueOf(t.split[8]) + (t.split[8].endsWith(";") ? "" : ";") + "oldID=" + oldT;
                    Feature.rename("Parent", oldT, newT, t.upUTR);
                    Feature.rename("Parent", oldT, newT, t.list);
                    Feature.rename("Parent", oldT, newT, t.downUTR);
                    Feature.rename("Parent", oldT, newT, t.add);
                    ++i;
                }
            }
        }
    }

    static class SequenceIDComparator
    implements Comparator<String> {
        SequenceIDComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            int diff = Long.compare(this.extractLong(o1), this.extractLong(o2));
            if (diff == 0) {
                diff = o1.compareTo(o2);
            }
            return diff;
        }

        long extractLong(String s) {
            String num = s.replaceAll("\\D", "");
            if (num.isEmpty()) {
                return 0L;
            }
            try {
                long l = Long.parseLong(num);
                return l;
            }
            catch (NumberFormatException nfe) {
                return 0L;
            }
        }
    }

    static class Transcript
    extends Feature
    implements Comparable<Transcript> {
        ArrayList<CDS> list;
        ArrayList<UTR> upUTR;
        ArrayList<UTR> downUTR;
        String id;
        double score;

        Transcript(String[] split) {
            super(split);
            String[] attr = split[8].split(";");
            int l = 0;
            while (l < attr.length && !attr[l].startsWith("ID=")) {
                ++l;
            }
            this.id = attr[l].substring(3);
            l = 0;
            while (l < attr.length && !attr[l].startsWith("score=")) {
                ++l;
            }
            if (l < attr.length) {
                try {
                    this.score = Double.parseDouble(attr[l].substring(6));
                }
                catch (Exception e) {
                    this.score = Double.NaN;
                }
            } else {
                this.score = 0.0;
            }
            this.list = new ArrayList();
            this.upUTR = new ArrayList();
            this.downUTR = new ArrayList();
        }

        @Override
        public void add(String[] split) {
            switch (split[2]) {
                case "three_prime_UTR": {
                    this.downUTR.add(new UTR(split));
                    break;
                }
                case "five_prime_UTR": {
                    this.upUTR.add(new UTR(split));
                    break;
                }
                default: {
                    super.add(split);
                }
            }
        }

        public int strand() {
            return this.split[6].charAt(0) == '+' ? 1 : -1;
        }

        public int determine() {
            int min = this.getMin();
            int max = this.getMax();
            this.split[3] = "" + min;
            this.split[4] = "" + max;
            return min;
        }

        public int getMin() {
            int i;
            int min = Integer.MAX_VALUE;
            if (this.add != null) {
                i = 0;
                while (i < this.add.size()) {
                    min = Math.min(min, ((Feature)this.add.get((int)i)).start);
                    ++i;
                }
            }
            i = 0;
            while (i < this.upUTR.size()) {
                min = Math.min(min, this.upUTR.get(i).getMin());
                ++i;
            }
            i = 0;
            while (i < this.list.size()) {
                min = Math.min(min, this.list.get(i).getMin());
                ++i;
            }
            i = 0;
            while (i < this.downUTR.size()) {
                min = Math.min(min, this.downUTR.get(i).getMin());
                ++i;
            }
            return min;
        }

        public int getMax() {
            int i;
            int max = Integer.MIN_VALUE;
            if (this.add != null) {
                i = 0;
                while (i < this.add.size()) {
                    max = Math.max(max, ((Feature)this.add.get((int)i)).end);
                    ++i;
                }
            }
            i = 0;
            while (i < this.upUTR.size()) {
                max = Math.max(max, this.upUTR.get(i).getMax());
                ++i;
            }
            i = 0;
            while (i < this.list.size()) {
                max = Math.max(max, this.list.get(i).getMax());
                ++i;
            }
            i = 0;
            while (i < this.downUTR.size()) {
                max = Math.max(max, this.downUTR.get(i).getMax());
                ++i;
            }
            return max;
        }

        @Override
        public CDS addFeature(String[] split) {
            CDS c = new CDS(split);
            this.list.add(c);
            return c;
        }

        public void addUTR(boolean up, String[] split) {
            UTR utr = new UTR(split);
            if (up) {
                this.upUTR.add(utr);
            } else {
                this.downUTR.add(utr);
            }
        }

        @Override
        public String toString() {
            StringBuffer all = new StringBuffer();
            all.append(super.toString(false));
            int num = (this.add == null ? 0 : this.add.size()) + this.upUTR.size() + this.list.size() + this.downUTR.size();
            Feature[] array = new Feature[num];
            int start = 0;
            start = AnnotationFinalizer.set(array, this.add, start);
            start = AnnotationFinalizer.set(array, this.upUTR, start);
            start = AnnotationFinalizer.set(array, this.list, start);
            start = AnnotationFinalizer.set(array, this.downUTR, start);
            Arrays.sort(array, FeatureComparator.DUMMY);
            int j = 0;
            while (j < array.length) {
                all.append(array[j].toString());
                ++j;
            }
            return all.toString();
        }

        @Override
        public int compareTo(Transcript t) {
            return -Double.compare(this.score, t.score);
        }
    }

    static class UTR
    extends Feature {
        UTR(String[] split) {
            super(split);
        }

        @Override
        public Feature addFeature(String[] split) {
            throw new RuntimeException("not supported");
        }

        public int getMin() {
            return Integer.parseInt(this.split[3]);
        }

        public int getMax() {
            return Integer.parseInt(this.split[4]);
        }
    }
}

