/*
 * Decompiled with CFR 0.152.
 */
package projects.gemoma;

import de.jstacs.results.ResultSet;
import de.jstacs.results.TextResult;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.ToolParameterSet;
import de.jstacs.tools.ToolResult;
import de.jstacs.tools.ui.cli.CLI;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import projects.gemoma.Extractor;
import projects.gemoma.Tools;

public class Catalog {
    public static int anz = 0;
    public static int checked = 0;

    public static void main(String[] args) throws Exception {
        String gffs = args[0];
        String contigs = args[1];
        String[] fNames = new File(gffs).list();
        HashMap<Integer, HashSet<String>> catalogue = new HashMap<Integer, HashSet<String>>();
        Extractor e = new Extractor(-1);
        ToolParameterSet parameter = e.getToolParameters();
        parameter.getParameterForName(Extractor.name[2]).setValue(true);
        parameter.getParameterForName("Ambiguity").setValue((Object)Tools.Ambiguity.AMBIGUOUS);
        ProgressUpdater progress = new ProgressUpdater();
        CLI.QuietSysProtocol protocol = new CLI.QuietSysProtocol();
        String assign = "catalogue-assignment.tabular";
        String cds = "catalogue-cds-parts.fasta";
        BufferedWriter assignment = new BufferedWriter(new FileWriter(assign));
        BufferedWriter cdsParts = new BufferedWriter(new FileWriter(cds));
        int i = 0;
        while (i < fNames.length) {
            String infix = fNames[i].substring(0, fNames[i].length() - 4);
            parameter.getParameterForName("annotation").setValue(String.valueOf(gffs) + File.separator + fNames[i]);
            parameter.getParameterForName("genome").setValue(String.valueOf(contigs) + File.separator + infix + ".fasta");
            ToolResult tr = e.run(parameter, protocol, progress, 1);
            ResultSet raw = tr.getRawResult()[0];
            TextResult c = (TextResult)raw.getResultForName(Extractor.name[0]);
            TextResult a = (TextResult)raw.getResultForName(Extractor.name[1]);
            TextResult p = (TextResult)raw.getResultForName(Extractor.name[2]);
            Catalog.add(infix, a.getValue().getFilename(), c.getValue().getFilename(), p.getValue().getFilename(), catalogue, assignment, cdsParts, i == 0);
            System.out.println(String.valueOf(i) + "\t" + anz + "\t" + checked);
            ++i;
        }
        assignment.close();
        cdsParts.close();
    }

    public static void add(String prefix, String assignmentFile, String cdsPartsFile, String proteinFile, HashMap<Integer, HashSet<String>> hash, BufferedWriter assign, BufferedWriter cdsParts, boolean first) throws IOException {
        String comment;
        BufferedReader a = new BufferedReader(new FileReader(assignmentFile));
        BufferedReader c = new BufferedReader(new FileReader(cdsPartsFile));
        BufferedReader p = new BufferedReader(new FileReader(proteinFile));
        if (first) {
            assign.append(a.readLine());
            assign.newLine();
        }
        StringBuffer cds = new StringBuffer();
        while ((comment = p.readLine()) != null) {
            String protein = p.readLine();
            String ass = a.readLine();
            String[] aSplit = ass.split("\t");
            int exons = aSplit[2].split(",").length;
            cds.delete(0, cds.length());
            int i = 0;
            while (i < exons) {
                cds.append(">" + prefix + "_" + c.readLine().substring(1) + "\n");
                cds.append(String.valueOf(c.readLine()) + "\n");
                ++i;
            }
            HashSet<String> current = hash.get(exons);
            if (current == null) {
                current = new HashSet();
                hash.put(exons, current);
            }
            if (!current.contains(protein)) {
                current.add(protein);
                ++anz;
                int i2 = 0;
                while (i2 < aSplit.length) {
                    assign.append(String.valueOf(i2 > 0 ? "\t" : "") + (i2 <= 1 ? String.valueOf(prefix) + "_" : "") + aSplit[i2]);
                    ++i2;
                }
                assign.newLine();
                cdsParts.append(cds);
            }
            ++checked;
        }
        a.close();
        c.close();
        p.close();
    }
}

