/*
 * Decompiled with CFR 0.152.
 */
package projects.gemoma;

import de.jstacs.DataType;
import de.jstacs.parameters.FileParameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.validation.FileExistsValidator;
import de.jstacs.results.ResultSet;
import de.jstacs.results.TextResult;
import de.jstacs.tools.JstacsTool;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.Protocol;
import de.jstacs.tools.ToolParameterSet;
import de.jstacs.tools.ToolResult;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import projects.gemoma.GeMoMaModule;
import projects.gemoma.Tools;

public class GFFAttributes2
extends GeMoMaModule {
    static String[] pos = new String[]{"0chromosome", "1start position", "2end postion"};
    static int[] ind;

    static {
        int[] nArray = new int[3];
        nArray[1] = 3;
        nArray[2] = 4;
        ind = nArray;
    }

    @Override
    public ToolParameterSet getToolParameters() {
        try {
            return new ToolParameterSet(this.getShortName(), new FileParameter("annotation", "GFF file containing the gene annotations", "gff,gff3", true, new FileExistsValidator(), true), new SimpleParameter(DataType.STRING, "feature", "the feature which is used to parse the attributes", true, "mRNA"), new SimpleParameter(DataType.STRING, "missing", "the value used for missing attributes of a feature", true, ""));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }

    @Override
    public String getToolName() {
        return this.getShortName();
    }

    @Override
    public String getShortName() {
        return "GFFAttributes";
    }

    @Override
    public String getDescription() {
        return "extracts attributes from a feature class of GFF";
    }

    @Override
    public String getHelpText() {
        return "Annotations that are build with **GeMoMaPipeline** or augmented with **AnnotationEvidence** have lots of attributes that might be intersting for the user. This module allows to create a simple table that can easily be parsed and used for visualization of statistics. However, the module could also be used for annotations that are not created of modified with GeMoMa modules.";
    }

    @Override
    public ToolResult[] getTestCases(String path) {
        return null;
    }

    @Override
    public ToolResult run(ToolParameterSet parameters, Protocol protocol, ProgressUpdater progress, int threads, String temp) throws Exception {
        int j;
        String line;
        String missing = parameters.getParameterForName("missing").getValue().toString();
        String tag = parameters.getParameterForName("feature").getValue().toString();
        String fName = parameters.getParameterForName("annotation").getValue().toString();
        HashMap<String, Integer> keys = new HashMap<String, Integer>();
        int i = 0;
        while (i < pos.length) {
            keys.put(pos[i], i);
            ++i;
        }
        ArrayList<Object[]> feature = new ArrayList<Object[]>();
        BufferedReader r = Tools.openGzOrPlain(fName);
        while ((line = r.readLine()) != null) {
            String[] split;
            if (line.equalsIgnoreCase("##FASTA")) break;
            if (line.length() == 0 || line.startsWith("#") || !(split = line.split("\t"))[2].equalsIgnoreCase(tag)) continue;
            String[] att = split[8].split(";");
            String[] v = new String[att.length + 3];
            int[] index = new int[att.length + 3];
            int i2 = 0;
            while (i2 < att.length) {
                j = att[i2].indexOf(61);
                if (j < 0) {
                    throw new IllegalArgumentException("Could not parse attribute: " + att[i2]);
                }
                String a = att[i2].substring(0, j);
                v[i2] = att[i2].substring(j + 1);
                Integer ind = (Integer)keys.get(a);
                if (ind == null) {
                    ind = keys.size();
                    keys.put(a, ind);
                }
                index[i2] = ind;
                ++i2;
            }
            i2 = 0;
            while (i2 < pos.length) {
                index[att.length + i2] = (Integer)keys.get(pos[i2]);
                v[att.length + i2] = split[ind[i2]];
                ++i2;
            }
            Object[] filled = new String[keys.size()];
            Arrays.fill(filled, missing);
            int i3 = 0;
            while (i3 < v.length) {
                filled[index[i3]] = v[i3];
                ++i3;
            }
            feature.add(filled);
        }
        r.close();
        Object[] k = keys.keySet().toArray(new String[0]);
        Arrays.sort(k);
        Collections.sort(feature, new StringArrayComparator());
        File out = Tools.createTempFile("GFF-attributes", temp);
        BufferedWriter w = new BufferedWriter(new FileWriter(out));
        int i4 = 0;
        while (i4 < k.length) {
            Object h = k[i4];
            if (i4 < pos.length) {
                h = ((String)h).substring(1);
            }
            w.append(String.valueOf(i4 == 0 ? "" : "\t") + (String)h);
            ++i4;
        }
        w.newLine();
        i4 = 0;
        while (i4 < feature.size()) {
            String[] attributes = (String[])feature.get(i4);
            j = 0;
            while (j < k.length) {
                int idx = (Integer)keys.get(k[j]);
                w.append(String.valueOf(j == 0 ? "" : "\t") + (idx < attributes.length ? attributes[idx] : missing));
                ++j;
            }
            w.newLine();
            ++i4;
        }
        w.close();
        return new ToolResult("", "", null, new ResultSet(new TextResult("GFF attributes", "Result", new FileParameter.FileRepresentation(out.getAbsolutePath()), "tabular", this.getToolName(), null, true)), parameters, this.getToolName(), new Date());
    }

    @Override
    public JstacsTool.ResultEntry[] getDefaultResultInfos() {
        return new JstacsTool.ResultEntry[]{new JstacsTool.ResultEntry(TextResult.class, "tabular", "GFF attributes")};
    }

    public static class StringArrayComparator
    implements Comparator<String[]> {
        @Override
        public int compare(String[] a, String[] b) {
            int res = 0;
            if (a != b) {
                if (a == null) {
                    res = 1;
                } else if (b == null) {
                    res = -1;
                } else {
                    int i = 0;
                    int n = Math.min(a.length, b.length);
                    while (res == 0 && i < n) {
                        res = i == 2 || i == 1 ? Integer.compare(Integer.parseInt(a[i]), Integer.parseInt(b[i])) : a[i].compareTo(b[i]);
                        ++i;
                    }
                }
            }
            return res;
        }
    }
}

