/*
 * Decompiled with CFR 0.152.
 */
package projects.gemoma;

import de.jstacs.DataType;
import de.jstacs.algorithms.alignment.Alignment;
import de.jstacs.algorithms.alignment.PairwiseStringAlignment;
import de.jstacs.algorithms.alignment.cost.AffineCosts;
import de.jstacs.algorithms.alignment.cost.MatrixCosts;
import de.jstacs.algorithms.graphs.UnionFind;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.WrongLengthException;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.FileManager;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.EnumParameter;
import de.jstacs.parameters.ExpandableParameterSet;
import de.jstacs.parameters.FileParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.ParameterSetContainer;
import de.jstacs.parameters.SelectionParameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.SimpleParameterSet;
import de.jstacs.parameters.validation.FileExistsValidator;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.results.ResultSet;
import de.jstacs.results.TextResult;
import de.jstacs.tools.JstacsTool;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.Protocol;
import de.jstacs.tools.ToolParameterSet;
import de.jstacs.tools.ToolResult;
import de.jstacs.tools.ui.cli.CLI;
import de.jstacs.tools.ui.galaxy.Galaxy;
import de.jstacs.utils.IntList;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.naming.OperationNotSupportedException;
import projects.gemoma.AddAttribute;
import projects.gemoma.Analyzer;
import projects.gemoma.AnnotationEvidence;
import projects.gemoma.AnnotationFinalizer;
import projects.gemoma.Attribute2Table;
import projects.gemoma.BUSCORecomputer;
import projects.gemoma.CheckIntrons;
import projects.gemoma.DenoiseIntrons;
import projects.gemoma.ExtractRNAseqEvidence;
import projects.gemoma.Extractor;
import projects.gemoma.GAFComparison;
import projects.gemoma.GFFAttributes;
import projects.gemoma.GeMoMaAnnotationFilter;
import projects.gemoma.GeMoMaModule;
import projects.gemoma.GeMoMaPipeline;
import projects.gemoma.NCBIReferenceRetriever;
import projects.gemoma.SyntenyChecker;
import projects.gemoma.Tools;
import projects.gemoma.TranscribedCluster;

public class GeMoMa
extends GeMoMaModule {
    public static final String TAG = "mRNA";
    public static DecimalFormat decFormat = new DecimalFormat("###.####", DecimalFormatSymbols.getInstance(Locale.US));
    private static final int scoreIndex = 13;
    public static final String timeoutMsg = "Invocation did not return before timeout";
    StringBuffer timeOutWarning;
    static HashMap<String, String> seqs;
    private static HashMap<String, Character> code;
    static HashMap<String, String> selected;
    static HashMap<String, int[][][]> donorSites;
    static HashMap<String, int[][][]> acceptorSites;
    static HashMap<String, int[][]>[] coverage;
    private double contigThreshold;
    private double hitThreshold;
    private int MAX_INTRON_LENGTH;
    private int INTRON_GAIN_LOSS;
    private int REDUCTION_FACTOR;
    private boolean approx;
    private boolean avoidPrematureStop;
    private double eValue;
    private int predictions;
    private double factor;
    private static final int MIN_INTRON_LENGTH = 30;
    private static final int MAX_GAP = 5;
    private static final int missingAA = 10;
    private static final int ignoreAAForSpliceSite = 30;
    private boolean proteinAlignment;
    private HashMap<String, String> cds;
    private HashMap<String, HashMap<String, Info>> transcriptInfo;
    private String prefix;
    private String tag;
    private DiscreteAlphabet aaAlphabet;
    private Character unknown;
    private AlphabetContainer alph;
    private double[][] matrix;
    private int gapOpening;
    private int gapExtension;
    private AffineCosts cost;
    private Tools.Ambiguity ambiguity = Tools.Ambiguity.AMBIGUOUS;
    private boolean sp;
    public static final String[] DONOR;
    public static final String ACCEPTOR = "AG";
    private static int[] intronic;
    private int noL;
    private boolean verbose;
    private int maxSize;
    private long timeOut;
    private long maxTimeOut;
    private static int[] count;
    static final String DEF_RES = "predicted annotation";

    static {
        selected = null;
        DONOR = new String[]{"GT", "GC"};
        intronic = new int[]{DONOR[0].length(), ACCEPTOR.length()};
        count = new int[3];
    }

    static synchronized void fill(Protocol protocol, boolean verbose, int maxSize, String targetGenome, String selectedFile, int reads, ExpandableParameterSet introns, ExpandableParameterSet cov) throws Exception {
        seqs = Tools.getFasta(targetGenome, 20, ".*");
        String x = Arrays.toString(seqs.keySet().toArray());
        if (x.length() > 200) {
            x = String.valueOf(x.substring(0, 200)) + "...";
        }
        protocol.append("genome parts: " + seqs.size() + "\t" + x + "\n");
        if (selectedFile != null) {
            selected = Tools.getSelection(selectedFile, maxSize, protocol);
            protocol.append("selected: " + selected.size() + (selected.size() < 100 ? "\t" + selected : "") + "\n");
        }
        if (introns != null) {
            ArrayList<String> fName = new ArrayList<String>();
            int i = 0;
            while (i < introns.getNumberOfParameters()) {
                Parameter y = ((ParameterSet)introns.getParameterAt(i).getValue()).getParameterAt(0);
                if (y.isSet()) {
                    fName.add(y.getValue().toString());
                }
                ++i;
            }
            if (fName.size() > 0) {
                HashMap<String, int[][][]>[] res = GeMoMa.readIntrons(reads, protocol, verbose, seqs, null, fName.toArray(new String[fName.size()]));
                GeMoMa.check(protocol, res[0], "introns");
                donorSites = res[0];
                acceptorSites = res[1];
            } else {
                donorSites = null;
                acceptorSites = null;
            }
        }
        if (cov != null) {
            coverage = GeMoMa.readCoverage(cov, protocol, verbose, true);
        }
    }

    static void check(Protocol p, HashMap<String, ?> h, String text) {
        Iterator<String> it = seqs.keySet().iterator();
        int anz = 0;
        int found = 0;
        while (it.hasNext()) {
            ++anz;
            String chr = it.next();
            if (!h.containsKey(chr)) continue;
            ++found;
        }
        double d = (double)found / (double)anz;
        if (d < 0.5) {
            p.appendWarning("Check RNA-seq data (" + text + "): " + Math.round(d * 100.0) + "% of the sequences in the reference genome are covered.\n");
        }
    }

    public String getHeading() {
        return "gene\ttranscript\t#parts\t#predicted hits\t#blast hits\t#strands\tbest sum score\t#candidate strands\t#predictions\t#alignments\tbest final score\tchromosome\tstrand\tstart\tend\t#predicted parts\tfirst part\tfirst aa\tlast parts\tlast aa\t#*\tintron gain\tintron loss" + (this.proteinAlignment ? "\tminimal score\tcurrent score\toptimal score\t%positive\tpid\tref_length\tpred_length" : "") + (acceptorSites == null ? "" : "\tacceptor evidence") + (donorSites == null ? "" : "\tdonor evidence") + (donorSites == null ? "" : "\tintron evidence") + (coverage == null ? "" : "\tpercent covered\tmin coverage") + "\tsimilar";
    }

    public GeMoMa(int maxSize, long timeOut, long maxTimeOut) {
        this.maxSize = maxSize;
        this.timeOut = timeOut;
        this.maxTimeOut = maxTimeOut;
        this.timeOutWarning = new StringBuffer();
    }

    public static void main(String[] args) throws Exception {
        StringBuffer xml;
        File jarfile = new File(Galaxy.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
        System.setProperty("java.net.useSystemProxies", "true");
        String site = "https://www.jstacs.de/index.php/GeMoMa";
        System.out.println("Searching for the new GeMoMa updates ...");
        boolean checked = false;
        try {
            int idx2;
            int idx;
            URL url = new URL(site);
            URLConnection con = url.openConnection();
            con.setConnectTimeout(5000);
            con.setReadTimeout(5000);
            BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream()));
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("<h") && line.contains("Version history")) break;
            }
            if (line != null && (idx = (line = br.readLine()).lastIndexOf("GeMoMa")) >= 0 && (idx2 = line.indexOf("<", idx += 6)) >= 0) {
                String ver = line.substring(idx, idx2).trim();
                if (!ver.equals("1.9")) {
                    if (ver.compareTo("1.9") > 0) {
                        System.out.println("You are using GeMoMa 1.9, but the latest version is " + ver + ".\nYou can download the latest version from " + site);
                    } else {
                        System.out.println("You are using an unofficial GeMoMa 1.9; the latest official version is " + ver + ".");
                    }
                } else {
                    System.out.println("You are using the latest GeMoMa version.");
                }
                checked = true;
            }
        }
        catch (Exception url) {
            // empty catch block
        }
        if (!checked) {
            System.out.println("Could not connect to the GeMoMa-Homepage. Please check manually at " + site);
        }
        System.out.println();
        File basic = new File(Tools.GeMoMa_TEMP);
        basic.mkdirs();
        int maxSize = -1;
        long timeOut = 3600L;
        long maxTimeOut = 604800L;
        File ini = new File(String.valueOf(jarfile.getParentFile().getAbsolutePath()) + File.separator + "GeMoMa.ini.xml");
        if (ini.exists()) {
            xml = FileManager.readFile(ini);
            maxSize = XMLParser.extractObjectForTags(xml, "maxSize", Integer.class);
            timeOut = XMLParser.extractObjectForTags(xml, "timeOut", Long.class);
            maxTimeOut = XMLParser.extractObjectForTags(xml, "maxTimeOut", Long.class);
        } else {
            xml = new StringBuffer();
            XMLParser.appendObjectWithTags(xml, maxSize, "maxSize");
            xml.append("\n");
            XMLParser.appendObjectWithTags(xml, timeOut, "timeOut");
            xml.append("\n");
            XMLParser.appendObjectWithTags(xml, maxTimeOut, "maxTimeOut");
            try {
                FileManager.writeFile(ini, (CharSequence)xml);
            }
            catch (Exception e) {
                System.err.println("Default values could not be written to " + ini.getAbsolutePath());
            }
        }
        JstacsTool[] tools = new JstacsTool[]{new GeMoMaPipeline(), new ExtractRNAseqEvidence(), new CheckIntrons(), new DenoiseIntrons(), new NCBIReferenceRetriever(), new Extractor(maxSize), new GeMoMa(maxSize, timeOut, maxTimeOut), new GeMoMaAnnotationFilter(), new AnnotationFinalizer(), new AnnotationEvidence(), new Attribute2Table(), new SyntenyChecker(), new AddAttribute(), new GAFComparison(), new Analyzer(), new BUSCORecomputer(), new GFFAttributes(), new TranscribedCluster()};
        boolean[] configureThreads = new boolean[tools.length];
        Arrays.fill(configureThreads, false);
        configureThreads[0] = true;
        if (args.length == 0) {
            System.out.print("version: 1.9");
            if (jarfile != null) {
                System.out.print(" (jar time stamp: " + new Date(jarfile.lastModified()) + ")");
            }
            System.out.println();
            System.out.println();
            System.out.println("If you like to run GeMoMa on the command line, you have to start with the tool with with first parameter \"CLI\":");
            System.out.println(" java -jar GeMoMa-1.9.jar CLI <input>");
            System.out.println("If you like to run GeMoMa in Galaxy, you need to start with the tool with:");
            System.out.println(" java -jar GeMoMa-1.9.jar <input>");
            System.out.println("If you like to receive some documentation as given in the wiki, you can start with the tool with:");
            System.out.println(" java -jar GeMoMa-1.9.jar wiki");
        } else if (args[0].equalsIgnoreCase("CLI") || args[0].equalsIgnoreCase("wiki")) {
            CLI cli = new CLI("This jar allows to run all parts of GeneModelMapper (GeMoMa) except the external search algorithm (e.g. tblastn).\n" + MORE.replaceAll("\\*\\*.*\\*\\*\n", "").replaceAll("\\*", "") + "\n\nIf you use this tool, please cite\n\n" + REF[0] + "\n" + REF[1], "CLI", configureThreads, tools);
            if (args[0].equalsIgnoreCase("CLI")) {
                String[] part = new String[args.length - 1];
                System.arraycopy(args, 1, part, 0, part.length);
                cli.run(part);
            } else {
                System.out.println("Creating help for wiki");
                StringBuffer sb = cli.wikiPage("GeMoMa-1.9.jar CLI");
                sb.insert(0, "== In a nutshell ==\n\nGeMoMa is a modular, homology-based gene prediction program with huge flexibility. However, we also provide a pipeline allowing to use GeMoMa easily. If you like to start GeMoMa for the first time, we recommend to use the GeMoMaPipeline like this\n java -jar GeMoMa-1.9.jar CLI GeMoMaPipeline threads=<threads> outdir=<outdir> GeMoMa.Score=ReAlign AnnotationFinalizer.r=NO o=true t=<target_genome> i=<reference_1_id> a=<reference_1_annotation> g=<reference_1_genome>\nthere are several parameters that need to be set indicated with '''&lt;'''foo'''&gt;'''. You can specify\n* the number of threads\n* the output directory\n* the target genome\n* and the reference ID (optional), annotation and genome. If you have several references just repeat <code>s=own</code> and the parameter tags <code>i</code>, <code>a</code>, <code>g</code> with the corresponding values.\nIn addition, we recommend to set several parameters:\n* <code>GeMoMa.Score=ReAlign</code>: states that the score from mmseqs should be recomputed as mmseqs uses an approximation\n* <code>AnnotationFinalizer.r=NO</code>: do not rename genes and transcripts\n* <code>o=true</code>: output individual predictions for each reference as a separate file allowing to rerun the combination step ('''GAF''') very easily and quickly\nIf you like to specify the maximum intron length please consider the parameters <code>GeMoMa.m</code> and <code>GeMoMa.sil</code>.\nIf you have RNA-seq data either from own experiments or publicly available data sets (cf. [https://www.ncbi.nlm.nih.gov/sra NCBI SRA], [https://www.ebi.ac.uk/ena EMBL-EBI ENA]), we recommend to use them. You need to map the data against the target genome with your favorite read mapper. In addition, we recommend to check the parameters of the section '''DenoiseIntrons'''.\n\n");
                FileManager.overwriteFile("gemoma-wiki.page", sb.toString().replaceAll(MORE, "").replace(" Here is an example\n\n+---+------------------------------+\n| I | ATT, ATC, ATA                |\n+---+------------------------------+\n| L | CTT, CTC, CTA, CTG, TTA, TTG |\n+---+------------------------------+\n| V | GTT, GTC, GTA, GTG           |\n+---+------------------------------+\n|...| ...                          |\n+---+------------------------------+", "").replace("c=<cds_parts>", "c=<cds_parts> a=<assignment>").replace("CLI GeMoMaPipeline t=", "CLI GeMoMaPipeline a=<reference_annotation> g=<reference_genome> t="));
            }
        } else {
            Galaxy galaxy = new Galaxy("", configureThreads, true, tools);
            galaxy.run(args);
        }
        tools[0].clear();
    }

    public static HashMap<String, int[][]> simplify(HashMap<String, ArrayList<int[]>> current) {
        Iterator<String> it = current.keySet().iterator();
        HashMap<String, int[][]> res = new HashMap<String, int[][]>();
        ArrayList<int[]> list = new ArrayList<int[]>();
        while (it.hasNext()) {
            String key = it.next();
            int[][] val = (int[][])current.get(key).toArray((T[])new int[0][]);
            Arrays.sort(val, IntArrayComparator.comparator[0]);
            int i = 0;
            list.clear();
            while (i < val.length) {
                int j = i + 1;
                int max = val[i][1];
                while (j < val.length && max >= val[j][0]) {
                    if (max < val[j][1]) {
                        max = val[j][1];
                    }
                    ++j;
                }
                if (j - i == 1) {
                    list.add(val[i]);
                } else {
                    int second = 0;
                    do {
                        int min = max;
                        int k = i;
                        while (k < j) {
                            if (val[k][2] > 0 && val[k][0] < min) {
                                min = val[k][0];
                            }
                            ++k;
                        }
                        second = max;
                        k = i;
                        while (k < j) {
                            if (val[k][2] > 0 && val[k][0] > min && val[k][0] < second) {
                                second = val[k][0] - 1;
                            }
                            if (val[k][2] > 0 && val[k][1] < second) {
                                second = val[k][1];
                            }
                            ++k;
                        }
                        int s = 0;
                        int k2 = i;
                        while (k2 < j) {
                            if (min == val[k2][0] && val[k2][1] >= second) {
                                s += val[k2][2];
                            }
                            ++k2;
                        }
                        list.add(new int[]{min, second, s});
                        k2 = i;
                        while (k2 < j) {
                            if (val[k2][0] == min && val[k2][1] >= second) {
                                val[k2][0] = second + 1;
                                if (val[k2][0] > val[k2][1]) {
                                    val[k2][2] = 0;
                                }
                            }
                            ++k2;
                        }
                    } while (second < max);
                }
                i = j;
            }
            res.put(key, (int[][])list.toArray((T[])new int[list.size()][]));
        }
        return res;
    }

    public static HashMap<String, int[][]> combine(boolean clone, HashMap<String, ArrayList<int[]>> basis, HashMap<String, ArrayList<int[]>> add) {
        for (String key : add.keySet()) {
            ArrayList<int[]> a = add.get(key);
            ArrayList<Object> b = basis.get(key);
            if (b == null) {
                b = new ArrayList();
                basis.put(key, b);
            }
            if (clone) {
                int i = 0;
                while (i < a.size()) {
                    b.add((int[])a.get(i).clone());
                    ++i;
                }
                continue;
            }
            b.addAll(a);
        }
        return GeMoMa.simplify(basis);
    }

    public static HashMap<String, int[][]>[] readCoverage(ExpandableParameterSet eps, Protocol protocol, boolean verbose, boolean check) throws IOException {
        HashMap[] coverage;
        HashMap[] initialCoverage = new HashMap[3];
        int i = 0;
        while (i < initialCoverage.length) {
            initialCoverage[i] = new HashMap();
            ++i;
        }
        int anz = 0;
        int u = 0;
        int i2 = 0;
        while (i2 < eps.getNumberOfParameters()) {
            ++anz;
            SimpleParameterSet sps = (SimpleParameterSet)eps.getParameterAt(i2).getValue();
            if ((sps = (SimpleParameterSet)sps.getParameterAt(0).getValue()).getNumberOfParameters() == 2) {
                GeMoMa.readCoverage(initialCoverage[0], sps.getParameterForName("coverage_forward").getValue().toString(), protocol, verbose);
                GeMoMa.readCoverage(initialCoverage[1], sps.getParameterForName("coverage_reverse").getValue().toString(), protocol, verbose);
            } else if (sps.getNumberOfParameters() == 1) {
                GeMoMa.readCoverage(initialCoverage[2], sps.getParameterForName("coverage_unstranded").getValue().toString(), protocol, verbose);
                ++u;
            } else {
                --anz;
            }
            ++i2;
        }
        if (anz > 0) {
            coverage = new HashMap[2];
            coverage[0] = GeMoMa.combine(true, initialCoverage[0], initialCoverage[2]);
            if (anz == u) {
                coverage[1] = coverage[0];
                if (check) {
                    GeMoMa.check(protocol, coverage[0], "coverage");
                }
            } else {
                coverage[1] = GeMoMa.combine(false, initialCoverage[1], initialCoverage[2]);
                if (check) {
                    GeMoMa.check(protocol, coverage[0], "forward coverage");
                    GeMoMa.check(protocol, coverage[1], "reverse coverage");
                }
            }
        } else {
            coverage = null;
        }
        return coverage;
    }

    public static void readCoverage(HashMap<String, ArrayList<int[]>> coverage, String fName, Protocol protocol, boolean verbose) throws IOException {
        String line;
        BufferedReader r = new BufferedReader(new FileReader(fName));
        int threshold = 1;
        String chr = null;
        ArrayList<Object> list = new ArrayList();
        int i = 0;
        while ((line = r.readLine()) != null) {
            if (i != 0 || !line.startsWith("track type=bedgraph")) {
                int reads;
                String[] split = line.split("\t");
                if (!(chr != null && split[0].equals(chr) || (list = coverage.get(chr = split[0])) != null)) {
                    list = new ArrayList();
                    coverage.put(chr, list);
                }
                try {
                    reads = Integer.parseInt(split[3]);
                }
                catch (Exception e) {
                    if (verbose) {
                        protocol.appendWarning("Could not parse number of reads. Set coverage to " + threshold + ". Line: " + line + "\n");
                    }
                    reads = threshold;
                }
                list.add(new int[]{Integer.parseInt(split[1]), Integer.parseInt(split[2]) - 1, reads});
            }
            ++i;
        }
        r.close();
    }

    public static HashMap<String, int[][][]>[] readIntrons(int threshold, Protocol protocol, boolean verbose, HashMap<String, String> seqs, HashMap<String, int[]> diNucl, String ... intronGFF) throws IOException {
        ArrayList[] h;
        HashMap<String, ArrayList[]> spliceHash = new HashMap<String, ArrayList[]>();
        String[] donor = null;
        String acceptor = null;
        int num = 0;
        Arrays.fill(count, 0);
        String[] stringArray = intronGFF;
        int n = intronGFF.length;
        int n2 = 0;
        while (n2 < n) {
            String line;
            String file = stringArray[n2];
            BufferedReader r = new BufferedReader(new FileReader(file));
            while ((line = r.readLine()) != null) {
                int reads;
                if (line.charAt(0) == '#') continue;
                String[] split = line.split("\t");
                try {
                    reads = Integer.parseInt(split[5]);
                }
                catch (NumberFormatException nfe) {
                    if (verbose) {
                        protocol.appendWarning("Could not parse number of reads. Set " + threshold + ": " + line + "\n");
                    }
                    reads = threshold;
                }
                h = (ArrayList[])spliceHash.get(split[0]);
                if (h == null) {
                    h = new ArrayList[]{new ArrayList(), new ArrayList()};
                    spliceHash.put(split[0], h);
                }
                int c = split[6].charAt(0);
                int a = Integer.parseInt(split[3]);
                int b = Integer.parseInt(split[4]);
                if (c == 46 || diNucl != null) {
                    String s;
                    if (donor == null) {
                        donor = new String[]{Tools.rc(DONOR[0]), Tools.rc(DONOR[1])};
                        acceptor = Tools.rc(ACCEPTOR);
                    }
                    if ((s = seqs.get(split[0])) == null) {
                        r.close();
                        throw new IllegalArgumentException("Did not find sequence " + split[0] + ", which should contain an intron");
                    }
                    String x = s.substring(a - 1, a + 1).toUpperCase();
                    String y = s.substring(b - 3, b - 1).toUpperCase();
                    if (c == 46) {
                        boolean bwd;
                        boolean fwd = (x.equals(DONOR[0]) || x.equals(DONOR[1])) && y.equals(ACCEPTOR);
                        boolean bl = bwd = (y.equals(donor[0]) || y.equals(donor[1])) && x.equals(acceptor);
                        if (fwd && !bwd) {
                            c = 43;
                        } else if (bwd && !fwd) {
                            c = 45;
                        }
                    }
                    if (diNucl != null) {
                        if (reads >= threshold) {
                            int[] v;
                            if (c == 45) {
                                String hh = Tools.rc(x);
                                x = Tools.rc(y);
                                y = hh;
                            }
                            if ((v = diNucl.get(String.valueOf(x) + "-" + y)) == null) {
                                v = new int[2];
                                diNucl.put(String.valueOf(x) + "-" + y, v);
                            }
                            v[0] = v[0] + 1;
                            v[1] = v[1] + reads;
                        }
                        ++num;
                    }
                }
                if (diNucl == null) {
                    if (c == 43 || c == 46) {
                        h[0].add(new int[]{a, b, reads});
                    }
                    if (c == 45 || c == 46) {
                        h[1].add(new int[]{b, a, reads});
                    }
                }
                switch (c) {
                    case 43: {
                        count[0] = count[0] + 1;
                        break;
                    }
                    case 45: {
                        count[1] = count[1] + 1;
                        break;
                    }
                    case 46: {
                        count[2] = count[2] + 1;
                    }
                }
            }
            r.close();
            ++n2;
        }
        HashMap<String, int[][][]> donorSites = new HashMap<String, int[][][]>();
        HashMap<String, int[][][]> acceptorSites = new HashMap<String, int[][][]>();
        for (Map.Entry e : spliceHash.entrySet()) {
            h = (ArrayList[])e.getValue();
            int[][][] help = new int[2][][];
            int k = 0;
            while (k < 2) {
                help[k] = new int[h[k].size()][3];
                int m = 0;
                while (m < h[k].size()) {
                    int[] site = (int[])h[k].get(m);
                    help[k][m][0] = site[0];
                    help[k][m][1] = site[1];
                    help[k][m][2] = site[2];
                    ++m;
                }
                ++k;
            }
            int[][][] x = GeMoMa.combineIntrons(help, 1, threshold);
            num += x[0][0].length + x[1][0].length;
            acceptorSites.put((String)e.getKey(), x);
            donorSites.put((String)e.getKey(), GeMoMa.combineIntrons(help, 0, threshold));
        }
        protocol.append("possible introns from RNA-seq (split reads>=" + threshold + "): " + num + "\n");
        protocol.append("+: " + count[0] + "\n");
        protocol.append("-: " + count[1] + "\n");
        protocol.append(".: " + count[2] + "\n");
        return new HashMap[]{donorSites, acceptorSites};
    }

    private static int[][][] combineIntrons(int[][][] help, int idx, int threshold) {
        LinkedList[] list = new LinkedList[2];
        int[][][] vals = new int[2][][];
        int k = 0;
        while (k < 2) {
            Arrays.sort(help[k], IntArrayComparator.comparator[idx]);
            list[k] = new LinkedList();
            int[] last = null;
            int m = 0;
            while (m < help[k].length) {
                if (last != null && help[k][m][0] == last[0] && help[k][m][1] == last[1]) {
                    last[2] = last[2] + help[k][m][2];
                } else {
                    if (list[k].size() > 0 && ((int[])list[k].getLast())[2] < threshold) {
                        list[k].removeLast();
                    }
                    last = (int[])help[k][m].clone();
                    list[k].add(last);
                }
                ++m;
            }
            if (list[k].size() > 0 && ((int[])list[k].getLast())[2] < threshold) {
                list[k].removeLast();
            }
            vals[k] = new int[3][list[k].size()];
            m = 0;
            while (m < list[k].size()) {
                last = (int[])list[k].get(m);
                vals[k][0][m] = last[0];
                vals[k][1][m] = last[1];
                vals[k][2][m] = last[2];
                ++m;
            }
            ++k;
        }
        return vals;
    }

    @Override
    public ToolResult run(ToolParameterSet parameters, Protocol protocol, ProgressUpdater progress, int threads, String temp) throws Exception {
        String problem;
        Exception e;
        ArrayList<TextResult> res;
        boolean okay;
        block42: {
            String[] split;
            boolean addStop;
            String line;
            this.timeOutWarning.delete(0, this.timeOutWarning.length());
            this.verbose = (Boolean)parameters.getParameterForName("verbose").getValue();
            if (seqs == null) {
                GeMoMa.fill(protocol, this.verbose, this.maxSize, (String)parameters.getParameterForName("target genome").getValue(), (String)parameters.getParameterForName("selected").getValue(), (Integer)parameters.getParameterForName("reads").getValue(), (ExpandableParameterSet)((ParameterSetContainer)parameters.getParameterForName("introns")).getValue(), (ExpandableParameterSet)((ParameterSetContainer)parameters.getParameterForName("coverage")).getValue());
            } else {
                protocol.append("Using pre-set values.\n");
            }
            BufferedReader r = null;
            String assignment = (String)parameters.getParameterForName("assignment").getValue();
            String searchFile = (String)parameters.getParameterForName("search results").getValue();
            File search = (Boolean)parameters.getParameterForName("sort").getValue() != false ? Tools.externalSort(searchFile, 500000, 1, protocol, assignment != null)[0] : new File(searchFile);
            this.MAX_INTRON_LENGTH = (Integer)parameters.getParameterForName("maximum intron length").getValue();
            boolean staticIntronLength = (Boolean)parameters.getParameterForName("static intron length").getValue();
            this.REDUCTION_FACTOR = (Integer)this.getParameter(parameters, "reduction factor").getValue();
            this.eValue = (Double)parameters.getParameterForName("e-value").getValue();
            this.contigThreshold = (Double)parameters.getParameterForName("contig threshold").getValue();
            this.hitThreshold = (Double)parameters.getParameterForName("hit threshold").getValue();
            this.factor = -1.0;
            this.predictions = -1;
            Parameter p = parameters.getParameterForName("output");
            if (p instanceof SimpleParameter) {
                this.predictions = (Integer)p.getValue();
            } else if ((p = ((SimpleParameterSet)((SelectionParameter)p).getValue()).getParameterAt(0)).getName().equals("factor")) {
                this.factor = (Double)p.getValue();
            } else {
                this.predictions = (Integer)p.getValue();
            }
            this.gapOpening = (Integer)parameters.getParameterForName("gap opening").getValue();
            this.gapExtension = (Integer)parameters.getParameterForName("gap extension").getValue();
            this.INTRON_GAIN_LOSS = (Integer)parameters.getParameterForName("intron-loss-gain-penalty").getValue();
            this.avoidPrematureStop = (Boolean)parameters.getParameterForName("avoid stop").getValue();
            this.approx = (Boolean)parameters.getParameterForName("approx").getValue();
            this.prefix = (String)parameters.getParameterForName("prefix").getValue();
            this.tag = (String)parameters.getParameterForName("tag").getValue();
            this.timeOut = (Long)parameters.getParameterForName("timeout").getValue();
            this.proteinAlignment = (Boolean)parameters.getParameterForName("protein alignment").getValue();
            Score score = (Score)((Object)parameters.getParameterForName("Score").getValue());
            r = new BufferedReader(new InputStreamReader(Tools.getInputStream(parameters.getParameterForName("substitution matrix"), "projects/gemoma/test_data/BLOSUM62.txt")));
            while ((line = r.readLine()) != null && line.charAt(0) == '#') {
            }
            String[] abc = line.split("\\s+");
            String[] abc2 = new String[abc.length - 1];
            System.arraycopy(abc, 1, abc2, 0, abc2.length);
            int i = 0;
            while (i < abc2.length && !abc2[i].equals("*")) {
                ++i;
            }
            boolean bl = addStop = i == abc2.length;
            if (addStop) {
                String[] h = new String[abc2.length + 1];
                System.arraycopy(abc2, 0, h, 0, abc2.length);
                h[abc2.length] = "*";
                abc2 = h;
            }
            this.aaAlphabet = new DiscreteAlphabet(true, abc2);
            p = parameters.getParameterForName("replace unknown");
            this.unknown = p != null && (Boolean)p.getValue() != false ? Character.valueOf('X') : null;
            this.alph = new AlphabetContainer((Alphabet)this.aaAlphabet);
            this.matrix = new double[abc2.length][abc2.length];
            int j = 0;
            while ((line = r.readLine()) != null) {
                split = line.split("\\s+");
                int k = 1;
                while (k < split.length) {
                    this.matrix[j][k - 1] = -Double.parseDouble(split[k]);
                    ++k;
                }
                ++j;
            }
            r.close();
            if (addStop) {
                i = 0;
                while (i < abc2.length - 1) {
                    this.matrix[i][abc2.length - 1] = 4.0;
                    ++i;
                }
                Arrays.fill(this.matrix[abc2.length - 1], 4.0);
                this.matrix[abc2.length - 1][abc2.length - 1] = -1.0;
                protocol.append("Expand substitution matrix: Use default costs for *\n");
            }
            this.cost = new AffineCosts(this.gapOpening, new MatrixCosts(this.matrix, this.gapExtension));
            if (assignment != null) {
                this.transcriptInfo = new HashMap();
                r = new BufferedReader(new FileReader(assignment));
                while ((line = r.readLine()) != null) {
                    if (line.length() <= 0 || line.charAt(0) == '#') continue;
                    split = line.split("\t");
                    HashMap<String, Info> c = this.transcriptInfo.get(split[0]);
                    if (c == null) {
                        c = new HashMap();
                        this.transcriptInfo.put(split[0], c);
                    }
                    c.put(split[1], new Info(split[2], split[3], split.length >= 12 ? split[11] : "", split[9], this.aaAlphabet));
                }
                r.close();
                progress.setLast(this.transcriptInfo.size());
                progress.setCurrent(0.0);
            } else {
                progress.setIndeterminate();
                this.transcriptInfo = null;
            }
            this.cds = Tools.getFasta((String)parameters.getParameterForName("cds parts").getValue(), 15000);
            protocol.append("CDS: " + this.cds.size() + " / " + (this.transcriptInfo == null ? this.cds.size() : this.transcriptInfo.size()) + "\n");
            code = Tools.getCode(Tools.getInputStream(parameters.getParameterForName("genetic code"), "projects/gemoma/test_data/genetic_code.txt"));
            code.put("NNN", Character.valueOf('X'));
            if (selected != null) {
                progress.setLast(selected.size());
            }
            if (donorSites != null) {
                this.sp = (Boolean)parameters.getParameterForName("splice").getValue();
            }
            okay = true;
            res = new ArrayList<TextResult>();
            e = null;
            TranscriptPredictor tp = new TranscriptPredictor(true, parameters, temp);
            problem = null;
            String old = null;
            try {
                try {
                    r = new BufferedReader(new FileReader(search));
                    protocol.append(String.valueOf(this.getHeading()) + "\n");
                    this.noL = 0;
                    HashMap<String, HashMap<Integer, ArrayList<Hit>>[]> hash = new HashMap<String, HashMap<Integer, ArrayList<Hit>>[]>();
                    HashSet<String> used = new HashSet<String>();
                    while ((line = r.readLine()) != null) {
                        if (line.length() <= 0) continue;
                        if (old == null || !line.startsWith(old)) {
                            if (old != null) {
                                tp.numberOfLines = this.noL;
                                progress.add(tp.compute(old, hash, staticIntronLength));
                                protocol.append(tp.protocol.toString());
                                this.noL = 0;
                                hash.clear();
                            }
                            old = line.substring(0, line.indexOf(9));
                            old = this.transcriptInfo != null ? old.substring(0, old.lastIndexOf(95) + 1) : String.valueOf(old) + "\t";
                            if (used.contains(old)) {
                                throw new Exception("The search results seem to be unsorted. ID " + old + " has been seen before.");
                            }
                            used.add(old);
                        }
                        this.addHit(hash, line, score, tp);
                    }
                    if (old != null) {
                        tp.numberOfLines = this.noL;
                        progress.add(tp.compute(old, hash, staticIntronLength));
                        protocol.append(tp.protocol.toString());
                    }
                }
                catch (Throwable er) {
                    protocol.appendThrowable(er);
                    if (er instanceof Exception) {
                        e = (Exception)er;
                    } else {
                        e = new Exception("Forwarding " + er.getClass().getName() + ": " + er.getMessage());
                        e.setStackTrace(er.getStackTrace());
                    }
                    okay = false;
                    problem = old;
                    tp.gff.close();
                    if (this.timeOutWarning.length() > 0) {
                        protocol.append("\ntime-out warning: " + this.timeOutWarning);
                    }
                    if (okay) {
                        String gff = tp.gffFile.getAbsolutePath();
                        res.add(new TextResult(DEF_RES, "Result", new FileParameter.FileRepresentation(gff), "gff", this.getToolName(), null, true));
                    }
                    if (r != null) {
                        r.close();
                    }
                    tp.close();
                    break block42;
                }
            }
            catch (Throwable throwable) {
                tp.gff.close();
                if (this.timeOutWarning.length() > 0) {
                    protocol.append("\ntime-out warning: " + this.timeOutWarning);
                }
                if (okay) {
                    String gff = tp.gffFile.getAbsolutePath();
                    res.add(new TextResult(DEF_RES, "Result", new FileParameter.FileRepresentation(gff), "gff", this.getToolName(), null, true));
                }
                if (r != null) {
                    r.close();
                }
                tp.close();
                throw throwable;
            }
            tp.gff.close();
            if (this.timeOutWarning.length() > 0) {
                protocol.append("\ntime-out warning: " + this.timeOutWarning);
            }
            if (okay) {
                String gff = tp.gffFile.getAbsolutePath();
                res.add(new TextResult(DEF_RES, "Result", new FileParameter.FileRepresentation(gff), "gff", this.getToolName(), null, true));
            }
            if (r != null) {
                r.close();
            }
            tp.close();
        }
        if (okay) {
            return new ToolResult("", "", null, new ResultSet(res), parameters, this.getToolName(), new Date());
        }
        if (problem != null && !(e instanceof InterruptedException)) {
            System.err.println("\nProblem while gene: " + problem);
        }
        throw e;
    }

    private double rescore(String a1, String a2, DiscreteAlphabet abc, double[][] matrix, double gapOpen, double gapExtend) throws WrongAlphabetException, WrongLengthException {
        if (a1.length() != a2.length()) {
            throw new WrongLengthException("aligned sequences need to have the same length");
        }
        int i = 0;
        double score = 0.0;
        do {
            int start;
            if (a1.charAt(i) == '-') {
                start = i;
                while (++i < a1.length() && a1.charAt(i) == '-') {
                }
                score += gapOpen + gapExtend * (double)(i - start);
                continue;
            }
            if (a2.charAt(i) == '-') {
                start = i;
                while (++i < a2.length() && a2.charAt(i) == '-') {
                }
                score += gapOpen + gapExtend * (double)(i - start);
                continue;
            }
            score += matrix[abc.getCode(a1.substring(i, i + 1))][abc.getCode(a2.substring(i, i + 1))];
            ++i;
        } while (i < a1.length());
        return -score;
    }

    void addHit(HashMap<String, HashMap<Integer, ArrayList<Hit>>[]> hash, String line, Score score, TranscriptPredictor tp) throws WrongAlphabetException, WrongLengthException {
        Object[] split = line.split("\t");
        if (!seqs.containsKey(split[1])) {
            throw new IllegalArgumentException("There is no sequence with sequence ID " + split[1] + " in the target genome.");
        }
        try {
            Integer part;
            int idx;
            ArrayList<Hit> lines;
            if (Double.parseDouble(split[10]) > this.eValue) {
                return;
            }
            boolean forward = Integer.parseInt(split[8]) < Integer.parseInt((String)split[9]);
            HashMap<Integer, ArrayList<Hit>>[] current = hash.get(split[1]);
            if (current == null) {
                current = new HashMap[]{new HashMap(), new HashMap()};
                hash.put((String)split[1], current);
            }
            if ((lines = current[idx = forward ? 0 : 1].get(part = Integer.valueOf(this.transcriptInfo == null ? 0 : new Integer(((String)split[0]).substring(1 + ((String)split[0]).lastIndexOf("_")))))) == null) {
                lines = new ArrayList();
                current[idx].put(part, lines);
            }
            int s = Integer.parseInt((String)split[13]);
            Object queryAlign = split[20];
            Object targetAlign = split[21];
            if (this.unknown != null) {
                queryAlign = this.replace((String)queryAlign);
                targetAlign = this.replace((String)targetAlign);
            }
            switch (score) {
                case Trust: {
                    break;
                }
                case ReScore: {
                    s = (int)this.rescore((String)queryAlign, (String)targetAlign, this.aaAlphabet, this.matrix, this.gapOpening, this.gapExtension);
                    break;
                }
                case ReAlign: {
                    Sequence q = Sequence.create(this.alph, ((String)queryAlign).replaceAll("-", ""));
                    Sequence t = Sequence.create(this.alph, ((String)targetAlign).replaceAll("-", ""));
                    PairwiseStringAlignment sa = tp.align.getAlignment(Alignment.AlignmentType.GLOBAL, q, t);
                    queryAlign = sa.getAlignedString(0);
                    targetAlign = sa.getAlignedString(1);
                    s = -((int)sa.getCost());
                    break;
                }
                default: {
                    throw new IllegalArgumentException(score.name());
                }
            }
            Hit h = new Hit((String)split[0], (String)split[1], Integer.parseInt((String)split[6]), Integer.parseInt((String)split[7]), Integer.parseInt((String)split[22]), Integer.parseInt((String)split[8]), Integer.parseInt((String)split[9]), s, (String)queryAlign, (String)targetAlign, "search algorithm;");
            lines.add(h);
            ++this.noL;
        }
        catch (ArrayIndexOutOfBoundsException aiobe) {
            ArrayIndexOutOfBoundsException moreDetails = new ArrayIndexOutOfBoundsException("Please check the search algorithm input. It seems to have less columns than expected.\nline: " + line + "\nsplit: " + Arrays.toString(split) + "\noriginal message: " + aiobe.getMessage() + "\n");
            moreDetails.setStackTrace(aiobe.getStackTrace());
            throw moreDetails;
        }
    }

    String replace(String s) {
        char[] c = s.toCharArray();
        int anz = 0;
        int i = 0;
        while (i < c.length) {
            if (c[i] != '-' && !this.aaAlphabet.isSymbol("" + c[i])) {
                c[i] = this.unknown.charValue();
                ++anz;
            }
            ++i;
        }
        return anz == 0 ? s : new String(c);
    }

    private int getGapLength(String s) {
        int g = 0;
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == '-') {
                ++g;
            }
            ++i;
        }
        return g;
    }

    private int getScore(String s1, String s2) throws WrongAlphabetException {
        int res = 0;
        int gap = -1;
        int i = 0;
        while (i < s1.length()) {
            char c1 = s1.charAt(i);
            char c2 = s2.charAt(i);
            if (c1 != '-' && c2 != '-') {
                res = (int)((double)res + this.matrix[this.aaAlphabet.getCode("" + c1)][this.aaAlphabet.getCode("" + c2)]);
                gap = -1;
            } else {
                if (gap == -1 || gap == 1 && c2 == '-' || gap == 2 && c1 == '-') {
                    res += this.gapOpening;
                    gap = c1 == '-' ? 1 : 2;
                }
                res += this.gapExtension;
            }
            ++i;
        }
        return -res;
    }

    @Override
    public ToolParameterSet getToolParameters() {
        try {
            return new ToolParameterSet(this.getShortName(), new FileParameter("search results", "The search results, e.g., from tblastn or mmseqs", "tabular", true, new FileExistsValidator()), new FileParameter("target genome", "The target genome file (FASTA), i.e., the target sequences in the blast run. Should be in IUPAC code", "fasta,fas,fa,fna,fasta.gz,fas.gz,fa.gz,fna.gz", true, new FileExistsValidator(), true), new FileParameter("cds parts", "The query CDS parts file (protein FASTA), i.e., the CDS parts that have been searched in the target genome using for instance BLAST or mmseqs", "fasta,fa,fas,fna", true, new FileExistsValidator(), true), new FileParameter("assignment", "The assignment file, which combines CDS parts to proteins", "tabular", false, new FileExistsValidator()), new ParameterSetContainer("introns", "", new ExpandableParameterSet(new SimpleParameterSet(new FileParameter("introns", "Introns (GFF), which might be obtained from RNA-seq", "gff,gff3", true, new FileExistsValidator(), true)), "introns", "", 0)), new SimpleParameter(DataType.INT, "reads", "if introns are given by a GFF, only use those which have at least this number of supporting split reads", true, new NumberValidator<Integer>(1, Integer.MAX_VALUE), 1), new SimpleParameter(DataType.BOOLEAN, "splice", "if no intron is given by RNA-seq, compute candidate splice sites or not", true, true), new ParameterSetContainer("coverage", "", new ExpandableParameterSet(new SimpleParameterSet(new SelectionParameter(DataType.PARAMETERSET, new String[]{"UNSTRANDED", "STRANDED"}, new Object[]{new SimpleParameterSet(new FileParameter("coverage_unstranded", "The coverage file contains the unstranded coverage of the genome per interval. Intervals with coverage 0 (zero) can be left out.", "bedgraph", true, new FileExistsValidator(), true)), new SimpleParameterSet(new FileParameter("coverage_forward", "The coverage file contains the forward coverage of the genome per interval. Intervals with coverage 0 (zero) can be left out.", "bedgraph", true, new FileExistsValidator(), true), new FileParameter("coverage_reverse", "The coverage file contains the reverse coverage of the genome per interval. Intervals with coverage 0 (zero) can be left out.", "bedgraph", true, new FileExistsValidator(), true))}, "coverage", "experimental coverage (RNA-seq)", true)), "coverage", "", 0)), new FileParameter("genetic code", "optional user-specified genetic code", "tabular", false, new FileExistsValidator()), new FileParameter("substitution matrix", "optional user-specified substitution matrix", "tabular", false, new FileExistsValidator()), new SimpleParameter(DataType.INT, "gap opening", "The gap opening cost in the alignment", true, 11), new SimpleParameter(DataType.INT, "gap extension", "The gap extension cost in the alignment", true, 1), new SimpleParameter(DataType.INT, "maximum intron length", "The maximum length of an intron", true, 15000), new SimpleParameter(DataType.BOOLEAN, "static intron length", "A flag which allows to switch between static intron length, which can be specified by the user and is identical for all genes, and dynamic intron length, which is based on the gene-specific maximum intron length in the reference organism plus the user given maximum intron length", true, true), new SimpleParameter(DataType.INT, "intron-loss-gain-penalty", "The penalty used for intron loss and gain", true, 25), new SimpleParameter(DataType.INT, "reduction factor", "Factor for reducing the allowed intron length when searching for missing marginal exons", true, new NumberValidator<Integer>(1, 100), 10), new SimpleParameter(DataType.DOUBLE, "e-value", "The e-value for filtering blast results", true, 100.0), new SimpleParameter(DataType.DOUBLE, "contig threshold", "The threshold for evaluating contigs", true, new NumberValidator<Double>(0.0, 1.0), 0.4), new SimpleParameter(DataType.DOUBLE, "hit threshold", "The threshold for adding additional hits", true, new NumberValidator<Double>(0.0, 1.0), 0.9), new SelectionParameter(DataType.PARAMETERSET, new String[]{"STATIC", "DYNAMIC"}, new Object[]{new SimpleParameterSet(new SimpleParameter(DataType.INT, "predictions", "The (maximal) number of predictions per transcript", true, 10)), new SimpleParameterSet(new SimpleParameter(DataType.DOUBLE, "factor", "a prediction is used if: score >= factor*Math.max(0,bestScore)", true, new NumberValidator<Double>(0.0, 1.0), 0.8))}, "output", "critierium to determine the number of predictions per reference transcript", true), new FileParameter("selected", "The path to list file, which allows to make only a predictions for the contained transcript ids. The first column should contain transcript IDs as given in the annotation. Remaining columns can be used to determine a target region that should be overlapped by the prediction, if columns 2 to 5 contain chromosome, strand, start and end of region", "tabular,txt", this.maxSize > -1, new FileExistsValidator()), new SimpleParameter(DataType.BOOLEAN, "avoid stop", "A flag which allows to avoid (additional) pre-mature stop codons in a transcript", true, true), new SimpleParameter(DataType.BOOLEAN, "approx", "whether an approximation is used to compute the score for intron gain", true, true), new SimpleParameter(DataType.BOOLEAN, "protein alignment", "whether a protein alignment between the prediction and the reference transcript should be computed. If so two additional attributes (iAA, pAA) will be added to predictions in the gff output. These might be used in GAF. However, since some transcripts are very long this can increase the needed runtime and memory (RAM).", true, true), new SimpleParameter(DataType.STRING, "prefix", "A prefix to be used for naming the predictions", true, ""), new SimpleParameter(DataType.STRING, "tag", "A user-specified tag for transcript predictions in the third column of the returned gff. It might be beneficial to set this to a specific value for some genome browsers.", true, TAG), new SimpleParameter(DataType.BOOLEAN, "verbose", "A flag which allows to output a wealth of additional information per transcript", true, false), new SimpleParameter(DataType.LONG, "timeout", "The (maximal) number of seconds to be used for the predictions of one transcript, if exceeded GeMoMa does not output a prediction for this transcript.", true, new NumberValidator<Long>(0L, this.maxTimeOut), this.timeOut), new SimpleParameter(DataType.BOOLEAN, "sort", "A flag which allows to sort the search results", true, false), new SimpleParameter(DataType.BOOLEAN, "replace unknown", "Replace unknown amino acid symbols by X", true, false), new EnumParameter(Score.class, "A flag which allows to do nothing, re-score or re-align the search results", true, "Trust"));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }

    @Override
    public String getToolName() {
        return "GeneModelMapper";
    }

    @Override
    public String getShortName() {
        return "GeMoMa";
    }

    @Override
    public String getDescription() {
        return "builds gene models from search results";
    }

    @Override
    public String getHelpText() {
        return "This tool is the main part of, a homology-based gene prediction tool. GeMoMa builds gene models from search results (e.g. tblastn or mmseqs).\n\nAs first step, you should run **Extractor** obtaining *cds parts* and *assignment*. Second, you should run a search algorithm, e.g. **tblastn** or **mmseqs**, with *cds parts* as query. Finally, these search results are then used in **GeMoMa**. Search results should be clustered according to the reference genes. The most easiest way is to sort the search results accoring to the first column. If the search results are not sorted by default (e.g. mmseqs), you should the parameter *sort*.\nIf you like to run GeMoMa ignoring intron position conservation, you should blast protein sequences and feed the results in *query cds parts* and leave *assignment* unselected.\n\nIf you like to run GeMoMa using RNA-seq evidence, you should map your RNA-seq reads to the genome and run **ERE** on the mapped reads. For several reasons, spurious introns can be extracted from RNA-seq data. Hence, we recommend to run **DenoiseIntrons** to remove such spurious introns. Finally, you can use the obtained *introns* (and *coverage*) in GeMoMa.\n\nIf you like to obtain multiple predictions per gene model of the reference organism, you should set *predictions* accordingly. In addition, we suggest to decrease the value of *contig threshold* allowing GeMoMa to evaluate more candidate contigs/chromosomes.\n\nIf you change the values of *contig threshold*, *region threshold* and *hit threshold*, this will influence the predictions as well as the runtime of the algorithm. The lower the values are, the slower the algorithm is.\n\nYou can filter your predictions using **GAF**, which also allows for combining predictions from different reference organismns.\n\nFinally, you can predict UTRs and rename predictions using **AnnotationFinalizer**.\n\nIf you like to run the complete GeMoMa pipeline and not only specific module, you can run the multi-threaded module **GeMoMaPipeline**." + MORE;
    }

    @Override
    public JstacsTool.ResultEntry[] getDefaultResultInfos() {
        return new JstacsTool.ResultEntry[]{new JstacsTool.ResultEntry(TextResult.class, "gff", DEF_RES)};
    }

    @Override
    public ToolResult[] getTestCases(String path) {
        try {
            return new ToolResult[]{new ToolResult(FileManager.readFile(String.valueOf(path) + File.separator + "tests/gemoma/xml/gemoma-test.xml"))};
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private class Hit
    implements Cloneable {
        boolean forward;
        String queryID;
        String targetID;
        int queryStart;
        int queryEnd;
        int targetStart;
        int targetEnd;
        int queryLength;
        String queryAlign;
        String targetAlign;
        int score;
        int part;
        int firstOffset;
        int lastOffset;
        int firstAddScore;
        int lastAddScore;
        String info;
        StringBuffer up;
        StringBuffer down;
        StringBuffer seqUp;
        StringBuffer seqDown;
        int maxUpstreamStart;
        int maxDownstreamEnd;
        IntList[] accCand;
        IntList[] accCandScore;
        IntList[][] donCand;
        IntList[][] donCandScore;
        boolean border;
        boolean splice;
        boolean de;
        boolean ae;
        char firstAA;
        int phase;

        private Hit(String queryID, String targetID, int queryStart, int queryEnd, int queryLength, int blastTargetStart, int blastTargetEnd, int score, String queryAlign, String targetAlign, String info) {
            this.queryID = queryID;
            this.targetID = targetID;
            this.part = GeMoMa.this.transcriptInfo == null ? 0 : Integer.parseInt(queryID.substring(queryID.lastIndexOf(95) + 1));
            this.queryStart = queryStart;
            this.queryEnd = queryEnd;
            this.queryLength = queryLength;
            this.targetStart = blastTargetStart;
            this.targetEnd = blastTargetEnd;
            this.score = score;
            this.queryAlign = queryAlign;
            this.targetAlign = targetAlign.replaceAll("[BJZ]", "X");
            this.info = info;
            boolean bl = this.forward = blastTargetStart < blastTargetEnd;
            if (!this.forward) {
                int h = this.targetEnd;
                this.targetEnd = this.targetStart;
                this.targetStart = h;
            }
            this.accCand = null;
            this.donCand = null;
            this.accCandScore = null;
            this.donCandScore = null;
            this.maxDownstreamEnd = Integer.MIN_VALUE;
            this.maxUpstreamStart = Integer.MIN_VALUE;
            this.lastOffset = 0;
            this.firstOffset = 0;
            this.lastAddScore = 0;
            this.firstAddScore = 0;
            this.seqUp = new StringBuffer();
            this.seqDown = new StringBuffer();
            this.splice = false;
            this.border = false;
            this.ae = false;
            this.de = false;
        }

        public Hit clone() throws CloneNotSupportedException {
            Hit clone = (Hit)super.clone();
            clone.accCand = (IntList[])ArrayHandler.clone((Cloneable[])this.accCand);
            clone.donCand = (IntList[][])ArrayHandler.clone((Cloneable[])this.donCand);
            clone.accCandScore = (IntList[])ArrayHandler.clone((Cloneable[])this.accCandScore);
            clone.donCandScore = (IntList[][])ArrayHandler.clone((Cloneable[])this.donCandScore);
            clone.up = this.up == null ? null : new StringBuffer(this.up);
            clone.down = this.down == null ? null : new StringBuffer(this.down);
            clone.seqUp = this.seqUp == null ? null : new StringBuffer(this.seqUp);
            clone.seqDown = this.seqDown == null ? null : new StringBuffer(this.seqDown);
            return clone;
        }

        public String toString() {
            return String.valueOf(this.queryID) + "\t" + this.targetID + "\t" + (this.forward ? "+" : "-") + "\t" + this.queryStart + "\t" + this.queryEnd + "\t" + this.queryLength + "\t" + this.targetStart + "\t" + this.targetEnd + "\t" + this.score + "\t" + this.queryAlign + "\t" + this.targetAlign + "\t" + this.info;
        }

        /*
         * Unable to fully structure code
         */
        public void addSplitHits(ArrayList<Hit> add) throws WrongAlphabetException {
            idx = -1;
            old = 0;
            qStart = this.queryStart;
            tStart = this.forward != false ? this.targetStart : this.targetEnd;
            v0 = factor = this.forward != false ? 1 : -1;
            while (true) {
                block13: {
                    block14: {
                        block12: {
                            if ((idx = this.targetAlign.indexOf(42, idx + 1)) >= 0 && this.queryAlign.charAt(idx) == '*') {
                                continue;
                            }
                            b = 0;
                            a = 0;
                            if (idx < 0) {
                                if (old == 0) {
                                    add.add(this);
                                    return;
                                }
                                f = this.targetAlign.length();
                            } else {
                                f = idx;
                                if (this.queryAlign.charAt(idx) == '-') {
                                    a = 1;
                                    b = 0;
                                } else {
                                    b = 1;
                                    a = 1;
                                }
                            }
                            t = this.targetAlign.substring(old, f);
                            q = this.queryAlign.substring(old, f);
                            off1 = 0;
                            oq1 = 0;
                            while (off1 < t.length() && (t.charAt(off1) == '-' || q.charAt(off1) == '-')) {
                                if (q.charAt(off1) == '-') {
                                    ++oq1;
                                }
                                ++off1;
                            }
                            if (off1 != t.length()) break block12;
                            qg = GeMoMa.access$1(GeMoMa.this, q);
                            tg = GeMoMa.access$1(GeMoMa.this, t);
                            qStart += q.length() - qg + b;
                            tStart += factor * 3 * (t.length() - tg + a);
                            break block13;
                        }
                        off2 = t.length() - 1;
                        oq2 = 0;
                        n = 0;
                        if (off1 != t.length()) ** GOTO lbl51
                        off2 = 0;
                        break block14;
lbl-1000:
                        // 1 sources

                        {
                            if (q.charAt(off2) == '-') {
                                ++oq2;
                            }
                            ++n;
                            --off2;
lbl51:
                            // 2 sources

                            ** while (off2 >= 0 && (t.charAt((int)off2) == '-' || q.charAt((int)off2) == '-'))
                        }
lbl52:
                        // 1 sources

                        ++off2;
                    }
                    q = q.substring(off1, off2);
                    t = t.substring(off1, off2);
                    sc = GeMoMa.access$2(GeMoMa.this, q, t);
                    qg = GeMoMa.access$1(GeMoMa.this, q);
                    tg = GeMoMa.access$1(GeMoMa.this, t);
                    tS = tStart + factor * 3 * oq1;
                    if (sc > 0) {
                        h = new Hit(this.queryID, this.targetID, qStart + (off1 - oq1), qStart + (off1 - oq1) + q.length() - qg - 1, this.queryLength, tS, tS + factor * (3 * (t.length() - tg) - 1), sc, q, t, String.valueOf(this.info) + "split by '*';");
                        add.add(h);
                    }
                    qStart += off1 - oq1 + q.length() - qg + (n - oq2) + b;
                    tStart += factor * 3 * (oq1 + t.length() - tg + oq2 + a);
                }
                old = f + 1;
                if (idx < 0) break;
            }
        }

        public void prepareSpliceCandidates(String chr, MyAlignment align, int maxAllowedIntron) throws CloneNotSupportedException, WrongAlphabetException {
            if (!this.splice) {
                int i;
                int p;
                int i2;
                Sequence tPart;
                Sequence qPart;
                int add;
                if (this.accCand == null) {
                    this.accCand = (IntList[])ArrayHandler.createArrayOf((Cloneable)new IntList(), (int)3);
                    this.accCandScore = (IntList[])ArrayHandler.createArrayOf((Cloneable)new IntList(), (int)3);
                    this.donCand = new IntList[2][];
                    this.donCandScore = new IntList[2][];
                }
                int l = Math.abs(this.targetStart - 1 - this.targetEnd);
                int t = 90;
                int eDon = 0;
                int eAcc = 0;
                if (l / 3 < t) {
                    add = l / 3;
                    add -= add % 3;
                } else {
                    add = t;
                }
                String a = this.targetAlign.replaceAll("-", "");
                this.up = new StringBuffer();
                Tools.getMaximalExtension(chr, this.forward, false, this.forward ? -1 : 1, this.forward ? this.targetStart + add - 1 : this.targetEnd - add, '*', '*', this.seqUp, this.up, a.substring(0, add / 3), eAcc, intronic[1] - 1, maxAllowedIntron, code);
                int s = this.seqUp.length() - add - eAcc;
                this.maxUpstreamStart = this.forward ? this.targetStart - s + intronic[1] : this.targetEnd + s - intronic[1];
                this.up = this.up.delete(this.up.length() - add / 3, this.up.length());
                int anz = this.getExperimentalCandidates(acceptorSites, 1, this.accCand, add, false, this.maxUpstreamStart);
                boolean bl = this.ae = anz > 0;
                if (acceptorSites == null || GeMoMa.this.sp && anz == 0) {
                    this.getCanonincalCandidates(this.seqUp, this.accCand, GeMoMa.ACCEPTOR, true, true, s);
                }
                int max = Integer.MIN_VALUE;
                int p2 = 0;
                while (p2 < 3) {
                    int i3 = 0;
                    while (i3 < this.accCand[p2].length()) {
                        max = Math.max(max, this.accCand[p2].get(i3));
                        ++i3;
                    }
                    ++p2;
                }
                String query = (String)GeMoMa.this.cds.get(this.queryID);
                if (max > Integer.MIN_VALUE) {
                    qPart = Sequence.create(GeMoMa.this.alph, query.substring(0, this.queryEnd));
                    if (max > 0) {
                        max = (int)Math.floor((double)max / 3.0);
                        tPart = Sequence.create(GeMoMa.this.alph, String.valueOf(this.up.substring(this.up.length() - max)) + a);
                    } else {
                        max = -((int)Math.ceil((double)(-max) / 3.0));
                        tPart = Sequence.create(GeMoMa.this.alph, a.substring(-max));
                    }
                    try {
                        qPart = qPart.reverse();
                        tPart = tPart.reverse();
                    }
                    catch (OperationNotSupportedException onse) {
                        throw new RuntimeException(onse.getMessage());
                    }
                    align.computeAlignment(Alignment.AlignmentType.GLOBAL, qPart, tPart);
                    int p3 = 0;
                    while (p3 < 3) {
                        i2 = 0;
                        while (i2 < this.accCand[p3].length()) {
                            int pos = this.accCand[p3].get(i2);
                            pos = pos > 0 ? (int)Math.floor((double)pos / 3.0) : -((int)Math.ceil((double)(-pos) / 3.0));
                            pos = tPart.getLength() - (max - pos);
                            this.accCandScore[p3].add((int)(-align.getCost(qPart.getLength(), pos)) - this.score);
                            ++i2;
                        }
                        ++p3;
                    }
                }
                this.down = new StringBuffer();
                Tools.getMaximalExtension(chr, this.forward, true, this.forward ? 1 : -1, this.forward ? this.targetEnd - add : this.targetStart + add - 1, '*', '*', this.seqDown, this.down, a.substring(a.length() - add / 3), eDon, intronic[0] - 1, maxAllowedIntron, code);
                s = add + eDon;
                this.maxDownstreamEnd = this.forward ? this.targetEnd + this.seqDown.length() - s - intronic[0] : this.targetStart - this.seqDown.length() + s + intronic[0];
                this.down = this.down.delete(0, add / 3);
                int m = 0;
                m = 0;
                while (m < this.donCand.length) {
                    this.donCand[m] = (IntList[])ArrayHandler.createArrayOf((Cloneable)new IntList(), (int)3);
                    this.donCandScore[m] = (IntList[])ArrayHandler.createArrayOf((Cloneable)new IntList(), (int)3);
                    ++m;
                }
                anz = this.getExperimentalCandidates(donorSites, 0, this.donCand[0], add, true, this.maxDownstreamEnd);
                boolean bl2 = this.de = anz > 0;
                if (donorSites == null || GeMoMa.this.sp && anz == 0) {
                    m = 0;
                    while (m < DONOR.length) {
                        this.getCanonincalCandidates(this.seqDown, this.donCand[m], DONOR[m], false, false, s);
                        ++m;
                    }
                    i2 = 0;
                    while (i2 < 3) {
                        if (add + i2 + 2 <= this.seqDown.length() && this.seqDown.substring(add + i2, add + i2 + 2).equals(DONOR[1])) {
                            this.donCand[0][i2].add(i2);
                        }
                        ++i2;
                    }
                }
                max = Integer.MIN_VALUE;
                m = 0;
                while (m < this.donCand.length) {
                    p = 0;
                    while (p < 3) {
                        i = 0;
                        while (i < this.donCand[m][p].length()) {
                            max = Math.max(max, this.donCand[m][p].get(i));
                            ++i;
                        }
                        ++p;
                    }
                    ++m;
                }
                if (max > Integer.MIN_VALUE) {
                    qPart = Sequence.create(GeMoMa.this.alph, query.substring(this.queryStart - 1));
                    tPart = max > 0 ? Sequence.create(GeMoMa.this.alph, String.valueOf(a) + this.down.substring(0, (int)Math.floor((double)max / 3.0))) : Sequence.create(GeMoMa.this.alph, a.substring(0, a.length() - (int)Math.ceil((double)(-max) / 3.0)));
                    align.computeAlignment(Alignment.AlignmentType.GLOBAL, qPart, tPart);
                    m = 0;
                    while (m < this.donCand.length) {
                        p = 0;
                        while (p < 3) {
                            i = 0;
                            while (i < this.donCand[m][p].length()) {
                                int pos = this.donCand[m][p].get(i);
                                pos = pos > 0 ? a.length() + (int)Math.floor((double)pos / 3.0) : a.length() - (int)Math.ceil((double)(-pos) / 3.0);
                                this.donCandScore[m][p].add((int)(-align.getCost(qPart.getLength(), pos)) - this.score);
                                ++i;
                            }
                            ++p;
                        }
                        ++m;
                    }
                }
                this.splice = true;
            }
        }

        private int getExperimentalCandidates(HashMap<String, int[][][]> sites, int sIndex, IntList[] cand, int add, boolean invert, int max) {
            int[][][] vals;
            int anz = 0;
            if (sites != null && (vals = sites.get(this.targetID)) != null) {
                boolean b;
                int start = -10;
                int end = -10;
                int ref = -10;
                int f = 0;
                int z = this.forward ? 0 : 1;
                int i = 0;
                while (i < 3) {
                    cand[i].clear();
                    ++i;
                }
                boolean bl = invert ? !this.forward : (b = this.forward);
                if (b) {
                    start = max;
                    end = this.targetStart + add;
                    ref = this.targetStart;
                    f = 1;
                } else {
                    start = this.targetEnd - add;
                    end = max + 1;
                    ref = this.targetEnd + 1;
                    f = -1;
                }
                int idx = Arrays.binarySearch(vals[z][sIndex], start);
                if (idx < 0) {
                    idx = -(idx + 1);
                }
                int old = -1;
                while (idx < vals[z][sIndex].length && vals[z][sIndex][idx] <= end) {
                    if (vals[z][sIndex][idx] != old) {
                        int d = f * (ref - vals[z][sIndex][idx]);
                        int m = d % 3;
                        if (m < 0) {
                            m += 3;
                        }
                        cand[m].add(d);
                        ++anz;
                        old = vals[z][sIndex][idx];
                    }
                    ++idx;
                }
            }
            return anz;
        }

        private void getCanonincalCandidates(StringBuffer region, IntList[] sites, String p, boolean add, boolean reverse, int ref) {
            int i = 0;
            while (i < 3) {
                sites[i].clear();
                ++i;
            }
            int idxSite = 0;
            while (idxSite < region.length() && (idxSite = region.indexOf(p, idxSite)) >= 0) {
                int pos = idxSite;
                if (add) {
                    pos += p.length();
                }
                pos = reverse ? ref - pos : (pos -= ref);
                int i2 = pos % 3;
                if (i2 < 0) {
                    i2 += 3;
                }
                sites[i2].add(pos);
                ++idxSite;
            }
        }

        public void setSpliceSite(boolean donor, int add) {
            if (donor) {
                this.info = String.valueOf(this.info) + "donor";
                if (add != 0) {
                    if (this.forward) {
                        this.info = String.valueOf(this.info) + " (" + this.targetEnd + ")";
                        this.targetEnd += add;
                    } else {
                        this.info = String.valueOf(this.info) + " (" + this.targetStart + ")";
                        this.targetStart -= add;
                    }
                    if (add < 0) {
                        int del = (int)Math.ceil((double)(-add) / 3.0);
                        int i = this.targetAlign.length() - 1;
                        int r = 0;
                        while (i >= 0 && del > 0) {
                            if (this.targetAlign.charAt(i) != '-') {
                                --del;
                            }
                            if (this.queryAlign.charAt(i) != '-') {
                                ++r;
                            }
                            --i;
                        }
                        this.targetAlign = this.targetAlign.substring(0, i + 1);
                        this.queryAlign = this.queryAlign.substring(0, i + 1);
                        this.queryEnd -= r;
                    }
                }
            } else {
                this.info = String.valueOf(this.info) + "acceptor";
                if (add != 0) {
                    this.phase = add % 3;
                    if (this.phase < 0) {
                        this.phase += 3;
                    }
                    if (this.forward) {
                        this.info = String.valueOf(this.info) + " (" + this.targetStart + ")";
                        this.targetStart -= add;
                    } else {
                        this.info = String.valueOf(this.info) + " (" + this.targetEnd + ")";
                        this.targetEnd += add;
                    }
                }
                if (add < 0) {
                    int del = (int)Math.ceil((double)(-add) / 3.0);
                    int i = 0;
                    int r = 0;
                    while (i < this.targetAlign.length() && del > 0) {
                        if (this.targetAlign.charAt(i) != '-') {
                            --del;
                        }
                        if (this.queryAlign.charAt(i) != '-') {
                            ++r;
                        }
                        ++i;
                    }
                    this.targetAlign = this.targetAlign.substring(i);
                    this.queryAlign = this.queryAlign.substring(i);
                    this.queryStart += r;
                }
            }
            this.info = String.valueOf(this.info) + ";";
        }

        public void setBorderConstraints(boolean firstExon, boolean lastExon, MyAlignment align) throws IllegalArgumentException, WrongAlphabetException {
            if (!this.border) {
                Sequence t;
                Sequence q;
                if (firstExon) {
                    if (this.targetAlign.charAt(0) != 'M' || this.queryStart != 1) {
                        this.firstOffset = this.up.length();
                        if (this.firstOffset > 0 && this.up.indexOf("M") >= 0) {
                            int idx;
                            int best;
                            Sequence missing = Sequence.create(GeMoMa.this.alph, ((String)GeMoMa.this.cds.get(this.queryID)).substring(0, this.queryStart));
                            StringBuffer up = this.up.reverse();
                            try {
                                missing = missing.reverse();
                            }
                            catch (OperationNotSupportedException onse) {
                                throw new RuntimeException(onse.getMessage());
                            }
                            Sequence upSeq = Sequence.create(GeMoMa.this.alph, up.substring(0, up.lastIndexOf("M") + 1));
                            align.computeAlignment(Alignment.AlignmentType.GLOBAL, missing, upSeq);
                            if (this.targetAlign.charAt(0) == 'M') {
                                best = -(GeMoMa.this.gapOpening + missing.getLength() * GeMoMa.this.gapExtension);
                                idx = -1;
                            } else {
                                best = Integer.MIN_VALUE;
                                idx = Integer.MIN_VALUE;
                            }
                            int j = -1;
                            while ((j = up.indexOf("M", j + 1)) >= 0) {
                                int current = (int)(-align.getCost(missing.getLength(), j + 1));
                                if (current <= best) continue;
                                best = current;
                                idx = j;
                            }
                            this.firstOffset = idx + 1;
                        } else {
                            this.firstOffset = this.targetAlign.indexOf(77);
                            if (this.firstOffset > 0) {
                                this.firstOffset -= GeMoMa.this.getGapLength(this.targetAlign.substring(0, this.firstOffset));
                                boolean okay = true;
                                if (this.forward) {
                                    if (this.targetStart + 3 * this.firstOffset >= this.targetEnd) {
                                        okay = false;
                                    }
                                } else if (this.targetEnd - 3 * this.firstOffset <= this.targetStart) {
                                    okay = false;
                                }
                                if (okay) {
                                    this.firstOffset *= -1;
                                }
                            } else {
                                this.firstOffset = 0;
                            }
                        }
                    }
                    q = Sequence.create(GeMoMa.this.alph, ((String)GeMoMa.this.cds.get(this.queryID)).substring(0, this.queryEnd));
                    t = Sequence.create(GeMoMa.this.alph, Tools.translate(0, this.getDNA(3 * this.firstOffset, 0), code, false, GeMoMa.this.ambiguity));
                    align.computeAlignment(Alignment.AlignmentType.GLOBAL, q, t);
                    int current = (int)(-align.getCost(q.getLength(), t.getLength()));
                    this.firstAddScore = current - this.score;
                    this.firstAA = GeMoMa.this.alph.getSymbol(0, t.discreteVal(0)).charAt(0);
                }
                if (lastExon) {
                    this.lastOffset = 0;
                    if (this.targetAlign.charAt(this.targetAlign.length() - 1) != '*' && this.down.length() > 0 && this.down.charAt(this.down.length() - 1) == '*') {
                        this.lastOffset = this.down.length();
                        q = Sequence.create(GeMoMa.this.alph, ((String)GeMoMa.this.cds.get(this.queryID)).substring(this.queryStart - 1));
                        t = Sequence.create(GeMoMa.this.alph, Tools.translate(0, this.getDNA(0, 3 * this.lastOffset), code, false, GeMoMa.this.ambiguity));
                        PairwiseStringAlignment sa = align.getAlignment(Alignment.AlignmentType.GLOBAL, q, t);
                        int current = (int)(-sa.getCost());
                        this.lastAddScore = current - this.score;
                    }
                }
                this.border = true;
            }
        }

        public void extend(boolean firstExon, boolean lastExon) {
            boolean problem;
            if (firstExon) {
                problem = false;
                if (this.firstOffset != 0) {
                    if (this.forward) {
                        if (this.targetStart - 3 * this.firstOffset < this.targetEnd) {
                            this.targetStart -= 3 * this.firstOffset;
                        } else {
                            problem = true;
                        }
                    } else if (this.targetEnd + 3 * this.firstOffset > this.targetStart) {
                        this.targetEnd += 3 * this.firstOffset;
                    } else {
                        problem = true;
                    }
                    this.info = !problem ? String.valueOf(this.info) + "START (" + this.firstOffset + " aa);" : String.valueOf(this.info) + "START-problem";
                }
            }
            if (lastExon) {
                problem = false;
                if (this.lastOffset > 0) {
                    if (this.forward) {
                        if (this.targetStart < this.targetEnd + 3 * this.lastOffset) {
                            this.targetEnd += 3 * this.lastOffset;
                        } else {
                            problem = true;
                        }
                    } else if (this.targetStart - 3 * this.lastOffset < this.targetEnd) {
                        this.targetStart -= 3 * this.lastOffset;
                    } else {
                        problem = true;
                    }
                    this.info = !problem ? String.valueOf(this.info) + "STOP (" + this.lastOffset + " aa);" : String.valueOf(this.info) + "STOP-problem";
                }
            }
        }

        public String getDNA(int off1, int off2) {
            int offsetDown;
            int offsetUp;
            String chr = seqs.get(this.targetID);
            if (this.forward) {
                offsetUp = off1;
                offsetDown = off2;
            } else {
                offsetUp = off2;
                offsetDown = off1;
            }
            String r = chr.substring(this.targetStart - 1 - offsetUp, this.targetEnd + offsetDown);
            if (!this.forward) {
                r = Tools.rc(r);
            }
            return r;
        }

        public int getLength() {
            return this.targetEnd - (this.targetStart - 1);
        }
    }

    private static class HitComparator
    implements Comparator<Hit> {
        static HitComparator[] comparator = new HitComparator[]{new HitComparator(true), new HitComparator(false)};
        private boolean forward;

        private HitComparator(boolean f) {
            this.forward = f;
        }

        @Override
        public int compare(Hit o1, Hit o2) {
            if (this.forward) {
                return o1.targetStart - o2.targetStart;
            }
            return o2.targetEnd - o1.targetEnd;
        }
    }

    private static class Info {
        int[] exonID;
        int[] phase;
        String[] splitAA;
        int maxIntron;
        String protein;
        static Info DUMMY = new Info();

        Info(String exonID, String phase, String splitAA, String maxIntron, DiscreteAlphabet aaAlphabet) {
            String[] split = exonID.split(",[ ]*");
            this.exonID = new int[split.length];
            int i = 0;
            while (i < this.exonID.length) {
                this.exonID[i] = Integer.parseInt(split[i].trim());
                ++i;
            }
            phase = null;
            if (phase != null) {
                split = phase.split(",");
                this.phase = new int[split.length];
                i = 0;
                while (i < this.phase.length) {
                    this.phase[i] = Integer.parseInt(split[i].trim());
                    ++i;
                }
            }
            this.splitAA = new String[this.exonID.length];
            Arrays.fill(this.splitAA, "");
            if (splitAA != null) {
                split = splitAA.split(",");
                i = 0;
                while (i < split.length) {
                    if (split[i].length() > 1) {
                        throw new IllegalArgumentException("Expect only one additonal amino acids per exon-exon boundary.");
                    }
                    if (split[i].length() == 1 && !aaAlphabet.isSymbol(split[i])) {
                        throw new IllegalArgumentException("Unknown character " + split[i] + " in additional amino acid column of assignment file.");
                    }
                    this.splitAA[i] = split[i];
                    ++i;
                }
            }
            this.maxIntron = maxIntron == null || maxIntron.equals("NA") ? 0 : Integer.parseInt(maxIntron);
        }

        private Info() {
            this.exonID = new int[1];
            this.phase = new int[0];
            this.splitAA = new String[0];
            this.maxIntron = 0;
        }

        public String toString() {
            return "parts: " + Arrays.toString(this.exonID) + "\n" + "phase: " + Arrays.toString(this.phase) + "\n" + "splitAA: " + Arrays.toString(this.splitAA) + "\n";
        }

        public void prepareProtein(HashMap<String, String> cds, String prefix) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < this.exonID.length) {
                String cdsPart = cds.get(String.valueOf(prefix) + this.exonID[i]);
                if (cdsPart != null) {
                    sb.append(cdsPart);
                }
                if (i < this.splitAA.length) {
                    sb.append(this.splitAA[i]);
                }
                ++i;
            }
            this.protein = sb.toString();
        }
    }

    public static class IntArrayComparator
    implements Comparator<int[]> {
        public static IntArrayComparator[] comparator = new IntArrayComparator[]{new IntArrayComparator(0, 1), new IntArrayComparator(1, 0), new IntArrayComparator(0)};
        private int[] idx;

        private IntArrayComparator(int ... idx) {
            this.idx = idx;
        }

        @Override
        public int compare(int[] o1, int[] o2) {
            int res = 0;
            int i = 0;
            while (i < this.idx.length && (res = Integer.compare(o1[this.idx[i]], o2[this.idx[i]])) == 0) {
                ++i;
            }
            return res;
        }
    }

    static class MyAlignment
    extends Alignment {
        private boolean destroyed = false;
        private IntList first = new IntList();
        private IntList second = new IntList();
        private TranscriptPredictor instance;

        public MyAlignment(AffineCosts costs, TranscriptPredictor instance) {
            super(costs);
            this.instance = instance;
        }

        private void check() {
            if (this.destroyed) {
                throw new RuntimeException("A MyAlignment instance ist destroyed probably due to a time-out.");
            }
        }

        public double getBestValue(MyAlignment a2, int end1, int end2, char aa) throws WrongAlphabetException {
            this.check();
            if (this.type == Alignment.AlignmentType.GLOBAL && a2.type == Alignment.AlignmentType.GLOBAL && this.startS1 == 0 && a2.startS2 == 0) {
                this.first.clear();
                int i = 1;
                while (i < this.l1) {
                    if (this.d[0][i][end1] < this.d[1][i][end1] && this.d[0][i][end1] < this.d[2][i][end1]) {
                        this.first.add(i);
                    }
                    ++i;
                }
                this.second.clear();
                i = 1;
                while (i < this.l1) {
                    if (a2.d[0][i][end2] < a2.d[1][i][end2] && a2.d[0][i][end2] < a2.d[2][i][end2]) {
                        this.second.add(i);
                    }
                    ++i;
                }
                double best = Double.POSITIVE_INFINITY;
                int i2 = 0;
                while (i2 < this.first.length()) {
                    int pos1 = this.first.get(i2);
                    int j = 0;
                    while (j < this.second.length()) {
                        int pos2 = this.second.get(j);
                        int l = this.l1 - pos2 - pos1;
                        if (l < 0) break;
                        double cost = l > 0 ? this.aCosts.getGapCostsFor(l) : 0.0;
                        double current = this.d[0][pos1][end1] + a2.d[0][pos2][end2] + cost;
                        if (current < best) {
                            best = current;
                        }
                        ++j;
                    }
                    ++i2;
                }
                return best;
            }
            throw new IllegalArgumentException("The given alignments can not be used");
        }

        @Override
        public boolean computeAlignment(Alignment.AlignmentType type, Sequence s1, int startS1, int endS1, Sequence s2, int startS2, int endS2) {
            this.check();
            if (this.type == type && this.startS1 == startS1 && this.l1 == endS1 - startS1 && this.startS2 == startS2 && this.l2 == endS2 - startS2) {
                int i = startS1;
                while (i < endS1 && this.s1.discreteVal(i) == s1.discreteVal(i)) {
                    ++i;
                }
                if (i == endS1) {
                    i = startS2;
                    while (i < endS2 && this.s2.discreteVal(i) == s2.discreteVal(i)) {
                        ++i;
                    }
                    if (i == endS2) {
                        return false;
                    }
                }
            }
            TranscriptPredictor transcriptPredictor = this.instance;
            transcriptPredictor.numberOfPairwiseAlignments = transcriptPredictor.numberOfPairwiseAlignments + 1;
            return super.computeAlignment(type, s1, startS1, endS1, s2, startS2, endS2);
        }

        void clear() {
            this.s2 = null;
            this.s1 = null;
            this.l2 = -1;
            this.l1 = -1;
            this.startS2 = -1;
            this.startS1 = -1;
            this.destroyed = true;
        }
    }

    public static enum Score {
        Trust,
        ReScore,
        ReAlign;

    }

    private class TranscriptPredictor {
        private int[][] sums;
        private int[] revParts;
        private int[] oldSize;
        private int[] length;
        private int[] cumLength;
        private int[] revCumLength;
        private int[][] start;
        private int[][] end;
        private int[][] qStart;
        private int[][] qEnd;
        private int[][] qL;
        private int maxAllowedIntron;
        double[][] used;
        int[][][][][] splice;
        static final int NOT_COMPUTED = Integer.MAX_VALUE;
        static final int NO_SPLICE_VARIANT = Integer.MIN_VALUE;
        private int numberOfLines;
        private int numberOfTestedStrands;
        private int numberOfPairwiseAlignments;
        private int[] refined = new int[2];
        private String geneName;
        private PriorityQueue<Solution> result;
        private Solution sol = new Solution();
        private final ScheduledThreadPoolExecutor executorService;
        private StringBuffer gffHelp;
        private Info currentInfo;
        private BufferedWriter gff;
        private File gffFile;
        private StringBuffer protocol;
        private MyAlignment align;
        private MyAlignment align1;
        private MyAlignment align2;
        int[] res = null;
        boolean[] spliceType = new boolean[4];
        IntList[] bestIdx = new IntList[]{new IntList(), new IntList()};

        public TranscriptPredictor(boolean add, ToolParameterSet parameters, String temp) throws Exception {
            this.protocol = new StringBuffer();
            this.gffFile = Tools.createTempFile("gff", temp);
            this.gff = new BufferedWriter(new FileWriter(this.gffFile));
            if (add) {
                this.gff.append("##gff-version 3");
                this.gff.newLine();
                this.gff.append("#SOFTWARE INFO: " + GeMoMa.this.getShortName() + " " + GeMoMa.this.getToolVersion() + "; ");
                String info = JstacsTool.getSimpleParameterInfo(parameters);
                if (info != null) {
                    this.gff.append("SIMPLE PARAMETERS: " + info);
                }
                this.gff.newLine();
            }
            this.align = new MyAlignment(GeMoMa.this.cost, this);
            this.align1 = new MyAlignment(GeMoMa.this.cost, this);
            this.align2 = new MyAlignment(GeMoMa.this.cost, this);
            this.result = new PriorityQueue();
            this.executorService = new ScheduledThreadPoolExecutor(1, runnable -> {
                Thread thread = new Thread(runnable, this.getClass().getName());
                thread.setDaemon(true);
                return thread;
            });
            this.executorService.setRemoveOnCancelPolicy(true);
            this.gffHelp = new StringBuffer();
        }

        public void close() {
            List<Runnable> list = this.executorService.shutdownNow();
            if (list.size() > 0) {
                for (Runnable r : list) {
                    System.out.println("open Runnable: " + r.toString());
                }
            }
        }

        public int compute(String name, HashMap<String, HashMap<Integer, ArrayList<Hit>>[]> hash, boolean staticIntronLength) throws Exception {
            HashMap<Integer, ArrayList<Hit>>[] v;
            Object[] s;
            HashMap transcript;
            this.protocol.delete(0, this.protocol.length());
            this.geneName = name.substring(0, name.length() - 1);
            if (GeMoMa.this.transcriptInfo != null) {
                transcript = (HashMap)GeMoMa.this.transcriptInfo.get(this.geneName);
                if (transcript == null) {
                    return 0;
                }
                s = new String[transcript.size()];
                transcript.keySet().toArray(s);
                Arrays.sort(s);
            } else {
                transcript = null;
                s = new String[]{this.geneName};
            }
            HashMap<String, HashMap<Integer, ArrayList<Hit>>[]> data = new HashMap<String, HashMap<Integer, ArrayList<Hit>>[]>();
            String[] h = new String[hash.size()];
            hash.keySet().toArray(h);
            int j = 0;
            while (j < h.length) {
                v = hash.get(h[j]);
                int f = 0;
                while (f < 2) {
                    this.sort(v[f], f == 0);
                    ++f;
                }
                ++j;
            }
            int i = 0;
            while (i < s.length) {
                String info = null;
                if (selected == null || (info = selected.get(s[i])) != null) {
                    int j2;
                    int p;
                    int max = 0;
                    if (transcript != null) {
                        this.currentInfo = (Info)transcript.get(s[i]);
                        p = 0;
                        while (p < this.currentInfo.exonID.length) {
                            if (this.currentInfo.exonID[p] > max) {
                                max = this.currentInfo.exonID[p];
                            }
                            ++p;
                        }
                    } else {
                        this.currentInfo = Info.DUMMY;
                    }
                    this.maxAllowedIntron = staticIntronLength ? GeMoMa.this.MAX_INTRON_LENGTH : this.currentInfo.maxIntron + GeMoMa.this.MAX_INTRON_LENGTH;
                    this.revParts = new int[max + 1];
                    if (transcript != null) {
                        Arrays.fill(this.revParts, -1);
                        p = 0;
                        while (p < this.currentInfo.exonID.length) {
                            this.revParts[this.currentInfo.exonID[p]] = p;
                            ++p;
                        }
                        this.length = new int[this.currentInfo.exonID.length];
                        j2 = 0;
                        while (j2 < this.currentInfo.exonID.length) {
                            String st = String.valueOf(this.geneName) + (GeMoMa.this.transcriptInfo == null ? "" : "_" + this.currentInfo.exonID[j2]);
                            st = (String)GeMoMa.this.cds.get(st);
                            this.length[j2] = st != null ? st.length() : 0;
                            ++j2;
                        }
                    } else {
                        this.revParts[0] = 0;
                        this.length = new int[]{((String)GeMoMa.this.cds.get(this.geneName)).length()};
                    }
                    this.cumLength = new int[this.length.length];
                    j2 = 1;
                    while (j2 < this.length.length) {
                        this.cumLength[j2] = this.cumLength[j2 - 1] + this.length[j2 - 1];
                        ++j2;
                    }
                    this.revCumLength = new int[this.length.length];
                    j2 = this.length.length - 2;
                    while (j2 >= 0) {
                        this.revCumLength[j2] = this.revCumLength[j2 + 1] + this.length[j2 + 1];
                        --j2;
                    }
                    int l = this.currentInfo.exonID.length;
                    this.sums = new int[l][];
                    this.start = new int[l][];
                    this.end = new int[l][];
                    this.qStart = new int[l][];
                    this.qEnd = new int[l][];
                    this.qL = new int[l][];
                    if (GeMoMa.this.transcriptInfo == null) {
                        this.computeTranscript((String)s[i], info, hash);
                    } else {
                        boolean hasHits = false;
                        data.clear();
                        int j3 = 0;
                        while (j3 < h.length) {
                            v = hash.get(h[j3]);
                            HashMap[] w = new HashMap[]{new HashMap(), new HashMap()};
                            int f = 0;
                            while (f < 2) {
                                int k = 0;
                                while (k < this.currentInfo.exonID.length) {
                                    ArrayList<Hit> hits = v[f].get(this.currentInfo.exonID[k]);
                                    if (hits != null) {
                                        w[f].put(this.currentInfo.exonID[k], this.clone(hits));
                                        hasHits = true;
                                    }
                                    ++k;
                                }
                                ++f;
                            }
                            data.put(h[j3], w);
                            ++j3;
                        }
                        if (hasHits) {
                            this.currentInfo.prepareProtein(GeMoMa.this.cds, String.valueOf(this.geneName) + (GeMoMa.this.transcriptInfo == null ? "" : "_"));
                            this.computeTranscript((String)s[i], info, data);
                            this.currentInfo.protein = null;
                        }
                    }
                }
                ++i;
            }
            return s.length;
        }

        public void sort(HashMap<Integer, ArrayList<Hit>> lines, boolean forward) {
            for (ArrayList<Hit> current : lines.values()) {
                if (current == null) continue;
                Collections.sort(current, HitComparator.comparator[forward ? 0 : 1]);
            }
        }

        public ArrayList<Hit> clone(ArrayList<Hit> original) throws CloneNotSupportedException {
            ArrayList<Hit> clone = new ArrayList<Hit>(original.size());
            int i = 0;
            while (i < original.size()) {
                clone.add(original.get(i));
                ++i;
            }
            return clone;
        }

        String getRefProtein(String transcriptName) {
            String ref = this.currentInfo != Info.DUMMY ? this.currentInfo.protein : (String)GeMoMa.this.cds.get(transcriptName);
            return ref;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void computeTranscript(String transcriptName, String info, HashMap<String, HashMap<Integer, ArrayList<Hit>>[]> hash) throws Exception {
            boolean out;
            block69: {
                int strand;
                String chrom;
                Collection<String> collection;
                block74: {
                    block70: {
                        block71: {
                            HashMap<Integer, ArrayList<Hit>>[] lines;
                            String[] pos;
                            int end;
                            int start;
                            block72: {
                                if (GeMoMa.this.verbose) {
                                    this.protocol.append("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
                                    this.protocol.append(String.valueOf(this.geneName) + "\t" + transcriptName + "\t" + Arrays.toString(this.currentInfo.exonID) + "\t" + new Date() + (info == null ? "" : "\t" + info) + "\n");
                                    this.protocol.append(String.valueOf(Arrays.toString(this.length)) + "\n");
                                    this.protocol.append(String.valueOf(Arrays.toString(this.cumLength)) + "\n");
                                    this.protocol.append(String.valueOf(Arrays.toString(this.revCumLength)) + "\n");
                                }
                                this.protocol.append(String.valueOf(this.geneName) + "\t" + transcriptName);
                                this.numberOfPairwiseAlignments = 0;
                                this.numberOfTestedStrands = 0;
                                this.oldSize = new int[this.currentInfo.exonID.length];
                                this.result.clear();
                                collection = hash.keySet();
                                chrom = null;
                                start = 0;
                                end = -1;
                                strand = -1;
                                if (info == null || info.length() <= 0) break block70;
                                pos = info.split("\t");
                                if (!hash.containsKey(pos[0])) break block71;
                                chrom = pos[0];
                                collection = new ArrayList();
                                collection.add(chrom);
                                if (pos.length <= 1) break block72;
                                switch (pos[1]) {
                                    case "+": 
                                    case "1": {
                                        strand = 0;
                                        break;
                                    }
                                    case "-": 
                                    case "-1": {
                                        strand = 1;
                                        break;
                                    }
                                    default: {
                                        strand = -1;
                                    }
                                }
                            }
                            if (pos.length > 2) {
                                try {
                                    start = Integer.parseInt(pos[2]);
                                }
                                catch (Exception ex) {
                                    start = 0;
                                }
                            }
                            if (pos.length > 3) {
                                try {
                                    end = Integer.parseInt(pos[3]);
                                }
                                catch (Exception ex) {
                                    end = -1;
                                }
                            }
                            if ((lines = hash.get(chrom)) != null) {
                                if (strand != -1) {
                                    if (lines[strand] != null) {
                                        this.filter(lines[strand], start, end);
                                    }
                                } else {
                                    int i = 0;
                                    while (i < 2) {
                                        if (lines[i] != null) {
                                            this.filter(lines[i], start, end);
                                        }
                                        ++i;
                                    }
                                }
                            }
                            if (GeMoMa.this.verbose) {
                                this.protocol.append("try to predict " + transcriptName + " on (" + chrom + " " + strand + ": " + start + " " + end + ") as user-specified\n");
                            }
                            break block74;
                        }
                        if (GeMoMa.this.verbose) {
                            this.protocol.append("\n");
                        }
                        break block74;
                    }
                    if (GeMoMa.this.verbose) {
                        this.protocol.append("\n");
                    }
                }
                out = true;
                final int STRAND = strand;
                final String CHROM = chrom;
                final HashMap<String, HashMap<Integer, ArrayList<Hit>>[]> HASH = hash;
                final Set<String> COLLECTION = collection;
                this.res = null;
                Future<?> f = null;
                Thread t = null;
                try {
                    try {
                        t = new Thread(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                try {
                                    try {
                                        TranscriptPredictor.this.splice = null;
                                        TranscriptPredictor.this.used = null;
                                        int m = 0;
                                        int k = 0;
                                        int bestSumScore = Integer.MIN_VALUE;
                                        if (STRAND == -1) {
                                            HashMap[] lines;
                                            Iterator it = COLLECTION.iterator();
                                            IntList score = new IntList();
                                            while (it.hasNext()) {
                                                String c = (String)it.next();
                                                lines = (HashMap[])HASH.get(c);
                                                int j = 0;
                                                while (j < lines.length) {
                                                    if (lines[j].size() > 0) {
                                                        TranscriptPredictor transcriptPredictor = TranscriptPredictor.this;
                                                        transcriptPredictor.numberOfTestedStrands = transcriptPredictor.numberOfTestedStrands + 1;
                                                        int sumScore = TranscriptPredictor.this.forwardDP(j == 0, lines[j], false);
                                                        if (sumScore > bestSumScore) {
                                                            bestSumScore = sumScore;
                                                        }
                                                        score.add(sumScore);
                                                    }
                                                    ++j;
                                                }
                                            }
                                            it = COLLECTION.iterator();
                                            double threshold = (double)bestSumScore * GeMoMa.this.contigThreshold;
                                            while (it.hasNext()) {
                                                String c = (String)it.next();
                                                lines = (HashMap[])HASH.get(c);
                                                int j = 0;
                                                while (j < lines.length) {
                                                    if (lines[j].size() > 0) {
                                                        if ((double)score.get(m) >= threshold) {
                                                            ++k;
                                                            TranscriptPredictor.this.detailedAnalyse(c, j == 0, lines[j], bestSumScore, -1, -1);
                                                        }
                                                        ++m;
                                                    }
                                                    ++j;
                                                }
                                            }
                                        } else {
                                            HashMap[] lines = (HashMap[])HASH.get(CHROM);
                                            if (lines != null && lines[STRAND].size() > 0) {
                                                TranscriptPredictor transcriptPredictor = TranscriptPredictor.this;
                                                transcriptPredictor.numberOfTestedStrands = transcriptPredictor.numberOfTestedStrands + 1;
                                                bestSumScore = TranscriptPredictor.this.forwardDP(STRAND == 0, lines[STRAND], false);
                                                TranscriptPredictor.this.detailedAnalyse(CHROM, STRAND == 0, lines[STRAND], bestSumScore, -1, -1);
                                                k = 1;
                                            }
                                        }
                                        TranscriptPredictor.this.res = new int[]{bestSumScore, k};
                                    }
                                    catch (Exception e) {
                                        RuntimeException re = new RuntimeException(e.getMessage());
                                        re.setStackTrace(e.getStackTrace());
                                        throw re;
                                    }
                                }
                                catch (Throwable throwable) {
                                    StringBuffer stringBuffer = TranscriptPredictor.this.protocol;
                                    synchronized (stringBuffer) {
                                        TranscriptPredictor.this.protocol.notify();
                                    }
                                    throw throwable;
                                }
                                StringBuffer stringBuffer = TranscriptPredictor.this.protocol;
                                synchronized (stringBuffer) {
                                    TranscriptPredictor.this.protocol.notify();
                                }
                            }
                        };
                        f = this.executorService.submit(t);
                        f.get(GeMoMa.this.timeOut, TimeUnit.SECONDS);
                    }
                    catch (TimeoutException e) {
                        this.protocol.append("\tInvocation did not return before timeout of " + GeMoMa.this.timeOut + " seconds\n");
                        this.protocol.append(new Date() + "\t" + System.currentTimeMillis() + "\n");
                        out = false;
                        GeMoMa.this.timeOutWarning.append(String.valueOf(GeMoMa.this.timeOutWarning.length() > 0 ? ", " : "") + transcriptName);
                        t.interrupt();
                        StringBuffer stringBuffer = this.protocol;
                        synchronized (stringBuffer) {
                            this.align1.clear();
                            this.align2.clear();
                            this.align.clear();
                            int[][] s = this.sums;
                            this.sums = null;
                            this.protocol.wait();
                            this.align.destroyed = false;
                            this.align1.destroyed = false;
                            this.align2.destroyed = false;
                            this.sums = s;
                        }
                        this.protocol.append(new Date() + "\t" + System.currentTimeMillis() + "\n");
                        this.splice = null;
                        this.used = null;
                        break block69;
                    }
                }
                catch (Throwable throwable) {
                    this.splice = null;
                    this.used = null;
                    throw throwable;
                }
                this.splice = null;
                this.used = null;
            }
            if (out) {
                String protein = this.getRefProtein(transcriptName);
                double maxScore = 0.0;
                if (GeMoMa.this.proteinAlignment) {
                    int i = 0;
                    while (i < protein.length()) {
                        int idx = GeMoMa.this.aaAlphabet.getCode(protein.substring(i, i + 1));
                        maxScore -= GeMoMa.this.matrix[idx][idx];
                        ++i;
                    }
                }
                int counts = 0;
                int i = 0;
                int bestScore = Integer.MIN_VALUE;
                double th = Double.POSITIVE_INFINITY;
                while (this.result.size() > 0) {
                    Solution best = this.result.poll();
                    if (i == 0) {
                        bestScore = best.score;
                        th = GeMoMa.this.factor * (double)Math.max(0, bestScore);
                    }
                    if (GeMoMa.this.predictions >= 0 && i >= GeMoMa.this.predictions || GeMoMa.this.factor >= 0.0 && (double)best.score < th || best.hits.size() <= 0) break;
                    ++counts;
                    best = best.refine(transcriptName);
                    best.writeSummary(this.geneName, transcriptName, i);
                    this.gff.append(";raa=" + protein.length());
                    this.gff.append(";score=" + best.score);
                    if (bestScore == Integer.MIN_VALUE) {
                        bestScore = best.score;
                    }
                    this.gff.append(";prediction=" + i + ";bestScore=" + bestScore);
                    this.gffHelp.delete(0, this.gffHelp.length());
                    int anz = best.writeGFF(transcriptName, i, this.gffHelp);
                    if (GeMoMa.this.transcriptInfo != null) {
                        this.gff.append(";ce=" + anz + ";rce=" + this.currentInfo.exonID.length);
                    }
                    if (acceptorSites != null) {
                        this.gff.append(";tae=" + (best.A == 0 ? "NA" : decFormat.format((double)best.a / (double)best.A)));
                    }
                    if (donorSites != null) {
                        this.gff.append(";tde=" + (best.D == 0 ? "NA" : decFormat.format((double)best.d / (double)best.D)));
                        this.gff.append(";tie=" + (best.I == 0 ? "NA" : decFormat.format((double)best.i / (double)best.I)));
                        this.gff.append(";minSplitReads=" + (best.I == 0 ? "NA" : Integer.valueOf(best.minSplitReads)));
                    }
                    if (coverage != null && coverage[best.forward ? 0 : 1] != null) {
                        this.gff.append(";tpc=" + decFormat.format((double)best.Cov / (double)best.Len));
                        this.gff.append(";minCov=" + best.minC);
                        this.gff.append(";avgCov=" + decFormat.format((double)best.Sum / (double)best.Len));
                    }
                    int id = 0;
                    int pos = 0;
                    int longest = 0;
                    int current = 0;
                    int gap = -1;
                    int currentGap = 0;
                    int maxGap = 0;
                    String s1 = null;
                    String pred = best.getProtein();
                    PairwiseStringAlignment psa = null;
                    if (GeMoMa.this.proteinAlignment) {
                        psa = this.align.getAlignment(Alignment.AlignmentType.GLOBAL, Sequence.create(GeMoMa.this.alph, protein), Sequence.create(GeMoMa.this.alph, pred));
                        String s0 = psa.getAlignedString(0);
                        s1 = psa.getAlignedString(1);
                        int p = 0;
                        while (p < s1.length()) {
                            char c0 = s0.charAt(p);
                            char c1 = s1.charAt(p);
                            if (c0 == '-' || c1 == '-') {
                                int idx;
                                int n = idx = c0 == '-' ? 0 : 1;
                                if (gap != idx) {
                                    if (currentGap > maxGap) {
                                        maxGap = currentGap;
                                    }
                                    gap = idx;
                                    currentGap = 0;
                                }
                                ++currentGap;
                                if (longest < current) {
                                    longest = current;
                                }
                                current = 0;
                            } else {
                                if (gap != -1) {
                                    if (currentGap > maxGap) {
                                        maxGap = currentGap;
                                    }
                                    gap = -1;
                                    currentGap = 0;
                                }
                                if (c0 == c1) {
                                    ++id;
                                    ++pos;
                                    ++current;
                                } else {
                                    StringBuilder stringBuilder = new StringBuilder();
                                    StringBuilder stringBuilder2 = new StringBuilder();
                                    if (GeMoMa.this.matrix[GeMoMa.this.aaAlphabet.getCode(stringBuilder.append(c0).toString())][GeMoMa.this.aaAlphabet.getCode(stringBuilder2.append(c1).toString())] > 0.0) {
                                        ++pos;
                                        ++current;
                                    } else {
                                        if (longest < current) {
                                            longest = current;
                                        }
                                        current = 0;
                                    }
                                }
                            }
                            ++p;
                        }
                        if (gap == -1) {
                            if (longest < current) {
                                longest = current;
                            }
                        } else if (currentGap > maxGap) {
                            maxGap = currentGap;
                        }
                        if (GeMoMa.this.verbose) {
                            this.protocol.append(String.valueOf(s0) + "\n");
                            this.protocol.append(String.valueOf(s1) + "\n");
                        }
                        this.gff.append(";pAA=" + decFormat.format((double)pos / (double)s1.length()) + ";iAA=" + decFormat.format((double)id / (double)s1.length()) + ";lpm=" + longest + ";maxScore=" + (int)maxScore + ";maxGap=" + maxGap);
                    }
                    int preMatureStops = 0;
                    int j = -1;
                    String aa = pred.substring(0, pred.length() - 1);
                    while ((j = aa.indexOf(42, j + 1)) >= 0) {
                        ++preMatureStops;
                    }
                    this.gff.append(";nps=" + preMatureStops);
                    this.protocol.append(String.valueOf(i == 0 && !GeMoMa.this.verbose ? "" : String.valueOf(this.geneName) + "\t" + transcriptName) + "\t" + this.currentInfo.exonID.length + "\t" + best.hits.size() + "\t" + this.numberOfLines + "\t" + this.numberOfTestedStrands + "\t" + this.res[0] + "\t" + this.res[1] + "\t" + (this.result.size() + 1) + "\t" + this.numberOfPairwiseAlignments + "\t" + best.score + "\t" + best.hits.getFirst().targetID + "\t" + (best.forward ? 1 : -1) + "\t" + (best.forward ? String.valueOf(best.hits.getFirst().targetStart) + "\t" + best.hits.getLast().targetEnd : String.valueOf(best.hits.getLast().targetStart) + "\t" + best.hits.getFirst().targetEnd) + "\t" + anz + "\t" + best.getInfo(this.gff) + (GeMoMa.this.proteinAlignment ? "\t" + this.getGapCost(protein.length(), this.currentInfo.exonID.length) + "\t" + (int)(-psa.getCost()) + "\t" + GeMoMa.this.getScore(protein, protein) + "\t" + (double)pos / (double)s1.length() + "\t" + (double)id / (double)s1.length() + "\t" + protein.length() + "\t" + pred.length() : "") + (acceptorSites == null ? "" : "\t" + (best.A == 0 ? "NA" : decFormat.format((double)best.a / (double)best.A))) + (donorSites == null ? "" : "\t" + (best.D == 0 ? "NA" : decFormat.format((double)best.d / (double)best.D))) + (donorSites == null ? "" : "\t" + (best.I == 0 ? "NA" : decFormat.format((double)best.i / (double)best.I))) + (coverage == null ? "" : "\t" + decFormat.format((double)best.Cov / (double)best.Len) + "\t" + best.minC) + "\t" + best.similar(this.result.peek()) + "\n");
                    this.gff.newLine();
                    this.gff.append(this.gffHelp);
                    this.gff.flush();
                    ++i;
                }
                if (counts == 0) {
                    this.protocol.append("\n");
                }
            }
        }

        private void filter(HashMap<Integer, ArrayList<Hit>> hash, int start, int end) {
            if (start == 0 && end == -1) {
                return;
            }
            if (GeMoMa.this.verbose) {
                this.protocol.append("\n");
            }
            int i = 0;
            while (i < this.currentInfo.exonID.length) {
                ArrayList<Hit> current = hash.get(this.currentInfo.exonID[i]);
                if (GeMoMa.this.verbose) {
                    this.protocol.append(String.valueOf(i) + "\t" + this.currentInfo.exonID[i] + "\t#=" + (current == null ? 0 : current.size()) + "\n");
                }
                if (current != null) {
                    int j = 0;
                    while (j < current.size()) {
                        Hit h = current.get(j);
                        if (h.targetEnd < start || h.targetStart > end) {
                            if (GeMoMa.this.verbose) {
                                this.protocol.append("out\t" + h + "\n");
                            }
                            current.remove(j);
                            continue;
                        }
                        if (GeMoMa.this.verbose) {
                            this.protocol.append("in\t" + h + "\n");
                        }
                        ++j;
                    }
                }
                if (GeMoMa.this.verbose) {
                    this.protocol.append(String.valueOf(i) + "\t" + this.currentInfo.exonID[i] + "\t#=" + (current == null ? 0 : current.size()) + "\n\n");
                }
                ++i;
            }
        }

        private int forwardDP(boolean forward, HashMap<Integer, ArrayList<Hit>> lines, boolean gap) throws WrongAlphabetException, IOException {
            if (lines.size() == 0) {
                int i = this.currentInfo.exonID.length - 1;
                while (i >= 0) {
                    this.qEnd[i] = null;
                    this.qStart[i] = null;
                    this.end[i] = null;
                    this.start[i] = null;
                    this.sums[i] = null;
                    --i;
                }
                this.bestIdx[0].clear();
                this.bestIdx[1].clear();
                return Integer.MIN_VALUE;
            }
            String chr = null;
            int i = this.currentInfo.exonID.length - 1;
            while (i >= 0) {
                ArrayList<Hit> l = lines.get(this.currentInfo.exonID[i]);
                if (l == null || l.size() == 0) {
                    this.qEnd[i] = null;
                    this.qStart[i] = null;
                    this.end[i] = null;
                    this.start[i] = null;
                    this.sums[i] = null;
                } else {
                    int anz = l.size();
                    this.sums[i] = new int[anz];
                    this.start[i] = new int[anz];
                    this.end[i] = new int[anz];
                    this.qStart[i] = new int[anz];
                    this.qEnd[i] = new int[anz];
                    this.qL[i] = new int[anz];
                    if (this.splice != null && this.splice[i] == null) {
                        this.splice[i] = new int[anz][this.currentInfo.exonID.length - i][][];
                    }
                    int j = anz - 1;
                    while (j >= 0) {
                        Hit o = l.get(j);
                        if (this.splice != null && chr == null) {
                            chr = seqs.get(o.targetID);
                        }
                        this.start[i][j] = forward ? o.targetStart : o.targetEnd;
                        this.end[i][j] = forward ? o.targetEnd : o.targetStart;
                        this.qStart[i][j] = o.queryStart;
                        this.qEnd[i][j] = o.queryEnd;
                        this.qL[i][j] = o.queryEnd - o.queryStart + 1;
                        int b = o.score;
                        this.sums[i][j] = b + this.getCost(o, gap, false, i);
                        int m = Math.min(i + 5, this.currentInfo.exonID.length);
                        int startIdx = j + 1;
                        int max = 0;
                        int k = i;
                        while (k < m) {
                            max = this.getMax(forward, lines, i, j, k, startIdx, chr, gap);
                            if (this.sums[i][j] < b + max) {
                                this.sums[i][j] = b + max;
                            }
                            startIdx = 0;
                            ++k;
                        }
                        --j;
                    }
                }
                --i;
            }
            return this.getBest(gap, lines);
        }

        int getCost(Hit o, boolean gap, boolean start, int i) {
            if (!gap) {
                return 0;
            }
            if (start) {
                if (i == 0) {
                    return o.firstAddScore;
                }
                return this.getGapCost(o.queryStart - 1 + this.cumLength[i], i - 1);
            }
            if (i == this.currentInfo.exonID.length - 1) {
                return o.lastAddScore;
            }
            return this.getGapCost(o.queryLength - o.queryEnd + this.revCumLength[i], this.currentInfo.exonID.length - 1 - i);
        }

        final int getGapCost(int cumLength, int exons) {
            return -(cumLength > 0 ? GeMoMa.this.gapOpening + GeMoMa.this.gapExtension * cumLength : 0) - exons * GeMoMa.this.INTRON_GAIN_LOSS;
        }

        final boolean check(boolean forward, int i, int j, int k, int m) {
            return (forward ? 1 : -1) * (this.start[k][m] - this.start[i][j]) > 0 && (forward ? 1 : -1) * (this.end[k][m] - this.end[i][j]) > 0 && (k > i || this.qStart[i][j] < this.qStart[k][m] && this.qEnd[i][j] < this.qEnd[k][m]);
        }

        final boolean check2(int i, int j, int k, int m) {
            return i == k && (double)Math.max(this.qEnd[i][j] - this.qStart[k][m], 0) / (double)Math.min(this.qL[i][j], this.qL[k][m]) > 0.5;
        }

        private final int getMax(boolean forward, HashMap<Integer, ArrayList<Hit>> lines, int i, int j, int k, int startIdx, String chr, boolean gap) throws WrongAlphabetException {
            int max = this.getCost(lines.get(this.currentInfo.exonID[i]).get(j), gap, false, i);
            ArrayList<Hit> ref = lines.get(this.currentInfo.exonID[k]);
            if (ref == null) {
                return max;
            }
            Hit upstreamHit = lines.get(this.currentInfo.exonID[i]).get(j);
            int introns = Math.max(1, k - i);
            if (this.splice != null && this.splice[i][j][k - i] == null) {
                try {
                    this.splice[i][j][k - i] = new int[ref.size()][5];
                    int x = 0;
                    while (x < this.splice[i][j][k - i].length) {
                        this.splice[i][j][k - i][x][0] = Integer.MAX_VALUE;
                        ++x;
                    }
                }
                catch (OutOfMemoryError e) {
                    this.protocol.append(String.valueOf(this.currentInfo.exonID[i]) + "\t" + this.length[i] + "\n");
                    this.protocol.append(String.valueOf(this.splice[i].length) + "\n");
                    this.protocol.append(String.valueOf(ref.size()) + "\n");
                    throw e;
                }
            }
            int len = 0;
            if (gap && this.sums[k] != null && i + 1 != k) {
                int v = i + 1;
                while (v < k) {
                    len += this.length[v];
                    ++v;
                }
            }
            int m = startIdx;
            while (this.sums[k] != null && m < this.sums[k].length) {
                int d = (forward ? 1 : -1) * (this.start[k][m] - (this.end[i][j] + 1));
                if (d >= introns * this.maxAllowedIntron) {
                    if (this.splice == null || this.splice[i][j][k - i] == null) break;
                    int x = m;
                    while (x < this.splice[i][j][k - i].length) {
                        this.splice[i][j][k - i][x][0] = Integer.MIN_VALUE;
                        ++x;
                    }
                    break;
                }
                if (this.check(forward, i, j, k, m)) {
                    int adScore = 0;
                    if (this.splice != null && this.splice[i][j][k - i] != null) {
                        if (this.splice[i][j][k - i][m][0] == Integer.MAX_VALUE) {
                            this.checkSpliceSites(chr, upstreamHit, ref.get(m), len, this.splice[i][j][k - i][m]);
                        }
                        adScore = this.splice[i][j][k - i][m][0];
                    } else if (this.check2(i, j, k, m)) {
                        adScore = Integer.MIN_VALUE;
                    }
                    if (adScore != Integer.MIN_VALUE && max < this.sums[k][m] + adScore) {
                        max = this.sums[k][m] + adScore;
                    }
                } else if (this.splice != null && this.splice[i][j][k - i] != null) {
                    this.splice[i][j][k - i][m][0] = Integer.MIN_VALUE;
                }
                ++m;
            }
            return max;
        }

        private void backTracking(int[][] sites, boolean forward, HashMap<Integer, ArrayList<Hit>> lines, int i, int j, int intron, int exp, double diff, Solution current, Solution best, boolean gap) {
            Hit o = lines.get(this.currentInfo.exonID[i]).get(j);
            if (this.used != null) {
                if (this.used[i] == null) {
                    this.used[i] = new double[lines.get(this.currentInfo.exonID[i]).size()];
                    Arrays.fill(this.used[i], Double.NEGATIVE_INFINITY);
                }
                if (diff >= 0.0 && diff >= this.used[i][j]) {
                    this.used[i][j] = diff;
                } else {
                    return;
                }
            }
            if (current != null) {
                current.I += intron;
                current.i += exp;
                current.hits.add(o);
            }
            diff -= (double)(this.sums[i][j] - o.score);
            int min = Math.min(i + 5, this.currentInfo.exonID.length);
            int startIdx = j + 1;
            int k = i;
            while (k < min) {
                this.findNext(sites, forward, lines, i, j, k, startIdx, diff, current, best, gap);
                startIdx = 0;
                ++k;
            }
            if (current != null && this.sums[i][j] - (o.score + this.getCost(o, gap, false, i)) == 0 && (best.hits.size() == 0 || best.compareTo(current) > 0)) {
                best.set(current);
            }
        }

        private void findNext(int[][] sites, boolean forward, HashMap<Integer, ArrayList<Hit>> lines, int i, int j, int k, int startIdx, double diff, Solution current, Solution best, boolean gap) {
            if (this.sums[k] != null) {
                int introns = Math.max(1, k - i);
                int m = startIdx;
                while (m < this.sums[k].length) {
                    int d = (forward ? 1 : -1) * (this.start[k][m] - (this.end[i][j] + 1));
                    if (d >= introns * this.maxAllowedIntron) break;
                    if (this.check(forward, i, j, k, m)) {
                        int adScore = 0;
                        if (this.splice != null) {
                            adScore = this.splice[i][j][k - i][m][0];
                        } else if (this.check2(i, j, k, m)) {
                            adScore = Integer.MIN_VALUE;
                        }
                        double newDiff = diff + (double)adScore + (double)this.sums[k][m];
                        if (adScore != Integer.MIN_VALUE && newDiff >= 0.0) {
                            int intron = 0;
                            int exp = 0;
                            if (this.splice != null) {
                                if (this.splice[i][j][k - i][m][4] == Integer.MAX_VALUE) {
                                    this.splice[i][j][k - i][m][4] = sites != null ? (this.getSplitReads(sites, forward, this.splice[i][j][k - i][m][3], this.splice[i][j][k - i][m][3], this.splice[i][j][k - i][m][2]) > 0 ? 1 : 0) : 0;
                                }
                                intron = this.splice[i][j][k - i][m][1];
                                exp = this.splice[i][j][k - i][m][4];
                            }
                            this.backTracking(sites, forward, lines, k, m, intron, exp, newDiff, current, best, gap);
                            if (current != null) {
                                current.hits.removeLast();
                                current.I -= intron;
                                current.i -= exp;
                            }
                        }
                    }
                    ++m;
                }
            }
        }

        private void detailedAnalyse(String chromosome, boolean forward, HashMap<Integer, ArrayList<Hit>> lines, double bestSumScore, int start, int end) throws CloneNotSupportedException, IllegalArgumentException, WrongAlphabetException, IOException {
            int bestValue;
            if (GeMoMa.this.verbose) {
                this.protocol.append("all hits " + chromosome + " " + (forward ? "+" : "-") + "\n");
                this.show(lines);
            }
            if ((double)(bestValue = this.forwardDP(forward, lines, false)) >= bestSumScore * GeMoMa.this.contigThreshold) {
                double infThresh = 0.5;
                this.getBest(true, lines);
                Solution best = new Solution();
                best.clear(forward, Integer.MIN_VALUE);
                ArrayList<int[]> borders = new ArrayList<int[]>();
                int h = 0;
                while (h < this.bestIdx[0].length()) {
                    int i = this.bestIdx[0].get(h);
                    int idx = this.bestIdx[1].get(h);
                    this.sol.clear(forward, bestValue);
                    this.backTracking(null, forward, lines, i, idx, 0, 0, 0.0, this.sol, best, false);
                    borders.add(new int[]{best.getMin(), best.getMax()});
                    ++h;
                }
                Collections.sort(borders, IntArrayComparator.comparator[0]);
                int[] bo = (int[])borders.get(0);
                int min = bo[0];
                int max = bo[1];
                int k = 1;
                while (k < borders.size() && (bo = (int[])borders.get(k))[0] < max) {
                    max = Math.max(max, bo[1]);
                    ++k;
                }
                int mid = this.findSubInterval(infThresh, forward, lines, min, max);
                if (forward) {
                    max = mid;
                } else {
                    min = mid;
                }
                HashMap<Integer, ArrayList<Hit>> middle = new HashMap<Integer, ArrayList<Hit>>();
                int j = 0;
                while (j < this.currentInfo.exonID.length) {
                    ArrayList<Hit> m;
                    int key = this.currentInfo.exonID[j];
                    ArrayList<Hit> current = lines.get(key);
                    if (current != null) {
                        m = new ArrayList();
                        int i = 0;
                        while (i < current.size()) {
                            Hit now = current.get(i);
                            if (min <= now.targetEnd && now.targetStart <= max) {
                                m.add(now);
                            }
                            ++i;
                        }
                    } else {
                        m = current;
                    }
                    middle.put(key, m == null || m.size() == 0 ? null : m);
                    ++j;
                }
                int v = this.forwardDP(forward, middle, false);
                HashMap<Integer, ArrayList<Hit>> filtered = this.reduce(null, chromosome, forward, middle, GeMoMa.this.avoidPrematureStop, false, (double)v * GeMoMa.this.hitThreshold);
                if (GeMoMa.this.verbose) {
                    this.protocol.append("filtered hits " + chromosome + " " + (forward ? "+" : "-") + "\n");
                    this.show(filtered);
                }
                middle = filtered;
                Solution s = this.detailedAnalyseRegion(chromosome, forward, middle, start, end);
                if (s.hits.size() > 0) {
                    this.result.add(s);
                    min = s.getMin();
                    max = s.getMax();
                }
                HashMap<Integer, ArrayList<Hit>> before = new HashMap<Integer, ArrayList<Hit>>();
                HashMap<Integer, ArrayList<Hit>> after = new HashMap<Integer, ArrayList<Hit>>();
                int numA = 0;
                int numB = 0;
                int j2 = 0;
                while (j2 < this.currentInfo.exonID.length) {
                    int key = this.currentInfo.exonID[j2];
                    ArrayList<Hit> current = lines.get(key);
                    ArrayList<Hit> b = new ArrayList<Hit>();
                    ArrayList<Hit> a = new ArrayList<Hit>();
                    if (current != null) {
                        int i = 0;
                        while (i < current.size()) {
                            Hit now = current.get(i);
                            if (Math.max(now.targetStart, now.targetEnd) < min) {
                                b.add(now);
                                ++numB;
                            } else if (Math.min(now.targetStart, now.targetEnd) > max) {
                                a.add(now);
                                ++numA;
                            }
                            ++i;
                        }
                    }
                    before.put(key, b.size() == 0 ? null : b);
                    after.put(key, a.size() == 0 ? null : a);
                    ++j2;
                }
                if (numB > 0) {
                    this.detailedAnalyse(chromosome, forward, before, bestSumScore, start, min);
                }
                if (numA > 0) {
                    this.detailedAnalyse(chromosome, forward, after, bestSumScore, max, end);
                }
            }
        }

        private int findSubInterval(double infThresh, boolean forward, HashMap<Integer, ArrayList<Hit>> lines, int myMin, int myMax) {
            ArrayList<Hit> inf = new ArrayList<Hit>();
            ArrayList<String> keys = new ArrayList<String>();
            int j = 0;
            while (j < this.currentInfo.exonID.length) {
                String key = String.valueOf(this.geneName) + (GeMoMa.this.transcriptInfo == null ? "" : "_" + this.currentInfo.exonID[j]);
                String r = (String)GeMoMa.this.cds.get(key);
                if (r != null && r.length() >= 30) {
                    keys.add(key);
                    ArrayList<Hit> current = lines.get(this.currentInfo.exonID[j]);
                    if (current != null) {
                        int i = 0;
                        while (i < current.size()) {
                            double v;
                            Hit now = current.get(i);
                            if (myMin <= now.targetEnd && now.targetStart <= myMax && (v = ((double)(now.queryEnd - now.queryStart) + 1.0) / (double)now.queryLength) >= infThresh) {
                                inf.add(now);
                            }
                            ++i;
                        }
                    }
                }
                ++j;
            }
            j = -2;
            int i = -2;
            Hit b = null;
            if (inf.size() > 0) {
                Collections.sort(inf, HitComparator.comparator[forward ? 0 : 1]);
                i = this.findChain(inf, 0, keys, forward, forward ? myMin : myMax);
                if (i < inf.size()) {
                    b = inf.get(i);
                    int middle = forward ? b.targetStart : b.targetEnd;
                    j = this.findChain(inf, i, keys, forward, middle);
                }
            }
            if (inf.size() > 0 && i < inf.size() && j != inf.size()) {
                int middle = forward ? b.targetStart : b.targetEnd;
                return middle;
            }
            return forward ? myMax : myMin;
        }

        private int findChain(ArrayList<Hit> inf, int i, ArrayList<String> keys, boolean forward, int start) {
            int s = 0;
            while (i < inf.size() && s < keys.size()) {
                Hit h = inf.get(i);
                if (h.queryID.equals(keys.get(s))) {
                    if (forward) {
                        if (start <= h.targetStart) {
                            start = h.targetEnd;
                            ++s;
                        }
                    } else if (h.targetEnd <= start) {
                        start = h.targetStart;
                        ++s;
                    }
                }
                ++i;
            }
            if (s == keys.size()) {
                String k = keys.get(0);
                while (i < inf.size()) {
                    Hit h = inf.get(i);
                    if (h.queryID.equals(k) && (forward ? start < h.targetStart : h.targetEnd < start)) break;
                    ++i;
                }
                if (i == inf.size()) {
                    ++i;
                }
            }
            return i;
        }

        private void show(HashMap<Integer, ArrayList<Hit>> lines) throws IOException {
            int h = 0;
            while (h < this.currentInfo.exonID.length) {
                ArrayList<Hit> list = lines.get(this.currentInfo.exonID[h]);
                this.protocol.append(String.valueOf(h) + "\t" + this.currentInfo.exonID[h] + "\t#=" + (list == null ? 0 : list.size()) + "\n");
                int k = 0;
                while (list != null && k < list.size()) {
                    this.protocol.append(list.get(k) + "\n");
                    ++k;
                }
                ++h;
            }
            this.protocol.append("\n");
        }

        private HashMap<Integer, ArrayList<Hit>> reduce(int[][] sites, String chromosome, boolean forward, HashMap<Integer, ArrayList<Hit>> lines, boolean avoidStop, boolean gap, double thresh) throws IOException, WrongAlphabetException {
            ArrayList<Hit> list;
            this.used = new double[this.currentInfo.exonID.length][];
            int i = 0;
            while (i < this.sums.length) {
                list = lines.get(this.currentInfo.exonID[i]);
                int j = 0;
                while (this.sums[i] != null && j < this.sums[i].length) {
                    int c = this.getCost(list.get(j), gap, true, i);
                    this.backTracking(sites, forward, lines, i, j, 0, 0, (double)(this.sums[i][j] + c) - thresh, null, null, gap);
                    ++j;
                }
                ++i;
            }
            if (this.splice != null) {
                int[] anz = new int[this.currentInfo.exonID.length];
                boolean changed = false;
                int i2 = 0;
                while (i2 < this.used.length) {
                    int a = 0;
                    if (this.used[i2] != null) {
                        int j = 0;
                        while (j < this.used[i2].length) {
                            if (this.used[i2][j] >= 0.0) {
                                ++a;
                            } else {
                                changed = true;
                            }
                            ++j;
                        }
                    } else {
                        list = lines.get(this.currentInfo.exonID[i2]);
                        if (list != null && list.size() > 0) {
                            changed = true;
                        }
                    }
                    anz[i2] = a;
                    ++i2;
                }
                if (GeMoMa.this.verbose) {
                    this.protocol.append("#new hits: " + Arrays.toString(anz) + "\n");
                }
                if (changed) {
                    int[][][][][] splice2 = new int[this.currentInfo.exonID.length][][][][];
                    int i3 = 0;
                    while (i3 < this.used.length) {
                        if (anz[i3] > 0) {
                            splice2[i3] = new int[anz[i3]][this.currentInfo.exonID.length - i3][][];
                            int[] su = new int[anz[i3]];
                            int[] st = new int[anz[i3]];
                            int[] e = new int[anz[i3]];
                            int[] qS = new int[anz[i3]];
                            int[] qE = new int[anz[i3]];
                            int[] qL = new int[anz[i3]];
                            int idx = 0;
                            int j = 0;
                            while (this.used[i3] != null && j < this.used[i3].length) {
                                if (this.used[i3][j] >= 0.0) {
                                    su[idx] = this.sums[i3][j];
                                    st[idx] = this.start[i3][j];
                                    e[idx] = this.end[i3][j];
                                    qS[idx] = this.qStart[i3][j];
                                    qE[idx] = this.qEnd[i3][j];
                                    qL[idx] = this.qL[i3][j];
                                    int k = i3;
                                    while (k < this.used.length) {
                                        splice2[i3][idx][k - i3] = new int[anz[k]][5];
                                        if (this.splice[i3][j][k - i3] != null && anz[k] > 0) {
                                            int idx2 = 0;
                                            int l = 0;
                                            while (l < this.used[k].length) {
                                                if (this.used[k][l] >= 0.0) {
                                                    System.arraycopy(this.splice[i3][j][k - i3][l], 0, splice2[i3][idx][k - i3][idx2++], 0, this.splice[i3][j][k - i3][l].length);
                                                }
                                                ++l;
                                            }
                                        }
                                        ++k;
                                    }
                                    ++idx;
                                }
                                ++j;
                            }
                            this.sums[i3] = su;
                            this.start[i3] = st;
                            this.end[i3] = e;
                            this.qStart[i3] = qS;
                            this.qEnd[i3] = qE;
                            this.qL[i3] = qL;
                        } else {
                            this.qEnd[i3] = null;
                            this.qStart[i3] = null;
                            this.end[i3] = null;
                            this.start[i3] = null;
                            this.sums[i3] = null;
                        }
                        ++i3;
                    }
                    this.splice = splice2;
                }
            }
            HashMap<Integer, ArrayList<Hit>> filtered = new HashMap<Integer, ArrayList<Hit>>();
            int i4 = 0;
            while (i4 < this.used.length) {
                if (this.used[i4] != null) {
                    list = lines.get(this.currentInfo.exonID[i4]);
                    ArrayList<Hit> add = new ArrayList<Hit>();
                    int j = 0;
                    while (j < this.used[i4].length) {
                        if (this.used[i4][j] >= 0.0) {
                            if (avoidStop) {
                                list.get(j).addSplitHits(add);
                            } else {
                                add.add(list.get(j));
                            }
                        }
                        ++j;
                    }
                    if (add.size() > 0) {
                        filtered.put(this.currentInfo.exonID[i4], add);
                    }
                }
                ++i4;
            }
            this.used = null;
            return filtered;
        }

        private Solution detailedAnalyseRegion(String chromosome, boolean forward, HashMap<Integer, ArrayList<Hit>> filtered, int globalStart, int globalEnd) throws CloneNotSupportedException, WrongAlphabetException, IOException {
            int[][][] sites;
            ArrayList<Hit> current;
            if (GeMoMa.this.verbose) {
                this.show(filtered);
            }
            int i = 0;
            while (i < this.currentInfo.exonID.length) {
                current = filtered.get(this.currentInfo.exonID[i]);
                this.oldSize[i] = current == null ? 0 : current.size();
                ++i;
            }
            String chr = seqs.get(chromosome);
            if (globalStart < 0) {
                globalStart = 0;
            }
            if (globalEnd < 0) {
                globalEnd = chr.length();
            }
            if (acceptorSites != null && donorSites != null) {
                int h = 0;
                while (h < this.currentInfo.exonID.length) {
                    ArrayList<Hit> list = filtered.get(this.currentInfo.exonID[h]);
                    int k = 0;
                    while (list != null && k < list.size()) {
                        Hit hit = list.get(k);
                        hit.prepareSpliceCandidates(chr, this.align, this.maxAllowedIntron);
                        ++k;
                    }
                    ++h;
                }
            }
            int first = -1;
            int last = this.currentInfo.exonID.length;
            int old = -1;
            int j = 0;
            while (j < this.currentInfo.exonID.length) {
                current = filtered.get(this.currentInfo.exonID[j]);
                if (current != null && current.size() > 0) {
                    if (first < 0) {
                        first = j;
                    }
                    last = j;
                    if (old >= 0 && old + 1 != j) {
                        ArrayList<Hit> previous = filtered.get(this.currentInfo.exonID[old]);
                        int offset = current.size();
                        UnionFind uf = new UnionFind(offset + previous.size());
                        int a = 0;
                        while (a < current.size()) {
                            Hit x = current.get(a);
                            int b = 0;
                            while (b < previous.size()) {
                                int d;
                                Hit y = previous.get(b);
                                if (forward) {
                                    d = x.targetStart - y.targetEnd;
                                    if (d >= 0 && d < (j - old) * this.maxAllowedIntron) {
                                        uf.union(a, offset + b);
                                    }
                                } else {
                                    d = y.targetStart - x.targetEnd;
                                    if (d >= 0 && d < (j - old) * this.maxAllowedIntron) {
                                        uf.union(a, offset + b);
                                    }
                                }
                                ++b;
                            }
                            ++a;
                        }
                        int[][] array = uf.getComponents();
                        int a2 = 0;
                        while (a2 < array.length) {
                            int i2;
                            int end;
                            int start;
                            boolean de = false;
                            boolean ae = false;
                            if (forward) {
                                start = -1;
                                end = Integer.MAX_VALUE;
                                i2 = 0;
                                while (i2 < array[a2].length) {
                                    if (array[a2][i2] < offset) {
                                        start = Math.max(start, current.get((int)array[a2][i2]).targetStart);
                                        de |= current.get((int)array[a2][i2]).de;
                                    } else {
                                        end = Math.min(end, previous.get((int)(array[a2][i2] - offset)).targetEnd);
                                        ae |= previous.get((int)(array[a2][i2] - offset)).ae;
                                    }
                                    ++i2;
                                }
                            } else {
                                start = Integer.MAX_VALUE;
                                end = -1;
                                i2 = 0;
                                while (i2 < array[a2].length) {
                                    if (array[a2][i2] < offset) {
                                        start = Math.min(start, current.get((int)array[a2][i2]).targetEnd);
                                        ae |= current.get((int)array[a2][i2]).ae;
                                    } else {
                                        end = Math.max(end, previous.get((int)(array[a2][i2] - offset)).targetStart);
                                        de |= previous.get((int)(array[a2][i2] - offset)).de;
                                    }
                                    ++i2;
                                }
                            }
                            if (start > end == forward) {
                                if (GeMoMa.this.verbose) {
                                    this.protocol.append("INTERNAL\t" + (old + 1) + ".." + (j - 1) + "\t" + this.currentInfo.exonID[old + 1] + ".." + this.currentInfo.exonID[j - 1] + "\n");
                                }
                                this.align(chromosome, forward, end, start, old + 1, j, filtered, "internal", ae && de, ae && de);
                            }
                            ++a2;
                        }
                    }
                    old = j;
                }
                ++j;
            }
            if (first > 0) {
                if (GeMoMa.this.verbose) {
                    this.protocol.append("FIRST\t" + first + "\t" + this.currentInfo.exonID[first] + "\n");
                }
                this.extend(chromosome, forward, filtered, first, true, "upstream", globalStart, globalEnd);
            }
            if (last < this.currentInfo.exonID.length - 1) {
                if (GeMoMa.this.verbose) {
                    this.protocol.append("LAST\t" + last + "\t" + this.currentInfo.exonID[last] + "\n");
                }
                this.extend(chromosome, forward, filtered, last, false, "downstream", globalStart, globalEnd);
            }
            int i3 = 0;
            while (i3 < this.currentInfo.exonID.length) {
                current = filtered.get(this.currentInfo.exonID[i3]);
                if (current != null && current.size() - this.oldSize[i3] > 20000) {
                    while (current.size() > this.oldSize[i3]) {
                        current.remove(current.size() - 1);
                    }
                }
                ++i3;
            }
            int h = 0;
            while (h < this.currentInfo.exonID.length) {
                ArrayList<Hit> list = filtered.get(this.currentInfo.exonID[h]);
                String r = String.valueOf(this.geneName) + (GeMoMa.this.transcriptInfo == null ? "" : "_" + this.currentInfo.exonID[h]);
                String ref = (String)GeMoMa.this.cds.get(r);
                int k = 0;
                while (list != null && k < list.size()) {
                    Hit hit = list.get(k);
                    if (!hit.splice) {
                        hit.prepareSpliceCandidates(chr, this.align, this.maxAllowedIntron);
                    }
                    if (ref != null && (h == 0 && ref.charAt(0) == 'M' || h + 1 == this.currentInfo.exonID.length && ref.charAt(ref.length() - 1) == '*')) {
                        hit.setBorderConstraints(h == 0 && ref.charAt(0) == 'M', h + 1 == this.currentInfo.exonID.length && ref.charAt(ref.length() - 1) == '*', this.align);
                    }
                    ++k;
                }
                ++h;
            }
            this.sort(filtered, forward);
            this.splice = new int[this.currentInfo.exonID.length][][][][];
            int bestValue = this.forwardDP(forward, filtered, true);
            int[][][] nArray = sites = donorSites != null ? donorSites.get(chromosome) : null;
            int[][] specSites = sites == null ? null : sites[forward ? 0 : 1];
            filtered = this.reduce(specSites, chromosome, forward, filtered, GeMoMa.this.avoidPrematureStop, true, bestValue);
            if (GeMoMa.this.verbose) {
                int h2 = 0;
                while (h2 < this.currentInfo.exonID.length) {
                    ArrayList<Hit> list = filtered.get(this.currentInfo.exonID[h2]);
                    this.protocol.append(String.valueOf(this.currentInfo.exonID[h2]) + "\t" + Arrays.toString(this.sums[h2]) + "\n");
                    int k = 0;
                    while (list != null && k < list.size()) {
                        Hit hi = list.get(k);
                        this.protocol.append(hi + "\t" + hi.firstAddScore + "\t" + hi.lastAddScore + "\t" + hi.up + "\t" + hi.seqUp + "\t" + hi.down + "\t" + hi.seqDown + "\n");
                        ++k;
                    }
                    ++h2;
                }
            }
            this.getBest(true, filtered);
            if (GeMoMa.this.verbose) {
                this.protocol.append(String.valueOf(bestValue) + "\n");
                this.protocol.append(this.bestIdx[0] + ", " + this.bestIdx[1] + "\n");
            }
            Solution best = new Solution();
            best.clear(forward, Integer.MIN_VALUE);
            int h3 = 0;
            while (h3 < this.bestIdx[0].length()) {
                int i4 = this.bestIdx[0].get(h3);
                int idx = this.bestIdx[1].get(h3);
                this.sol.clear(forward, bestValue);
                if (GeMoMa.this.verbose) {
                    this.protocol.append(String.valueOf(i4) + ", " + idx + "\n");
                }
                this.backTracking(specSites, forward, filtered, i4, idx, 0, 0, 0.0, this.sol, best, true);
                if (GeMoMa.this.verbose) {
                    this.protocol.append(best + "\n");
                }
                ++h3;
            }
            this.splice = null;
            return best;
        }

        private void extend(String chromosome, boolean forward, HashMap<Integer, ArrayList<Hit>> lines, int index, boolean upstream, String info, int globalStart, int globalEnd) throws IllegalArgumentException, WrongAlphabetException {
            int next;
            int end;
            int dir;
            if (upstream) {
                dir = -1;
                end = -1;
            } else {
                dir = 1;
                end = this.currentInfo.exonID.length;
            }
            int d = this.maxAllowedIntron / GeMoMa.this.REDUCTION_FACTOR;
            int f = 0;
            int a = upstream ? 0 : d;
            int[][] array = null;
            do {
                int startNext;
                int endLast;
                ArrayList<Hit> current;
                if ((current = lines.get(this.currentInfo.exonID[index])) != null) {
                    array = new int[current.size()][2];
                    int i = 0;
                    while (i < array.length) {
                        Hit h = current.get(i);
                        array[i][0] = upstream == forward ? h.targetStart : h.targetEnd;
                        array[i][1] = (upstream ? h.ae : h.de) ? 1 : 0;
                        ++i;
                    }
                    Arrays.sort(array, IntArrayComparator.comparator[0]);
                    f = 1;
                } else {
                    ++f;
                }
                next = index + dir;
                int stop = upstream ? index : next + dir;
                int startIndex = 0;
                boolean site = false;
                int i = 1;
                while (i < array.length) {
                    if (array[i][0] - array[i - 1][0] > d) {
                        int startNext2;
                        int endLast2;
                        if (forward) {
                            endLast2 = Math.max(globalStart, array[startIndex][0] - f * (d - a));
                            startNext2 = Math.min(globalEnd, array[i - 1][0] + f * a);
                        } else {
                            endLast2 = Math.min(globalEnd, array[i - 1][0] + f * (d - a));
                            startNext2 = Math.max(globalStart, array[startIndex][0] - f * a);
                        }
                        this.align(chromosome, forward, endLast2, startNext2, next, stop, lines, info, upstream ? false : site, upstream ? site : false);
                        startIndex = i;
                        site = false;
                    }
                    site |= array[i][1] == 1;
                    ++i;
                }
                if (forward) {
                    endLast = Math.max(globalStart, array[startIndex][0] - f * (d - a));
                    startNext = Math.min(globalEnd, array[array.length - 1][0] + f * a);
                } else {
                    endLast = Math.min(globalEnd, array[array.length - 1][0] + f * (d - a));
                    startNext = Math.max(globalStart, array[startIndex][0] - f * a);
                }
                this.align(chromosome, forward, endLast, startNext, next, stop, lines, info, upstream ? false : site, upstream ? site : false);
            } while ((index = next) + dir != end);
        }

        private void align(String chromosome, boolean forward, int endLast, int startNext, int startIdx, int endIdx, HashMap<Integer, ArrayList<Hit>> lines, String info, boolean up, boolean down) throws IllegalArgumentException, WrongAlphabetException {
            String chr = seqs.get(chromosome);
            if (forward) {
                if (endLast < 0) {
                    endLast = 0;
                }
                if (startNext > chr.length()) {
                    startNext = chr.length();
                }
            } else {
                if (startNext < 0) {
                    startNext = 0;
                }
                if (endLast > chr.length()) {
                    endLast = chr.length();
                }
            }
            String region = chr.substring(forward ? endLast : startNext, forward ? startNext : endLast);
            if (!forward) {
                region = Tools.rc(region);
            }
            int i = startIdx;
            while (i < endIdx) {
                this.alignPart(chromosome, forward, endLast, startNext, i, -1, -1, region, lines, info, up, down);
                ++i;
            }
        }

        private int alignPart(String chromosome, boolean forward, int endLast, int startNext, int idx, int startPos, int endPos, String region, HashMap<Integer, ArrayList<Hit>> lines, String info, boolean upstream, boolean downstream) throws IllegalArgumentException, WrongAlphabetException {
            Object acc = null;
            Object don = null;
            int donFrom = -1;
            int donTo = -1;
            int accFrom = -1;
            int accTo = -1;
            downstream = false;
            upstream = false;
            Sequence cdsSeq = null;
            String r = String.valueOf(this.geneName) + (GeMoMa.this.transcriptInfo == null ? "" : "_" + this.currentInfo.exonID[idx]);
            String m = (String)GeMoMa.this.cds.get(r);
            double best = 0.0;
            int anz = 0;
            if (m != null) {
                ArrayList<Hit> cand;
                boolean add;
                boolean findStart;
                int len = m.length();
                boolean bl = findStart = idx == 0 && startPos <= 0 && m.charAt(0) == 'M';
                if (startPos >= 0 && endPos >= 0) {
                    m = m.substring(startPos, endPos);
                }
                boolean bl2 = add = (cand = lines.get(this.currentInfo.exonID[idx])) == null;
                if (add) {
                    cand = new ArrayList();
                }
                int oldSize = cand.size();
                cdsSeq = Sequence.create(GeMoMa.this.alph, m);
                int tested = upstream || downstream ? 0 : 1;
                do {
                    int k = 0;
                    while (k < 3) {
                        int splitStart = k;
                        String trans = Tools.translate(k, region, code, false, GeMoMa.this.ambiguity);
                        String[] split = trans.split("\\*");
                        int a = 0;
                        while (a < split.length) {
                            Sequence intronPartSeq;
                            PairwiseStringAlignment sa;
                            double c;
                            int x;
                            int e;
                            int off;
                            if (idx + 1 == this.currentInfo.exonID.length && a + 1 < split.length) {
                                int n = a;
                                split[n] = String.valueOf(split[n]) + "*";
                                off = 0;
                            } else {
                                int n = off = a + 1 < split.length ? 1 : 0;
                            }
                            if (forward) {
                                e = endLast + (forward ? 1 : -1) * (splitStart - 2);
                                x = e + (forward ? 1 : -1) * ((split[a].length() + off) * 3 - 1);
                            } else {
                                x = endLast + (forward ? 1 : -1) * (splitStart - 2);
                                e = x + (forward ? 1 : -1) * ((split[a].length() + off) * 3 - 1);
                            }
                            if (split[a].length() > 0 && (!findStart || m.length() > 20 || split[a].indexOf(77) >= 0) && (c = (sa = this.align.getAlignment(Alignment.AlignmentType.LOCAL, cdsSeq, intronPartSeq = Sequence.create(GeMoMa.this.alph, split[a]))).getCost()) < 0.0 && c <= best * GeMoMa.this.hitThreshold) {
                                String xx = sa.getAlignedString(1).replaceAll("-", "");
                                int l = 3 * xx.length();
                                int z = split[a].indexOf(77);
                                int endAlign2 = -1;
                                while ((endAlign2 = split[a].indexOf(xx, endAlign2 + 1)) >= 0) {
                                    int end;
                                    int start;
                                    int pos;
                                    if (findStart && sa.getStartIndexOfAlignmentForFirst() <= 10 && (z < 0 || z >= endAlign2 + xx.length())) continue;
                                    if (forward) {
                                        pos = endLast + (splitStart + 3 * endAlign2);
                                        start = pos + 1;
                                        end = pos + l;
                                    } else {
                                        pos = endLast - (splitStart + 3 * endAlign2);
                                        end = pos - l + 1;
                                        start = pos;
                                    }
                                    if (start < 0 || end < 0) {
                                        this.protocol.append(String.valueOf(endLast) + "\n");
                                        this.protocol.append(String.valueOf(startNext) + "\n");
                                        throw new RuntimeException("negative pos");
                                    }
                                    Hit h = new Hit(r, chromosome, sa.getStartIndexOfAlignmentForFirst() + 1, sa.getEndIndexOfAlignmentForFirst(), len, start, end, (int)(-sa.getCost()), sa.getAlignedString(0), sa.getAlignedString(1), String.valueOf(info) + ";");
                                    cand.add(h);
                                    if (!(sa.getCost() < best)) continue;
                                    best = sa.getCost();
                                }
                            }
                            splitStart += 3 * (split[a].length() + off);
                            ++a;
                        }
                        ++k;
                    }
                    int j = cand.size() - 1;
                    while (j >= 0 && cand.size() > oldSize) {
                        Hit o = cand.get(j);
                        if ((double)o.score <= -GeMoMa.this.hitThreshold * best) {
                            cand.remove(j);
                        }
                        --j;
                    }
                    if (add && cand.size() > oldSize) {
                        lines.put(this.currentInfo.exonID[idx], cand);
                    }
                    anz = cand.size() - oldSize;
                    downstream = false;
                    upstream = false;
                } while (anz == 0 && acc != null && don != null && ++tested < 2);
            }
            return anz;
        }

        String getProteinSeqFromExons(Hit first, Hit second) {
            String m;
            String firstCDS = (String)GeMoMa.this.cds.get(first.queryID);
            int partStart = first.part;
            int partEnd = second.part;
            if (partStart == partEnd) {
                m = firstCDS.substring(first.queryStart - 1, second.queryEnd);
            } else {
                m = firstCDS.substring(first.queryStart - 1);
                m = String.valueOf(m) + this.currentInfo.splitAA[this.revParts[partStart]];
                int idx = this.revParts[partStart] + 1;
                while (idx < this.revParts[partEnd]) {
                    String p = (String)GeMoMa.this.cds.get(String.valueOf(this.geneName) + (GeMoMa.this.transcriptInfo == null ? "" : "_" + this.currentInfo.exonID[idx]));
                    if (p != null) {
                        m = String.valueOf(m) + p;
                    }
                    m = String.valueOf(m) + this.currentInfo.splitAA[idx];
                    ++idx;
                }
                m = String.valueOf(m) + ((String)GeMoMa.this.cds.get(second.queryID)).substring(0, second.queryEnd);
            }
            return m;
        }

        private void checkSpliceSites(String chr, Hit first, Hit second, int delta, int[] res) throws WrongAlphabetException {
            int d = this.revParts[second.part] - this.revParts[first.part];
            if (d <= 1) {
                boolean b = d != 0;
                Arrays.fill(this.spliceType, b);
                this.spliceType[3] = !b;
                this.checkSpecificSpliceSiteTypes(chr, first, second, delta, res);
                if (res[0] == Integer.MIN_VALUE) {
                    int i = 0;
                    while (i < this.spliceType.length) {
                        this.spliceType[i] = !this.spliceType[i];
                        ++i;
                    }
                    this.checkSpecificSpliceSiteTypes(chr, first, second, delta, res);
                }
            } else {
                Arrays.fill(this.spliceType, true);
                this.checkSpecificSpliceSiteTypes(chr, first, second, delta, res);
            }
        }

        private void checkSpecificSpliceSiteTypes(String chr, Hit first, Hit second, int delta, int[] res) throws WrongAlphabetException {
            int current;
            Sequence targetSeq;
            int diff;
            this.refined[1] = 0;
            this.refined[0] = 0;
            boolean f = first.forward;
            int best = Integer.MIN_VALUE;
            int intron = 0;
            Sequence cdsSeq = null;
            String region = null;
            int n = diff = first.forward ? second.targetStart - 1 - first.targetEnd : first.targetStart - 1 - second.targetEnd;
            if (this.spliceType[3] && diff >= 0 && diff % 3 == 0 && (first.forward && first.maxDownstreamEnd > second.targetStart && first.targetEnd > second.maxUpstreamStart || !first.forward && first.maxDownstreamEnd < second.targetEnd && first.targetStart < second.maxUpstreamStart)) {
                if (first.forward) {
                    region = chr.substring(first.targetStart - 1, second.targetEnd);
                } else {
                    region = chr.substring(second.targetStart - 1, first.targetEnd);
                    region = Tools.rc(region);
                }
                targetSeq = Sequence.create(GeMoMa.this.alph, Tools.translate(0, region, code, false, GeMoMa.this.ambiguity));
                cdsSeq = Sequence.create(GeMoMa.this.alph, this.getProteinSeqFromExons(first, second));
                this.align.computeAlignment(Alignment.AlignmentType.GLOBAL, targetSeq, cdsSeq);
                current = (int)this.align.getCost(targetSeq.getLength(), cdsSeq.getLength());
                best = -current - (first.score + second.score);
                this.refined[0] = diff;
                this.refined[1] = 0;
                best -= (this.revParts[second.part] - this.revParts[first.part]) * GeMoMa.this.INTRON_GAIN_LOSS;
            }
            boolean same = second.part == first.part;
            boolean computed = false;
            if ((!same || best == Integer.MIN_VALUE) && (this.spliceType[0] || this.spliceType[1] || this.spliceType[2])) {
                int gap = this.getGapCost(delta, this.revParts[second.part] - 1 - this.revParts[first.part]);
                int gain_or_loss = Math.abs(this.revParts[second.part] - 1 - this.revParts[first.part]) * GeMoMa.this.INTRON_GAIN_LOSS;
                int p = 0;
                int length = Integer.MAX_VALUE;
                int end = f ? first.targetEnd : first.targetStart;
                int start = f ? second.targetStart : second.targetEnd;
                String remaining2 = null;
                boolean set = false;
                do {
                    int remainingSecond = 0;
                    while (remainingSecond < 3) {
                        if (this.spliceType[remainingSecond]) {
                            int remainingFirst = (3 - remainingSecond) % 3;
                            int j = 0;
                            while (j < second.accCand[remainingSecond].length()) {
                                int a = second.accCand[remainingSecond].get(j);
                                if (remainingSecond != 0) {
                                    current = f ? second.targetStart - 1 - a : second.targetEnd + a - remainingSecond;
                                    remaining2 = chr.substring(current, current + remainingSecond);
                                    if (!f) {
                                        remaining2 = Tools.rc(remaining2);
                                    }
                                }
                                int k = 0;
                                while (k < first.donCand[p][remainingFirst].length()) {
                                    int d;
                                    int b = first.donCand[p][remainingFirst].get(k);
                                    int n2 = d = f ? start - a - (end + b) : end - b - (start + a);
                                    if (d >= 30) {
                                        char aa;
                                        String triplett;
                                        String remaining1;
                                        if (remainingSecond != 0) {
                                            current = f ? first.targetEnd + b - remainingFirst : first.targetStart - 1 - b;
                                            remaining1 = chr.substring(current, current + remainingFirst);
                                            if (!f) {
                                                remaining1 = Tools.rc(remaining1);
                                            }
                                            triplett = String.valueOf(remaining1) + remaining2;
                                            aa = Tools.translate(triplett, code, GeMoMa.this.ambiguity);
                                        } else {
                                            triplett = null;
                                            remaining2 = null;
                                            remaining1 = null;
                                            aa = '!';
                                        }
                                        if (aa != '*') {
                                            if (!same) {
                                                current = first.donCandScore[p][remainingFirst].get(k) + second.accCandScore[remainingSecond].get(j) + gap;
                                                if (this.revParts[first.part] + 1 == this.revParts[second.part]) {
                                                    String ref = this.currentInfo.splitAA[this.revParts[first.part]];
                                                    if (aa == '!' || ref.length() == 0) {
                                                        if (aa != '!' || ref.length() != 0) {
                                                            current += this.getGapCost(1, 0);
                                                        }
                                                    } else {
                                                        current = (int)((double)current - GeMoMa.this.matrix[GeMoMa.this.aaAlphabet.getCode("" + aa)][GeMoMa.this.aaAlphabet.getCode(ref)]);
                                                    }
                                                }
                                            } else {
                                                if (!GeMoMa.this.approx) {
                                                    if (cdsSeq == null) {
                                                        cdsSeq = Sequence.create(GeMoMa.this.alph, this.getProteinSeqFromExons(first, second));
                                                    }
                                                    if (first.forward) {
                                                        region = String.valueOf(chr.substring(first.targetStart - 1, first.targetEnd + b)) + chr.substring(second.targetStart - 1 - a, second.targetEnd);
                                                    } else {
                                                        region = String.valueOf(chr.substring(second.targetStart - 1, second.targetEnd + a)) + chr.substring(first.targetStart - 1 - b, first.targetEnd);
                                                        region = Tools.rc(region);
                                                    }
                                                    targetSeq = Sequence.create(GeMoMa.this.alph, Tools.translate(0, region, code, false, GeMoMa.this.ambiguity));
                                                    this.align1.computeAlignment(Alignment.AlignmentType.GLOBAL, targetSeq, cdsSeq);
                                                    current = (int)this.align1.getCost(targetSeq.getLength(), cdsSeq.getLength()) - gain_or_loss;
                                                } else {
                                                    if (!computed) {
                                                        if (cdsSeq == null) {
                                                            cdsSeq = Sequence.create(GeMoMa.this.alph, this.getProteinSeqFromExons(first, second));
                                                        }
                                                        this.align1.computeAlignment(Alignment.AlignmentType.GLOBAL, cdsSeq, Sequence.create(GeMoMa.this.alph, String.valueOf(first.targetAlign.replaceAll("-", "")) + first.down));
                                                        try {
                                                            this.align2.computeAlignment(Alignment.AlignmentType.GLOBAL, cdsSeq.reverse(), Sequence.create(GeMoMa.this.alph, second.up + second.targetAlign.replaceAll("-", "")).reverse());
                                                        }
                                                        catch (OperationNotSupportedException onse) {
                                                            throw new RuntimeException(onse.getMessage());
                                                        }
                                                        computed = true;
                                                    }
                                                    region = "";
                                                    int l1 = first.targetEnd + b - (first.targetStart - 1);
                                                    int l2 = second.targetEnd - (second.targetStart - 1 - a);
                                                    double v = this.align1.getBestValue(this.align2, l1 / 3, l2 / 3, aa);
                                                    current = Double.isInfinite(v) ? Integer.MIN_VALUE : (int)v;
                                                }
                                                if (current != Integer.MIN_VALUE) {
                                                    current = -current - gain_or_loss - first.score - second.score;
                                                }
                                            }
                                            int len = Math.abs(a) + Math.abs(b);
                                            if (current != Integer.MIN_VALUE && (current > best || current == best && len < length)) {
                                                best = current;
                                                length = len;
                                                this.refined[0] = b;
                                                this.refined[1] = a;
                                                intron = 1;
                                                set = true;
                                            }
                                        }
                                    }
                                    ++k;
                                }
                                ++j;
                            }
                        }
                        ++remainingSecond;
                    }
                } while (++p < first.donCand.length && !set);
            }
            res[0] = best;
            res[1] = intron;
            if (intron == 1) {
                res[2] = first.forward ? first.targetEnd + this.refined[0] + 1 : first.targetStart - this.refined[0];
                res[3] = second.forward ? second.targetStart - this.refined[1] : second.targetEnd + this.refined[1];
                res[4] = Integer.MAX_VALUE;
            }
        }

        int getSplitReads(int[][] donSites, boolean forward, int start, int end, int last) {
            int result = 0;
            if (donSites != null) {
                int v = forward ? start : end + 1;
                int idx = Arrays.binarySearch(donSites[0], last);
                if (idx > 0) {
                    while (idx > 0 && donSites[0][idx - 1] == last) {
                        --idx;
                    }
                }
                if (idx >= 0) {
                    while (idx < donSites[0].length && donSites[0][idx] == last && donSites[1][idx] != v) {
                        ++idx;
                    }
                    if (idx < donSites[0].length && donSites[0][idx] == last && donSites[1][idx] == v) {
                        result = donSites[2][idx];
                    }
                }
            }
            return result;
        }

        int getBest(boolean gap, HashMap<Integer, ArrayList<Hit>> hits) {
            this.bestIdx[0].clear();
            this.bestIdx[1].clear();
            int bestValue = Integer.MIN_VALUE;
            int i = 0;
            while (i < this.sums.length) {
                ArrayList<Hit> current = hits.get(this.currentInfo.exonID[i]);
                int j = 0;
                while (this.sums[i] != null && j < this.sums[i].length) {
                    int add = this.getCost(current.get(j), gap, true, i);
                    if (bestValue <= this.sums[i][j] + add) {
                        if (bestValue < this.sums[i][j] + add) {
                            this.bestIdx[0].clear();
                            this.bestIdx[1].clear();
                            bestValue = this.sums[i][j] + add;
                        }
                        this.bestIdx[0].add(i);
                        this.bestIdx[1].add(j);
                    }
                    ++j;
                }
                ++i;
            }
            return bestValue;
        }

        class Solution
        implements Comparable<Solution>,
        Cloneable {
            LinkedList<Hit> hits = new LinkedList();
            boolean forward;
            int score = Integer.MIN_VALUE;
            int minSplitReads;
            int a;
            int A;
            int d;
            int D;
            int i;
            int I;
            int Len;
            int Cov;
            int minC;
            int Sum;

            public int getNumberOfAA() {
                int l = 0;
                Iterator it = this.hits.iterator();
                while (it.hasNext()) {
                    l += ((Hit)it.next()).getLength();
                }
                return l / 3;
            }

            public String getDNA() {
                StringBuffer sb = new StringBuffer();
                Iterator it = this.hits.iterator();
                while (it.hasNext()) {
                    sb.append(((Hit)it.next()).getDNA(0, 0));
                }
                return sb.toString();
            }

            public String getProtein() {
                return Tools.translate(0, this.getDNA(), code, false, GeMoMa.this.ambiguity);
            }

            public Solution clone() throws CloneNotSupportedException {
                Solution clone = (Solution)super.clone();
                clone.hits = new LinkedList();
                Iterator it = this.hits.iterator();
                while (it.hasNext()) {
                    clone.hits.add(((Hit)it.next()).clone());
                }
                return clone;
            }

            public void clear(boolean f, int score) {
                this.hits.clear();
                this.forward = f;
                this.I = 0;
                this.i = 0;
                this.D = 0;
                this.A = 0;
                this.d = 0;
                this.a = 0;
                this.score = score;
            }

            public int matchParts() {
                int p = 0;
                boolean[] match = new boolean[((TranscriptPredictor)TranscriptPredictor.this).currentInfo.exonID.length];
                Arrays.fill(match, false);
                int i = 0;
                while (i < this.hits.size()) {
                    int part = this.hits.get((int)i).part;
                    if (!match[TranscriptPredictor.this.revParts[part]]) {
                        match[((TranscriptPredictor)TranscriptPredictor.this).revParts[part]] = true;
                        ++p;
                    }
                    ++i;
                }
                return p;
            }

            public int getMin() {
                int min = Integer.MAX_VALUE;
                int i = 0;
                while (i < this.hits.size()) {
                    Hit o = this.hits.get(i);
                    int v = o.targetStart;
                    if (v < min) {
                        min = v;
                    }
                    ++i;
                }
                return min;
            }

            public int getMax() {
                int max = Integer.MIN_VALUE;
                int i = 0;
                while (i < this.hits.size()) {
                    Hit o = this.hits.get(i);
                    int v = o.targetEnd;
                    if (v > max) {
                        max = v;
                    }
                    ++i;
                }
                return max;
            }

            public int getDifference() {
                return this.getMax() - this.getMin();
            }

            public void set(Solution s) {
                this.clear(s.forward, s.score);
                this.hits.addAll(s.hits);
                this.I = s.I;
                this.i = s.i;
            }

            @Override
            public int compareTo(Solution o) {
                int d = this.similar(o);
                if (d == 0) {
                    if (this.I > 0 && o.I > 0) {
                        d = -Double.compare((double)this.i / (double)this.I, (double)o.i / (double)o.I);
                    }
                    if (d == 0) {
                        d = this.getDifference() - o.getDifference();
                    }
                }
                return d;
            }

            public int similar(Solution o) {
                if (o == null) {
                    return Integer.MIN_VALUE;
                }
                if (this.score == Integer.MIN_VALUE) {
                    return 1;
                }
                if (o.score == Integer.MIN_VALUE) {
                    return -1;
                }
                int d = o.score - this.score;
                if (d == 0 && (d = o.matchParts() - this.matchParts()) == 0 && (d = this.hits.size() - o.hits.size()) == 0) {
                    Hit h = this.hits.get(0);
                    int firstAA = 33;
                    int oFirstAA = 33;
                    if (TranscriptPredictor.this.revParts[h.part] == 0) {
                        firstAA = h.firstAA;
                    }
                    h = o.hits.get(0);
                    if (TranscriptPredictor.this.revParts[h.part] == 0) {
                        oFirstAA = h.firstAA;
                    }
                    if (firstAA != oFirstAA) {
                        if (firstAA == 77) {
                            d = 1;
                        } else if (oFirstAA == 77) {
                            d = -1;
                        }
                    }
                }
                return d;
            }

            public String toString() {
                Iterator it = this.hits.iterator();
                String res = "";
                while (it.hasNext()) {
                    res = String.valueOf(res) + it.next() + "\n";
                }
                return res;
            }

            public Solution refine(String transcriptName) throws WrongAlphabetException, CloneNotSupportedException {
                Hit c;
                if (this.hits.size() == 0) {
                    return this;
                }
                Solution res = new Solution();
                res.clear(this.forward, this.score);
                res.i = this.i;
                res.I = this.I;
                Hit l = this.hits.get(0);
                res.hits.add(l.clone());
                String chr = seqs.get(l.targetID);
                int[] help = new int[5];
                int i = 1;
                while (i < this.hits.size()) {
                    c = this.hits.get(i);
                    res.hits.add(c.clone());
                    int delta = 0;
                    int j = TranscriptPredictor.this.revParts[l.part] + 1;
                    while (j < TranscriptPredictor.this.revParts[c.part]) {
                        delta += TranscriptPredictor.this.length[j];
                        ++j;
                    }
                    TranscriptPredictor.this.checkSpliceSites(chr, l, c, delta, help);
                    if (help[0] != Integer.MIN_VALUE) {
                        res.hits.get(i - 1).setSpliceSite(true, TranscriptPredictor.this.refined[0]);
                        res.hits.get(i).setSpliceSite(false, TranscriptPredictor.this.refined[1]);
                    }
                    l = c;
                    ++i;
                }
                String ref = TranscriptPredictor.this.getRefProtein(transcriptName);
                if (ref.charAt(0) == 'M') {
                    c = res.hits.get(0);
                    c.extend(c.part == ((TranscriptPredictor)TranscriptPredictor.this).currentInfo.exonID[0], false);
                }
                if (ref.charAt(ref.length() - 1) == '*') {
                    c = res.hits.get(res.hits.size() - 1);
                    c.extend(false, c.part == ((TranscriptPredictor)TranscriptPredictor.this).currentInfo.exonID[((TranscriptPredictor)TranscriptPredictor.this).currentInfo.exonID.length - 1]);
                }
                return res;
            }

            public String getInfo(BufferedWriter gff) throws IOException {
                Iterator it = this.hits.iterator();
                Hit oldH = null;
                String dna = "";
                boolean intronGain = false;
                boolean intronLoss = false;
                while (it.hasNext()) {
                    Hit h = (Hit)it.next();
                    if (oldH != null) {
                        if (h.part == oldH.part) {
                            if (this.forward) {
                                if (oldH.targetEnd + 1 < h.targetStart) {
                                    intronGain = true;
                                }
                            } else if (oldH.targetStart - 1 > h.targetEnd) {
                                intronGain = true;
                            }
                        } else if (this.forward) {
                            if (oldH.targetEnd + 1 == h.targetStart) {
                                intronLoss = true;
                            }
                        } else if (oldH.targetStart - 1 == h.targetEnd) {
                            intronLoss = true;
                        }
                    }
                    dna = String.valueOf(dna) + h.getDNA(0, 0);
                    oldH = h;
                }
                String protein = Tools.translate(0, dna, code, false, GeMoMa.this.ambiguity);
                int idx = -1;
                int anz = 0;
                while ((idx = protein.indexOf(42, idx + 1)) >= 0) {
                    ++anz;
                }
                gff.append(";start=" + protein.charAt(0) + ";stop=" + protein.charAt(protein.length() - 1));
                String res = String.valueOf(this.hits.getFirst().part == ((TranscriptPredictor)TranscriptPredictor.this).currentInfo.exonID[0]) + "\t" + protein.charAt(0) + "\t" + (this.hits.getLast().part == ((TranscriptPredictor)TranscriptPredictor.this).currentInfo.exonID[((TranscriptPredictor)TranscriptPredictor.this).currentInfo.exonID.length - 1]) + "\t" + protein.charAt(protein.length() - 1) + "\t" + anz + "\t" + intronGain + "\t" + intronLoss;
                return res;
            }

            public void writeSummary(String geneName, String transcriptName, int i) throws Exception {
                Hit first = this.hits.get(0);
                TranscriptPredictor.this.gff.append(String.valueOf(first.targetID) + "\tGeMoMa\t" + GeMoMa.this.tag + "\t");
                if (this.forward) {
                    TranscriptPredictor.this.gff.append(String.valueOf(first.targetStart) + "\t" + this.hits.getLast().targetEnd);
                } else {
                    TranscriptPredictor.this.gff.append(String.valueOf(this.hits.getLast().targetStart) + "\t" + first.targetEnd);
                }
                TranscriptPredictor.this.gff.append("\t.\t" + (this.forward ? "+" : "-") + "\t.\tID=" + GeMoMa.this.prefix + transcriptName + "_R" + i + ";ref-gene=" + GeMoMa.this.prefix + geneName + ";aa=" + this.getNumberOfAA());
            }

            /*
             * Unable to fully structure code
             */
            public int writeGFF(String transcriptName, int pred, StringBuffer sb) throws Exception {
                block19: {
                    this.I = 0;
                    this.i = 0;
                    this.D = 0;
                    this.A = 0;
                    this.d = 0;
                    this.a = 0;
                    this.minSplitReads = 0x7FFFFFFF;
                    start = -1;
                    end = -1;
                    phase = -1;
                    parts = 0;
                    id = null;
                    first = true;
                    ae = false;
                    de = false;
                    donSites = null;
                    cov = null;
                    this.Sum = 0;
                    this.Cov = 0;
                    this.Len = 0;
                    this.minC = 0x7FFFFFFF;
                    last = -1;
                    pref = String.valueOf(GeMoMa.access$12(TranscriptPredictor.access$16(TranscriptPredictor.this))) + transcriptName + "_R" + pred;
                    for (Hit t : this.hits) {
                        block18: {
                            if (id == null) {
                                id = t.targetID;
                                v0 = sites = GeMoMa.donorSites != null ? GeMoMa.donorSites.get(id) : null;
                                if (sites != null) {
                                    donSites = sites[this.forward != false ? 0 : 1];
                                }
                                v1 = GeMoMa.coverage != null && GeMoMa.coverage[this.forward != false ? 0 : 1] != null ? GeMoMa.coverage[this.forward != false ? 0 : 1].get(id) : (cov = null);
                            }
                            if (start < 0) {
                                start = t.targetStart;
                                end = t.targetEnd;
                                phase = t.phase;
                                ae = t.ae;
                                de = t.de;
                                continue;
                            }
                            if (this.forward && end + 1 == t.targetStart) {
                                end = t.targetEnd;
                                de = t.de;
                                continue;
                            }
                            if (!this.forward && start - 1 == t.targetEnd) {
                                start = t.targetStart;
                                de = t.de;
                                continue;
                            }
                            l = end - start + 1;
                            covered = 0;
                            min = 0x7FFFFFFF;
                            if (cov == null) break block18;
                            idx = Arrays.binarySearch(cov, new int[]{start}, IntArrayComparator.comparator[2]);
                            if (idx < 0) {
                                idx = -(idx + 1);
                                idx = Math.max(0, idx - 1);
                            }
                            inter = cov[idx];
                            p = start;
                            ** GOTO lbl73
                            {
                                if (++idx >= cov.length) {
                                    min = 0;
                                    break;
                                }
                                inter = cov[idx];
                                do {
                                    if (p > inter[1]) continue block1;
                                    if (inter[0] <= p && p <= inter[1]) {
                                        h = Math.min(inter[1], end) + 1;
                                        a = h - p;
                                        covered += a;
                                        this.Sum += inter[2] * a;
                                        min = Math.min(min, inter[2]);
                                        p = h;
                                        continue;
                                    }
                                    min = 0;
                                    p = Math.min(inter[0], end + 1);
lbl73:
                                    // 3 sources

                                } while (p <= end);
                            }
                            this.Cov += covered;
                        }
                        this.Len += l;
                        if (covered == 0) {
                            min = 0;
                        }
                        this.minC = Math.min(this.minC, min);
                        sb.append(String.valueOf(id) + "\tGeMoMa\tCDS\t" + start + "\t" + end + "\t.\t" + (this.forward != false ? "+" : "-") + "\t" + phase + "\t" + "Parent=" + pref + (GeMoMa.acceptorSites == null || first != false ? "" : ";ae=" + ae) + (GeMoMa.donorSites == null ? "" : ";de=" + de) + (cov == null ? "" : ";pc=" + GeMoMa.decFormat.format((double)covered / (double)l) + ";minCov=" + min) + "\n");
                        ++this.D;
                        this.d += de != false ? 1 : 0;
                        this.combineIntronStat(first, ae, donSites, this.forward, start, end, last);
                        ++parts;
                        last = this.forward != false ? end + 1 : start;
                        start = t.targetStart;
                        end = t.targetEnd;
                        phase = t.phase;
                        ae = t.ae;
                        de = t.de;
                        first = false;
                    }
                    l = end - start + 1;
                    covered = 0;
                    min = 0x7FFFFFFF;
                    if (cov == null) break block19;
                    idx = Arrays.binarySearch(cov, new int[]{start}, IntArrayComparator.comparator[2]);
                    if (idx < 0) {
                        idx = -(idx + 1);
                        idx = Math.max(0, idx - 1);
                    }
                    inter = cov[idx];
                    p = start;
                    ** GOTO lbl121
                    {
                        if (++idx >= cov.length) {
                            min = 0;
                            break;
                        }
                        inter = cov[idx];
                        do {
                            if (p > inter[1]) continue block3;
                            if (inter[0] <= p && p <= inter[1]) {
                                h = Math.min(inter[1], end) + 1;
                                a = h - p;
                                covered += a;
                                this.Sum += inter[2] * a;
                                min = Math.min(min, inter[2]);
                                p = h;
                                continue;
                            }
                            min = 0;
                            p = Math.min((int)inter[0], end + 1);
lbl121:
                            // 3 sources

                        } while (p <= end);
                    }
                    this.Cov += covered;
                }
                this.Len += l;
                if (covered == 0) {
                    min = 0;
                }
                this.minC = Math.min(this.minC, min);
                sb.append(String.valueOf(id) + "\tGeMoMa\tCDS\t" + start + "\t" + end + "\t.\t" + (this.forward != false ? "+" : "-") + "\t" + phase + "\t" + "Parent=" + pref + (GeMoMa.acceptorSites == null || first != false ? "" : ";ae=" + ae) + (cov == null ? "" : ";pc=" + GeMoMa.decFormat.format((double)covered / (double)l) + ";minCov=" + min) + "\n");
                this.combineIntronStat(first, ae, donSites, this.forward, start, end, last);
                return ++parts;
            }

            void combineIntronStat(boolean first, boolean ae, int[][] donSites, boolean forward, int start, int end, int last) {
                if (!first) {
                    ++this.A;
                    this.a += ae ? 1 : 0;
                    ++this.I;
                    int splitReads = TranscriptPredictor.this.getSplitReads(donSites, forward, start, end, last);
                    if (splitReads > 0) {
                        ++this.i;
                        this.minSplitReads = Math.min(this.minSplitReads, splitReads);
                    } else {
                        this.minSplitReads = 0;
                    }
                }
            }
        }
    }
}

