/*
 * Decompiled with CFR 0.152.
 */
package projects.gemoma;

import de.jstacs.DataType;
import de.jstacs.parameters.ExpandableParameterSet;
import de.jstacs.parameters.FileParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterSetContainer;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.SimpleParameterSet;
import de.jstacs.parameters.validation.FileExistsValidator;
import de.jstacs.results.ResultSet;
import de.jstacs.results.TextResult;
import de.jstacs.tools.JstacsTool;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.Protocol;
import de.jstacs.tools.ToolParameterSet;
import de.jstacs.tools.ToolResult;
import de.jstacs.utils.IntList;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import projects.gemoma.GeMoMaModule;
import projects.gemoma.Tools;

public class CompareTranscripts
extends GeMoMaModule {
    private static String par = "Parent=";
    private static HashMap<String, String> info = new HashMap();
    private static int all;
    private static StringBuffer ids;

    static {
        ids = new StringBuffer();
    }

    @Override
    public ToolResult run(ToolParameterSet parameters, Protocol protocol, ProgressUpdater progress, int threads, String temp) throws Exception {
        boolean output;
        ExpandableParameterSet eps = (ExpandableParameterSet)parameters.getParameterForName("transcript info").getValue();
        HashMap<String, String[]> gene = new HashMap<String, String[]>();
        HashMap<String, int[]> stats = new HashMap<String, int[]>();
        int i = 0;
        while (i < eps.getNumberOfParameters()) {
            SimpleParameterSet ps = (SimpleParameterSet)eps.getParameterAt(i).getValue();
            String fName = (String)ps.getParameterForName("assignment").getValue();
            Parameter p = ps.getParameterForName("prefix");
            String prefix = p.isSet() ? (String)p.getValue() : null;
            Tools.getAlias(gene, fName, prefix, 1, 0, 2);
            ++i;
        }
        boolean bl = output = gene.size() > 0;
        if (!output) {
            gene = null;
        } else {
            for (Map.Entry e : gene.entrySet()) {
                String geneName = ((String[])e.getValue())[0];
                int[] stat = (int[])stats.get(geneName);
                if (stat == null) {
                    stat = new int[3];
                    stats.put(geneName, stat);
                }
                stat[0] = stat[0] + 1;
            }
        }
        HashMap<String, Annotation> truth = CompareTranscripts.readGFF(parameters.getParameterForName("annotation").getValue().toString(), false, true);
        protocol.append("truth: " + truth.size() + "\n");
        HashMap<String, Annotation> prediction = CompareTranscripts.readGFF(parameters.getParameterForName("prediction").getValue().toString(), true, true);
        protocol.append("prediction: " + prediction.size() + "\n");
        File f = Tools.createTempFile("CompareTranscript", temp);
        int problem = CompareTranscripts.bestHit(gene, "_R", null, truth, prediction, f, protocol, stats);
        ArrayList<TextResult> res = new ArrayList<TextResult>();
        res.add(new TextResult("comparison", "Result", new FileParameter.FileRepresentation(f.getAbsolutePath()), "tabular", this.getToolName(), null, true));
        if (stats.size() > 0) {
            f = Tools.createTempFile("CompareTranscript-stats", temp);
            BufferedWriter w = new BufferedWriter(new FileWriter(f));
            w.append("#geneID\ttranscripts in reference annotation\ttranscripts with this ref-gene\ttranscripts with this alternative\n");
            for (Map.Entry<String, int[]> e : stats.entrySet()) {
                int[] stat = e.getValue();
                w.append(String.valueOf(e.getKey()) + "\t" + stat[0] + "\t" + stat[1] + "\t" + stat[2] + "\n");
            }
            w.close();
            res.add(new TextResult("stats", "Result", new FileParameter.FileRepresentation(f.getAbsolutePath()), "tabular", this.getToolName(), null, true));
        }
        protocol.append("\nproblems: " + problem);
        return new ToolResult("", "", null, new ResultSet(res), parameters, this.getToolName(), new Date());
    }

    private static HashMap<String, Annotation> readGFF(String input, boolean information, boolean toUpper) throws Exception {
        String line;
        HashMap<String, Annotation> annot = new HashMap<String, Annotation>();
        BufferedReader r = new BufferedReader(new FileReader(input));
        while ((line = r.readLine()) != null) {
            int h;
            int idx;
            if (line.equalsIgnoreCase("##FASTA")) break;
            if (line.length() == 0 || line.startsWith("#")) continue;
            String[] split = line.split("\t");
            if (split[2].equalsIgnoreCase("CDS")) {
                String[] t;
                idx = split[8].indexOf(par);
                if (idx >= 0) {
                    idx += par.length();
                } else {
                    idx = split[8].indexOf("ID=");
                    if (idx < 0) {
                        r.close();
                        throw new IllegalArgumentException("corrupt line: " + line);
                    }
                    idx += 3;
                }
                h = split[8].indexOf(59, idx);
                String x = split[8].substring(idx, h < 0 ? split[8].length() : h);
                if (toUpper) {
                    x = x.toUpperCase();
                }
                String[] stringArray = t = x.split(",");
                int n = t.length;
                int n2 = 0;
                while (n2 < n) {
                    String transcriptID = stringArray[n2];
                    Annotation current = annot.get(transcriptID);
                    if (current == null) {
                        current = new Annotation(transcriptID, split[0], split[6].trim().charAt(0) == '+');
                        annot.put(transcriptID, current);
                    }
                    current.add(split[3], split[4]);
                    ++n2;
                }
                continue;
            }
            if (!information || !split[2].equalsIgnoreCase("mRNA") && !split[2].equalsIgnoreCase("prediction") && !split[2].equalsIgnoreCase("transcript")) continue;
            idx = split[8].indexOf("ID=") + 3;
            h = split[8].indexOf(";", idx);
            if (h < 0) {
                h = split[8].length();
            }
            String id = split[8].substring(idx, h);
            if (toUpper) {
                id = id.toUpperCase();
            }
            info.put(id, split[8]);
        }
        r.close();
        return annot;
    }

    private static int bestHit(HashMap<String, String[]> gene, String sep, HashMap<String, String[]> alias, HashMap<String, Annotation> truth, HashMap<String, Annotation> prediction, File file, Protocol protocol, HashMap<String, int[]> stats) throws IOException {
        int problem = 0;
        Annotation[] a = new Annotation[truth.size()];
        truth.values().toArray(a);
        int[] end = CompareTranscripts.getEnds(a);
        int[] counts = new int[9];
        int[] bestCounts = new int[9];
        HashSet<Integer> check = new HashSet<Integer>();
        IntList best = new IntList();
        PseudoAnnotation ps = new PseudoAnnotation();
        BufferedWriter w = new BufferedWriter(new FileWriter(file));
        String[] id = new String[]{"?", "?"};
        w.append("#gene\ttranscript\t#exons");
        w.append("\tprediction\t#predicted exons\tchr\tstrand\tstart\tstop\tnumber of best hits\tf1\tinfo: id,annotated exons,tp,fn,fp,perfect exons,missed exons,superfluous exons,max exon splice error,perfect start,perfect end\tinfo");
        w.newLine();
        Object[] array = prediction.keySet().toArray(new String[0]);
        Arrays.sort(array);
        HashSet<String> used = new HashSet<String>();
        int i = 0;
        while (i < array.length) {
            Object transcript;
            Object predictionID = array[i];
            int index = ((String)predictionID).lastIndexOf(sep);
            Object object = transcript = index > 0 ? ((String)predictionID).substring(0, index) : predictionID;
            if (alias != null) {
                transcript = alias.get(transcript)[0];
            }
            if (gene != null) {
                id = gene.get(transcript);
            }
            if (id != null) {
                w.append(String.valueOf(id[0]) + "\t" + (String)transcript + "\t" + id[1] + "\t" + (String)predictionID);
                Annotation test = prediction.get(predictionID);
                check.clear();
                if (test == null) {
                    w.append("\tNA\tNA\tNA\tNA\tNA");
                } else {
                    w.append("\t" + test.cdsParts.size() + "\t" + test.chr + "\t" + (test.forward ? "+" : "-") + "\t" + test.getMin() + "\t" + test.getMax());
                    CompareTranscripts.getCandidates(test, ps, a, end, check);
                }
                if (check.size() > 0) {
                    Iterator it = check.iterator();
                    while (it.hasNext()) {
                        used.add(a[((Integer)it.next()).intValue()].id);
                    }
                }
                double x = CompareTranscripts.getBest(test, a, check, counts, bestCounts, best, false);
                if (best.length() > 0) {
                    double f1 = x;
                    IntList idx = best;
                    Annotation[] c = a;
                    w.append("\t" + idx.length() + "\t" + f1);
                    int j = 0;
                    while (j < idx.length()) {
                        int k = idx.get(j);
                        w.append(j == 0 ? "\t" : ";");
                        CompareTranscripts.compare(test, c[k], counts, true);
                        String s = Arrays.toString(counts).replaceAll(" ", "");
                        w.append(String.valueOf(c[k].id) + "," + c[k].cdsParts.size() + "," + s.substring(1, s.length() - 1));
                        ++j;
                    }
                } else {
                    w.append("\t0\tNA\tNA");
                }
                String attributes = info.get(predictionID);
                w.append("\t" + attributes);
                w.newLine();
                String s = null;
                int idx = attributes.indexOf("ref-gene=");
                if (idx >= 0) {
                    int[] xx;
                    String[] help;
                    s = attributes.substring(idx += 9, attributes.indexOf(59, idx)).toUpperCase();
                    if (gene != null && (help = gene.get(s)) != null) {
                        s = help[1];
                    }
                    if ((xx = stats.get(s)) != null) {
                        xx[1] = xx[1] + 1;
                    }
                }
                if ((idx = attributes.indexOf("alternative=")) >= 0) {
                    String h;
                    int idx2 = attributes.indexOf(59, idx += 12);
                    if (idx2 < 0) {
                        idx2 = attributes.length();
                    }
                    if ((h = attributes.substring(idx, idx2).toUpperCase()).charAt(0) == '\"' && h.charAt(h.length() - 1) == '\"') {
                        h = h.substring(1, h.length() - 1);
                    }
                    String[] split = h.split(",");
                    int j = 0;
                    while (j < split.length) {
                        int[] xx;
                        if (!s.equals(split[j]) && (xx = stats.get(split[j])) != null) {
                            xx[2] = xx[2] + 1;
                        }
                        ++j;
                    }
                }
            } else {
                protocol.append("problem: " + (String)transcript + "\n");
                ++problem;
            }
            ++i;
        }
        w.close();
        protocol.append("\n");
        protocol.append("transcripts from annotation that have no overlap with predictions\n");
        int count = 0;
        int i2 = 0;
        while (i2 < a.length) {
            if (!used.contains(a[i2].id)) {
                ++count;
                protocol.append(String.valueOf(a[i2].id) + "\n");
            }
            ++i2;
        }
        protocol.append("unused: " + count + "\n\n");
        return problem;
    }

    private static int[] getEnds(Annotation[] a) {
        Arrays.sort(a);
        int[] end = new int[a.length];
        int j = 0;
        while (j < a.length) {
            end[j] = j == 0 || !a[j].chr.equals(a[j - 1].chr) || a[j].forward != a[j - 1].forward ? a[j].getMax() : Math.max(end[j - 1], a[j].getMax());
            ++j;
        }
        return end;
    }

    private static void getCandidates(Annotation test, PseudoAnnotation ps, Annotation[] a, int[] end, HashSet<Integer> check) {
        int k = 0;
        while (k < test.cdsParts.size()) {
            int[] x = test.cdsParts.get(k);
            ps.set(test.chr, test.forward, x[1]);
            int stop = CompareTranscripts.getIndex(Arrays.binarySearch(a, ps));
            int start = stop - 1;
            int min = x[0];
            while (start >= 0 && end[start] >= min && a[start].chr.equals(test.chr) && a[start].forward == test.forward) {
                check.add(start);
                --start;
            }
            ++k;
        }
    }

    private static double getBest(Annotation test, Annotation[] a, HashSet<Integer> check, int[] counts, int[] bestCounts, IntList best, boolean exon) {
        best.clear();
        Arrays.fill(bestCounts, 0);
        double d = 0.0;
        Iterator<Integer> it = check.iterator();
        all = 0;
        ids.delete(0, ids.length());
        while (it.hasNext()) {
            int k = it.next();
            CompareTranscripts.compare(test, a[k], counts, exon);
            double h = CompareTranscripts.getF1(counts);
            if (h > 0.0) {
                ids.append(String.valueOf(all == 0 ? "" : ", ") + a[k].id);
                ++all;
            }
            if (h > d) {
                d = h;
                best.clear();
                best.add(k);
                System.arraycopy(counts, 0, bestCounts, 0, 3);
                continue;
            }
            if (!(d > 0.0) || h != d) continue;
            best.add(k);
        }
        return d;
    }

    private static double getF1(int[] counts) {
        return 2.0 * (double)counts[0] / (2.0 * (double)counts[0] + (double)counts[1] + (double)counts[2]);
    }

    static int getIndex(int insert) {
        int end = insert < 0 ? -(insert + 1) : insert + 1;
        return end;
    }

    private static boolean compare(Annotation predictedAnnot, Annotation trueAnnot, int[] counts, boolean exon) {
        boolean chrAndStrandCorrect;
        Arrays.fill(counts, 0);
        boolean bl = chrAndStrandCorrect = predictedAnnot.chr.equals(trueAnnot.chr) && predictedAnnot.forward == trueAnnot.forward;
        if (chrAndStrandCorrect) {
            int start = Math.min(predictedAnnot.getMin(), trueAnnot.getMin()) - 1;
            int end = Math.max(predictedAnnot.getMax(), trueAnnot.getMax()) + 1;
            BitSet predictedRegion = new BitSet(end - start + 1);
            BitSet trueRegion = new BitSet(end - start + 1);
            predictedAnnot.set(predictedRegion, start);
            trueAnnot.set(trueRegion, start);
            counts[0] = CompareTranscripts.count(predictedRegion, trueRegion, false);
            counts[1] = CompareTranscripts.count(predictedRegion, trueRegion, true);
            counts[2] = CompareTranscripts.count(trueRegion, predictedRegion, true);
            int n = (trueAnnot.forward ? trueRegion.nextSetBit(0) == predictedRegion.nextSetBit(0) : trueRegion.previousSetBit(end - start) == predictedRegion.previousSetBit(end - start)) ? 1 : (counts[7] = 0);
            int n2 = (!trueAnnot.forward ? trueRegion.nextSetBit(0) == predictedRegion.nextSetBit(0) : trueRegion.previousSetBit(end - start) == predictedRegion.previousSetBit(end - start)) ? 1 : (counts[8] = 0);
            if (exon) {
                int p;
                int[] border;
                int i = 0;
                while (i < trueAnnot.cdsParts.size()) {
                    border = trueAnnot.cdsParts.get(i);
                    int s = border[0] - 1;
                    int e = border[1] + 2;
                    while (s <= e && predictedRegion.get(s - start) == trueRegion.get(s - start)) {
                        ++s;
                    }
                    if (s > e) {
                        counts[3] = counts[3] + 1;
                    }
                    ++i;
                }
                i = 0;
                while (i < trueAnnot.cdsParts.size()) {
                    border = trueAnnot.cdsParts.get(i);
                    p = predictedRegion.nextSetBit(border[0] - start);
                    if (p == -1 || p > border[1] - start) {
                        counts[4] = counts[4] + 1;
                    }
                    ++i;
                }
                i = 0;
                while (i < predictedAnnot.cdsParts.size()) {
                    border = predictedAnnot.cdsParts.get(i);
                    p = trueRegion.nextSetBit(border[0] - start);
                    if (p == -1 || p > border[1] - start) {
                        counts[5] = counts[5] + 1;
                    } else {
                        int dist = p > border[0] - start ? p - (border[0] - start) : border[0] - start - (trueRegion.previousClearBit(border[0] - start) + 1);
                        if (dist > counts[6]) {
                            counts[6] = dist;
                        }
                        if ((dist = (p = trueRegion.previousSetBit(border[1] - start)) < border[1] - start ? border[1] - start - p : trueRegion.nextClearBit(border[1] - start) - 1 - (border[1] - start)) > counts[6]) {
                            counts[6] = dist;
                        }
                    }
                    ++i;
                }
            }
        } else {
            counts[0] = 0;
            counts[1] = trueAnnot.getLength();
            counts[2] = predictedAnnot.getLength();
            if (exon) {
                counts[3] = 0;
                counts[4] = predictedAnnot.cdsParts.size();
                counts[5] = trueAnnot.cdsParts.size();
                counts[6] = Integer.MAX_VALUE;
            }
            counts[8] = 0;
            counts[7] = 0;
        }
        return chrAndStrandCorrect;
    }

    private static int count(BitSet b1, BitSet b2, boolean flipFirst) {
        BitSet h = (BitSet)b1.clone();
        if (flipFirst) {
            h.flip(0, h.size());
        }
        h.and(b2);
        return h.cardinality();
    }

    @Override
    public ToolParameterSet getToolParameters() {
        try {
            return new ToolParameterSet(this.getShortName(), new FileParameter("prediction", "The predicted annotation", "gff,gff3", true, new FileExistsValidator(), true), new FileParameter("annotation", "The true annotation", "gff,gff3", true, new FileExistsValidator(), true), new ParameterSetContainer("transcript info", "", new ExpandableParameterSet(new SimpleParameterSet(new SimpleParameter(DataType.STRING, "prefix", "the prefix can be used to distinguish predictions from different input files", false, ""), new FileParameter("assignment", "the transcript info for the reference of the prediction", "tabular", true, new FileExistsValidator())), "transcript info", "", 0)));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }

    @Override
    public String getToolName() {
        return "Compare transcripts";
    }

    @Override
    public String getShortName() {
        return "CompareTranscripts";
    }

    @Override
    public String getDescription() {
        return "This tool helps to compare transcripts from different annotations (e.g. prediction vs. given annotation)";
    }

    @Override
    public String getHelpText() {
        return "This tool compares a predicted annotation with a given annotation in terms of F1 measure. If the F1 measure is 1 both annotations are in perfect agreement for this transcript. The smaller the value is the low is the agreement. If it is NA then there is no overlapping annotation." + MORE;
    }

    @Override
    public JstacsTool.ResultEntry[] getDefaultResultInfos() {
        return new JstacsTool.ResultEntry[]{new JstacsTool.ResultEntry(TextResult.class, "tabular", "comparison")};
    }

    @Override
    public ToolResult[] getTestCases(String path) {
        return null;
    }

    static class Annotation
    implements Comparable<Annotation> {
        String id;
        String chr;
        boolean forward;
        ArrayList<int[]> cdsParts;

        public Annotation(String id, String chr, boolean forward) {
            this.id = id;
            this.chr = chr;
            this.forward = forward;
            this.cdsParts = new ArrayList();
        }

        public void add(String start, String end) {
            this.cdsParts.add(new int[]{Integer.parseInt(start), Integer.parseInt(end)});
        }

        static int getLength(int[] interval) {
            return interval[1] - interval[0] + 1;
        }

        public int getLength() {
            int l = 0;
            int i = 0;
            while (i < this.cdsParts.size()) {
                int[] interval = this.cdsParts.get(i);
                l += Annotation.getLength(interval);
                ++i;
            }
            return l;
        }

        public int getMin() {
            int min = Integer.MAX_VALUE;
            int i = 0;
            while (i < this.cdsParts.size()) {
                int[] interval = this.cdsParts.get(i);
                if (interval[0] < min) {
                    min = interval[0];
                }
                ++i;
            }
            return min;
        }

        public int getMax() {
            int max = Integer.MIN_VALUE;
            int i = 0;
            while (i < this.cdsParts.size()) {
                int[] interval = this.cdsParts.get(i);
                if (interval[1] > max) {
                    max = interval[1];
                }
                ++i;
            }
            return max;
        }

        public void set(BitSet region, int start) {
            int i = 0;
            while (i < this.cdsParts.size()) {
                int[] interval = this.cdsParts.get(i);
                region.set(interval[0] - start, interval[1] - start + 1);
                ++i;
            }
        }

        @Override
        public int compareTo(Annotation a) {
            int d = this.chr.compareTo(a.chr);
            if (d == 0) {
                d = this.forward == a.forward ? this.getMin() - a.getMin() : (this.forward ? -1 : 1);
            }
            return d;
        }

        public String toString(boolean full) {
            StringBuffer sb = new StringBuffer(String.valueOf(this.id) + "\t" + this.chr + "\t" + this.forward + "\t" + this.getMin() + "\t" + this.getMax());
            if (full) {
                int i = 0;
                while (i < this.cdsParts.size()) {
                    sb.append("\n" + i + "\t" + Arrays.toString(this.cdsParts.get(i)));
                    ++i;
                }
            }
            sb.append("\n" + this.getLength());
            return sb.toString();
        }

        public String toString() {
            return this.toString(false);
        }
    }

    static class PseudoAnnotation
    extends Annotation {
        int v;

        public PseudoAnnotation() {
            super(null, null, true);
        }

        void set(String chr, boolean forward, int v) {
            this.v = v;
            this.chr = chr;
            this.forward = forward;
        }

        @Override
        public int getMin() {
            return this.v;
        }
    }
}

