/*
 * Decompiled with CFR 0.152.
 */
package projects.gemoma;

import de.jstacs.DataType;
import de.jstacs.parameters.ExpandableParameterSet;
import de.jstacs.parameters.FileParameter;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.ParameterSetContainer;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.SimpleParameterSet;
import de.jstacs.parameters.validation.FileExistsValidator;
import de.jstacs.parameters.validation.RegExpValidator;
import de.jstacs.results.ResultSet;
import de.jstacs.results.TextResult;
import de.jstacs.tools.JstacsTool;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.Protocol;
import de.jstacs.tools.ToolParameterSet;
import de.jstacs.tools.ToolResult;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import projects.gemoma.GeMoMaModule;
import projects.gemoma.Tools;

public class SyntenyChecker
extends GeMoMaModule {
    @Override
    public ToolResult run(ToolParameterSet parameters, Protocol protocol, ProgressUpdater progress, int threads, String temp) throws Exception {
        String line;
        Object a;
        String tag = (String)parameters.getParameterForName("tag").getValue();
        ArrayList<Assignment> assign = new ArrayList<Assignment>();
        ExpandableParameterSet eps = (ExpandableParameterSet)parameters.getParameterForName("references").getValue();
        int i = 0;
        while (i < eps.getNumberOfParameters()) {
            ParameterSet ps = (ParameterSet)eps.getParameterAt(i).getValue();
            String prefix = (String)ps.getParameterForName("prefix").getValue();
            if (prefix != null && prefix.length() != 0 && !prefix.endsWith("_")) {
                prefix = String.valueOf(prefix) + "_";
            }
            String assignFile = (String)ps.getParameterForName("assignment").getValue();
            a = new Assignment(assignFile, prefix);
            assign.add((Assignment)a);
            protocol.append("assignment: " + ((Assignment)a).hash.size() + "\n");
            ++i;
        }
        protocol.append("read assignment files: " + assign.size());
        String annot = (String)parameters.getParameterForName("gene annotation file").getValue();
        BufferedReader r = new BufferedReader(new FileReader(annot));
        HashMap<String, Gene> annotation = new HashMap<String, Gene>();
        a = new HashMap();
        while ((line = r.readLine()) != null) {
            String[] split;
            if (line.length() == 0 || line.charAt(0) == '#' || !(split = line.split("\t"))[2].equals(tag)) continue;
            String[] att = split[8].split(";");
            ((HashMap)a).clear();
            int i2 = 0;
            while (i2 < att.length) {
                int idx = att[i2].indexOf(61);
                if (idx >= 0) {
                    String key = att[i2].substring(0, idx);
                    String value = att[i2].substring(idx + 1);
                    if (value.charAt(0) == '\"') {
                        value = value.substring(1, value.length() - 1);
                    }
                    ((HashMap)a).put(key, value);
                }
                ++i2;
            }
            String parent = (String)((HashMap)a).get("Parent");
            Gene g = (Gene)annotation.get(parent);
            if (g == null) {
                g = new Gene(parent);
                g.rg = new HashSet();
                annotation.put(parent, g);
            }
            g.extend(split[0], split[6].charAt(0) == '+' ? 1 : -1, Integer.parseInt(split[3]), Integer.parseInt(split[4]));
            String refG = (String)((HashMap)a).get("ref-gene");
            g.rg.add(refG);
            String altG = (String)((HashMap)a).get("alternative");
            if (altG == null) continue;
            String[] al = altG.split(",");
            int i3 = 0;
            while (i3 < al.length) {
                g.rg.add(al[i3]);
                ++i3;
            }
        }
        r.close();
        ArrayList<Gene> anno = new ArrayList<Gene>();
        for (Gene g : annotation.values()) {
            anno.add(g);
        }
        Collections.sort(anno);
        String oldContig = null;
        int j = 0;
        File output = Tools.createTempFile("synteny", temp);
        BufferedWriter w = new BufferedWriter(new FileWriter(output));
        w.append("contig\tmiddle position\tstrand\tord\tname\tref-genes");
        int as = 0;
        while (as < assign.size()) {
            Assignment ass = (Assignment)assign.get(as);
            w.append("\t" + (ass.prefix.length() > 0 ? ass.prefix.substring(0, ass.prefix.length() - 1) : "reference_species_" + as));
            ++as;
        }
        w.newLine();
        int i4 = 0;
        while (i4 < anno.size()) {
            Gene g = (Gene)anno.get(i4);
            if (!g.chr.equals(oldContig)) {
                j = 0;
                oldContig = g.chr;
            }
            String target = String.valueOf(g.chr) + "\t" + g.middle;
            w.append(String.valueOf(g.chr) + "\t" + g.middle + "\t" + g.strand + "\t" + j++ + "\t" + g.name + "\t" + g.rg.size());
            int as2 = 0;
            while (as2 < assign.size()) {
                w.append("\t" + ((Assignment)assign.get(as2)).check(g, target));
                ++as2;
            }
            w.newLine();
            ++i4;
        }
        w.close();
        String out = output.getAbsolutePath();
        ArrayList<TextResult> res = new ArrayList<TextResult>();
        res.add(new TextResult("reference gene table", "Result", new FileParameter.FileRepresentation(out), "tabular", this.getToolName(), null, true));
        return new ToolResult("", "", null, new ResultSet(res), parameters, this.getToolName(), new Date());
    }

    @Override
    public ToolParameterSet getToolParameters() {
        try {
            return new ToolParameterSet(this.getShortName(), new SimpleParameter(DataType.STRING, "tag", "the tag used to read the GeMoMa annotations", true, "mRNA"), new ParameterSetContainer("references", "", new ExpandableParameterSet(new SimpleParameterSet(new SimpleParameter(DataType.STRING, "prefix", "the prefix can be used to distinguish predictions from different input files (=reference organisms)", false, new RegExpValidator("\\w*")), new FileParameter("assignment", "the assignment file of this reference organism, which combines parts of the CDS to transcripts", "tabular", true, new FileExistsValidator())), "reference", "", 1)), new FileParameter("gene annotation file", "GFF file containing the gene annotations predicted by GAF", "gff,gff3", true, new FileExistsValidator(), true));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }

    @Override
    public String getToolName() {
        return "Synteny checker";
    }

    @Override
    public String getShortName() {
        return "SyntenyChecker";
    }

    @Override
    public String getDescription() {
        return "extracts the reference genes from the annotation";
    }

    @Override
    public String getHelpText() {
        return "This tool can be used to determine syntenic regions between target organism and reference organism based on similiarity of genes. The tool returns a table of reference genes per predicted gene. This table can be easily visualized with an R script that is included in the GeMoMa package." + MORE;
    }

    @Override
    public JstacsTool.ResultEntry[] getDefaultResultInfos() {
        return new JstacsTool.ResultEntry[]{new JstacsTool.ResultEntry(TextResult.class, "tabular", "reference gene table")};
    }

    @Override
    public ToolResult[] getTestCases(String path) {
        return null;
    }

    static class Assignment {
        String prefix;
        HashMap<String, Gene> hash;

        public Assignment(String fName, String pref) throws IOException {
            String line;
            this.prefix = pref != null ? pref : "";
            this.hash = new HashMap();
            BufferedReader r = new BufferedReader(new FileReader(fName));
            r.readLine();
            while ((line = r.readLine()) != null) {
                this.add(line);
            }
            r.close();
            ArrayList<Gene> ref = new ArrayList<Gene>();
            for (Gene g : this.hash.values()) {
                ref.add(g);
            }
            Collections.sort(ref);
            String oldContig = null;
            int num = 0;
            int i = 0;
            while (i < ref.size()) {
                Gene g = (Gene)ref.get(i);
                if (!g.chr.equals(oldContig)) {
                    num = 0;
                    oldContig = g.chr;
                }
                g.num = num++;
                ++i;
            }
        }

        public String check(Gene g, String target) throws IOException {
            Iterator<String> rgs = g.rg.iterator();
            StringBuffer sb = new StringBuffer();
            while (rgs.hasNext()) {
                Gene ref;
                String current = rgs.next();
                if (!current.startsWith(this.prefix) || (ref = this.hash.get(current)) == null) continue;
                if (sb.length() > 0) {
                    sb.append("; ");
                }
                sb.append(String.valueOf(ref.chr) + "," + ref.middle + "," + ref.strand + "," + ref.num + "," + ref.name);
            }
            return sb.toString();
        }

        public void add(String line) {
            int end;
            int start;
            int strand;
            String[] split = line.split("\t");
            split[0] = String.valueOf(this.prefix) + split[0];
            try {
                strand = Integer.parseInt(split[5]);
                start = Integer.parseInt(split[6]);
                end = Integer.parseInt(split[7]);
            }
            catch (NumberFormatException nfe) {
                end = -9999;
                start = -9999;
                strand = -9999;
            }
            if (strand != -9999) {
                Gene g = this.hash.get(split[0]);
                if (g == null) {
                    g = new Gene(split[0]);
                    this.hash.put(split[0], g);
                }
                g.extend(split[4], strand, start, end);
            }
        }
    }

    static class Gene
    implements Comparable<Gene> {
        String name;
        String chr;
        int strand;
        int start;
        int end;
        int middle;
        int num = -1;
        HashSet<String> rg;

        Gene(String name) {
            this.name = name;
            this.chr = null;
            this.strand = 0;
            this.middle = -1;
            this.rg = null;
        }

        void extend(String chr, int strand, int start, int end) {
            if (this.chr == null) {
                this.chr = chr;
                this.strand = strand;
                this.start = start;
                this.end = end;
            } else if (this.chr.equals(chr) && this.strand == strand) {
                this.start = Math.min(start, this.start);
                this.end = Math.max(end, this.end);
            } else {
                throw new RuntimeException("Check chromsome/contig and strand for gene " + this.name);
            }
            this.middle = (end + start) / 2;
        }

        @Override
        public int compareTo(Gene g) {
            int d = this.chr.compareTo(g.chr);
            if (d == 0) {
                d = Integer.compare(this.middle, g.middle);
            }
            return d;
        }
    }
}

