/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.clustering.distances;

import de.jstacs.clustering.hierachical.ClusterTree;
import de.jstacs.data.DeBruijnGraphSequenceGenerator;
import de.jstacs.data.alphabets.DNAAlphabet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.sequences.CyclicSequenceAdaptor;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.ArrayHandler;
import de.jstacs.sequenceScores.statisticalModels.StatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.trainable.PFMWrapperTrainSM;
import de.jstacs.utils.PFMComparator;
import de.jstacs.utils.Pair;

public class DeBruijnMotifComparison {
    private static double[] getStatistics(double[] profile) {
        double sum = 0.0;
        double sq = 0.0;
        int i = 0;
        while (i < profile.length) {
            sum += profile[i];
            sq += profile[i] * profile[i];
            ++i;
        }
        return new double[]{sum, sq};
    }

    private static double getCross(double[] profile1, double[] profile2, int shift) {
        double cr = 0.0;
        int i = 0;
        while (i < profile1.length) {
            cr = i + shift >= profile2.length ? (cr += profile1[i] * profile2[i + shift - profile2.length]) : (cr += profile1[i] * profile2[i + shift]);
            ++i;
        }
        return cr;
    }

    public static Pair<Integer, Double> compare(double[] profile1, double[] profile2, int maxShift) {
        double[] fullStat1 = DeBruijnMotifComparison.getStatistics(profile1);
        double[] fullStat2 = DeBruijnMotifComparison.getStatistics(profile2);
        double fac = Math.sqrt((fullStat1[1] - 1.0 / (double)profile1.length * fullStat1[0] * fullStat1[0]) * (fullStat2[1] - 1.0 / (double)profile1.length * fullStat2[0] * fullStat2[0]));
        double max = Double.NEGATIVE_INFINITY;
        int maxOff = 0;
        int i = 0;
        while (i <= maxShift) {
            double cr = DeBruijnMotifComparison.getCross(profile1, profile2, i);
            double corPlus = cr - 1.0 / (double)profile1.length * fullStat1[0] * fullStat2[0];
            corPlus /= fac;
            cr = DeBruijnMotifComparison.getCross(profile2, profile1, i);
            double corMinus = cr - 1.0 / (double)profile1.length * fullStat1[0] * fullStat2[0];
            corMinus /= fac;
            if (corPlus > max) {
                max = corPlus;
                maxOff = i;
            }
            if (corMinus > max) {
                max = corMinus;
                maxOff = -i;
            }
            ++i;
        }
        return new Pair<Integer, Double>(maxOff, max);
    }

    public static double[][] getProfilesForMotif(StatisticalModel model, int n, boolean revcom, boolean exp) throws Exception {
        CyclicSequenceAdaptor[] ad = DeBruijnGraphSequenceGenerator.generate((DiscreteAlphabet)model.getAlphabetContainer().getAlphabetAt(0), n);
        return DeBruijnMotifComparison.getProfilesForMotif(ad, model, revcom, exp);
    }

    public static double[][] getProfilesForMotif(CyclicSequenceAdaptor[] ad, StatisticalModel model, boolean revcom, boolean exp) throws Exception {
        double[][] profiles = new double[ad.length][];
        int i = 0;
        while (i < ad.length) {
            Sequence seq = ad[i];
            if (revcom) {
                seq = ((CyclicSequenceAdaptor)seq).reverseComplement();
            }
            int origLength = ((CyclicSequenceAdaptor)seq).getLength();
            seq = ((CyclicSequenceAdaptor)seq).getSuperSequence(((CyclicSequenceAdaptor)seq).getLength() + model.getLength() - 1);
            profiles[i] = new double[origLength];
            int j = 0;
            while (j < origLength) {
                profiles[i][j] = revcom ? (j + model.getLength() < origLength + 1 ? model.getLogProbFor(seq, origLength - j - model.getLength()) : model.getLogProbFor(seq, ((CyclicSequenceAdaptor)seq).getLength() - j - 1)) : model.getLogProbFor(seq, j);
                if (exp) {
                    profiles[i][j] = Math.exp(profiles[i][j]);
                }
                ++j;
            }
            ++i;
        }
        return profiles;
    }

    public static Pair<double[][], int[][]> getClusterRepresentative(ClusterTree<StatisticalModel> tree, int n) throws Exception {
        if (tree.getNumberOfElements() == 1) {
            if (tree.getClusterElements()[0] instanceof PFMWrapperTrainSM) {
                int[][] nArrayArray = new int[1][];
                int[] nArray = new int[2];
                nArray[1] = 1;
                nArrayArray[0] = nArray;
                return new Pair<double[][], int[][]>(((PFMWrapperTrainSM)tree.getClusterElements()[0]).getPWM(), nArrayArray);
            }
            return null;
        }
        int[][] shifts = new int[tree.getNumberOfElements()][2];
        ClusterTree<StatisticalModel>[] subs = tree.getSubTrees();
        double[][][] reps = new double[subs.length][][];
        int[][][] prevShifts = new int[subs.length][][];
        int i = 0;
        while (i < subs.length) {
            Pair<double[][], int[][]> pair = DeBruijnMotifComparison.getClusterRepresentative(subs[i], n);
            reps[i] = pair.getFirstElement();
            prevShifts[i] = pair.getSecondElement();
            ++i;
        }
        double[][] rep = reps[0];
        int g = 0;
        int minPrevShift = Integer.MAX_VALUE;
        int i2 = 0;
        while (i2 < prevShifts[0].length) {
            shifts[g] = (int[])prevShifts[0][i2].clone();
            if (shifts[g][0] < minPrevShift) {
                minPrevShift = shifts[g][0];
            }
            ++i2;
            ++g;
        }
        g = 0;
        i2 = 0;
        while (i2 < prevShifts[0].length) {
            int[] nArray = shifts[g];
            nArray[0] = nArray[0] - minPrevShift;
            ++i2;
            ++g;
        }
        double n1 = subs[0].getNumberOfElements();
        int i3 = 1;
        while (i3 < reps.length) {
            PFMWrapperTrainSM model = new PFMWrapperTrainSM(DNAAlphabetContainer.SINGLETON, null, rep, 0.0);
            double[][] prof1 = DeBruijnMotifComparison.getProfilesForMotif(model, n, false, false);
            PFMWrapperTrainSM model2 = new PFMWrapperTrainSM(DNAAlphabetContainer.SINGLETON, null, reps[i3], 0.0);
            double[][] prof2 = DeBruijnMotifComparison.getProfilesForMotif(model2, n, false, false);
            double[][] prof2Rc = DeBruijnMotifComparison.getProfilesForMotif(model2, n, true, false);
            int maxShift = Math.max(rep.length, reps[i3].length);
            Pair<Integer, Double> fwd = DeBruijnMotifComparison.compare(prof1[0], prof2[0], maxShift);
            Pair<Integer, Double> rev = DeBruijnMotifComparison.compare(prof1[0], prof2Rc[0], maxShift);
            int shift = fwd.getFirstElement();
            int rc = 1;
            double[][] mat = (double[][])ArrayHandler.clone((Cloneable[])reps[i3]);
            if (fwd.getSecondElement() < rev.getSecondElement()) {
                shift = rev.getFirstElement();
                rc = -1;
                mat = PFMComparator.getReverseComplement(DNAAlphabet.SINGLETON, mat);
            }
            int totL = shift >= 0 ? Math.max(rep.length, mat.length + shift) : Math.max(rep.length - shift, mat.length);
            double[][] com = new double[totL][rep[0].length];
            double n2 = subs[i3].getNumberOfElements();
            int j = 0;
            while (j < com.length) {
                int k = 0;
                while (k < com[j].length) {
                    com[j][k] = shift >= 0 ? ((j < rep.length ? rep[j][k] : 0.25) * n1 + (j >= shift && j - shift < mat.length ? mat[j - shift][k] : 0.25) * n2) / (n1 + n2) : ((j >= -shift && j + shift < rep.length ? rep[j + shift][k] : 0.25) * n1 + (j < mat.length ? mat[j][k] : 0.25) * n2) / (n1 + n2);
                    ++k;
                }
                ++j;
            }
            n1 += n2;
            rep = com;
            minPrevShift = Integer.MAX_VALUE;
            j = 0;
            while (j < prevShifts[i3].length) {
                if (rc < 0) {
                    prevShifts[i3][j][0] = -(subs[i3].getClusterElements()[j].getLength() - mat.length) - prevShifts[i3][j][0];
                }
                if (prevShifts[i3][j][0] < minPrevShift) {
                    minPrevShift = prevShifts[i3][j][0];
                }
                ++j;
            }
            j = 0;
            while (j < prevShifts[i3].length) {
                shifts[g][0] = prevShifts[i3][j][0] - minPrevShift + shift;
                shifts[g][1] = prevShifts[i3][j][1] * rc;
                ++j;
                ++g;
            }
            ++i3;
        }
        return new Pair<double[][], int[][]>(rep, shifts);
    }
}

