/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.clustering.kmeans;

import de.jstacs.clustering.distances.PNorm;
import java.util.Arrays;
import java.util.Random;

public class Kmeans {
    private PNorm ed = new PNorm(2.0);

    public int[] cluster(double[][] data, double[][] center) throws Exception {
        int[] res = new int[data.length];
        int[] stat = new int[center.length];
        Arrays.fill(res, -2);
        int changed = -1;
        block0: while (true) {
            int j;
            changed = 0;
            int i = 0;
            while (i < data.length) {
                int old = res[i];
                res[i] = -1;
                double bestD = Double.POSITIVE_INFINITY;
                int j2 = 0;
                while (j2 < center.length) {
                    double current = this.ed.getDistance(data[i], center[j2]);
                    if (current < bestD) {
                        bestD = current;
                        res[i] = j2;
                    }
                    ++j2;
                }
                if (old != res[i]) {
                    ++changed;
                }
                ++i;
            }
            if (changed == 0) break;
            Arrays.fill(stat, 0);
            i = 0;
            while (i < center.length) {
                Arrays.fill(center[i], 0.0);
                ++i;
            }
            i = 0;
            while (i < data.length) {
                int n = res[i];
                stat[n] = stat[n] + 1;
                j = 0;
                while (j < data[i].length) {
                    double[] dArray = center[res[i]];
                    int n2 = j;
                    dArray[n2] = dArray[n2] + data[i][j];
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (true) {
                if (i >= center.length) continue block0;
                j = 0;
                while (j < center[i].length) {
                    double[] dArray = center[i];
                    int n = j++;
                    dArray[n] = dArray[n] / (double)stat[i];
                }
                ++i;
            }
            break;
        }
        return res;
    }

    public int[] cluster(double[][] data, int k, int n) throws Exception {
        double[][] center = new double[k][data[0].length];
        int[] best = null;
        double sse = Double.POSITIVE_INFINITY;
        Random r = new Random();
        double[] maxmin = new double[data.length];
        int i = 0;
        while (i < n) {
            Arrays.fill(maxmin, Double.POSITIVE_INFINITY);
            int first = r.nextInt(data.length);
            System.arraycopy(data[first], 0, center[0], 0, data[first].length);
            int j = 1;
            while (j < k) {
                int max = -1;
                int l = 0;
                while (l < data.length) {
                    double current = this.ed.getDistance(center[j - 1], data[l]);
                    if (current < maxmin[l]) {
                        maxmin[l] = current;
                    }
                    if (max < 0 || maxmin[l] > maxmin[max]) {
                        max = l;
                    }
                    ++l;
                }
                System.arraycopy(data[max], 0, center[j], 0, data[max].length);
                ++j;
            }
            int[] assignment = this.cluster(data, center);
            double current = this.getSSE(center, assignment, data);
            if (current < sse) {
                sse = current;
                best = assignment;
            }
            ++i;
        }
        return best;
    }

    double getSSE(double[][] center, int[] assignment, double[][] data) throws Exception {
        double sse = 0.0;
        int i = 0;
        while (i < data.length) {
            double dist = this.ed.getDistance(data[i], center[assignment[i]]);
            sse += dist * dist;
            ++i;
        }
        return sse;
    }

    public static double[][] rescale(double[][] x) {
        int j;
        double[] mean = new double[x[0].length];
        int i = 0;
        while (i < x.length) {
            j = 0;
            while (j < x[0].length) {
                int n = j;
                mean[n] = mean[n] + x[i][j];
                ++j;
            }
            ++i;
        }
        int j2 = 0;
        while (j2 < mean.length) {
            int n = j2++;
            mean[n] = mean[n] / (double)x.length;
        }
        double[] sd = new double[x[0].length];
        int i2 = 0;
        while (i2 < x.length) {
            int j3 = 0;
            while (j3 < x[0].length) {
                double v = x[i2][j3] - mean[j3];
                int n = j3++;
                sd[n] = sd[n] + v * v;
            }
            ++i2;
        }
        j = 0;
        while (j < mean.length) {
            sd[j] = Math.sqrt(sd[j]) / (double)(x.length - 1);
            ++j;
        }
        double[][] rescaled = new double[x.length][x[0].length];
        int i3 = 0;
        while (i3 < x.length) {
            int j4 = 0;
            while (j4 < x[0].length) {
                rescaled[i3][j4] = (x[i3][j4] - mean[j4]) / sd[j4];
                ++j4;
            }
            ++i3;
        }
        return rescaled;
    }
}

